/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.spinner;

import java.awt.Color;
import java.awt.Font;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;

public class ValueSpinner
extends JSpinner {
    protected static final boolean TRANSAPARENT_DISABLED_FIELD = Boolean.TRUE.equals(UIManager.get("ValueSpinner.disabledTransparent"));

    public ValueSpinner(SpinnerModel spinnerModel) {
        super(spinnerModel);
        this.b();
    }

    public JFormattedTextField getEditorField() {
        return ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
    }

    public String getFormattedValueString() {
        JFormattedTextField.AbstractFormatter abstractFormatter = this.getEditorField().getFormatter();
        String string = null;
        try {
            string = abstractFormatter.valueToString(this.getValue());
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public Object getInputValueObject() {
        JFormattedTextField jFormattedTextField = this.getEditorField();
        JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
        Object object = null;
        try {
            object = abstractFormatter.stringToValue(jFormattedTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public void requestFocus() {
        this.getEditorField().requestFocus();
    }

    public void setEnabled(boolean bl) {
        JFormattedTextField jFormattedTextField = this.getEditorField();
        if (TRANSAPARENT_DISABLED_FIELD && !bl) {
            jFormattedTextField.setDisabledTextColor(Color.BLACK);
        }
        super.setEnabled(bl);
        if (TRANSAPARENT_DISABLED_FIELD) {
            jFormattedTextField.setOpaque(bl);
        }
    }

    private void b() {
        JFormattedTextField jFormattedTextField = this.getEditorField();
        this.setEnabled(true);
        if (TRANSAPARENT_DISABLED_FIELD) {
            jFormattedTextField.setDisabledTextColor(Color.BLACK);
        }
    }

    public static class BeepField
    extends JFormattedTextField {
        public BeepField(JFormattedTextField jFormattedTextField) {
            this.setValue(jFormattedTextField.getValue());
            this.setEditable(jFormattedTextField.isEditable());
            this.setFormatterFactory(jFormattedTextField.getFormatterFactory());
            this.setHorizontalAlignment(4);
            this.setColumns(jFormattedTextField.getColumns());
            Font font = jFormattedTextField.getFont();
            this.setFont(font.deriveFont(font.getStyle()));
        }

        public void commitEdit() throws ParseException {
            try {
                super.commitEdit();
            }
            catch (ParseException parseException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
                throw parseException;
            }
        }
    }
}

