/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.spinner;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import jpdf_common.gui.plaf.PlafPainter;

public class UneditableSpinner
extends JSpinner
implements FocusListener {
    public UneditableSpinner(SpinnerModel spinnerModel) {
        this(spinnerModel, 0, 2);
    }

    public UneditableSpinner(SpinnerModel spinnerModel, int n2) {
        this(spinnerModel, n2, 2);
    }

    public UneditableSpinner(SpinnerModel spinnerModel, int n2, int n3) {
        super(spinnerModel);
        this.a(n2, n3);
        PlafPainter.getPlafPainter().customizeComponent(this);
    }

    public void paint(Graphics graphics) {
        PlafPainter plafPainter = PlafPainter.getPlafPainter();
        plafPainter.prepareToPaint(graphics, this);
        super.paint(graphics);
        if (((JSpinner.DefaultEditor)this.getEditor()).getTextField().isFocusOwner()) {
            plafPainter.paintFocusRectangle(graphics, this);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    public JFormattedTextField getEditorField() {
        return ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
    }

    public void updateUI() {
        JFormattedTextField jFormattedTextField = this.getEditorField();
        super.updateUI();
        this.setForeground(new Color(PlafPainter.CONTROL_TEXT_COLOR.getRGB()));
        jFormattedTextField.setDisabledTextColor(Color.BLACK);
        jFormattedTextField.setEditable(false);
        jFormattedTextField.setOpaque(true);
        jFormattedTextField.setFont(UIManager.getFont("Spinner.font"));
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.getEditorField().setDisabledTextColor(Color.BLACK);
        }
        super.setEnabled(bl);
    }

    private void a(int n2, int n3) {
        JFormattedTextField jFormattedTextField = this.getEditorField();
        Dimension dimension = null;
        jFormattedTextField.setHorizontalAlignment(n2);
        jFormattedTextField.setColumns(n3);
        dimension = jFormattedTextField.getPreferredSize();
        dimension.width += 4;
        jFormattedTextField.setColumns(0);
        jFormattedTextField.setPreferredSize(dimension);
        jFormattedTextField.addFocusListener(this);
    }
}

