/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.select;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jpdf_common.gui.component.select.f;
import jpdf_common.gui.plaf.PlafPainter;
import jpdf_common.gui.utility.KeyboardActionUtility;

public abstract class AbstractSelectionGridPanel
extends JPanel {
    public static final int SELECT_NO_CELL = 0;
    public static final int SELECT_SINGLE_CELL = 1;
    public static final int SELECT_SINGLE_RANGE = 2;
    protected static final int NO_VALUE = -9999;
    protected static final int DEFAULT_CELL_WIDTH = 18;
    protected static final int DEFAULT_CELL_HEIGHT = 18;
    protected final Border CELL_FLYOVER_BORDER = this.createFlyoverCellBorder();
    protected final Border CELL_BORDER;
    protected final Dimension CELL_SIZE;
    protected final Color CELL_FOREGROUND;
    protected final Border SELECTED_CELL_BORDER;
    protected final Color SELECTED_CELL_BACKGROUND;
    protected final Color SELECTED_CELL_FOREGROUND;
    private int a = 0;
    private boolean j = false;
    private boolean e = true;

    public AbstractSelectionGridPanel(int n2) {
        this(n2, new Dimension(18, 18), 3, true);
    }

    public AbstractSelectionGridPanel(int n2, Dimension dimension, int n3) {
        this(n2, dimension, n3, true);
    }

    public AbstractSelectionGridPanel(int n2, int n3, int n4, boolean bl) {
        this(n2, new Dimension(n3, n3), n4, bl);
    }

    public AbstractSelectionGridPanel(int n2, Dimension dimension, int n3, boolean bl) {
        super(new GridLayout(0, n2, n3, n3));
        this.CELL_SIZE = dimension;
        this.CELL_FOREGROUND = PlafPainter.CONTROL_TEXT_COLOR;
        this.SELECTED_CELL_BACKGROUND = Color.BLACK;
        this.SELECTED_CELL_FOREGROUND = Color.WHITE;
        if (bl) {
            this.CELL_BORDER = this.createCellBorder(this.CELL_FOREGROUND);
            this.SELECTED_CELL_BORDER = this.createSelectedCellBorder(this.SELECTED_CELL_FOREGROUND);
        } else {
            this.CELL_BORDER = null;
            this.SELECTED_CELL_BORDER = null;
        }
        this.e();
    }

    public JButton createUnselectAllButton(String string, Dimension dimension) {
        return new f(this, string, dimension, null);
    }

    public void flyoverClear() {
        int n2 = this.b();
        if (n2 >= 0) {
            ((SelectionCell)this.getComponent(n2)).setFlyover(false);
        }
    }

    public void flyoverDown() {
        this.c(this.getColumnCount());
    }

    public void flyoverLeft() {
        this.c(-1);
    }

    public void flyoverRight() {
        this.c(1);
    }

    public void flyoverUp() {
        this.c(-this.getColumnCount());
    }

    public int getColumnCount() {
        return ((GridLayout)this.getLayout()).getColumns();
    }

    public int getPrefixEmptyCellCount() {
        return this.a;
    }

    public int getRowCount() {
        int n2 = this.getColumnCount();
        int n3 = this.getComponentCount();
        boolean bl = n3 % n2 == 0;
        return n3 / n2 + (bl ? 0 : 1);
    }

    public int getRowHeight() {
        if (this.getComponentCount() == 0) {
            return 0;
        }
        return this.getComponent(0).getHeight() + ((GridLayout)this.getLayout()).getVgap();
    }

    public int getRowIndex(int n2) {
        int n3 = this.getColumnCount();
        if (n2 < 0 || n2 >= this.getComponentCount()) {
            String string = "Invalid Selection Grid Cell Index: " + n2;
            throw new IllegalArgumentException(string);
        }
        return n2 / n3;
    }

    public int getRowY(int n2) {
        if (n2 < 0 || n2 >= this.getRowCount()) {
            String string = "Invalid Selection Grid Row Index: " + n2;
            throw new IllegalArgumentException(string);
        }
        return this.getRowHeight() * n2 + this.getComponent(0).getY();
    }

    public int getValueCellCount() {
        return this.getComponentCount() - this.getPrefixEmptyCellCount();
    }

    public boolean isFlyoverWrappedAtEnd() {
        return this.j;
    }

    public boolean isFocusPainted() {
        return this.e;
    }

    public boolean isMatchingArrangement(int n2, int n3) {
        return this.isMatchingArrangement(n2, n3, 0);
    }

    public boolean isMatchingArrangement(int n2, int n3, int n4) {
        if (n4 != this.getPrefixEmptyCellCount()) {
            return false;
        }
        if (n3 != ((GridLayout)this.getLayout()).getColumns()) {
            return false;
        }
        return (n2 += n4) == this.getComponentCount();
    }

    public boolean isMatchingDimensions(int n2, int n3) {
        int n4 = ((GridLayout)this.getLayout()).getColumns();
        int n5 = 0;
        int n6 = 0;
        if (n4 != n3) {
            return false;
        }
        n5 = this.getComponentCount();
        if (n5 > 0) {
            n6 = (int)((float)(n5 - 1) / (float)n4) + 1;
        }
        return n6 == n2;
    }

    public void makeKeyboardTraversable() {
        this.addKeyboardActions(this);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setFocusTraversalKeysEnabled(true);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isFocusOwner() && this.isFocusPainted()) {
            PlafPainter.getPlafPainter().paintFocusRectangle(graphics, this);
        }
    }

    public void selectFlyoverCell(boolean bl) {
        int n2 = this.b();
        if (n2 >= 0) {
            this.selectCell((SelectionCell)this.getComponent(n2), bl);
        }
    }

    public void setCellWidth(int n2) {
        Component[] componentArray = this.getComponents();
        this.CELL_SIZE.width = n2;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            ((SelectionCell)componentArray[i2]).setPreferredSize(this.CELL_SIZE);
        }
    }

    public void setFlyoverWrappedAtEnd(boolean bl) {
        this.j = bl;
    }

    public void setFocusable(boolean bl) {
        super.setFocusable(bl);
        if (bl) {
            this.enableEvents(4L);
        } else {
            this.disableEvents(4L);
        }
    }

    public void setFocusPainted(boolean bl) {
        this.e = bl;
    }

    public void setForeground(Color color) {
        Component[] componentArray = this.getComponents();
        super.setForeground(color);
        for (int i2 = this.getPrefixEmptyCellCount(); i2 < componentArray.length; ++i2) {
            ((SelectionCell)componentArray[i2]).setForeground(color);
        }
    }

    public void setPrefixEmptyCellCount(int n2) {
        if (this.a > n2) {
            for (int i2 = 0; i2 < this.a - n2; ++i2) {
                this.remove(0);
            }
        } else {
            for (int i3 = this.a; i3 < n2; ++i3) {
                this.add((Component)new EmptySelectionCell(this), 0);
            }
        }
        this.a = n2;
        this.invalidate();
    }

    public abstract void unselectAllCells(boolean var1);

    protected void addImpl(Component component, Object object, int n2) {
        String string = null;
        if (!(component instanceof SelectionCell)) {
            string = "Only Selection Cells can be added to a Selection Grid Panel.\n  Invalid Component: " + component;
            throw new IllegalArgumentException(string);
        }
        super.addImpl(component, object, n2);
    }

    protected void addKeyboardActions(JComponent jComponent) {
        AbstractAction abstractAction = null;
        abstractAction = new FlyoverLeftAction(this);
        KeyboardActionUtility.addFocusedKeyboardAction(jComponent, "flyoverLeft", 37, abstractAction);
        abstractAction = new FlyoverRightAction(this);
        KeyboardActionUtility.addFocusedKeyboardAction(jComponent, "flyoverRight", 39, abstractAction);
        abstractAction = new FlyoverUpAction(this);
        KeyboardActionUtility.addFocusedKeyboardAction(jComponent, "flyoverUp", 38, abstractAction);
        abstractAction = new FlyoverDownAction(this);
        KeyboardActionUtility.addFocusedKeyboardAction(jComponent, "flyoverDown", 40, abstractAction);
        abstractAction = new SelectFlyoverAction(this);
        KeyboardActionUtility.addFocusedKeyboardAction(jComponent, "selectFlyover", 10, abstractAction);
    }

    protected Border createCellBorder(Color color) {
        return BorderFactory.createLineBorder(color);
    }

    protected Border createFlyoverCellBorder() {
        return BorderFactory.createLineBorder(Color.RED);
    }

    protected Border createSelectedCellBorder(Color color) {
        return BorderFactory.createLineBorder(color);
    }

    protected int getSelectedCellIndex() {
        SelectionCell selectionCell = null;
        Component[] componentArray = this.getComponents();
        int n2 = -1;
        for (int i2 = this.getPrefixEmptyCellCount(); i2 < componentArray.length; ++i2) {
            selectionCell = (SelectionCell)componentArray[i2];
            if (!selectionCell.isSelected()) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        boolean bl = focusEvent.getID() == 1005;
        boolean bl2 = focusEvent.isTemporary();
        super.processFocusEvent(focusEvent);
        if (bl && !bl2) {
            this.flyoverClear();
        }
        this.repaint();
    }

    protected void resetAllSelections() {
        Component[] componentArray = this.getComponents();
        for (int i2 = this.getPrefixEmptyCellCount(); i2 < componentArray.length; ++i2) {
            ((SelectionCell)componentArray[i2]).setSelected(false);
        }
    }

    protected abstract void selectCell(SelectionCell var1, boolean var2);

    private void c(int n2) {
        int n3 = this.b();
        if (n3 < 0) {
            n3 = this.getSelectedCellIndex();
        }
        this.b(n3 + n2);
    }

    private int b() {
        SelectionCell selectionCell = null;
        Component[] componentArray = this.getComponents();
        int n2 = -1;
        for (int i2 = this.getPrefixEmptyCellCount(); i2 < componentArray.length; ++i2) {
            selectionCell = (SelectionCell)componentArray[i2];
            if (!selectionCell.isFlyover()) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    private void e() {
        this.setFocusable(false);
    }

    private void b(int n2) {
        SelectionCell selectionCell = null;
        int n3 = this.getComponentCount();
        int n4 = this.getPrefixEmptyCellCount();
        if (!this.isFlyoverWrappedAtEnd()) {
            if (n2 < n4) {
                return;
            }
            if (n2 >= n3) {
                return;
            }
        }
        this.flyoverClear();
        if (n2 < n4) {
            n2 = n3 - 1;
        } else if (n2 >= n3) {
            n2 = n4;
        }
        selectionCell = (SelectionCell)this.getComponent(n2);
        selectionCell.setFlyover(true);
    }

    static int a(AbstractSelectionGridPanel abstractSelectionGridPanel) {
        return abstractSelectionGridPanel.b();
    }

    protected class EmptySelectionCell
    extends SelectionCell {
        private final AbstractSelectionGridPanel c;

        protected EmptySelectionCell(AbstractSelectionGridPanel abstractSelectionGridPanel) {
            this.c = abstractSelectionGridPanel;
            super(abstractSelectionGridPanel);
            this.setPreferredSize(abstractSelectionGridPanel.CELL_SIZE);
            this.setOpaque(false);
        }
    }

    protected class SelectionCell
    extends JLabel {
        private final AbstractSelectionGridPanel c;

        protected SelectionCell(AbstractSelectionGridPanel abstractSelectionGridPanel) {
            this.c = abstractSelectionGridPanel;
        }

        protected SelectionCell(AbstractSelectionGridPanel abstractSelectionGridPanel, MouseListener mouseListener, String string) {
            this.c = abstractSelectionGridPanel;
            super(string, 0);
            this.a(mouseListener, string);
        }

        public boolean isFlyover() {
            return this.getBorder() == this.c.CELL_FLYOVER_BORDER;
        }

        public boolean isSelected() {
            return this.isOpaque();
        }

        public void setFlyover(boolean bl) {
            this.setBorder(bl ? this.c.CELL_FLYOVER_BORDER : this.c.CELL_BORDER);
        }

        public void setSelected(boolean bl) {
            if (bl) {
                this.setForeground(this.c.SELECTED_CELL_FOREGROUND);
                this.setBorder(this.c.SELECTED_CELL_BORDER);
            } else {
                this.setForeground(this.c.CELL_FOREGROUND);
                this.setBorder(this.c.CELL_BORDER);
            }
            this.setOpaque(bl);
        }

        public String toString() {
            return this.getClass().getName() + " [" + this.getText() + "]";
        }

        private void a(MouseListener mouseListener, String string) {
            this.setBackground(this.c.SELECTED_CELL_BACKGROUND);
            this.setBorder(this.c.CELL_BORDER);
            this.setPreferredSize(this.c.CELL_SIZE);
            this.setOpaque(false);
            if (mouseListener != null) {
                this.addMouseListener(mouseListener);
            }
        }
    }

    protected class CellSelectionMouseListener
    extends MouseAdapter {
        private final AbstractSelectionGridPanel a;

        protected CellSelectionMouseListener(AbstractSelectionGridPanel abstractSelectionGridPanel) {
            this.a = abstractSelectionGridPanel;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            SelectionCell selectionCell = (SelectionCell)mouseEvent.getSource();
            this.a.flyoverClear();
            selectionCell.setFlyover(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SelectionCell selectionCell = (SelectionCell)mouseEvent.getSource();
            if (!this.a.isFocusOwner()) {
                selectionCell.setFlyover(false);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SelectionCell selectionCell = null;
            int n2 = AbstractSelectionGridPanel.a(this.a);
            selectionCell = n2 >= 0 ? (SelectionCell)this.a.getComponent(n2) : (SelectionCell)mouseEvent.getSource();
            this.a.selectCell(selectionCell, true);
        }
    }

    protected class SelectFlyoverAction
    extends AbstractAction {
        private final AbstractSelectionGridPanel a;

        protected SelectFlyoverAction(AbstractSelectionGridPanel abstractSelectionGridPanel) {
            this.a = abstractSelectionGridPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.selectFlyoverCell(true);
        }
    }

    protected class FlyoverUpAction
    extends AbstractAction {
        private final AbstractSelectionGridPanel a;

        protected FlyoverUpAction(AbstractSelectionGridPanel abstractSelectionGridPanel) {
            this.a = abstractSelectionGridPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.flyoverUp();
        }
    }

    protected class FlyoverRightAction
    extends AbstractAction {
        private final AbstractSelectionGridPanel a;

        protected FlyoverRightAction(AbstractSelectionGridPanel abstractSelectionGridPanel) {
            this.a = abstractSelectionGridPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.flyoverRight();
        }
    }

    protected class FlyoverLeftAction
    extends AbstractAction {
        private final AbstractSelectionGridPanel a;

        protected FlyoverLeftAction(AbstractSelectionGridPanel abstractSelectionGridPanel) {
            this.a = abstractSelectionGridPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.flyoverLeft();
        }
    }

    protected class FlyoverDownAction
    extends AbstractAction {
        private final AbstractSelectionGridPanel a;

        protected FlyoverDownAction(AbstractSelectionGridPanel abstractSelectionGridPanel) {
            this.a = abstractSelectionGridPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.flyoverDown();
        }
    }
}

