/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.select;

import java.awt.Dimension;
import java.awt.event.MouseListener;
import jpdf_common.gui.component.select.AbstractSelectionGridPanel;

public abstract class AbstractNumberSelectionGridPanel
extends AbstractSelectionGridPanel {
    protected final int FIRST_CELL_VALUE;

    public AbstractNumberSelectionGridPanel(int n2, int n3, int n4, boolean bl) {
        super(1, n3, n4, bl);
        this.FIRST_CELL_VALUE = n2;
    }

    public int getFirstCellValue() {
        return this.FIRST_CELL_VALUE;
    }

    public int getLastCellValue() {
        return this.FIRST_CELL_VALUE + this.getValueCellCount() - 1;
    }

    public int getValueCellY(int n2) {
        if (n2 < this.getFirstCellValue() || n2 > this.getLastCellValue()) {
            String string = "Invalid Selection Grid Cell Value: " + n2;
            throw new IllegalArgumentException(string);
        }
        return this.getRowY(this.getRowIndex(this.getCellIndex(n2)));
    }

    public void selectCellValue(int n2, boolean bl) {
        int n3 = 0;
        if (n2 >= this.FIRST_CELL_VALUE && n3 <= this.getLastCellValue()) {
            n3 = n2 - this.FIRST_CELL_VALUE + this.getPrefixEmptyCellCount();
            this.selectCell((NumberSelectionCell)this.getComponents()[n3], bl);
        }
    }

    public abstract void setArrangement(int var1, int var2);

    public void setDimensions(int n2, int n3) {
        this.setArrangement(n2 * n3, n3);
    }

    public void setDimensions(Dimension dimension) {
        this.setDimensions(dimension.height, dimension.width);
    }

    protected int getCellIndex(int n2) {
        return n2 - this.FIRST_CELL_VALUE + this.getPrefixEmptyCellCount();
    }

    protected abstract void informSelectionObserver(int var1);

    protected void selectCell(AbstractSelectionGridPanel.SelectionCell selectionCell, boolean bl) {
        int n2 = 0;
        if (selectionCell != null) {
            n2 = ((NumberSelectionCell)selectionCell).getCellValue();
            this.resetAllSelections();
            selectionCell.setSelected(true);
            this.repaint();
            if (bl) {
                this.informSelectionObserver(n2);
            }
        }
    }

    protected void updateCellWidth(int n2, int n3) {
        int n4 = Integer.toString(n2).length();
        int n5 = Integer.toString(n3).length();
        if (n5 != n4) {
            if (n5 <= 2) {
                this.setCellWidth(18);
            } else {
                this.setCellWidth(18 + 4 * (n5 - 2));
            }
        }
    }

    protected class NumberSelectionCell
    extends AbstractSelectionGridPanel.SelectionCell {
        private final AbstractNumberSelectionGridPanel this$0;

        protected NumberSelectionCell(AbstractNumberSelectionGridPanel abstractNumberSelectionGridPanel, MouseListener mouseListener, int n2) {
            this.this$0 = abstractNumberSelectionGridPanel;
            super(abstractNumberSelectionGridPanel, mouseListener, Integer.toString(n2));
        }

        protected int getCellValue() {
            return Integer.parseInt(this.getText());
        }
    }
}

