/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import jpdf_common.gui.component.popup.d;
import jpdf_common.gui.component.popup.m;
import jpdf_common.gui.utility.UIUtility;

public abstract class AbstractPopupPanel
extends JPanel {
    private final m j = new m(this, null);
    protected final JComponent POPUP_COMPONENT;
    private Window i = null;
    private Popup h = null;

    public AbstractPopupPanel(JComponent jComponent) {
        this.POPUP_COMPONENT = jComponent;
        jComponent.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        jComponent.setSize(jComponent.getPreferredSize());
    }

    public void addNotify() {
        Window window = SwingUtilities.getWindowAncestor(this);
        String string = null;
        super.addNotify();
        if (window != null && !(window instanceof JDialog) && !(window instanceof JFrame)) {
            string = "The Popup Owner Window must be a javax.swing.JDialog of javax.swing.JFrame instance.\nInvalid Owner Window: " + window;
            throw new IllegalArgumentException(string);
        }
        this.i = window;
    }

    public void hidePopup() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.j);
        if (this.h != null) {
            this.h.hide();
            this.h = null;
        }
    }

    public boolean isPopupVisible() {
        return this.h != null;
    }

    public void showPopup() {
        Point point = this.computePopupDisplayLocation();
        this.h = new d(this, this.i, this.POPUP_COMPONENT, point.x, point.y, null);
        this.h.show();
        this.POPUP_COMPONENT.requestFocusInWindow();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.j, 17L);
    }

    public void togglePopupDisplay() {
        if (this.h != null) {
            this.hidePopup();
        } else {
            this.showPopup();
        }
    }

    protected Point computePopupDisplayLocation() {
        Dimension dimension = UIUtility.getScreenSize();
        Point point = this.getLocationOnScreen();
        int n2 = this.POPUP_COMPONENT.getWidth();
        int n3 = this.POPUP_COMPONENT.getHeight();
        int n4 = 0;
        point.y = point.y + n3 + 5 <= dimension.height ? (point.y += this.getHeight()) : (point.y -= n3);
        n4 = point.x + n2 + 5 - dimension.width;
        if (n4 > 0) {
            point.x -= n4;
        }
        return point;
    }

    protected boolean isComponentInsidePopup(Component component) {
        RootPaneContainer rootPaneContainer = null;
        Container container = null;
        if (component instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)component)).getContentPane();
            return container.getComponentCount() > 0 && container.getComponent(0) == this.POPUP_COMPONENT;
        }
        rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(component));
        container = rootPaneContainer.getContentPane();
        return container.getComponentCount() > 0 && container.getComponent(0) == this.POPUP_COMPONENT;
    }

    protected void handlePopupMousePress(MouseEvent mouseEvent, Component component) {
        if (!this.isComponentInsidePopup(component)) {
            this.hidePopup();
        }
    }

    static Window a(AbstractPopupPanel abstractPopupPanel) {
        return abstractPopupPanel.i;
    }

    protected class TogglePopupDisplayAction
    extends AbstractAction {
        private final AbstractPopupPanel a;

        protected TogglePopupDisplayAction(AbstractPopupPanel abstractPopupPanel) {
            this.a = abstractPopupPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.togglePopupDisplay();
        }
    }

    protected class ShowPopupAction
    extends AbstractAction {
        private final AbstractPopupPanel a;

        protected ShowPopupAction(AbstractPopupPanel abstractPopupPanel) {
            this.a = abstractPopupPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.a.isPopupVisible()) {
                this.a.showPopup();
            }
        }
    }

    protected class HidePopupAction
    extends AbstractAction {
        private final AbstractPopupPanel a;

        protected HidePopupAction(AbstractPopupPanel abstractPopupPanel) {
            this.a = abstractPopupPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.a.isPopupVisible()) {
                this.a.hidePopup();
            }
        }
    }
}

