/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.html;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import jpdf_common.gui.component.html.c;
import jpdf_common.system.constant.SystemConstant;
import jpdf_common.system.utility.ColorUtility;

public class SynchronousLoadEditorPane
extends JEditorPane {
    private final c b = (c)this.getEditorKit();

    public SynchronousLoadEditorPane() {
        this(4);
    }

    public SynchronousLoadEditorPane(int n2) {
        c.a(this.b, n2);
    }

    public SynchronousLoadEditorPane(URL uRL) throws IOException {
        this(uRL, 4);
    }

    public SynchronousLoadEditorPane(URL uRL, int n2) throws IOException {
        this(n2);
        this.setPage(uRL);
    }

    public SynchronousLoadEditorPane(String string) {
        super("text/html", string);
        c.a(this.b, 4);
    }

    public SynchronousLoadEditorPane(String string, Font font) {
        this(string);
        this.a(font);
    }

    public SynchronousLoadEditorPane(URL uRL, Font font) throws IOException {
        this(uRL);
        this.a(font);
    }

    public void addCssRuleToDoc(String string) {
        StyleSheet styleSheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
        styleSheet.addRule(string);
    }

    public static String buildCssForColor(Color color) {
        return " COLOR: #" + ColorUtility.toHexString(color) + "; ";
    }

    public static String buildCssForFont(Font font) {
        StringBuffer stringBuffer = new StringBuffer(48);
        stringBuffer.append("FONT-FAMILY: " + font.getName() + "; ");
        stringBuffer.append("FONT-SIZE: " + font.getSize() + "pt; ");
        if (font.isBold()) {
            stringBuffer.append("FONT-WEIGHT: bold; ");
        }
        if (font.isItalic()) {
            stringBuffer.append("FONT-STYLE: italic; ");
        }
        return stringBuffer.toString();
    }

    public static String buildCssRuleForFont(String string, Font font) {
        StringBuffer stringBuffer = new StringBuffer(48);
        stringBuffer.append(string + " {FONT-FAMILY: " + font.getName() + "; ");
        stringBuffer.append("FONT-SIZE: " + font.getSize() + "pt; ");
        if (font.isBold()) {
            stringBuffer.append("FONT-WEIGHT: bold; ");
        }
        if (font.isItalic()) {
            stringBuffer.append("FONT-STYLE: italic; ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public EditorKit getEditorKitForContentType(String string) {
        String string2 = null;
        if (!string.equals("text/html")) {
            string2 = "This class is customized to HTML content.\nInvalid Content Type: " + string;
            throw new IllegalArgumentException(string2);
        }
        return this.b;
    }

    public void loadHtml(String string, URL uRL) {
        HTMLDocument hTMLDocument = null;
        hTMLDocument = (HTMLDocument)this.getEditorKit().createDefaultDocument();
        this.setDocument(hTMLDocument);
        hTMLDocument.setBase(uRL);
        this.setText(string);
    }

    protected EditorKit createDefaultEditorKit() {
        return new c(4, null);
    }

    private void a(Font font) {
        if (font != null) {
            this.setFont(font);
            this.addCssRuleToDoc(SynchronousLoadEditorPane.buildCssRuleForFont("BODY", font));
        }
        if (!SystemConstant.RUNNING_VM_1_4) {
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        }
    }
}

