/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.html;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import jpdf_common.gui.component.html.f;
import jpdf_common.gui.constant.UserInterfaceConstant;

public class HtmlViewerPane
extends JEditorPane {
    public static final int DEFAULT_FONT_SIZE_INDEX = 4;
    public static final int MIN_FONT_SIZE_INDEX = 1;
    public static final int MAX_FONT_SIZE_INDEX = 7;
    private final PageLoadObserver c;
    private int b = 4;

    public HtmlViewerPane() {
        this(false, null, 4);
    }

    public HtmlViewerPane(boolean bl) {
        this(bl, null, 4);
    }

    public HtmlViewerPane(boolean bl, PageLoadObserver pageLoadObserver) {
        this(bl, pageLoadObserver, 4);
    }

    public HtmlViewerPane(boolean bl, PageLoadObserver pageLoadObserver, int n2) {
        this.c = pageLoadObserver;
        this.setBaseFontSizeIndex(n2);
        this.setEditable(false);
        this.setEnabled(bl);
        this.setOpaque(true);
        this.setEditorKit(this.createEditorKit());
        if (pageLoadObserver != null) {
            this.addPropertyChangeListener(new f(this, null));
        }
    }

    public void addCssRule(String string) {
        StyleSheet styleSheet = ((HTMLEditorKit)this.getEditorKit()).getStyleSheet();
        styleSheet.addRule(string);
    }

    public void addCssRuleToDoc(String string) {
        StyleSheet styleSheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
        styleSheet.addRule(string);
    }

    public JPanel createContainingDisplayPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(UserInterfaceConstant.DEFAULT_BORDER);
        jPanel.add((Component)new JScrollPane(this), "Center");
        return jPanel;
    }

    public boolean decrementBaseFontSizeIndex() throws IOException {
        if (this.b > 1) {
            --this.b;
            this.refreshContents();
        }
        return this.b > 1;
    }

    public int getBaseFontSizeIndex() {
        return this.b;
    }

    public void loadFile(String string) throws IOException {
        HTMLDocument hTMLDocument = null;
        if (string.charAt(0) == '/') {
            this.setPage(new URL("file://" + string));
        } else {
            this.setPage(new URL("file:///" + string));
        }
        hTMLDocument = (HTMLDocument)this.getDocument();
        hTMLDocument.getStyleSheet().setBaseFontSize(this.b);
    }

    public void loadHtml(String string) {
        HTMLDocument hTMLDocument = null;
        hTMLDocument = (HTMLDocument)this.getEditorKit().createDefaultDocument();
        this.setDocument(hTMLDocument);
        hTMLDocument.getStyleSheet().setBaseFontSize(this.b);
        this.setText(string);
    }

    public void loadHtml(String string, URL uRL) {
        HTMLDocument hTMLDocument = null;
        hTMLDocument = (HTMLDocument)this.getEditorKit().createDefaultDocument();
        this.setDocument(hTMLDocument);
        hTMLDocument.setBase(uRL);
        hTMLDocument.getStyleSheet().setBaseFontSize(this.b);
        this.setText(string);
    }

    public void loadUrl(URL uRL) throws IOException {
        HTMLDocument hTMLDocument = null;
        this.setPage(uRL);
        hTMLDocument = (HTMLDocument)this.getDocument();
        hTMLDocument.getStyleSheet().setBaseFontSize(this.b);
    }

    public boolean incrementBaseFontSizeIndex() throws IOException {
        if (this.b < 7) {
            ++this.b;
            this.refreshContents();
        }
        return this.b < 7;
    }

    public void refreshContents() throws IOException {
        URL uRL = this.getPage();
        if (uRL != null) {
            this.loadHtml("");
            this.loadUrl(uRL);
        } else {
            this.loadHtml(this.getText());
        }
    }

    public void setBaseFontSizeIndex(int n2) {
        this.b = n2 < 1 ? 1 : (n2 > 7 ? 7 : n2);
    }

    public void setEditorKit(EditorKit editorKit) {
        if (!(editorKit instanceof HTMLEditorKit)) {
            editorKit = this.createEditorKit();
        }
        super.setEditorKit(editorKit);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        HTMLDocument hTMLDocument = null;
        int n4 = 0;
        int n5 = 0;
        if (n2 == 1) {
            hTMLDocument = (HTMLDocument)this.getDocument();
            n5 = (int)hTMLDocument.getStyleSheet().getPointSize(this.b);
            n4 = n5 + 4;
        } else {
            n4 = super.getScrollableUnitIncrement(rectangle, n2, n3);
        }
        return n4;
    }

    protected HTMLEditorKit createEditorKit() {
        return new HTMLEditorKit();
    }

    static PageLoadObserver a(HtmlViewerPane htmlViewerPane) {
        return htmlViewerPane.c;
    }

    public static interface PageLoadObserver {
        public void loadedHtmlPage(URL var1);
    }
}

