/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.html;

import java.awt.Color;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import jpdf_common.system.manage.BasicApplicationManager;
import jpdf_common.system.utility.ColorUtility;

public class CloneableHtmlDocument
extends HTMLDocument {
    public CloneableHtmlDocument(StyleSheet styleSheet) {
        super(styleSheet);
    }

    public CloneableHtmlDocument(StyleSheet styleSheet, HTMLDocument hTMLDocument) {
        super(styleSheet);
        this.loadDocumentContentsClone(hTMLDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDocumentContentsClone(HTMLDocument hTMLDocument) {
        Element element = hTMLDocument.getDefaultRootElement();
        AbstractDocument.BranchElement branchElement = null;
        Element[] elementArray = null;
        String string = null;
        branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        elementArray = new Element[((HTMLDocument.BlockElement)element).getChildCount()];
        try {
            this.writeLock();
            this.setBase(hTMLDocument.getBase());
            string = hTMLDocument.getText(0, hTMLDocument.getLength());
            this.insertString(0, string, null);
            for (int i2 = 0; i2 < elementArray.length; ++i2) {
                elementArray[i2] = this.a(branchElement, element.getElement(i2));
            }
            branchElement.replace(0, branchElement.getElementCount(), elementArray);
        }
        catch (Throwable throwable) {
            BasicApplicationManager.handleError(throwable, false);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected Color getBodyBackground() {
        MutableAttributeSet mutableAttributeSet = null;
        Element element = null;
        Color color = null;
        String string = null;
        element = this.a();
        if (element != null && element.getName().equalsIgnoreCase(HTML.Tag.BODY.toString()) && (string = (String)(mutableAttributeSet = (MutableAttributeSet)element.getAttributes()).getAttribute(HTML.Attribute.BGCOLOR)) != null && string.length() == 7 && string.charAt(0) == '#') {
            color = ColorUtility.fromHexString(string.substring(1));
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBodyBackground(Color color) {
        MutableAttributeSet mutableAttributeSet = null;
        Element element = null;
        boolean bl = false;
        try {
            element = this.a();
            if (element != null && element.getName().equalsIgnoreCase(HTML.Tag.BODY.toString())) {
                mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                this.writeLock();
                bl = true;
                if (color != null) {
                    mutableAttributeSet.addAttribute(HTML.Attribute.BGCOLOR, '#' + ColorUtility.toHexString(color));
                } else {
                    mutableAttributeSet.removeAttribute(HTML.Attribute.BGCOLOR);
                }
                this.a(element);
            }
        }
        finally {
            if (bl) {
                this.writeUnlock();
            }
        }
    }

    private Element a(Element element, Element element2) {
        Element element3 = null;
        Element[] elementArray = null;
        if (element2.isLeaf()) {
            element3 = this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
        } else {
            element3 = this.createBranchElement(element, element2.getAttributes());
            elementArray = new Element[element2.getElementCount()];
            for (int i2 = 0; i2 < elementArray.length; ++i2) {
                elementArray[i2] = this.a(element3, element2.getElement(i2));
            }
            ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray);
        }
        return element3;
    }

    private void a(Element element) {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = null;
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset() - n2;
        defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n2, n3, DocumentEvent.EventType.CHANGE);
        this.fireChangedUpdate(defaultDocumentEvent);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
    }

    private Element a() {
        return this.getDefaultRootElement().getElement(1);
    }
}

