/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.font;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpdf_common.gui.component.font.a;
import jpdf_common.gui.component.spinner.NumericSpinner;
import jpdf_common.gui.component.spinner.UneditableSpinner;
import jpdf_common.gui.layout.ColLayout;
import jpdf_common.system.manage.BasicLocalizationManager;

public abstract class AbstractFontSelectionPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private SelectionObserver e = null;
    private JComboBox f = null;
    private JCheckBox b = null;
    private JCheckBox g = null;
    private JSpinner a = null;
    private JPanel d = null;

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleFontChange(true);
    }

    public void addFontOptionsControl(JComponent jComponent) {
        this.addFontOptionsControl(jComponent, false);
    }

    public void addFontOptionsControl(JComponent jComponent, boolean bl) {
        JPanel jPanel = this.a();
        JPanel jPanel2 = null;
        if (bl) {
            jPanel.add(jComponent);
        } else {
            jPanel2 = (JPanel)jPanel.getComponent(0);
            jPanel2.add(jComponent);
        }
    }

    public static String[] getFontNames(boolean bl) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        Vector<String> vector = null;
        Font font = null;
        if (!bl) {
            vector = new Vector<String>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                font = new Font(stringArray[i2], 0, 0);
                if (!font.canDisplay('A')) continue;
                vector.add(stringArray[i2]);
            }
            stringArray = vector.toArray(new String[0]);
        }
        return stringArray;
    }

    public static String[] getFontNames(Locale locale, boolean bl) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames(locale);
        Vector<String> vector = null;
        Font font = null;
        if (!bl) {
            vector = new Vector<String>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                font = new Font(stringArray[i2], 0, 0);
                if (!font.canDisplay('A')) continue;
                vector.add(stringArray[i2]);
            }
            stringArray = vector.toArray(new String[0]);
        }
        return stringArray;
    }

    public abstract Font getSelectedFont();

    public static void loadFontNames(JComboBox jComboBox, boolean bl) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        AbstractFontSelectionPanel.loadFontNames(jComboBox, stringArray, bl);
    }

    public static void loadFontNames(JComboBox jComboBox, Locale locale, boolean bl) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames(locale);
        AbstractFontSelectionPanel.loadFontNames(jComboBox, stringArray, bl);
    }

    public static void loadFontNames(JComboBox jComboBox, String[] stringArray, boolean bl) {
        Font font = null;
        if (bl) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                jComboBox.addItem(stringArray[i2]);
            }
        } else {
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                font = new Font(stringArray[i3], 0, 0);
                if (!font.canDisplay('A')) continue;
                jComboBox.addItem(stringArray[i3]);
            }
        }
    }

    public abstract boolean selectFont(Font var1);

    public void setFontOptionsLayout(LayoutManager layoutManager) {
        JPanel jPanel = this.a();
        JPanel jPanel2 = null;
        jPanel2 = (JPanel)jPanel.getComponent(0);
        jPanel2.setLayout(layoutManager);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.handleFontChange(true);
    }

    protected JCheckBox createBoldCheckBox(Locale locale) {
        String string = null;
        string = locale == null ? "Bold" : BasicLocalizationManager.getLocalizedString("bold");
        this.b = new JCheckBox(string);
        this.b.addActionListener(this);
        return this.b;
    }

    protected JPanel createFontListPanel(Locale locale, boolean bl) {
        JComboBox jComboBox = this.createFontNameComboBox(locale, bl);
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 0));
        JLabel jLabel = null;
        String string = null;
        string = locale == null ? "Name:" : BasicLocalizationManager.getLocalizedString("name") + ":";
        jLabel = new JLabel(string);
        jPanel.add(jLabel);
        jPanel.add(jComboBox);
        jLabel.setLabelFor(jComboBox);
        return jPanel;
    }

    protected JComboBox createFontNameComboBox(Locale locale, boolean bl) {
        this.f = new JComboBox();
        AbstractFontSelectionPanel.loadFontNames(this.f, locale, bl);
        this.f.addActionListener(this);
        return this.f;
    }

    protected JPanel createFontOptionsPanel(Locale locale, LayoutManager layoutManager, boolean bl, boolean bl2, OptionsHolder optionsHolder) {
        JPanel jPanel = null;
        JPanel jPanel2 = new JPanel(layoutManager);
        this.d = new JPanel(new ColLayout(0, 0, 0));
        if (bl) {
            jPanel = this.createFontSizePanel(locale, optionsHolder);
            jPanel2.add(jPanel);
        }
        if (bl2) {
            jPanel2.add(this.createBoldCheckBox(locale));
            jPanel2.add(this.createItalicCheckBox(locale));
        }
        this.d.add(jPanel2);
        return this.d;
    }

    protected JPanel createFontSizePanel(Locale locale, OptionsHolder optionsHolder) {
        JSpinner jSpinner = this.createFontSizeSpinner(optionsHolder, new Dimension(50, 25));
        JPanel jPanel = new JPanel(new FlowLayout(0, 3, 0));
        JLabel jLabel = null;
        String string = null;
        string = locale == null ? "Size:" : BasicLocalizationManager.getLocalizedString("size") + ":";
        jLabel = new JLabel(string);
        jPanel.add(jLabel);
        jPanel.add(jSpinner);
        jLabel.setLabelFor(((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField());
        return jPanel;
    }

    protected JSpinner createFontSizeSpinner(OptionsHolder optionsHolder, Dimension dimension) {
        return this.createFontSizeSpinner(optionsHolder.minFontSize, optionsHolder.minFontSize, optionsHolder.maxFontSize, optionsHolder.fontSizeIncrement, dimension, optionsHolder.editableSizeSpinner);
    }

    protected JSpinner createFontSizeSpinner(int n2, int n3, int n4, int n5, Dimension dimension, boolean bl) {
        if (bl) {
            this.a = new NumericSpinner(n2, n3, n4, n5);
            this.a.addFocusListener(new a(this));
        } else {
            this.a = new UneditableSpinner(new SpinnerNumberModel(n2, n3, n4, n5));
        }
        if (dimension != null) {
            this.a.setPreferredSize(dimension);
        }
        this.a.addChangeListener(this);
        return this.a;
    }

    protected JCheckBox createItalicCheckBox(Locale locale) {
        String string = null;
        string = locale == null ? "Italic" : BasicLocalizationManager.getLocalizedString("italic");
        this.g = new JCheckBox(string);
        this.g.addActionListener(this);
        return this.g;
    }

    protected JCheckBox getBoldCheckBox() {
        return this.b;
    }

    protected JComboBox getFontNameComboBox() {
        return this.f;
    }

    protected JSpinner getFontSizeSpinner() {
        return this.a;
    }

    protected JCheckBox getItalicCheckBox() {
        return this.g;
    }

    protected int getRestrictedFontSize(int n2) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.getFontSizeSpinner().getModel();
        Integer n3 = (Integer)spinnerNumberModel.getMinimum();
        Integer n4 = (Integer)spinnerNumberModel.getMaximum();
        int n5 = n2;
        if (n2 < n3) {
            n5 = n3;
        } else if (n4 != null && n2 > n4) {
            n5 = n4;
        }
        return n5;
    }

    protected SelectionObserver getSelectionObserver() {
        return this.e;
    }

    protected abstract void handleFontChange(boolean var1);

    protected void informSelectionObserver(Font font) {
        SelectionObserver selectionObserver = this.getSelectionObserver();
        if (selectionObserver != null) {
            selectionObserver.selectedFont(font);
        }
    }

    protected void initializeState(Font font, SelectionObserver selectionObserver, boolean bl) {
        if (bl) {
            this.setSelectionObserver(selectionObserver);
        }
        if (font != null) {
            this.selectFont(font);
        } else {
            this.handleFontChange(bl);
        }
        this.setSelectionObserver(selectionObserver);
    }

    protected boolean selectFontName(Font font) {
        JComboBox jComboBox = this.getFontNameComboBox();
        String string = font.getFamily();
        String string2 = null;
        boolean bl = false;
        int n2 = 0;
        jComboBox.setSelectedItem(string);
        if (jComboBox.getSelectedItem() != string) {
            string = string.toUpperCase();
            n2 = jComboBox.getItemCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                string2 = jComboBox.getItemAt(i2).toString().toUpperCase();
                if (!string2.startsWith(string)) continue;
                jComboBox.setSelectedIndex(i2);
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    protected void setSelectionObserver(SelectionObserver selectionObserver) {
        this.e = selectionObserver;
    }

    JPanel a() {
        return this.d;
    }

    public static class OptionsHolder {
        public boolean includeMissingGlyphFonts = false;
        public boolean editableSizeSpinner = true;
        public int minFontSize = 8;
        public int maxFontSize = 99;
        public int fontSizeIncrement = 1;

        public OptionsHolder() {
        }

        public OptionsHolder(boolean bl) {
            this.includeMissingGlyphFonts = bl;
        }

        public OptionsHolder(boolean bl, boolean bl2, int n2, int n3, int n4) {
            this.includeMissingGlyphFonts = bl;
            this.editableSizeSpinner = bl2;
            this.minFontSize = n2;
            this.maxFontSize = n3;
            this.fontSizeIncrement = n4;
        }
    }

    public static interface SelectionObserver {
        public void selectedFont(Font var1);
    }
}

