/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.combo;

import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jpdf_common.gui.component.combo.AbstractComboBoxEditor;
import jpdf_common.gui.manage.BasicOptionPaneManager;

public class NumericComboBoxEditor
extends AbstractComboBoxEditor {
    private final boolean k;
    private Float a = null;
    private String j = null;
    private String d = null;
    private boolean i = false;
    private float c = 0.0f;
    private float h = 0.0f;

    public NumericComboBoxEditor(int n2, String string, boolean bl) {
        super(n2);
        this.k = bl;
        if (string != null) {
            this.setErrorMessageTitle("Invalid " + string);
            this.setRangeMessageTemplate("The " + string + " must be between <min> and <max>.");
        }
    }

    public NumericComboBoxEditor(int n2, float f2, float f3, String string, boolean bl) {
        super(n2);
        if (f2 >= f3) {
            String string2 = "Invalid " + string + " Combo Box range: " + Float.toString(f2) + " - " + Float.toString(f3);
            throw new IllegalArgumentException(string2);
        }
        this.k = bl;
        if (string != null) {
            this.setErrorMessageTitle("Invalid " + string);
            this.setRangeMessageTemplate("The " + string + " must be between <min> and <max>.");
        }
        this.setValueRange(f2, f3);
    }

    public String getErrorMessageTitle() {
        return this.j;
    }

    public Object getItem() {
        Float f2 = null;
        float f3 = 0.0f;
        try {
            f3 = this.parseInputStringValue(this.getEditorTextField().getText());
            f2 = new Float(f3);
        }
        catch (NumberFormatException numberFormatException) {
            f2 = this.c();
        }
        return f2;
    }

    public String getRangeMessageTemplate() {
        return this.d;
    }

    public void setErrorMessageTitle(String string) {
        this.j = string;
    }

    public void setItem(Object object) {
        float f2 = 0.0f;
        if (object instanceof Float && this.isValidNumberValue(f2 = ((Float)object).floatValue())) {
            this.getEditorTextField().setText(this.formatValueForDisplay(f2));
            this.a((Float)object);
        }
    }

    public void setRangeMessageTemplate(String string) {
        this.d = string;
    }

    protected void clear() {
        this.getEditorTextField().setText("");
        this.a(null);
    }

    protected void displayErrorMessage(String string) {
        BasicOptionPaneManager.displayMessageDialog(SwingUtilities.getWindowAncestor(this.getEditorTextField()), this.getErrorMessageTitle(), string, 0, true);
    }

    protected String formatValueForDisplay(float f2) {
        String string = null;
        string = this.k ? Integer.toString(Math.round(f2)) : Float.toString(f2);
        return string;
    }

    protected float getMaximum() {
        return this.h;
    }

    protected float getMinimum() {
        return this.c;
    }

    protected Float getPreviousValidValue() {
        return this.a;
    }

    protected boolean isRangeRestricted() {
        return this.i;
    }

    protected boolean isValidNumberValue(float f2) {
        Float f3 = this.getPreviousValidValue();
        String string = null;
        boolean bl = true;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (this.isRangeRestricted()) {
            f4 = this.getMinimum();
            f5 = this.getMaximum();
            if (f2 < f4 || f2 > f5) {
                string = this.getRangeMessageTemplate().replaceAll("<min>", Float.toString(f4)).replaceAll("<max>", Float.toString(f5));
                this.displayErrorMessage(string);
                bl = false;
            }
        }
        if (bl && f3 != null) {
            bl = f2 != f3.floatValue();
        }
        return bl;
    }

    protected float parseInputStringValue(String string) throws NumberFormatException {
        return Float.parseFloat(string);
    }

    protected void setValueRange(float f2, float f3) {
        String string = null;
        if (f2 >= f3) {
            string = "Invalid Numeric Combo Box range: " + Float.toString(f2) + " - " + Float.toString(f3);
            throw new IllegalArgumentException(string);
        }
        this.i = true;
        this.c = f2;
        this.h = f3;
    }

    protected boolean validateTextInput() {
        float f2 = 0.0f;
        boolean bl = false;
        try {
            f2 = this.parseInputStringValue(this.getEditorTextField().getText());
            bl = this.isValidNumberValue(f2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!bl) {
            this.c();
        }
        return bl;
    }

    private Float c() {
        JTextField jTextField = this.getEditorTextField();
        Float f2 = this.getPreviousValidValue();
        if (f2 != null) {
            jTextField.setText(this.formatValueForDisplay(f2.floatValue()));
        } else {
            jTextField.setText("");
        }
        return f2;
    }

    private void a(Float f2) {
        this.a = f2;
    }
}

