/*
 * Decompiled with CFR 0.152.
 */
package jpdf_common.gui.component.button;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jpdf_common.gui.constant.ButtonConstant;
import jpdf_common.gui.utility.UIUtility;

public abstract class AbstractButtonPanel
extends JPanel {
    public static final Dimension DEFAULT_BUTTON_SIZE = ButtonConstant.BIG_BUTTON_SIZE;
    public static final Dimension DEFAULT_ICON_SIZE = ButtonConstant.SMALL_ICON_BUTTON_SIZE;
    private JDialog a = null;

    public AbstractButtonPanel() {
    }

    public AbstractButtonPanel(JDialog jDialog) {
        this.a = jDialog;
    }

    public static JButton createBigButton(String string, ActionListener actionListener) {
        return AbstractButtonPanel.createButton(string, actionListener, ButtonConstant.BIG_BUTTON_SIZE);
    }

    public static JButton createButton(String string, ActionListener actionListener, Dimension dimension) {
        JButton jButton = new JButton(string);
        if (dimension != null) {
            UIUtility.setFixedSize(jButton, dimension);
        }
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JButton createMediumButton(String string, ActionListener actionListener) {
        return AbstractButtonPanel.createButton(string, actionListener, ButtonConstant.MEDIUM_BUTTON_SIZE);
    }

    public static JButton createSmallButton(String string, ActionListener actionListener) {
        return AbstractButtonPanel.createButton(string, actionListener, ButtonConstant.SMALL_BUTTON_SIZE);
    }

    public JButton[] getButtons() {
        return AbstractButtonPanel.getButtonsInContainer(this);
    }

    public static JButton[] getButtonsInContainer(Container container) {
        Component[] componentArray = container.getComponents();
        Object var2_2 = null;
        Vector<JButton> vector = new Vector<JButton>(6);
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (!(componentArray[i2] instanceof JButton)) continue;
            vector.add((JButton)componentArray[i2]);
        }
        return vector.toArray(new JButton[vector.size()]);
    }

    public void setButtonEnabled(String string, boolean bl) {
        JButton[] jButtonArray = this.getButtons();
        for (int i2 = 0; i2 < jButtonArray.length; ++i2) {
            if (jButtonArray[i2].getText() != string) continue;
            jButtonArray[i2].setEnabled(bl);
            break;
        }
    }

    public void setEnabled(boolean bl) {
        JButton[] jButtonArray = this.getButtons();
        super.setEnabled(bl);
        for (int i2 = 0; i2 < jButtonArray.length; ++i2) {
            jButtonArray[i2].setEnabled(bl);
        }
    }

    public void setIconButtonEnabled(String string, boolean bl, boolean bl2) {
        JButton[] jButtonArray = this.getButtons();
        for (int i2 = 0; i2 < jButtonArray.length; ++i2) {
            if (jButtonArray[i2].getToolTipText() != string) continue;
            jButtonArray[i2].setEnabled(bl);
            if (!bl2) break;
            jButtonArray[i2].setBorderPainted(bl);
            break;
        }
    }

    static JDialog a(AbstractButtonPanel abstractButtonPanel) {
        return abstractButtonPanel.a;
    }

    protected class HideParentButtonEventListener
    implements ActionListener {
        private final AbstractButtonPanel a;

        protected HideParentButtonEventListener(AbstractButtonPanel abstractButtonPanel) {
            this.a = abstractButtonPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AbstractButtonPanel.a(this.a) != null) {
                AbstractButtonPanel.a(this.a).setVisible(false);
            }
        }
    }
}

