/*
 * Decompiled with CFR 0.152.
 */
package jpdf.wrap;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import jpdf.wrap.Graphics2DWrapper;

public class NoAlphaGraphics2DWrapper
extends Graphics2DWrapper {
    public NoAlphaGraphics2DWrapper(Graphics2D graphics2D) {
        super(graphics2D);
    }

    public Graphics create() {
        return new NoAlphaGraphics2DWrapper((Graphics2D)this.TARGET_GRAPHICS.create());
    }

    public Graphics create(int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = null;
        graphics2D = (Graphics2D)this.TARGET_GRAPHICS.create(n2, n3, n4, n5);
        return new NoAlphaGraphics2DWrapper(graphics2D);
    }

    public void setColor(Color color) {
        if (color != null && color.getAlpha() < 255) {
            color = this.createOpaqueColor(color);
        }
        this.TARGET_GRAPHICS.setColor(color);
    }

    public void setBackground(Color color) {
        if (color.getAlpha() < 255) {
            color = this.createOpaqueColor(color);
        }
        this.TARGET_GRAPHICS.setBackground(color);
    }

    public void setPaint(Paint paint) {
        if (paint instanceof GradientPaint) {
            paint = ((GradientPaint)paint).getColor1();
        }
        if (paint.getTransparency() != 1) {
            paint = paint instanceof Color ? this.createOpaqueColor((Color)paint) : Color.WHITE;
        }
        this.TARGET_GRAPHICS.setPaint(paint);
    }

    protected Color createOpaqueColor(Color color) {
        float f2 = 0.0f;
        int n2 = color.getAlpha();
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        f2 = 1.0f - (float)n2 / 255.0f;
        n3 += (int)(f2 * (float)(255 - n3));
        n4 += (int)(f2 * (float)(255 - n4));
        n5 += (int)(f2 * (float)(255 - n5));
        return new Color(n3, n4, n5);
    }
}

