/*
 * Decompiled with CFR 0.152.
 */
package jpdf.wrap;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import jpdf.wrap.Graphics2DWrapper;

public class DebugGraphics2DWrapper
extends Graphics2DWrapper {
    private static boolean k = false;
    private static boolean m = true;
    private static boolean f = false;
    private static boolean n = false;
    private static boolean g = false;
    private static boolean d = true;
    private static boolean a = false;
    private static boolean e = false;
    private static boolean j = false;
    private static boolean c = false;
    private static boolean i = false;
    private static boolean l = false;
    private static int h = 9;
    private PrintStream b = System.out;

    public DebugGraphics2DWrapper(Graphics2D graphics2D) {
        super(graphics2D);
    }

    public DebugGraphics2DWrapper(Graphics2D graphics2D, String string) {
        this(graphics2D, string, false);
    }

    public DebugGraphics2DWrapper(Graphics2D graphics2D, String string, boolean bl) {
        super(graphics2D);
        this.setLogStream(DebugGraphics2DWrapper.a(string, bl));
    }

    private DebugGraphics2DWrapper(Graphics2D graphics2D, DebugGraphics2DWrapper debugGraphics2DWrapper) {
        super(graphics2D);
        this.b = debugGraphics2DWrapper.getLogStream();
    }

    public PrintStream getLogStream() {
        return this.b;
    }

    public int getMaxTraceDepth() {
        return h;
    }

    public static boolean isToIncludeTrace() {
        return l;
    }

    public static boolean isToLogClipping() {
        return j;
    }

    public static boolean isToLogColorSetting() {
        return e;
    }

    public static boolean isToLogCreateGraphics() {
        return d;
    }

    public static boolean isToLogDrawData() {
        return k;
    }

    public static boolean isToLogDrawGeometry() {
        return f;
    }

    public static boolean isToLogDrawImage() {
        return n;
    }

    public static boolean isToLogDrawText() {
        return m;
    }

    public static boolean isToLogFillGeometry() {
        return g;
    }

    public static boolean isToLogFontSetting() {
        return a;
    }

    public static boolean isToLogMiscellaneousOps() {
        return i;
    }

    public static boolean isToLogTransforms() {
        return c;
    }

    public void setLogStream(PrintStream printStream) {
        if (printStream == null) {
            printStream = System.out;
        }
        this.b = printStream;
    }

    public static void setMaxTraceDepth(int n2) {
        h = n2;
    }

    public static void setToIncludeTrace(boolean bl) {
        l = bl;
    }

    public static void isToLogClipping(boolean bl) {
        j = bl;
    }

    public static void setToLogColorSetting(boolean bl) {
        e = bl;
    }

    public static void setToLogCreateGraphics(boolean bl) {
        d = bl;
    }

    public static void setToLogDrawData(boolean bl) {
        k = bl;
    }

    public static void setToLogDrawGeometry(boolean bl) {
        f = bl;
    }

    public static void setToLogDrawImage(boolean bl) {
        n = bl;
    }

    public static void setToLogDrawText(boolean bl) {
        m = bl;
    }

    public static void setToLogFillGeometry(boolean bl) {
        g = bl;
    }

    public static void setToLogFontSetting(boolean bl) {
        a = bl;
    }

    public static void setToLogMiscellaneousOps(boolean bl) {
        i = bl;
    }

    public static void setToLogTransforms(boolean bl) {
        c = bl;
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Clearing rect: " + this.buildRectangleString(n2, n3, n4, n5));
        }
        this.TARGET_GRAPHICS.clearRect(n2, n3, n4, n5);
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.TARGET_GRAPHICS.clipRect(n2, n3, n4, n5);
        if (DebugGraphics2DWrapper.isToLogClipping()) {
            this.log(" Intersecting clipRect: " + this.buildRectangleString(n2, n3, n4, n5) + " New clipRect: " + this.TARGET_GRAPHICS.getClip());
        }
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Copying area from: " + this.buildRectangleString(n2, n3, n4, n5) + " to: " + this.buildPointString(n6, n7));
        }
        this.TARGET_GRAPHICS.copyArea(n2, n3, n4, n5, n6, n7);
    }

    public Graphics create() {
        if (DebugGraphics2DWrapper.isToLogCreateGraphics()) {
            this.log(" Creating Graphics");
        }
        return new DebugGraphics2DWrapper((Graphics2D)this.TARGET_GRAPHICS.create(), this);
    }

    public Graphics create(int n2, int n3, int n4, int n5) {
        if (DebugGraphics2DWrapper.isToLogCreateGraphics()) {
            this.log(" Creating Graphics: " + this.buildRectangleString(n2, n3, n4, n5));
        }
        return new DebugGraphics2DWrapper((Graphics2D)this.TARGET_GRAPHICS.create(n2, n3, n4, n5), this);
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing arc: " + this.buildRectangleString(n2, n3, n4, n5) + " startAngle: " + n6 + " arcAngle: " + n7);
        }
        this.TARGET_GRAPHICS.drawArc(n2, n3, n4, n5, n6, n7);
    }

    public void drawBytes(byte[] byArray, int n2, int n3, int n4, int n5) {
        if (DebugGraphics2DWrapper.isToLogDrawData()) {
            this.log(" Drawing bytes at: " + this.buildPointString(n4, n5));
        }
        this.TARGET_GRAPHICS.drawBytes(byArray, n2, n3, n4, n5);
    }

    public void drawChars(char[] cArray, int n2, int n3, int n4, int n5) {
        if (DebugGraphics2DWrapper.isToLogDrawData()) {
            this.log(" Drawing chars at: " + this.buildPointString(n4, n5));
        }
        this.TARGET_GRAPHICS.drawChars(cArray, n2, n3, n4, n5);
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing image (1): " + image.getClass().getName() + "\n     at: " + this.buildPointString(n2, n3));
        }
        return this.TARGET_GRAPHICS.drawImage(image, n2, n3, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing image (2): " + image.getClass().getName() + "\n     at: " + this.buildRectangleString(n2, n3, n4, n5));
        }
        return this.TARGET_GRAPHICS.drawImage(image, n2, n3, n4, n5, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing image (3): " + image.getClass().getName() + "\n     at: " + this.buildPointString(n2, n3) + ", bgcolor: " + this.buildColorString(color));
        }
        return this.TARGET_GRAPHICS.drawImage(image, n2, n3, color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing image (4): " + image.getClass().getName() + "\n     at: " + this.buildRectangleString(n2, n3, n4, n5) + ", bgcolor: " + this.buildColorString(color));
        }
        return this.TARGET_GRAPHICS.drawImage(image, n2, n3, n4, n5, color, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing image (5): " + image.getClass().getName() + "\n     destination: " + this.buildTwoPointString(n2, n3, n4, n5) + " source: " + this.buildTwoPointString(n6, n7, n8, n9));
        }
        return this.TARGET_GRAPHICS.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing image (6): " + image.getClass().getName() + "\n     destination: " + this.buildTwoPointString(n2, n3, n4, n5) + " source: " + this.buildTwoPointString(n6, n7, n8, n9) + ", bgcolor: " + this.buildColorString(color));
        }
        return this.TARGET_GRAPHICS.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, color, imageObserver);
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing line: from " + this.buildPointString(n2, n3) + " to " + this.buildPointString(n4, n5));
        }
        this.TARGET_GRAPHICS.drawLine(n2, n3, n4, n5);
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing oval: " + this.buildRectangleString(n2, n3, n4, n5));
        }
        this.TARGET_GRAPHICS.drawOval(n2, n3, n4, n5);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing polygon: nPoints: " + n2);
        }
        this.TARGET_GRAPHICS.drawPolygon(nArray, nArray2, n2);
    }

    public void drawPolygon(Polygon polygon) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing polygon: " + polygon);
        }
        this.TARGET_GRAPHICS.drawPolygon(polygon);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing Polyline: nPoints: " + n2);
        }
        this.TARGET_GRAPHICS.drawPolyline(nArray, nArray2, n2);
    }

    public void drawRect(int n2, int n3, int n4, int n5) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing rect: " + this.buildRectangleString(n2, n3, n4, n5));
        }
        this.TARGET_GRAPHICS.drawRect(n2, n3, n4, n5);
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing round rect: " + this.buildRectangleString(n2, n3, n4, n5) + " arcWidth: " + n6 + " archHeight: " + n7);
        }
        this.TARGET_GRAPHICS.drawRoundRect(n2, n3, n4, n5, n6, n7);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        if (DebugGraphics2DWrapper.isToLogDrawText()) {
            this.log(" Drawing string: \"" + attributedCharacterIterator + "\" at: " + this.buildPointString(n2, n3));
        }
        this.TARGET_GRAPHICS.drawString(attributedCharacterIterator, n2, n3);
    }

    public void drawString(String string, int n2, int n3) {
        if (DebugGraphics2DWrapper.isToLogDrawText()) {
            this.log(" Drawing string: \"" + string + "\" at: " + this.buildPointString(n2, n3));
        }
        this.TARGET_GRAPHICS.drawString(string, n2, n3);
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (DebugGraphics2DWrapper.isToLogFillGeometry()) {
            this.log(" Filling arc: " + this.buildRectangleString(n2, n3, n4, n5) + " startAngle: " + n6 + " arcAngle: " + n7);
        }
        this.TARGET_GRAPHICS.fillArc(n2, n3, n4, n5, n6, n7);
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        if (DebugGraphics2DWrapper.isToLogFillGeometry()) {
            this.log(" Filling oval: " + this.buildRectangleString(n2, n3, n4, n5));
        }
        this.TARGET_GRAPHICS.fillOval(n2, n3, n4, n5);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        if (DebugGraphics2DWrapper.isToLogFillGeometry()) {
            this.log(" Filling polygon: nPoints: " + n2);
        }
        this.TARGET_GRAPHICS.fillPolygon(nArray, nArray2, n2);
    }

    public void fillPolygon(Polygon polygon) {
        if (DebugGraphics2DWrapper.isToLogFillGeometry()) {
            this.log(" Filling polygon: " + polygon);
        }
        this.TARGET_GRAPHICS.fillPolygon(polygon);
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        if (DebugGraphics2DWrapper.isToLogFillGeometry()) {
            this.log(" Filling rect: " + this.buildRectangleString(n2, n3, n4, n5));
        }
        this.TARGET_GRAPHICS.fillRect(n2, n3, n4, n5);
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (DebugGraphics2DWrapper.isToLogFillGeometry()) {
            this.log(" Filling round rect: " + this.buildRectangleString(n2, n3, n4, n5) + " arcWidth: " + n6 + " archHeight: " + n7);
        }
        this.TARGET_GRAPHICS.fillRoundRect(n2, n3, n4, n5, n6, n7);
    }

    public void setClip(Shape shape) {
        this.TARGET_GRAPHICS.setClip(shape);
        if (DebugGraphics2DWrapper.isToLogClipping()) {
            this.log(" Setting new clipRect: " + this.TARGET_GRAPHICS.getClip());
        }
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        this.TARGET_GRAPHICS.setClip(n2, n3, n4, n5);
        if (DebugGraphics2DWrapper.isToLogClipping()) {
            this.log(" Setting new clipRect: " + this.TARGET_GRAPHICS.getClip());
        }
    }

    public void setColor(Color color) {
        if (DebugGraphics2DWrapper.isToLogColorSetting()) {
            this.log(" Setting Color: " + this.buildColorString(color));
        }
        this.TARGET_GRAPHICS.setColor(color);
    }

    public void setFont(Font font) {
        if (DebugGraphics2DWrapper.isToLogFontSetting()) {
            this.log(" Setting Font: " + font);
        }
        this.TARGET_GRAPHICS.setFont(font);
    }

    public void setPaintMode() {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Setting Paint Mode");
        }
        this.TARGET_GRAPHICS.setPaintMode();
    }

    public void setXORMode(Color color) {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Setting XOR Mode: " + this.buildColorString(color));
        }
        this.TARGET_GRAPHICS.setXORMode(color);
    }

    public void translate(int n2, int n3) {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Translating by: " + this.buildPointString(n2, n3));
        }
        this.TARGET_GRAPHICS.translate(n2, n3);
    }

    public void addRenderingHints(Map map) {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Adding Rendering Hints: " + map);
        }
        this.TARGET_GRAPHICS.addRenderingHints(map);
    }

    public void clip(Shape shape) {
        if (DebugGraphics2DWrapper.isToLogClipping()) {
            this.log(" Clipping: " + shape);
        }
        this.TARGET_GRAPHICS.clip(shape);
    }

    public void draw(Shape shape) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing Shape: " + shape);
        }
        this.TARGET_GRAPHICS.draw(shape);
    }

    public void draw3DRect(int n2, int n3, int n4, int n5, boolean bl) {
        if (DebugGraphics2DWrapper.isToLogDrawGeometry()) {
            this.log(" Drawing 3D Rectangle");
        }
        this.TARGET_GRAPHICS.draw3DRect(n2, n3, n4, n5, bl);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        if (DebugGraphics2DWrapper.isToLogDrawText()) {
            this.log(" Drawing Glyph Vector at: " + this.buildPointString(f2, f3));
        }
        this.TARGET_GRAPHICS.drawGlyphVector(glyphVector, f2, f3);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing image (7): " + image.getClass().getName());
        }
        return this.TARGET_GRAPHICS.drawImage(image, affineTransform, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing image (8): " + bufferedImage.getClass().getName() + " at: " + this.buildPointString(n2, n3));
        }
        this.TARGET_GRAPHICS.drawImage(bufferedImage, bufferedImageOp, n2, n3);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing rendered image: " + renderedImage.getClass().getName());
        }
        this.TARGET_GRAPHICS.drawRenderedImage(renderedImage, affineTransform);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        if (DebugGraphics2DWrapper.isToLogDrawImage()) {
            this.log(" Drawing renderable image: " + renderableImage.getClass().getName());
        }
        this.TARGET_GRAPHICS.drawRenderableImage(renderableImage, affineTransform);
    }

    public void drawString(String string, float f2, float f3) {
        if (DebugGraphics2DWrapper.isToLogDrawText()) {
            this.log(" Drawing string: \"" + string + "\" at: " + this.buildPointString(f2, f3));
        }
        this.TARGET_GRAPHICS.drawString(string, f2, f3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (DebugGraphics2DWrapper.isToLogDrawText()) {
            this.log(" Drawing string: \"" + attributedCharacterIterator + "\" at: " + this.buildPointString(f2, f3));
        }
        this.TARGET_GRAPHICS.drawString(attributedCharacterIterator, f2, f3);
    }

    public void fill(Shape shape) {
        if (DebugGraphics2DWrapper.isToLogFillGeometry()) {
            this.log(" Filling Shape: " + shape);
        }
        this.TARGET_GRAPHICS.fill(shape);
    }

    public void fill3DRect(int n2, int n3, int n4, int n5, boolean bl) {
        if (DebugGraphics2DWrapper.isToLogFillGeometry()) {
            this.log(" Filling 3D Rectangle");
        }
        this.TARGET_GRAPHICS.fill3DRect(n2, n3, n4, n5, bl);
    }

    public void rotate(double d2) {
        if (DebugGraphics2DWrapper.isToLogTransforms()) {
            this.log(" Rotating: " + d2);
        }
        this.TARGET_GRAPHICS.rotate(d2);
    }

    public void rotate(double d2, double d3, double d4) {
        if (DebugGraphics2DWrapper.isToLogTransforms()) {
            this.log(" Rotating: " + d2 + " at " + this.buildPointString(d3, d4));
        }
        this.TARGET_GRAPHICS.rotate(d2, d3, d4);
    }

    public void scale(double d2, double d3) {
        if (DebugGraphics2DWrapper.isToLogTransforms()) {
            this.log(" Scaling: " + d2 + " x " + d3);
        }
        this.TARGET_GRAPHICS.scale(d2, d3);
    }

    public void setBackground(Color color) {
        if (DebugGraphics2DWrapper.isToLogColorSetting()) {
            this.log(" Setting Background: " + this.buildColorString(color));
        }
        this.TARGET_GRAPHICS.setBackground(color);
    }

    public void setComposite(Composite composite) {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Setting Composite: " + composite);
        }
        this.TARGET_GRAPHICS.setComposite(composite);
    }

    public void setPaint(Paint paint) {
        if (DebugGraphics2DWrapper.isToLogColorSetting()) {
            this.log(" Setting Paint: " + paint);
        }
        this.TARGET_GRAPHICS.setPaint(paint);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Setting Rendering Hint: " + key + " -> " + object);
        }
        this.TARGET_GRAPHICS.setRenderingHint(key, object);
    }

    public void setRenderingHints(Map map) {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Setting Rendering Hints");
        }
        this.TARGET_GRAPHICS.setRenderingHints(map);
    }

    public void setStroke(Stroke stroke) {
        if (DebugGraphics2DWrapper.isToLogMiscellaneousOps()) {
            this.log(" Setting Stroke: " + stroke);
        }
        this.TARGET_GRAPHICS.setStroke(stroke);
    }

    public void setTransform(AffineTransform affineTransform) {
        if (DebugGraphics2DWrapper.isToLogTransforms()) {
            this.log(" Setting Transform: " + affineTransform);
        }
        this.TARGET_GRAPHICS.setTransform(affineTransform);
    }

    public void shear(double d2, double d3) {
        if (DebugGraphics2DWrapper.isToLogTransforms()) {
            this.log(" Shearing: " + d2 + " x " + d3);
        }
        this.TARGET_GRAPHICS.shear(d2, d3);
    }

    public void transform(AffineTransform affineTransform) {
        if (DebugGraphics2DWrapper.isToLogTransforms()) {
            this.log(" Transforming: " + affineTransform);
        }
        this.TARGET_GRAPHICS.transform(affineTransform);
    }

    public void translate(double d2, double d3) {
        if (DebugGraphics2DWrapper.isToLogTransforms()) {
            this.log(" Translating: " + d2 + " x " + d3);
        }
        this.TARGET_GRAPHICS.translate(d2, d3);
    }

    protected String buildColorString(Color color) {
        String string = null;
        int n2 = color.getAlpha();
        string = n2 < 255 ? color.getClass().getName() + "[r=" + color.getRed() + ",g=" + color.getGreen() + ",b=" + color.getBlue() + ", alpha=" + n2 + "]" : color.getClass().getName() + "[r=" + color.getRed() + ",g=" + color.getGreen() + ",b=" + color.getBlue() + "]";
        return string;
    }

    protected String buildPointString(int n2, int n3) {
        return "(x=" + n2 + ",y=" + n3 + ")";
    }

    protected String buildPointString(float f2, float f3) {
        return "(x=" + f2 + ",y=" + f3 + ")";
    }

    protected String buildPointString(double d2, double d3) {
        return "(x=" + d2 + ",y=" + d3 + ")";
    }

    protected String buildRectangleString(int n2, int n3, int n4, int n5) {
        return "[x=" + n2 + ",y=" + n3 + ",width=" + n4 + ",height=" + n5 + "]";
    }

    protected String buildTwoPointString(int n2, int n3, int n4, int n5) {
        return "[(x1=" + n2 + ",y1=" + n3 + "), (x2=" + n4 + ",y2=" + n5 + ")]";
    }

    protected void log(String string) {
        if (DebugGraphics2DWrapper.isToIncludeTrace()) {
            this.logWithTrace(string, this.getMaxTraceDepth(), 2);
        } else {
            this.getLogStream().println(string);
        }
    }

    protected void logWithTrace(String string, int n2, int n3) {
        StackTraceElement[] stackTraceElementArray = null;
        PrintStream printStream = this.getLogStream();
        int n4 = n3 + n2;
        printStream.println(string);
        stackTraceElementArray = new Exception().getStackTrace();
        if (n4 > stackTraceElementArray.length) {
            n4 = stackTraceElementArray.length;
        }
        for (int i2 = n3; i2 < n4; ++i2) {
            printStream.println("   >" + stackTraceElementArray[i2]);
        }
    }

    private static PrintStream a(String string, boolean bl) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(string, bl));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return printStream;
    }
}

