/*
 * Decompiled with CFR 0.152.
 */
package jpdf.wrap;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jpdf.wrap.PrintServiceWrapper;
import jpdf_common.gui.dialog.BasicDialog;

public class AliasPrintServiceWrapper
extends PrintServiceWrapper {
    private final PrintServiceAttributeSet b;
    private final String c;
    private ServiceUIFactory a = null;

    public AliasPrintServiceWrapper(String string, PrintService printService) {
        super(printService);
        this.c = string;
        this.b = new HashPrintServiceAttributeSet(printService.getAttributes());
        this.setServiceUIFactory(printService.getServiceUIFactory());
    }

    public void addAttribute(PrintServiceAttribute printServiceAttribute) {
        this.b.add(printServiceAttribute);
    }

    public PrintServiceAttribute getAttribute(Class clazz) {
        return (PrintServiceAttribute)this.b.get(clazz);
    }

    public PrintServiceAttributeSet getAttributes() {
        return AttributeSetUtilities.unmodifiableView(this.b);
    }

    public String getName() {
        return this.c;
    }

    public ServiceUIFactory getServiceUIFactory() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.c.equals(((AliasPrintServiceWrapper)object).getName());
    }

    public void setPrinterAcceptingJobs(boolean bl) {
        this.b.add(bl ? PrinterIsAcceptingJobs.ACCEPTING_JOBS : PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS);
    }

    public void setPrinterInfo(String string) {
        this.b.add(new PrinterInfo(string, null));
    }

    public void setPrinterMakeAndModel(String string) {
        this.b.add(new PrinterMakeAndModel(string, null));
    }

    public void setServiceUIFactory(ServiceUIFactory serviceUIFactory) {
        this.a = serviceUIFactory;
    }

    public void setTestServiceUIFactory() {
        this.setServiceUIFactory(new BasicServiceUIFactory(this));
    }

    public String toString() {
        return "Alias : " + this.c;
    }

    public static class BasicServiceUIFactory
    extends ServiceUIFactory {
        protected final PrintService PRINT_SERVICE;

        public BasicServiceUIFactory(PrintService printService) {
            this.PRINT_SERVICE = printService;
        }

        public Object getUI(int n2, String string) {
            Container container = null;
            String string2 = null;
            if (string == "javax.swing.JDialog") {
                container = this.createDialogUi(n2);
            } else if (string == "javax.swing.JComponent") {
                container = this.createPanelUi(n2);
            } else {
                string2 = "Invalid UI Class Name: " + string + "\nThis Service UI Factory supports only the following UI Class Names:\n   " + "javax.swing.JDialog" + " and " + "javax.swing.JComponent";
                throw new IllegalArgumentException(string2);
            }
            return container;
        }

        public String[] getUIClassNamesForRole(int n2) {
            return new String[]{"javax.swing.JDialog", "javax.swing.JComponent"};
        }

        protected JDialog createDialogUi(int n2) {
            Dimension dimension = new Dimension(300, 150);
            String string = this.PRINT_SERVICE.getName() + " Properties";
            BasicDialog basicDialog = null;
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            String string2 = null;
            if (window instanceof Dialog) {
                basicDialog = new BasicDialog((Dialog)window, string, dimension, true, 2);
            } else if (window instanceof Frame) {
                basicDialog = new BasicDialog((Frame)window, string, dimension, true, 2);
            } else {
                string2 = "A Dialog or Frame must be the Active Window.";
                throw new IllegalStateException(string2);
            }
            basicDialog.getContentPane().add(this.createPanelUi(n2));
            return basicDialog;
        }

        protected JPanel createPanelUi(int n2) {
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Test Print Service Properties"));
            return jPanel;
        }
    }
}

