/*
 * Decompiled with CFR 0.152.
 */
package jpdf.utility;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import jpdf.manage.PrintParameterHolder;
import jpdf.utility.PageDecorationPainter;
import jpdf_common.gui.constant.FontConstant;

public class StringDecorationPainter
implements PageDecorationPainter {
    private final int f;
    private final int g;
    private String d = null;
    private Color b = null;
    private Font a = null;
    private int c = 2;

    public StringDecorationPainter() {
        this(3, 6, null, Color.BLACK, FontConstant.BIG_BOLD_FONT);
    }

    public StringDecorationPainter(int n2, int n3) {
        this(n2, n3, null, Color.BLACK, FontConstant.BIG_BOLD_FONT);
    }

    public StringDecorationPainter(int n2, int n3, Font font) {
        this(n2, n3, null, Color.BLACK, font);
    }

    public StringDecorationPainter(String string) {
        this(3, 6, string, Color.BLACK, FontConstant.BIG_BOLD_FONT);
    }

    public StringDecorationPainter(int n2, int n3, String string, Color color, Font font) {
        this.f = n2;
        this.g = n3;
        this.setStringText(string);
        this.setStringColor(color);
        this.setStringFont(font);
    }

    public int getRequiredHeight(int n2, PrintParameterHolder printParameterHolder) {
        String string = this.getStringText();
        int n3 = 0;
        if (string != null && string.length() > 0) {
            n3 = this.getStringFont().getSize() + this.f;
        }
        return n3;
    }

    public Color getStringColor() {
        return this.b;
    }

    public Font getStringFont() {
        return this.a;
    }

    public String getStringText() {
        return this.d;
    }

    public int getHorizontalAlignment() {
        return this.c;
    }

    public int print(Graphics2D graphics2D, int n2, int n3, int n4, PrintParameterHolder printParameterHolder) {
        FontMetrics fontMetrics = null;
        String string = this.getStringText();
        Font font = this.getStringFont();
        int n5 = this.getHorizontalAlignment();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (string == null || string.length() == 0) {
            return 0;
        }
        graphics2D.setFont(font);
        graphics2D.setColor(this.getStringColor());
        fontMetrics = graphics2D.getFontMetrics();
        n8 = fontMetrics.getMaxAscent();
        if (font.getSize() > 10) {
            --n8;
        }
        if (n5 == 2) {
            n7 = this.g;
        } else {
            n6 = fontMetrics.stringWidth(string);
            n7 = n5 == 4 ? n2 - (n6 + this.g) : (n2 - n6) / 2;
        }
        graphics2D.translate(n3, n4);
        graphics2D.drawString(string, n7, n8);
        graphics2D.translate(-n3, -n4);
        return this.getRequiredHeight(n2, printParameterHolder);
    }

    public void setHorizontalAlignment(int n2) {
        if (n2 != 2 && n2 != 0 && n2 != 4) {
            String string = "Invalid Alignment.  Must be one of: SwingConstants.LEFT, SwingConstants.CENTER, or SwingConstants.RIGHT";
            throw new IllegalArgumentException(string);
        }
        this.c = n2;
    }

    public void setStringColor(Color color) {
        this.b = color;
    }

    public void setStringFont(Font font) {
        this.a = font;
    }

    public void setStringText(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.d = string;
    }
}

