/*
 * Decompiled with CFR 0.152.
 */
package jpdf.utility;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.util.Arrays;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import jpdf.attribute.PrintPageOddEven;
import jpdf.attribute.RequestMediaSizeName;
import jpdf.manage.PrintServiceRegistry;
import jpdf.printable.PageCountPrintable;
import jpdf.printer.AbstractComponentListPrinter;
import jpdf.printer.AbstractComponentPrinter;
import jpdf.utility.b;
import jpdf.wrap.AbstractPrintableWrapper;

public class PrintUtility {
    public static final MediaSize DEFAULT_MEDIA_SIZE;
    public static final MediaSizeName DEFAULT_MEDIA_SIZE_NAME;
    public static final float MM_TO_INCH_CONVERSION_FACTOR = 0.03937008f;
    static Class f;
    static Class g;
    static Class e;
    static Class a;
    static Class d;
    static Class c;
    static Class b;

    private PrintUtility() {
    }

    public static void addDefaultPageFormatAttributes(AttributeSet attributeSet) {
        attributeSet.add(DEFAULT_MEDIA_SIZE_NAME);
        if (DEFAULT_MEDIA_SIZE_NAME == MediaSizeName.ISO_A4) {
            PrintUtility.updateAttributeSet(false, 12, attributeSet, false);
        } else {
            PrintUtility.updateAttributeSet(false, 0.5f, attributeSet, false);
        }
    }

    public static MediaPrintableArea buildPrintableArea(MediaSize mediaSize) {
        return PrintUtility.buildPrintableArea(mediaSize, 0, 0, 0, 0, false, false);
    }

    public static MediaPrintableArea buildPrintableArea(MediaSize mediaSize, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        return PrintUtility.buildPrintableArea(mediaSize, PrintUtility.convertToInches(n2), PrintUtility.convertToInches(n3), PrintUtility.convertToInches(n4), PrintUtility.convertToInches(n5), bl, bl2);
    }

    public static MediaPrintableArea buildPrintableArea(MediaSize mediaSize, float f2, float f3, float f4, float f5, boolean bl, boolean bl2) {
        int n2 = 25400;
        float f6 = mediaSize.getX(n2);
        float f7 = mediaSize.getY(n2);
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        if (bl) {
            if (bl2) {
                f10 = f4;
                f11 = f3;
                f8 = f6 - (f2 + f4);
                f9 = f7 - (f3 + f5);
            } else {
                f10 = f2;
                f11 = f5;
                f8 = f6 - (f2 + f4);
                f9 = f7 - (f3 + f5);
            }
        } else if (bl2) {
            f10 = f5;
            f11 = f4;
            f8 = f6 - (f3 + f5);
            f9 = f7 - (f2 + f4);
        } else {
            f10 = f3;
            f11 = f2;
            f8 = f6 - (f3 + f5);
            f9 = f7 - (f2 + f4);
        }
        return new MediaPrintableArea(f10, f11, f8, f9, n2);
    }

    public static int computePrintablePageCount(Printable printable) {
        int n2 = -1;
        if (printable instanceof PageCountPrintable) {
            n2 = ((PageCountPrintable)printable).getPageCount();
            if (printable instanceof AbstractComponentPrinter) {
                if (n2 == -1) {
                    n2 = ((AbstractComponentPrinter)printable).computePageCount();
                }
            } else if (printable instanceof AbstractComponentListPrinter && n2 == -1) {
                n2 = ((AbstractComponentListPrinter)printable).computePageCount();
            }
        } else if (printable instanceof AbstractPrintableWrapper) {
            n2 = ((AbstractPrintableWrapper)printable).computePageCount();
        }
        return n2;
    }

    public static int computePrintPageCount(AttributeSet attributeSet, int n2) {
        return PrintUtility.computePrintPageCount(attributeSet, n2, true);
    }

    public static int computePrintPageCount(AttributeSet attributeSet, int n2, boolean bl) {
        PrintPageOddEven printPageOddEven = null;
        PageRanges pageRanges = null;
        NumberUp numberUp = null;
        int n3 = 0;
        int n4 = -1;
        int n5 = 1;
        printPageOddEven = (PrintPageOddEven)attributeSet.get(g == null ? (g = PrintUtility.class$("jpdf.attribute.PrintPageOddEven")) : g);
        pageRanges = (PageRanges)attributeSet.get(e == null ? (e = PrintUtility.class$("javax.print.attribute.standard.PageRanges")) : e);
        if (bl) {
            numberUp = (NumberUp)attributeSet.get(a == null ? (a = PrintUtility.class$("javax.print.attribute.standard.NumberUp")) : a);
        }
        if (printPageOddEven != null || pageRanges != null) {
            if (printPageOddEven != null && pageRanges != null) {
                while ((n4 = pageRanges.next(n4)) != -1) {
                    if (!printPageOddEven.isToPrint(n4)) continue;
                    ++n3;
                }
            } else if (pageRanges != null) {
                while ((n4 = pageRanges.next(n4)) != -1) {
                    ++n3;
                }
            } else {
                n3 = n2 / 2;
                if (printPageOddEven == PrintPageOddEven.ODD_ONLY && !PrintPageOddEven.isEven(n2)) {
                    ++n3;
                }
            }
        } else {
            n3 = n2;
        }
        if (numberUp != null && (n5 = numberUp.getValue()) > 1) {
            n3 = n3 % n5 == 0 ? (n3 /= n5) : n3 / n5 + 1;
        }
        return n3;
    }

    public static float convertToInches(int n2) {
        return (float)n2 * 0.03937008f;
    }

    public static PageFormat createPageFormat(AttributeSet attributeSet) {
        PageFormat pageFormat = new PageFormat();
        PrintUtility.updatePageFormat(attributeSet, pageFormat);
        return pageFormat;
    }

    public static MediaSize getMediaSize(AttributeSet attributeSet) {
        MediaSizeName mediaSizeName = PrintUtility.getMediaSizeName(attributeSet);
        MediaSize mediaSize = null;
        if (mediaSizeName != null) {
            mediaSize = RequestMediaSizeName.getMediaSize(mediaSizeName);
        }
        return mediaSize;
    }

    public static MediaSizeName getMediaSizeName(AttributeSet attributeSet) {
        RequestMediaSizeName requestMediaSizeName = null;
        MediaSizeName mediaSizeName = null;
        Media media = null;
        requestMediaSizeName = (RequestMediaSizeName)attributeSet.get(d == null ? (d = PrintUtility.class$("jpdf.attribute.RequestMediaSizeName")) : d);
        if (requestMediaSizeName != null) {
            mediaSizeName = requestMediaSizeName.getMediaSizeName();
        } else {
            media = (Media)attributeSet.get(f == null ? (f = PrintUtility.class$("javax.print.attribute.standard.Media")) : f);
            mediaSizeName = media instanceof MediaSizeName ? (MediaSizeName)media : DEFAULT_MEDIA_SIZE_NAME;
        }
        return mediaSizeName;
    }

    public static MediaPrintableArea getSupportedPrintableArea(PrintService printService, AttributeSet attributeSet, DocFlavor docFlavor) {
        MediaPrintableArea mediaPrintableArea = null;
        Object object = null;
        String string = null;
        if (!(attributeSet.get(f == null ? (f = PrintUtility.class$("javax.print.attribute.standard.Media")) : f) instanceof MediaSizeName)) {
            string = "The Printable Area cannot be determined because the given Attribute Set does not specify the Media Size.";
            throw new IllegalArgumentException(string);
        }
        object = printService.getSupportedAttributeValues(c == null ? (c = PrintUtility.class$("javax.print.attribute.standard.MediaPrintableArea")) : c, docFlavor, attributeSet);
        if (object instanceof MediaPrintableArea[] && ((Object[])object).length > 0) {
            mediaPrintableArea = ((MediaPrintableArea[])object)[0];
        }
        return mediaPrintableArea;
    }

    public static boolean isLetterPageSizeLocale(Locale locale) {
        String string = locale.getCountry();
        return string.equals("US") || string.equals("CA") || string.equals("MX");
    }

    public static MediaSizeName lookupMediaSizeName(Paper paper) {
        MediaSizeName mediaSizeName = null;
        float[] fArray = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        f2 = (float)paper.getWidth() / 72.0f;
        f3 = (float)paper.getHeight() / 72.0f;
        fArray = DEFAULT_MEDIA_SIZE.getSize(25400);
        mediaSizeName = f2 == fArray[0] && f3 == fArray[1] ? DEFAULT_MEDIA_SIZE_NAME : MediaSize.findMedia(f2, f3, 25400);
        return mediaSizeName;
    }

    public static MediaSizeName lookupMediaSizeName(PageFormat pageFormat) {
        return PrintUtility.lookupMediaSizeName(pageFormat.getPaper());
    }

    public static void removeUnsupportedAttributes(PrintService printService, DocFlavor docFlavor, AttributeSet attributeSet) {
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            if (printService.isAttributeValueSupported(attributeArray[i2], docFlavor, attributeSet)) continue;
            attributeSet.remove(attributeArray[i2]);
        }
    }

    public static void shiftContentToCenter(Graphics2D graphics2D, PageFormat pageFormat, Rectangle2D.Float float_) {
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)pageFormat.getImageableHeight();
        int n4 = (int)pageFormat.getImageableX();
        int n5 = (int)pageFormat.getImageableY();
        if ((float)n2 > float_.width) {
            n4 += (int)(((float)n2 - float_.width) / 2.0f) - (int)float_.x;
        }
        if ((float)n3 > float_.height) {
            n5 += (int)(((float)n3 - float_.height) / 3.0f) - (int)float_.y;
        }
        graphics2D.translate(n4, n5);
    }

    public static void sortPrintServiceList(PrintService[] printServiceArray) {
        Arrays.sort(printServiceArray, new b(null));
    }

    public static void updateAttributeSet(PageFormat pageFormat, AttributeSet attributeSet, boolean bl) {
        MediaSizeName mediaSizeName = null;
        Paper paper = pageFormat.getPaper();
        boolean bl2 = false;
        float f2 = 0.0f;
        int n2 = pageFormat.getOrientation();
        if (bl) {
            attributeSet.clear();
        } else {
            attributeSet.remove(d == null ? (d = PrintUtility.class$("jpdf.attribute.RequestMediaSizeName")) : d);
        }
        if (n2 == 0) {
            attributeSet.add(OrientationRequested.LANDSCAPE);
        } else if (n2 == 2) {
            attributeSet.add(OrientationRequested.LANDSCAPE);
        } else {
            attributeSet.add(OrientationRequested.PORTRAIT);
        }
        attributeSet.add(new MediaPrintableArea((float)paper.getImageableX() / 72.0f, (float)paper.getImageableY() / 72.0f, (float)paper.getImageableWidth() / 72.0f, (float)paper.getImageableHeight() / 72.0f, 25400));
        mediaSizeName = PrintUtility.lookupMediaSizeName(pageFormat);
        attributeSet.add(mediaSizeName == null ? DEFAULT_MEDIA_SIZE_NAME : mediaSizeName);
    }

    public static void updateAttributeSet(boolean bl, int n2, AttributeSet attributeSet, boolean bl2) {
        PrintUtility.updateAttributeSet(bl, PrintUtility.convertToInches(n2), attributeSet, bl2);
    }

    public static void updateAttributeSet(boolean bl, float f2, AttributeSet attributeSet, boolean bl2) {
        PageFormat pageFormat = new PageFormat();
        Paper paper = null;
        float f3 = f2 * 72.0f;
        float f4 = f3 * 2.0f;
        PrintUtility.updatePageFormat(attributeSet, pageFormat);
        paper = pageFormat.getPaper();
        paper.setImageableArea(f3, f3, paper.getWidth() - (double)f4, paper.getHeight() - (double)f4);
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(bl ? 0 : 1);
        PrintUtility.updateAttributeSet(pageFormat, attributeSet, bl2);
    }

    public static void updateAttributeSet(boolean bl, int n2, int n3, int n4, int n5, AttributeSet attributeSet, boolean bl2) {
        PrintUtility.updateAttributeSet(bl, PrintUtility.convertToInches(n2), PrintUtility.convertToInches(n3), PrintUtility.convertToInches(n4), PrintUtility.convertToInches(n5), attributeSet, bl2);
    }

    public static void updateAttributeSet(boolean bl, float f2, float f3, float f4, float f5, AttributeSet attributeSet, boolean bl2) {
        PageFormat pageFormat = new PageFormat();
        Paper paper = null;
        float f6 = f2 * 72.0f;
        float f7 = f3 * 72.0f;
        float f8 = f4 * 72.0f;
        float f9 = f5 * 72.0f;
        PrintUtility.updatePageFormat(attributeSet, pageFormat);
        paper = pageFormat.getPaper();
        if (bl) {
            paper.setImageableArea(f6, f9, paper.getWidth() - (double)(f6 + f8), paper.getHeight() - (double)(f7 + f9));
            pageFormat.setPaper(paper);
            pageFormat.setOrientation(0);
        } else {
            paper.setImageableArea(f7, f6, paper.getWidth() - (double)(f7 + f9), paper.getHeight() - (double)(f6 + f8));
            pageFormat.setPaper(paper);
            pageFormat.setOrientation(1);
        }
        PrintUtility.updateAttributeSet(pageFormat, attributeSet, bl2);
    }

    public static void updatePageFormat(PageFormat pageFormat, PageFormat pageFormat2) {
        pageFormat2.setOrientation(pageFormat.getOrientation());
        pageFormat2.setPaper(pageFormat.getPaper());
    }

    public static void updatePageFormat(AttributeSet attributeSet, PageFormat pageFormat) {
        OrientationRequested orientationRequested = null;
        MediaPrintableArea mediaPrintableArea = null;
        MediaSize mediaSize = PrintUtility.getMediaSize(attributeSet);
        Paper paper = pageFormat.getPaper();
        orientationRequested = (OrientationRequested)attributeSet.get(b == null ? (b = PrintUtility.class$("javax.print.attribute.standard.OrientationRequested")) : b);
        if (orientationRequested == OrientationRequested.LANDSCAPE) {
            pageFormat.setOrientation(0);
        } else if (orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
            pageFormat.setOrientation(2);
        } else {
            pageFormat.setOrientation(1);
        }
        if (mediaSize == null) {
            paper = new Paper();
        } else {
            paper.setSize(mediaSize.getX(25400) * 72.0f, mediaSize.getY(25400) * 72.0f);
            mediaPrintableArea = (MediaPrintableArea)attributeSet.get(c == null ? (c = PrintUtility.class$("javax.print.attribute.standard.MediaPrintableArea")) : c);
            if (mediaPrintableArea == null) {
                paper.setImageableArea(72.0, 72.0, paper.getWidth() - 144.0, paper.getHeight() - 144.0);
            } else {
                paper.setImageableArea(mediaPrintableArea.getX(25400) * 72.0f, mediaPrintableArea.getY(25400) * 72.0f, mediaPrintableArea.getWidth(25400) * 72.0f, mediaPrintableArea.getHeight(25400) * 72.0f);
            }
        }
        pageFormat.setPaper(paper);
    }

    public static void updatePageFormat(Rectangle rectangle, PageFormat pageFormat) {
        Paper paper = pageFormat.getPaper();
        if (pageFormat.getOrientation() == 1) {
            paper.setImageableArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            int n2 = (int)(pageFormat.getWidth() - (double)(rectangle.x + rectangle.width));
            paper.setImageableArea(rectangle.y, n2, rectangle.height, rectangle.width);
        }
        pageFormat.setPaper(paper);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        MediaSize mediaSize = null;
        PrintService printService = null;
        Media media = null;
        printService = PrintServiceRegistry.lookupDefaultPrintService();
        if (printService != null) {
            try {
                media = (Media)printService.getDefaultAttributeValue(f == null ? (f = PrintUtility.class$("javax.print.attribute.standard.Media")) : f);
                if (media instanceof MediaSizeName) {
                    mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (media != null && mediaSize != null) {
            DEFAULT_MEDIA_SIZE_NAME = (MediaSizeName)media;
            DEFAULT_MEDIA_SIZE = mediaSize;
        } else if (PrintUtility.isLetterPageSizeLocale(Locale.getDefault())) {
            DEFAULT_MEDIA_SIZE_NAME = MediaSizeName.NA_LETTER;
            DEFAULT_MEDIA_SIZE = MediaSize.NA.LETTER;
        } else {
            DEFAULT_MEDIA_SIZE_NAME = MediaSizeName.ISO_A4;
            DEFAULT_MEDIA_SIZE = MediaSize.ISO.A4;
        }
    }
}

