/*
 * Decompiled with CFR 0.152.
 */
package jpdf.utility;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.PrinterGraphics;
import javax.print.attribute.AttributeSet;
import javax.swing.SwingConstants;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jpdf.attribute.OffsetBottom;
import jpdf.attribute.OffsetLeft;
import jpdf.attribute.OffsetRight;
import jpdf.attribute.OffsetTop;
import jpdf.attribute.PageFooterAttribute;
import jpdf.attribute.PageFooterLine;
import jpdf.attribute.PageFooterOnFirstPage;
import jpdf.attribute.PageFrame;
import jpdf.attribute.PageHeaderAttribute;
import jpdf.attribute.PageHeaderLine;
import jpdf.attribute.PageHeaderOnFirstPage;
import jpdf.manage.PrintManager;
import jpdf.manage.PrintParameterHolder;
import jpdf.utility.AttributeClassifier;
import jpdf.utility.PageDecorationPainter;
import jpdf_common.gui.constant.FontConstant;
import jpdf_common.gui.constant.StrokeConstant;

public class PageDecorationUtility
implements SwingConstants {
    public static final Font DEFAULT_DECORATION_FONT = FontConstant.SMALL_FONT;
    public static final int FRAME_OFFSET = 2;
    private static int a = 4;
    private static int c = 6;
    private static Color d = Color.LIGHT_GRAY;
    private static Color f = Color.LIGHT_GRAY;
    private static BasicStroke e = StrokeConstant.SOLID_STROKE;
    private static BasicStroke h = StrokeConstant.SOLID_STROKE;
    static Class b;
    static Class g;

    private PageDecorationUtility() {
    }

    public static int computeAvailablePageHeight(PageFormat pageFormat, AttributeSet attributeSet, DecorationOptions decorationOptions, PrintParameterHolder printParameterHolder) {
        PageHeaderAttribute pageHeaderAttribute = null;
        PageFooterAttribute pageFooterAttribute = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = printParameterHolder.pageNo - 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n3 = (int)(pageFormat.getImageableWidth() + 0.5) - 4;
        PageDecorationUtility.a(attributeSet, decorationOptions);
        pageHeaderAttribute = (PageHeaderAttribute)attributeSet.get(b == null ? (b = PageDecorationUtility.class$("jpdf.attribute.PageHeaderAttribute")) : b);
        if (pageHeaderAttribute != null && PageDecorationUtility.a(attributeSet, n2)) {
            n4 = pageHeaderAttribute.getRequiredHeight(n3, printParameterHolder);
            bl = PageHeaderLine.isToPrintLine(attributeSet);
        }
        if ((pageFooterAttribute = (PageFooterAttribute)attributeSet.get(g == null ? (g = PageDecorationUtility.class$("jpdf.attribute.PageFooterAttribute")) : g)) != null && PageDecorationUtility.b(attributeSet, n2)) {
            n5 = pageFooterAttribute.getRequiredHeight(n3, printParameterHolder);
            bl2 = PageFooterLine.isToPrintLine(attributeSet);
        }
        if (decorationOptions.pageSubheaderPainter != null) {
            n4 += decorationOptions.pageSubheaderPainter.getRequiredHeight(n3, printParameterHolder);
        }
        return PageDecorationUtility.a(pageFormat, DecorationOptions.a(decorationOptions), n4, n5, bl, bl2);
    }

    public static Dimension computeAvailablePageSpace(PageFormat pageFormat, AttributeSet attributeSet, DecorationOptions decorationOptions, PrintParameterHolder printParameterHolder) {
        PageHeaderAttribute pageHeaderAttribute = null;
        PageFooterAttribute pageFooterAttribute = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        PageDecorationUtility.a(attributeSet, decorationOptions);
        if (attributeSet != null) {
            n3 = (int)(pageFormat.getImageableWidth() + 0.5) - 4;
            pageHeaderAttribute = (PageHeaderAttribute)attributeSet.get(b == null ? (b = PageDecorationUtility.class$("jpdf.attribute.PageHeaderAttribute")) : b);
            if (pageHeaderAttribute != null) {
                n5 = pageHeaderAttribute.getRequiredHeight(n3, printParameterHolder);
                bl = PageHeaderLine.isToPrintLine(attributeSet);
            }
            if ((pageFooterAttribute = (PageFooterAttribute)attributeSet.get(g == null ? (g = PageDecorationUtility.class$("jpdf.attribute.PageFooterAttribute")) : g)) != null) {
                n6 = pageFooterAttribute.getRequiredHeight(n3, printParameterHolder);
                bl2 = PageFooterLine.isToPrintLine(attributeSet);
            }
        }
        if (decorationOptions.pageSubheaderPainter != null) {
            n5 += decorationOptions.pageSubheaderPainter.getRequiredHeight(n2, printParameterHolder);
        }
        n2 = PageDecorationUtility.computeAvailablePageWidth(pageFormat, attributeSet, decorationOptions, 0);
        n4 = PageDecorationUtility.a(pageFormat, DecorationOptions.a(decorationOptions), n5, n6, bl, bl2);
        return new Dimension(n2, n4);
    }

    public static int computeAvailablePageWidth(PageFormat pageFormat, AttributeSet attributeSet, DecorationOptions decorationOptions, int n2) {
        PageDecorationUtility.a(attributeSet, decorationOptions);
        return PageDecorationUtility.a(pageFormat, DecorationOptions.a(decorationOptions), PageFrame.isToPrintFrame(attributeSet));
    }

    public static void fillBackground(Graphics2D graphics2D, PageFormat pageFormat, Color color) {
        Color color2 = graphics2D.getColor();
        graphics2D.setColor(color);
        graphics2D.fillRect((int)(pageFormat.getImageableX() + 2.0), (int)(pageFormat.getImageableY() + 2.0), (int)(pageFormat.getImageableWidth() - 4.0 - 1.0), (int)(pageFormat.getImageableHeight() - 4.0 - 1.0));
        graphics2D.setColor(color2);
    }

    public static Color getFooterLineColor() {
        return f;
    }

    public static BasicStroke getFooterLineStroke() {
        return h;
    }

    public static Color getHeaderLineColor() {
        return d;
    }

    public static BasicStroke getHeaderLineStroke() {
        return e;
    }

    public static int getNoteXOffsetLeft() {
        return a;
    }

    public static int getNoteXOffsetRight() {
        return c;
    }

    public static Class[] getPageDecorationAttributeClasses() {
        return AttributeClassifier.getPageDecorationAttributeClasses();
    }

    public static int printFooterLine(Graphics2D graphics2D, PageFormat pageFormat, int n2) {
        return PageDecorationUtility.printFooterLine(graphics2D, pageFormat, n2, true);
    }

    public static int printFooterLine(Graphics2D graphics2D, PageFormat pageFormat, int n2, boolean bl) {
        return PageDecorationUtility.a(graphics2D, pageFormat, PageDecorationUtility.getHeaderLineColor(), PageDecorationUtility.getHeaderLineStroke(), n2, false, bl);
    }

    public static int printFootNote(Graphics2D graphics2D, PageFormat pageFormat, String string, Font font, int n2, boolean bl) {
        FontMetrics fontMetrics = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (font != null) {
            graphics2D.setFont(font);
        } else {
            font = graphics2D.getFont();
        }
        fontMetrics = graphics2D.getFontMetrics();
        n3 = fontMetrics.getHeight();
        n4 = PageDecorationUtility.a(string, pageFormat, fontMetrics, n2);
        n5 += (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight()) - 2 - n3 + fontMetrics.getMaxAscent();
        if (font.getSize() >= 8) {
            --n5;
        }
        graphics2D.drawString(string, n4, n5);
        if (bl) {
            n3 += PageDecorationUtility.printFooterLine(graphics2D, pageFormat, n3, true);
        }
        return n3;
    }

    public static int printFootTextComponent(Graphics2D graphics2D, PageFormat pageFormat, JTextComponent jTextComponent, boolean bl) {
        int n2 = PageDecorationUtility.a(pageFormat);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n3 = PageDecorationUtility.a(jTextComponent, n2);
        n4 = (int)pageFormat.getImageableX() + PageDecorationUtility.getNoteXOffsetLeft();
        n5 = (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight()) - (2 + n3 + 3);
        graphics2D.translate(n4, n5);
        jTextComponent.paint(graphics2D);
        graphics2D.translate(-n4, -n5);
        if (bl) {
            n3 += PageDecorationUtility.printFooterLine(graphics2D, pageFormat, n3, true);
        }
        return n3;
    }

    public static void printFrame(Graphics2D graphics2D, PageFormat pageFormat, BasicStroke basicStroke) {
        Rectangle rectangle = graphics2D.getClipBounds();
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        if (rectangle != null && !(graphics2D instanceof PrinterGraphics)) {
            graphics2D.drawRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 5, rectangle.height - 5);
        } else {
            graphics2D.drawRect((int)(pageFormat.getImageableX() + 2.0 - 0.5), (int)(pageFormat.getImageableY() + 2.0 - 0.5), (int)(pageFormat.getImageableWidth() - 4.0 - 0.5), (int)(pageFormat.getImageableHeight() - 4.0 - 0.5));
        }
    }

    public static int printHeaderLine(Graphics2D graphics2D, PageFormat pageFormat, int n2) {
        return PageDecorationUtility.printHeaderLine(graphics2D, pageFormat, n2, true);
    }

    public static int printHeaderLine(Graphics2D graphics2D, PageFormat pageFormat, int n2, boolean bl) {
        return PageDecorationUtility.a(graphics2D, pageFormat, PageDecorationUtility.getHeaderLineColor(), PageDecorationUtility.getHeaderLineStroke(), n2, true, bl);
    }

    public static int printHeadNote(Graphics2D graphics2D, PageFormat pageFormat, String string, Font font, int n2, boolean bl) {
        FontMetrics fontMetrics = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (font != null) {
            graphics2D.setFont(font);
        } else {
            font = graphics2D.getFont();
        }
        fontMetrics = graphics2D.getFontMetrics();
        n3 = fontMetrics.getHeight() - 1;
        n4 = PageDecorationUtility.a(string, pageFormat, fontMetrics, n2);
        n5 += (int)pageFormat.getImageableY() + 2 + fontMetrics.getMaxAscent();
        if (font.getSize() >= 8) {
            --n5;
        }
        graphics2D.drawString(string, n4, n5);
        if (bl) {
            n3 += PageDecorationUtility.printHeaderLine(graphics2D, pageFormat, n3 + 1, true);
        }
        return n3;
    }

    public static int printHeadTextComponent(Graphics2D graphics2D, PageFormat pageFormat, JTextComponent jTextComponent, boolean bl) {
        int n2 = PageDecorationUtility.a(pageFormat);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n3 = PageDecorationUtility.a(jTextComponent, n2);
        n4 = (int)pageFormat.getImageableX() + PageDecorationUtility.getNoteXOffsetLeft();
        n5 = (int)pageFormat.getImageableY() + 2 - 3;
        graphics2D.translate(n4, n5);
        jTextComponent.paint(graphics2D);
        graphics2D.translate(-n4, -n5);
        if (bl) {
            n3 += PageDecorationUtility.printHeaderLine(graphics2D, pageFormat, n3, true);
        }
        return n3;
    }

    public static void printHorizontalBlock(Graphics2D graphics2D, PageFormat pageFormat, Color color, int n2, int n3) {
        int n4 = (int)pageFormat.getImageableY();
        n4 = n2 >= 0 ? (n4 += n2) : (n4 += (int)pageFormat.getImageableHeight() + n2 - n3);
        PageDecorationUtility.printHorizontalBlockAt(graphics2D, pageFormat, color, n4, n3);
    }

    public static void printHorizontalBlockAt(Graphics2D graphics2D, PageFormat pageFormat, Color color, int n2, int n3) {
        int n4 = (int)pageFormat.getImageableX() + 2;
        int n5 = (int)pageFormat.getImageableWidth() - 4;
        if (color != null) {
            graphics2D.setColor(color);
        }
        graphics2D.fillRect(n4, n2, n5, n3);
    }

    public static void printHorizontalLine(Graphics2D graphics2D, PageFormat pageFormat, Color color, BasicStroke basicStroke, int n2) {
        int n3 = (int)pageFormat.getImageableY();
        n3 = n2 >= 0 ? (n3 += n2) : (n3 += (int)pageFormat.getImageableHeight() + n2);
        PageDecorationUtility.printHorizontalLineAt(graphics2D, pageFormat, color, basicStroke, n3, 2);
    }

    public static void printHorizontalLineAt(Graphics2D graphics2D, PageFormat pageFormat, Color color, BasicStroke basicStroke, int n2) {
        PageDecorationUtility.printHorizontalLineAt(graphics2D, pageFormat, color, basicStroke, n2, 2);
    }

    public static void printHorizontalLineAt(Graphics2D graphics2D, PageFormat pageFormat, Color color, BasicStroke basicStroke, int n2, int n3) {
        int n4 = (int)pageFormat.getImageableX() + n3 - 1;
        int n5 = n4 + (int)pageFormat.getImageableWidth() - 2 * n3 - 1;
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        if (color != null) {
            graphics2D.setColor(color);
        }
        graphics2D.drawLine(n4, n2, n5, n2);
    }

    public static void printStandardPageDecorations(Graphics2D graphics2D, PageFormat pageFormat, DecorationOptions decorationOptions, String[] stringArray, String[] stringArray2) {
        int n2 = 0;
        int n3 = 0;
        if (stringArray != null) {
            graphics2D.setColor(decorationOptions.headNoteColor);
            PageDecorationUtility.printHeadNote(graphics2D, pageFormat, stringArray[0], decorationOptions.headNoteFont, 2, false);
            PageDecorationUtility.printHeadNote(graphics2D, pageFormat, stringArray[1], decorationOptions.headNoteFont, 0, false);
            n2 = PageDecorationUtility.printHeadNote(graphics2D, pageFormat, stringArray[2], decorationOptions.headNoteFont, 4, decorationOptions.headLinePrinted);
        }
        if (stringArray2 != null) {
            graphics2D.setColor(decorationOptions.footNoteColor);
            PageDecorationUtility.printFootNote(graphics2D, pageFormat, stringArray2[0], decorationOptions.footNoteFont, 2, false);
            PageDecorationUtility.printFootNote(graphics2D, pageFormat, stringArray2[1], decorationOptions.footNoteFont, 0, false);
            n3 = PageDecorationUtility.printFootNote(graphics2D, pageFormat, stringArray2[2], decorationOptions.footNoteFont, 4, decorationOptions.footLinePrinted);
        }
        if (decorationOptions.framePrinted) {
            graphics2D.setColor(Color.BLACK);
            PageDecorationUtility.printFrame(graphics2D, pageFormat, StrokeConstant.SOLID_STROKE);
        } else {
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(StrokeConstant.SOLID_STROKE);
        }
        PageDecorationUtility.a(graphics2D, pageFormat, decorationOptions.offsets, n2, n3, decorationOptions);
    }

    public static void printStandardPageDecorations(Graphics2D graphics2D, AttributeSet attributeSet, PageFormat pageFormat, DecorationOptions decorationOptions, PrintParameterHolder printParameterHolder) {
        PageHeaderAttribute pageHeaderAttribute = null;
        PageFooterAttribute pageFooterAttribute = null;
        int n2 = printParameterHolder.pageNo - 1;
        int n3 = n2 / printParameterHolder.pageGridWidth;
        int n4 = PageDecorationUtility.a(pageFormat);
        int n5 = (int)pageFormat.getImageableX();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (!(graphics2D instanceof PrinterGraphics) || decorationOptions.pageIndex != n2) {
            decorationOptions.framePrinted = PageFrame.isToPrintFrame(attributeSet);
            decorationOptions.pageIndex = n2;
            PageDecorationUtility.b(attributeSet, decorationOptions);
        }
        if ((pageHeaderAttribute = (PageHeaderAttribute)attributeSet.get(b == null ? (b = PageDecorationUtility.class$("jpdf.attribute.PageHeaderAttribute")) : b)) != null && PageDecorationUtility.a(attributeSet, n3)) {
            n6 = (int)pageFormat.getImageableY() + 2;
            n7 = pageHeaderAttribute.print(graphics2D, n4, n5, n6, printParameterHolder);
            if (PageHeaderLine.isToPrintLine(attributeSet)) {
                n7 += PageDecorationUtility.printHeaderLine(graphics2D, pageFormat, n7, decorationOptions.framePrinted);
            }
        }
        if (decorationOptions.pageSubheaderPainter != null) {
            n6 += n7;
            n7 += decorationOptions.pageSubheaderPainter.print(graphics2D, n4, n5, n6, printParameterHolder);
        }
        if ((pageFooterAttribute = (PageFooterAttribute)attributeSet.get(g == null ? (g = PageDecorationUtility.class$("jpdf.attribute.PageFooterAttribute")) : g)) != null && PageDecorationUtility.b(attributeSet, n3)) {
            n6 = (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight()) - 4;
            n8 = pageFooterAttribute.print(graphics2D, n4, n5, n6, printParameterHolder);
            if (PageFooterLine.isToPrintLine(attributeSet)) {
                n8 += PageDecorationUtility.printFooterLine(graphics2D, pageFormat, n8, decorationOptions.framePrinted);
            }
        }
        if (decorationOptions.framePrinted) {
            graphics2D.setColor(Color.BLACK);
            PageDecorationUtility.printFrame(graphics2D, pageFormat, StrokeConstant.SOLID_STROKE);
        } else {
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(StrokeConstant.SOLID_STROKE);
        }
        PageDecorationUtility.a(graphics2D, pageFormat, decorationOptions.offsets, n7, n8, decorationOptions);
    }

    public static void setFooterLineColor(Color color) {
        f = color;
    }

    public static void setFooterLineStroke(BasicStroke basicStroke) {
        h = basicStroke;
    }

    public static void setHeaderLineColor(Color color) {
        d = color;
    }

    public static void setHeaderLineStroke(BasicStroke basicStroke) {
        e = basicStroke;
    }

    public static void setNoteXOffsetLeft(int n2) {
        a = n2;
    }

    public static void setNoteXOffsetRight(int n2) {
        c = n2;
    }

    private static int a(PageFormat pageFormat, Insets insets, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = 0;
        n4 = (int)(pageFormat.getImageableHeight() + 0.5) - (4 + insets.top + insets.bottom + 4) - (n2 + n3);
        if (bl) {
            n4 = (int)((float)n4 - PageDecorationUtility.getHeaderLineStroke().getLineWidth());
        }
        if (bl2) {
            n4 = (int)((float)n4 - PageDecorationUtility.getFooterLineStroke().getLineWidth());
        }
        return n4;
    }

    private static int a(PageFormat pageFormat, Insets insets, boolean bl) {
        int n2 = 0;
        n2 = bl ? (int)(pageFormat.getImageableWidth() + 0.5) - (4 + insets.left + insets.right + 4) : (int)(pageFormat.getImageableWidth() + 0.5) - (insets.left + insets.right + 2);
        return n2;
    }

    private static int a(PageFormat pageFormat) {
        int n2 = 0;
        n2 = (int)(pageFormat.getImageableWidth() + 0.5) - 8;
        return n2;
    }

    private static int a(String string, PageFormat pageFormat, FontMetrics fontMetrics, int n2) {
        int n3 = (int)pageFormat.getImageableX();
        int n4 = 0;
        if (n2 == 0) {
            n4 = fontMetrics.stringWidth(string);
            n3 += (int)((pageFormat.getImageableWidth() - (double)n4) / 2.0);
        } else if (n2 == 4) {
            n4 = fontMetrics.stringWidth(string);
            n3 += (int)pageFormat.getImageableWidth() - n4 - PageDecorationUtility.getNoteXOffsetRight();
        } else {
            n3 += PageDecorationUtility.getNoteXOffsetLeft();
        }
        return n3;
    }

    private static boolean b(AttributeSet attributeSet) {
        return attributeSet != null && attributeSet.get(g == null ? (g = PageDecorationUtility.class$("jpdf.attribute.PageFooterAttribute")) : g) != null;
    }

    private static boolean b(AttributeSet attributeSet, int n2) {
        boolean bl = false;
        if (PageDecorationUtility.b(attributeSet)) {
            bl = PageFooterOnFirstPage.isFooterIncludedOnPage(attributeSet, n2);
        }
        return bl;
    }

    private static boolean a(AttributeSet attributeSet) {
        return attributeSet != null && attributeSet.get(b == null ? (b = PageDecorationUtility.class$("jpdf.attribute.PageHeaderAttribute")) : b) != null;
    }

    private static boolean a(AttributeSet attributeSet, int n2) {
        boolean bl = false;
        if (PageDecorationUtility.a(attributeSet)) {
            bl = PageHeaderOnFirstPage.isHeaderIncludedOnPage(attributeSet, n2);
        }
        return bl;
    }

    private static int a(Graphics2D graphics2D, PageFormat pageFormat, Color color, BasicStroke basicStroke, int n2, boolean bl, boolean bl2) {
        float f2 = basicStroke.getLineWidth();
        int n3 = (int)pageFormat.getImageableY();
        int n4 = (int)pageFormat.getImageableX();
        int n5 = n4 + (int)pageFormat.getImageableWidth();
        if (bl) {
            n3 += n2 + 2 + (int)(f2 / 2.0f);
        } else {
            n3 += (int)pageFormat.getImageableHeight() - (2 + n2) - 1;
            n3 -= f2 == 1.0f ? 1 : (int)(f2 / 2.0f);
        }
        if (bl2) {
            ++n4;
            n5 -= 4;
        }
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(color);
        graphics2D.drawLine(n4, n3, n5, n3);
        return (int)(f2 + 0.5f);
    }

    private static void a(Graphics2D graphics2D, PageFormat pageFormat, Insets insets, int n2, int n3, DecorationOptions decorationOptions) {
        int n4 = 0;
        int n5 = 0;
        int n6 = (int)Math.round(pageFormat.getImageableX());
        int n7 = (int)Math.round(pageFormat.getImageableY());
        int n8 = (int)Math.round(pageFormat.getImageableWidth());
        int n9 = (int)Math.round(pageFormat.getImageableHeight());
        n4 = PageDecorationUtility.a(pageFormat, insets, decorationOptions.framePrinted);
        n5 = PageDecorationUtility.a(pageFormat, insets, n2, n3, false, false);
        decorationOptions.pageContentRectangle.x = decorationOptions.framePrinted ? n6 + 2 + insets.left + 2 : n6 + insets.left + 1;
        decorationOptions.pageContentRectangle.y = n7 + 2 + insets.top + n2 + 2;
        decorationOptions.pageContentRectangle.width = Math.min(n8, n4);
        decorationOptions.pageContentRectangle.height = Math.min(n9, n5);
        graphics2D.clip(decorationOptions.pageContentRectangle);
    }

    private static int a(JTextComponent jTextComponent, int n2) {
        Document document = jTextComponent.getDocument();
        Rectangle rectangle = null;
        int n3 = document.getLength();
        int n4 = 0;
        jTextComponent.setSize(n2, 111);
        if (n3 > 0) {
            try {
                rectangle = jTextComponent.modelToView(n3 - 1);
            }
            catch (Exception exception) {
                PrintManager.handleException(exception, false, false);
            }
            n4 = rectangle.y + rectangle.height;
            jTextComponent.setSize(n2, n4);
        }
        return n4;
    }

    private static void b(AttributeSet attributeSet, DecorationOptions decorationOptions) {
        float f2 = 0.0f;
        decorationOptions.offsets.left = (int)(OffsetLeft.getOffset(attributeSet, 25400, 0.0f) * 72.0f + 0.5f) + decorationOptions.minimumOffsets.left;
        decorationOptions.offsets.right = (int)(OffsetRight.getOffset(attributeSet, 25400, 0.0f) * 72.0f + 0.5f) + decorationOptions.minimumOffsets.right;
        decorationOptions.offsets.top = (int)(OffsetTop.getOffset(attributeSet, 25400, 0.0f) * 72.0f + 0.5f) + decorationOptions.minimumOffsets.top;
        decorationOptions.offsets.bottom = (int)(OffsetBottom.getOffset(attributeSet, 25400, 0.0f) * 72.0f + 0.5f) + decorationOptions.minimumOffsets.bottom;
    }

    private static void a(AttributeSet attributeSet, DecorationOptions decorationOptions) {
        float f2 = 0.0f;
        DecorationOptions.a((DecorationOptions)decorationOptions).left = (int)(OffsetLeft.getOffset(attributeSet, 25400, 0.0f) * 72.0f + 0.5f) + decorationOptions.minimumOffsets.left;
        DecorationOptions.a((DecorationOptions)decorationOptions).right = (int)(OffsetRight.getOffset(attributeSet, 25400, 0.0f) * 72.0f + 0.5f) + decorationOptions.minimumOffsets.right;
        DecorationOptions.a((DecorationOptions)decorationOptions).top = (int)(OffsetTop.getOffset(attributeSet, 25400, 0.0f) * 72.0f + 0.5f) + decorationOptions.minimumOffsets.top;
        DecorationOptions.a((DecorationOptions)decorationOptions).bottom = (int)(OffsetBottom.getOffset(attributeSet, 25400, 0.0f) * 72.0f + 0.5f) + decorationOptions.minimumOffsets.bottom;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static class DecorationOptions {
        public Rectangle pageContentRectangle = new Rectangle();
        public Insets minimumOffsets = new Insets(2, 2, 2, 2);
        public Insets offsets = new Insets(0, 0, 0, 0);
        public Color footNoteColor = Color.BLACK;
        public Color headNoteColor = Color.BLACK;
        public Font footNoteFont = DEFAULT_DECORATION_FONT;
        public Font headNoteFont = DEFAULT_DECORATION_FONT;
        public boolean footLinePrinted = true;
        public boolean headLinePrinted = true;
        public boolean framePrinted = true;
        public int pageIndex = -99;
        public PageDecorationPainter pageSubheaderPainter = null;
        private Insets a = new Insets(0, 0, 0, 0);

        static Insets a(DecorationOptions decorationOptions) {
            return decorationOptions.a;
        }
    }
}

