/*
 * Decompiled with CFR 0.152.
 */
package jpdf.report.text;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JTextArea;
import jpdf.report.AbstractSectionOptions;
import jpdf.report.ReportStandardizer;
import jpdf.report.decoration.ReportDecorationBuilder;
import jpdf_common.system.utility.FileReadUtility;

public class TextSectionOptions
extends AbstractSectionOptions {
    public final String SECTION_TEXT;
    private Font j = ReportStandardizer.getDefaultSectionContentFont();
    private Color i = Color.BLACK;
    private boolean d = true;

    public TextSectionOptions(PrintRequestAttributeSet printRequestAttributeSet, String string, File file) throws Exception {
        this(printRequestAttributeSet, string, FileReadUtility.readContentString(file.getPath()));
    }

    public TextSectionOptions(PrintRequestAttributeSet printRequestAttributeSet, String string, String string2) {
        super(printRequestAttributeSet, string);
        this.SECTION_TEXT = string2;
    }

    public TextSectionOptions(PrintRequestAttributeSet printRequestAttributeSet, ReportDecorationBuilder reportDecorationBuilder, ReportDecorationBuilder reportDecorationBuilder2, File file) throws Exception {
        this(printRequestAttributeSet, reportDecorationBuilder, reportDecorationBuilder2, FileReadUtility.readContentString(file.getPath()));
    }

    public TextSectionOptions(PrintRequestAttributeSet printRequestAttributeSet, ReportDecorationBuilder reportDecorationBuilder, ReportDecorationBuilder reportDecorationBuilder2, String string) {
        super(printRequestAttributeSet, reportDecorationBuilder, reportDecorationBuilder2);
        this.SECTION_TEXT = string;
    }

    public int addSectionComponents(ArrayList arrayList) {
        return this.addSectionComponents(arrayList, this.buildSectionTextArea());
    }

    public Font getSectionFont() {
        return this.j;
    }

    public Color getSectionTextColor() {
        return this.i;
    }

    public boolean isToWrapText() {
        return this.d;
    }

    public void setSectionFont(Font font) {
        this.j = font;
    }

    public void setSectionTextColor(Color color) {
        this.i = color;
    }

    public void setToWrapText(boolean bl) {
        this.d = bl;
    }

    protected ReportTextArea buildSectionTextArea() {
        return new ReportTextArea(this);
    }

    protected static class ReportTextArea
    extends JTextArea {
        public ReportTextArea(TextSectionOptions textSectionOptions) {
            super(textSectionOptions.SECTION_TEXT);
            if (textSectionOptions.isToWrapText()) {
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
            } else {
                this.putClientProperty("JPDF_NoFitWidthScale", Boolean.TRUE);
            }
            this.setFont(textSectionOptions.getSectionFont());
            this.setForeground(textSectionOptions.getSectionTextColor());
            this.setName(textSectionOptions.computeContentComponentName(this));
        }
    }
}

