/*
 * Decompiled with CFR 0.152.
 */
package jpdf.report.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import jpdf.report.table.renderer.ReportDataCellRenderer;

public class FormattedCellRenderer
extends ReportDataCellRenderer {
    private Format d = null;
    private Font f = null;
    private Color c = null;
    private Color e = null;
    private int g = 0;

    public FormattedCellRenderer() {
    }

    public FormattedCellRenderer(Format format) {
        this.setCellFormat(format);
    }

    public FormattedCellRenderer(Format format, int n2) {
        this.setCellFormat(format);
        this.setHorizontalAlignment(n2);
    }

    public static FormattedCellRenderer buildNumberFormatInstance(NumberFormat numberFormat, int n2) {
        FormattedCellRenderer formattedCellRenderer = null;
        Border border = null;
        formattedCellRenderer = new FormattedCellRenderer(numberFormat, 4);
        border = BorderFactory.createEmptyBorder(1, 1, 1, n2);
        formattedCellRenderer.setBorder(border);
        return formattedCellRenderer;
    }

    public static FormattedCellRenderer buildNumberFormatInstance(NumberFormat numberFormat, Border border, int n2) {
        FormattedCellRenderer formattedCellRenderer = null;
        formattedCellRenderer = new FormattedCellRenderer(numberFormat, 4);
        formattedCellRenderer.setBorder(formattedCellRenderer.a(border, n2));
        return formattedCellRenderer;
    }

    public Color getCellBackgroundColor() {
        return this.c;
    }

    public Font getCellFont() {
        return this.f;
    }

    public Color getCellForegroundColor() {
        return this.e;
    }

    public Format getCellFormat() {
        return this.d;
    }

    public int getCellWidthPadding() {
        return this.g;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.g > 0) {
            dimension.width += this.g;
        }
        return dimension;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        Component component = null;
        if (this.d != null && object != null) {
            try {
                object = this.d.format(object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
        if (this.f != null) {
            component.setFont(this.f);
        }
        if (this.e != null) {
            component.setForeground(this.e);
        }
        if (this.c != null) {
            component.setBackground(this.c);
        }
        return component;
    }

    public void setCellBackgroundColor(Color color) {
        this.c = color;
    }

    public void setCellFont(Font font) {
        this.f = font;
    }

    public void setCellForegroundColor(Color color) {
        this.e = color;
    }

    public void setCellFormat(Format format) {
        this.d = format;
    }

    public void setCellWidthPadding(int n2) {
        this.g = n2;
    }

    private Border a(Border border, int n2) {
        Border border2 = null;
        int n3 = border.getBorderInsets((Component)this).right;
        if (n3 >= n2) {
            return border;
        }
        border2 = BorderFactory.createEmptyBorder(0, 0, 0, n2 - n3);
        return BorderFactory.createCompoundBorder(border, border2);
    }
}

