/*
 * Decompiled with CFR 0.152.
 */
package jpdf.report.table;

import java.util.ArrayList;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JComponent;
import jpdf.attribute.OffsetLeft;
import jpdf.report.ReportStandardizer;
import jpdf.report.decoration.ReportDecorationBuilder;
import jpdf.report.decoration.TitleOptions;
import jpdf.report.table.SegmentedReportTable;
import jpdf.report.table.TableData;
import jpdf.report.table.TableSectionOptions;

public class SegmentedTableSectionOptions
extends TableSectionOptions {
    public final int SEGMENTATION_COLUMNS;
    private final PrintRequestAttributeSet[][] s;
    private final Integer[] v;
    private final Integer[] t;
    private final ReportDecorationBuilder[] o;
    private final ReportDecorationBuilder[] w;
    private float u = 0.25f;

    public SegmentedTableSectionOptions(PrintRequestAttributeSet printRequestAttributeSet, TableData tableData, int n2) {
        this(printRequestAttributeSet, tableData, null, n2);
    }

    public SegmentedTableSectionOptions(PrintRequestAttributeSet printRequestAttributeSet, TableData tableData, ReportDecorationBuilder reportDecorationBuilder, int n2) {
        super(printRequestAttributeSet, tableData, reportDecorationBuilder);
        int n3;
        if (n2 < 1) {
            String string = "The number of Segmentation Columns must be greater than zero.";
            throw new IllegalArgumentException(string);
        }
        if (n2 >= tableData.getColumnCount()) {
            String string = "The number of Segmentation Columns must be less than the number of columns in the table";
            throw new IllegalArgumentException(string);
        }
        this.SEGMENTATION_COLUMNS = n2;
        this.v = new Integer[this.SEGMENTATION_COLUMNS];
        for (n3 = 0; n3 < this.SEGMENTATION_COLUMNS; ++n3) {
            this.v[n3] = new Integer(n3 + 1);
        }
        this.t = new Integer[this.SEGMENTATION_COLUMNS];
        this.o = new ReportDecorationBuilder[this.SEGMENTATION_COLUMNS];
        this.w = new ReportDecorationBuilder[this.SEGMENTATION_COLUMNS];
        this.o[0] = this.b(n2, 1);
        super.setTableHeaderBuilder(this.o[0]);
        this.w[0] = this.getTableFooterBuilder();
        for (n3 = 1; n3 < n2; ++n3) {
            this.o[n3] = this.b(n2, n3 + 1);
            this.w[n3] = this.w[0];
        }
        this.s = n2 > 1 ? new PrintRequestAttributeSet[this.SEGMENTATION_COLUMNS][2] : (PrintRequestAttributeSet[][])null;
    }

    public int addSectionComponents(ArrayList arrayList) {
        ReportDecorationBuilder reportDecorationBuilder = null;
        SegmentedReportTable segmentedReportTable = null;
        JComponent jComponent = null;
        int n2 = arrayList.size();
        int n3 = 0;
        segmentedReportTable = new SegmentedReportTable(this);
        segmentedReportTable.addSegmentedTableComponents(this, arrayList, this.SEGMENTATION_COLUMNS);
        reportDecorationBuilder = this.getSectionHeaderBuilder();
        if (reportDecorationBuilder != null) {
            jComponent = reportDecorationBuilder.buildDecorationComponent(arrayList, null);
            arrayList.add(n2, jComponent);
        }
        if ((reportDecorationBuilder = this.getSectionFooterBuilder()) != null) {
            jComponent = reportDecorationBuilder.buildDecorationComponent(arrayList, null);
            arrayList.add(jComponent);
        }
        n3 = arrayList.size() - n2;
        return n3;
    }

    public ReportDecorationBuilder getSegmentFooterBuilder(int n2) {
        return this.w[n2 - 1];
    }

    public ReportDecorationBuilder getSegmentHeaderBuilder(int n2) {
        return this.o[n2 - 1];
    }

    public int getSegmentIndent() {
        return (int)(this.u * 72.0f);
    }

    public Integer getSegmentStartNewPageHeight(int n2) {
        return this.t[n2 - 1];
    }

    public void setColumnResizeable(int n2) {
        int n3 = this.TABLE_DATA.getColumnCount() - 1 - this.SEGMENTATION_COLUMNS;
        this.a(n2, n3);
    }

    public void setColumnResizeWeights(float[] fArray) {
        int n2 = this.TABLE_DATA.getColumnCount() - 1 - this.SEGMENTATION_COLUMNS;
        if (fArray.length != n2) {
            String string = "The number of Resize Weights (" + fArray.length + ") must be the same " + "as the number of table columns (" + n2 + ").";
            throw new IllegalArgumentException(string);
        }
        this.a(fArray);
    }

    public void setSegmentFooterBuilder(int n2, ReportDecorationBuilder reportDecorationBuilder) {
        if (n2 == 1) {
            this.setTableFooterBuilder(reportDecorationBuilder);
        } else {
            this.w[n2 - 1] = reportDecorationBuilder;
        }
    }

    public void setSegmentHeaderBuilder(int n2, ReportDecorationBuilder reportDecorationBuilder) {
        if (n2 == 1) {
            this.setTableHeaderBuilder(reportDecorationBuilder);
        } else {
            this.o[n2 - 1] = reportDecorationBuilder;
        }
    }

    public void setSegmentIndent(int n2) {
        this.u = n2 <= 0 ? 0.0f : (float)n2 / 72.0f;
    }

    public void setSegmentStartNewPageHeight(int n2, int n3) {
        this.t[n2 - 1] = new Integer(n3);
    }

    public void setTableFooterBuilder(ReportDecorationBuilder reportDecorationBuilder) {
        super.setTableFooterBuilder(reportDecorationBuilder);
        this.w[0] = reportDecorationBuilder;
    }

    public void setTableHeaderBuilder(ReportDecorationBuilder reportDecorationBuilder) {
        super.setTableHeaderBuilder(reportDecorationBuilder);
        this.o[0] = reportDecorationBuilder;
    }

    protected void addSegmentFooterComponent(ArrayList arrayList, SegmentedReportTable segmentedReportTable) {
        ReportDecorationBuilder reportDecorationBuilder = this.getTableFooterBuilder();
        JComponent jComponent = null;
        int n2 = segmentedReportTable.getSegmentationLevel();
        reportDecorationBuilder = this.getSegmentFooterBuilder(n2);
        if (reportDecorationBuilder == null) {
            return;
        }
        jComponent = reportDecorationBuilder.buildDecorationComponent(arrayList, segmentedReportTable);
        arrayList.add(jComponent);
        jComponent.putClientProperty("JPDF_SegLevel", this.v[n2 - 1]);
    }

    protected void addSegmentHeaderComponent(ArrayList arrayList, SegmentedReportTable segmentedReportTable) {
        ReportDecorationBuilder reportDecorationBuilder = null;
        JComponent jComponent = null;
        Integer n2 = null;
        String string = null;
        int n3 = segmentedReportTable.getSegmentationLevel();
        n2 = this.getSegmentStartNewPageHeight(n3);
        reportDecorationBuilder = this.getSegmentHeaderBuilder(n3);
        if (reportDecorationBuilder == null) {
            if (n2 != null) {
                segmentedReportTable.putClientProperty("JPDF_SNPH", n2);
            }
            return;
        }
        jComponent = reportDecorationBuilder.buildDecorationComponent(arrayList, segmentedReportTable);
        arrayList.add(jComponent);
        if (n2 != null) {
            jComponent.putClientProperty("JPDF_SNPH", n2);
        }
        if (this.SEGMENTATION_COLUMNS > 1) {
            if (n3 == 1) {
                jComponent.putClientProperty("JPDF_ContinuationString", "[-none-]");
            } else {
                string = segmentedReportTable.a();
                jComponent.putClientProperty("JPDF_ContinuationString", string);
            }
        }
        jComponent.putClientProperty("JPDF_SegLevel", this.v[n3 - 1]);
    }

    protected PrintRequestAttributeSet getPrintAttributeSet(JComponent jComponent) {
        PrintRequestAttributeSet printRequestAttributeSet = null;
        Object object = null;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        if (jComponent instanceof SegmentedReportTable) {
            n2 = ((SegmentedReportTable)jComponent).getSegmentationLevel();
        } else {
            object = jComponent.getClientProperty("JPDF_SegLevel");
            if (object instanceof Integer) {
                n2 = (Integer)object;
            }
        }
        if (n2 <= 1) {
            return super.getPrintAttributeSet(jComponent);
        }
        if (this.getSegmentIndent() == 0) {
            return super.getPrintAttributeSet(jComponent);
        }
        n3 = n2 - 1;
        if (this.isDecorationPanel(jComponent)) {
            n4 = 1;
        }
        if ((printRequestAttributeSet = this.s[n3][n4]) == null) {
            this.s[n3][n4] = printRequestAttributeSet = this.a(jComponent, n2);
        }
        return printRequestAttributeSet;
    }

    private PrintRequestAttributeSet a(JComponent jComponent, int n2) {
        PrintRequestAttributeSet printRequestAttributeSet = super.getPrintAttributeSet(jComponent);
        float f2 = 0.0f;
        printRequestAttributeSet = new HashPrintRequestAttributeSet(printRequestAttributeSet);
        f2 = OffsetLeft.getOffset(printRequestAttributeSet, 25400, 0.0f);
        printRequestAttributeSet.add(new OffsetLeft(f2 += this.f() * (float)(n2 - 1), true));
        return printRequestAttributeSet;
    }

    private ReportDecorationBuilder b(int n2, int n3) {
        TitleOptions titleOptions = null;
        titleOptions = n2 > 1 ? (n3 == 1 ? ReportStandardizer.getSectionHeaderTitleOptions() : ReportStandardizer.getSubsectionHeaderTitleOptions()) : ReportStandardizer.getSubsectionHeaderTitleOptions();
        return new SegmentedReportTable.SegmentTitleBuilder(titleOptions);
    }

    private float f() {
        return this.u;
    }
}

