/*
 * Decompiled with CFR 0.152.
 */
package jpdf.report.table;

import jpdf.report.table.SlicedReportTable;
import jpdf.report.table.TableData;
import jpdf.report.table.TableSlicer;

public class DefaultTableSlicer
implements TableSlicer {
    private final TableData b;
    private final int c;
    private boolean a = true;

    public DefaultTableSlicer(TableData tableData, int n2) {
        if (n2 < 1) {
            String string = "The number of Slice Columns must be greater than zero.";
            throw new IllegalArgumentException(string);
        }
        if (n2 >= tableData.getColumnCount()) {
            String string = "The number of Slice Columns must be less than the number of columns in the table";
            throw new IllegalArgumentException(string);
        }
        this.b = tableData;
        this.c = n2;
    }

    public String computeSliceContentName(SlicedReportTable slicedReportTable) {
        int n2 = slicedReportTable.getSliceFirstRowIndex();
        int n3 = this.getLevelCount() - 1;
        return this.b.getColumnName(n3) + ": " + this.b.getValueAt(n2, n3);
    }

    public String computeSliceHeaderText(SlicedReportTable slicedReportTable) {
        return null;
    }

    public String computeSliceStartDivisionName(SlicedReportTable slicedReportTable) {
        StringBuffer stringBuffer = null;
        int n2 = this.getLevelCount();
        int n3 = slicedReportTable.getSliceFirstRowIndex();
        int n4 = 0;
        int n5 = 0;
        if (n2 == 1) {
            return null;
        }
        n4 = this.computeSliceLevel(slicedReportTable);
        if (n4 == n2) {
            return null;
        }
        stringBuffer = new StringBuffer(64);
        n5 = n4 - 1;
        for (int i2 = 0; i2 < n5; ++i2) {
            stringBuffer.append(this.b.getColumnName(i2) + ": " + this.b.getValueAt(n3, i2).toString() + "  ");
        }
        return stringBuffer.toString();
    }

    public int computeSliceLevel(SlicedReportTable slicedReportTable) {
        int n2 = 1;
        int n3 = slicedReportTable.getSliceFirstRowIndex();
        int n4 = n3 - 1;
        if (n3 == 0) {
            return n2;
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (!this.isSame(this.b.getValueAt(n3, i2), this.b.getValueAt(n4, i2))) continue;
            n2 = i2 + 1;
            break;
        }
        return n2;
    }

    public int findSliceEndIndex(int n2) {
        int n3 = this.b.getRowCount();
        int n4 = -1;
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < this.c; ++i3) {
                if (this.isSame(this.b.getValueAt(i2, i3), this.b.getValueAt(i2 - 1, i3))) continue;
                n4 = i2 - 1;
                break;
            }
            if (n4 >= 0) break;
        }
        if (n4 < 0) {
            n4 = n3 - 1;
        }
        return n4;
    }

    public int getLevelCount() {
        return this.c;
    }

    public TableData getTableData() {
        return this.b;
    }

    public boolean isToRemoveRepeatingValues() {
        return this.a;
    }

    public void prepareDataForPrinting() {
        int n2 = 0;
        if (this.isToRemoveRepeatingValues()) {
            n2 = this.getLevelCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b.removeRepeatingValues(i2);
            }
        }
    }

    public void setToRemoveRepeatingValues(boolean bl) {
        this.a = bl;
    }

    protected boolean isSame(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.toString().equalsIgnoreCase(object2.toString());
    }
}

