/*
 * Decompiled with CFR 0.152.
 */
package jpdf.report.form.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import jpdf.manage.PrintManager;
import jpdf.printer.TextAreaPrinter;
import jpdf.printer.swing.DoNotPrintConfigure;

public class FormTextArea
extends JTextArea
implements DoNotPrintConfigure {
    public FormTextArea(String string, Font font) {
        this(string, font, null, Color.BLACK);
    }

    public FormTextArea(String string, Font font, Border border) {
        this(string, font, border, Color.BLACK);
    }

    public FormTextArea(String string, Font font, Border border, Color color) {
        super(string);
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        this.setFont(font);
        this.setForeground(color);
        this.setBorder(border);
        this.setOpaque(false);
        TextAreaPrinter.configureForPrinting(this);
    }

    public String breakAtHeightAbove(int n2) {
        Point point = null;
        int n3 = 0;
        int n4 = 0;
        if (n2 >= this.getLastCharBottom()) {
            return null;
        }
        n3 = this.getInsets().left + 1;
        n4 = n2;
        point = new Point(n3, n4);
        return this.a(point);
    }

    public String breakAtHeightBelow(int n2) {
        Point point = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n2 >= this.getLastCharBottom()) {
            return null;
        }
        n3 = this.getRowHeight();
        n4 = this.getInsets().left + 1;
        n5 = n2 + n3;
        point = new Point(n4, n5);
        return this.a(point);
    }

    public int getLastCharBottom() {
        Rectangle rectangle = null;
        int n2 = this.getDocument().getLength() - 1;
        int n3 = 0;
        if (n2 < 0) {
            return 0;
        }
        rectangle = this.a(n2);
        n3 = rectangle != null ? rectangle.y + rectangle.height - 1 : this.getHeight();
        return n3;
    }

    public int sizeToWidth(int n2) {
        return TextAreaPrinter.sizeComponentToWidth(this, this.getInsets(), n2, 1.0f);
    }

    private String a(Point point) {
        String string = null;
        int n2 = this.getDocument().getLength();
        int n3 = 0;
        n3 = this.viewToModel(point);
        if (n3 < n2 - 1) {
            try {
                string = this.getText(n3, n2 - n3);
                this.setText(this.getText(0, n3));
            }
            catch (BadLocationException badLocationException) {
                PrintManager.handleException(badLocationException);
            }
        }
        return string;
    }

    private Rectangle a(int n2) {
        Rectangle rectangle = null;
        try {
            rectangle = this.modelToView(n2);
        }
        catch (BadLocationException badLocationException) {
            PrintManager.handleException(badLocationException);
        }
        return rectangle;
    }
}

