/*
 * Decompiled with CFR 0.152.
 */
package jpdf.report.form;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jpdf.report.border.SideStrokeBorder;
import jpdf.report.form.TablePanel;
import jpdf.report.form.text.HtmlFormEditorPane;

public class FormPanel
extends JPanel {
    public FormPanel(LayoutManager layoutManager) {
        this(layoutManager, null, null);
    }

    public FormPanel(LayoutManager layoutManager, Border border) {
        this(layoutManager, border, null);
    }

    public FormPanel(LayoutManager layoutManager, Color color) {
        this(layoutManager, null, color);
    }

    public FormPanel(LayoutManager layoutManager, Border border, Color color) {
        super(layoutManager, false);
        if (border != null) {
            this.setBorder(border);
        }
        if (color != null) {
            this.setOpaque(true);
            this.setBackground(color);
        } else {
            this.setOpaque(false);
        }
    }

    public static BasicStroke buildDashedStroke(float f2, float f3, float f4) {
        return new BasicStroke(f2, 0, 1, 10.0f, new float[]{f3, f4}, 0.0f);
    }

    public static HtmlFormEditorPane buildHtmlEditorPane(String string, Border border, Font font) {
        HtmlFormEditorPane htmlFormEditorPane = null;
        File file = new File(string);
        htmlFormEditorPane = HtmlFormEditorPane.createInstance(file, font);
        htmlFormEditorPane.setBorder(border);
        return htmlFormEditorPane;
    }

    public static HtmlFormEditorPane buildHtmlEditorPane(URL uRL, Border border, Font font) {
        HtmlFormEditorPane htmlFormEditorPane = null;
        htmlFormEditorPane = HtmlFormEditorPane.createInstance(uRL, font);
        htmlFormEditorPane.setBorder(border);
        return htmlFormEditorPane;
    }

    public static TablePanel buildTablePanel(int[] nArray, int[] nArray2, int n2) {
        TablePanel tablePanel = null;
        String string = null;
        int n3 = 0;
        boolean bl = false;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != 0) continue;
            n3 = TablePanel.computeTotal(nArray);
            if (n3 >= n2) {
                string = "The sum of the column widths must be less than the specified total Width.";
                throw new IllegalArgumentException(string);
            }
            nArray[i2] = n2 - n3;
            bl = true;
            break;
        }
        if (!bl) {
            string = "One of the column widths must be zero.";
            throw new IllegalArgumentException(string);
        }
        tablePanel = new TablePanel(nArray, nArray2);
        return tablePanel;
    }

    public static FormPanel buildTwoColumnDisplayPanel(JComponent jComponent, JComponent jComponent2, Border border, int n2) {
        FormPanel formPanel = new FormPanel((LayoutManager)new GridLayout(1, 2, n2, 5), border);
        formPanel.add(jComponent);
        formPanel.add(jComponent2);
        return formPanel;
    }

    public static FormPanel buildTwoColumnDisplayPanel(JComponent jComponent, JComponent jComponent2, Border border, Color color, int n2) {
        FormPanel formPanel = new FormPanel(new GridLayout(1, 2, n2, 5), border, color);
        formPanel.add(jComponent);
        formPanel.add(jComponent2);
        return formPanel;
    }

    public static Border buildUnderlineBorder(BasicStroke basicStroke, Color color) {
        return new SideStrokeBorder(basicStroke, color);
    }
}

