/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer.text;

import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class ViewUtility {
    public static int getChildViewIndex(CompositeView compositeView, View view) {
        int n2 = -1;
        int n3 = 0;
        if (compositeView != null) {
            n3 = compositeView.getViewCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (compositeView.getView(i2) != view) continue;
                n2 = i2;
                break;
            }
        }
        return n2;
    }

    public static View getFollowingSiblingView(View view) {
        View view2 = null;
        View view3 = view.getParent();
        int n2 = 0;
        if (view3 != null && view3 instanceof CompositeView) {
            n2 = ((CompositeView)view3).getViewCount() - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (((CompositeView)view3).getView(i2) != view) continue;
                view2 = ((CompositeView)view3).getView(i2 + 1);
                break;
            }
        }
        return view2;
    }

    public static int getLowestBottomCharOffset(JTextComponent jTextComponent, int n2, int n3) throws BadLocationException {
        Rectangle rectangle = null;
        Rectangle rectangle2 = jTextComponent.modelToView(n3);
        int n4 = 0;
        int n5 = rectangle2.y + rectangle2.height - 1;
        int n6 = n3;
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            rectangle = jTextComponent.modelToView(i2);
            n4 = rectangle.y + rectangle.height - 1;
            if (n4 < rectangle2.y) break;
            if (n4 <= n5) continue;
            n5 = n4;
            n6 = i2;
        }
        return n6;
    }

    public static View getPrecedingSiblingView(View view) {
        View view2 = null;
        View view3 = view.getParent();
        int n2 = 0;
        if (view3 != null && view3 instanceof CompositeView) {
            n2 = ((CompositeView)view3).getViewCount();
            for (int i2 = 1; i2 < n2; ++i2) {
                if (((CompositeView)view3).getView(i2) != view) continue;
                view2 = ((CompositeView)view3).getView(i2 - 1);
                break;
            }
        }
        return view2;
    }

    public static String getViewText(View view) throws BadLocationException {
        Element element = view.getElement();
        Document document = element.getDocument();
        int n2 = view.getStartOffset();
        int n3 = view.getEndOffset();
        return document.getText(n2, n3 - n2);
    }
}

