/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer.text;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import jpdf.printer.text.BadRangeError;

public final class PrintTextUtility {
    protected static final FontRenderContext FONT_RENDERER_CONTEXT = new FontRenderContext(null, false, true);

    public static int calculateBreakOffset(Segment segment, GlyphVector glyphVector, int n2) {
        int n3;
        boolean bl = false;
        double d2 = 0.0;
        int n4 = glyphVector.getNumGlyphs();
        int n5 = -1;
        if (segment.count <= 1) {
            return 0;
        }
        d2 = PrintTextUtility.getLastGlyphEndX(glyphVector);
        if (d2 <= (double)n2) {
            return segment.count - 1;
        }
        for (n3 = 1; n3 < n4; ++n3) {
            d2 = glyphVector.getGlyphPosition(n3).getX();
            if (!(d2 > (double)n2)) continue;
            n5 = glyphVector.getGlyphCharIndex(n3 - 1);
            break;
        }
        if (n5 < 0) {
            n5 = segment.count - 2;
        }
        for (n3 = segment.offset + n5; n3 >= segment.offset; --n3) {
            if (segment.array[n3] != ' ' && segment.array[n3] != '\t') continue;
            n5 = n3 - segment.offset;
            bl = true;
            break;
        }
        if (!bl) {
            --n5;
        }
        return n5;
    }

    public static int calculateFitOffset(Segment segment, GlyphVector glyphVector, int n2) {
        double d2 = 0.0;
        int n3 = glyphVector.getNumGlyphs();
        int n4 = 0;
        int n5 = 0;
        if (n2 <= 0) {
            return 0;
        }
        if (n2 >= PrintTextUtility.getLastGlyphEndX(glyphVector)) {
            return segment.count;
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            d2 = glyphVector.getGlyphPosition(i2).getX();
            if (!(d2 > (double)n2)) continue;
            n4 = i2 - 1;
            break;
        }
        if ((n5 = glyphVector.getGlyphCharIndex(n4)) < segment.count - 1 && segment.array[segment.offset + n5 + 1] == '\t') {
            ++n5;
        }
        return n5;
    }

    public static int calculateTextOffsetAtX(Segment segment, GlyphVector glyphVector, int n2, boolean bl) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = glyphVector.getNumGlyphs();
        int n4 = 0;
        if (n2 <= 0) {
            return 0;
        }
        if (n2 >= PrintTextUtility.getLastGlyphEndX(glyphVector)) {
            return segment.count;
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            d2 = glyphVector.getGlyphPosition(i2).getX();
            if ((double)n2 >= d3 && (double)n2 < d2) {
                if (bl) {
                    if ((double)n2 - d3 < d2 - (double)n2) {
                        n4 = i2 - 1;
                        break;
                    }
                    n4 = i2;
                    break;
                }
                n4 = i2 - 1;
                break;
            }
            d3 = d2;
        }
        return glyphVector.getGlyphCharIndex(n4);
    }

    public static int computeStringWidth(Font font, String string) {
        GlyphVector glyphVector = font.createGlyphVector(FONT_RENDERER_CONTEXT, string);
        return PrintTextUtility.getGlyphVectorLogicalWidth(glyphVector);
    }

    public static GlyphVector createGlyphVector(Font font, String string) {
        GlyphVector glyphVector = null;
        glyphVector = font.createGlyphVector(FONT_RENDERER_CONTEXT, string);
        glyphVector.performDefaultLayout();
        return glyphVector;
    }

    public static GlyphVector createGlyphVector(Font font, Segment segment) {
        GlyphVector glyphVector = null;
        glyphVector = font.createGlyphVector(FONT_RENDERER_CONTEXT, segment);
        glyphVector.performDefaultLayout();
        return glyphVector;
    }

    public static int drawGlyphVector(GlyphVector glyphVector, int n2, int n3, Graphics graphics) {
        ((Graphics2D)graphics).drawGlyphVector(glyphVector, n2, n3);
        return n2 + PrintTextUtility.getLastGlyphEndX(glyphVector);
    }

    public static int drawSegment(Segment segment, GlyphVector glyphVector, int n2, int n3, Graphics graphics, TabExpander tabExpander, int n4) {
        Utilities.drawTabbedText(segment, n2, n3, graphics, tabExpander, n4);
        return n2 + PrintTextUtility.getLastGlyphEndX(glyphVector);
    }

    public static int getLastGlyphEndX(GlyphVector glyphVector) {
        int n2 = glyphVector.getNumGlyphs() - 1;
        int n3 = 0;
        if (n2 >= 0) {
            n3 = (int)(glyphVector.getGlyphPosition(n2).getX() + (double)glyphVector.getGlyphMetrics(n2).getAdvance() + (double)0.99f);
        }
        return n3;
    }

    public static int getGlyphVectorLogicalWidth(GlyphVector glyphVector) {
        return (int)(glyphVector.getLogicalBounds().getWidth() + (double)0.99f);
    }

    public static int getGlyphVectorVisibleWidth(GlyphVector glyphVector) {
        int n2 = (int)(glyphVector.getVisualBounds().getWidth() + (double)0.99f);
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    public static boolean isSpaceCharPresent(Segment segment, int n2) {
        int n3 = 0;
        boolean bl = false;
        if (n2 >= segment.count) {
            n2 = segment.count;
        }
        n3 = segment.offset + n2 - 1;
        for (int i2 = segment.offset; i2 <= n3; ++i2) {
            if (segment.array[i2] != ' ' && segment.array[i2] != '\t') continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static GlyphVector loadText(Segment segment, Document document, int n2, int n3, Font font, TabExpander tabExpander, int n4, GlyphVector glyphVector) {
        int n5 = n3 - n2;
        if (segment.offset != n2 || segment.count != n5) {
            try {
                document.getText(n2, n5, segment);
                glyphVector = PrintTextUtility.createGlyphVector(font, segment);
                PrintTextUtility.updateGlyphVectorPositions(segment, glyphVector, tabExpander, n4);
            }
            catch (BadLocationException badLocationException) {
                throw new BadRangeError("Can't get document text.", n2, n3);
            }
        }
        return glyphVector;
    }

    public static void shiftGlyphVectorPositions(GlyphVector glyphVector, int n2) {
        Point2D point2D = null;
        int n3 = glyphVector.getNumGlyphs();
        for (int i2 = 0; i2 < n3; ++i2) {
            point2D = glyphVector.getGlyphPosition(i2);
            point2D.setLocation(point2D.getX() + (double)n2, point2D.getY());
            glyphVector.setGlyphPosition(i2, point2D);
        }
    }

    public static void updateGlyphVectorPositions(Segment segment, GlyphVector glyphVector, TabExpander tabExpander) {
        PrintTextUtility.updateGlyphVectorPositions(segment, glyphVector, tabExpander, 0);
    }

    public static void updateGlyphVectorPositions(Segment segment, GlyphVector glyphVector, TabExpander tabExpander, int n2) {
        Point2D point2D = null;
        double d2 = 0.0;
        double d3 = 0.0;
        float f2 = 0.0f;
        int n3 = glyphVector.getNumGlyphs();
        int n4 = 0;
        int n5 = 0;
        if (tabExpander == null) {
            return;
        }
        for (int i2 = 0; i2 < segment.count; ++i2) {
            int n6;
            if (segment.array[segment.offset + i2] != '\t') continue;
            for (n6 = n4; n6 < n3; ++n6) {
                n5 = glyphVector.getGlyphCharIndex(n6);
                if (n5 != i2) continue;
                n4 = n6;
                break;
            }
            d2 = glyphVector.getGlyphPosition(n4).getX();
            f2 = tabExpander.nextTabStop((float)((double)n2 + d2), segment.offset + n5) - (float)n2;
            d3 = (double)f2 - d2;
            for (n6 = n4; n6 < n3; ++n6) {
                point2D = glyphVector.getGlyphPosition(n6);
                point2D.setLocation(point2D.getX() + d3, point2D.getY());
                glyphVector.setGlyphPosition(n6, point2D);
            }
        }
    }
}

