/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PrintTableUtility {
    private PrintTableUtility() {
    }

    public static void copyColumnOrder(JTable jTable, JTable jTable2) {
        int n2 = jTable.getColumnCount();
        int n3 = 0;
        int n4 = 0;
        if (n2 != jTable2.getColumnCount()) {
            String string = "These tables do not have equal column counts: " + n2 + " != " + jTable2.getColumnCount();
            throw new IllegalArgumentException(string);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = jTable.convertColumnIndexToModel(i2);
            n4 = jTable2.convertColumnIndexToView(n3);
            if (n4 == i2) continue;
            jTable2.moveColumn(n4, i2);
        }
    }

    public static void copyColumnWidths(JTable jTable, JTable jTable2) {
        if (jTable.getColumnCount() != jTable2.getColumnCount()) {
            String string = "These tables do not have equal column counts: " + jTable.getColumnCount() + " != " + jTable2.getColumnCount();
            throw new IllegalArgumentException(string);
        }
        PrintTableUtility.copyColumnWidths(jTable.getColumnModel(), jTable2.getColumnModel());
    }

    public static void copyColumnWidths(TableColumnModel tableColumnModel, TableColumnModel tableColumnModel2) {
        TableColumn tableColumn = null;
        int n2 = 0;
        int n3 = tableColumnModel.getColumnCount();
        if (n3 != tableColumnModel2.getColumnCount()) {
            String string = "These models do not have equal column counts: " + n3 + " != " + tableColumnModel2.getColumnCount();
            throw new IllegalArgumentException(string);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = tableColumnModel.getColumn(i2).getWidth();
            tableColumn = tableColumnModel2.getColumn(i2);
            tableColumn.setWidth(n2);
            tableColumn.setPreferredWidth(n2);
        }
    }

    public static void copyRowHeights(JTable jTable, JTable jTable2) {
        int n2 = jTable.getRowCount();
        if (n2 != jTable2.getRowCount()) {
            String string = "These tables do not have equal row counts: " + n2 + " != " + jTable2.getRowCount();
            throw new IllegalArgumentException(string);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            jTable2.setRowHeight(i2, jTable.getRowHeight(i2));
        }
    }

    public static int[] getColumnMaxWidthsInModel(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        int n3 = 0;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = jTable.convertColumnIndexToModel(i2);
            nArray[n3] = tableColumnModel.getColumn(i2).getMaxWidth();
        }
        return nArray;
    }

    public static int[] getColumnMinWidthsInModel(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        int n3 = 0;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = jTable.convertColumnIndexToModel(i2);
            nArray[n3] = tableColumnModel.getColumn(i2).getMinWidth();
        }
        return nArray;
    }

    public static int[] getColumnPreferredWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = tableColumnModel.getColumn(i2).getPreferredWidth();
        }
        return nArray;
    }

    public static int[] getColumnPreferredWidthsInModel(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        int n3 = 0;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = jTable.convertColumnIndexToModel(i2);
            nArray[n3] = tableColumnModel.getColumn(i2).getPreferredWidth();
        }
        return nArray;
    }

    public static int[] getColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = tableColumnModel.getColumn(i2).getWidth();
        }
        return nArray;
    }

    public static Component getRendererComponent(JTable jTable, int n2, int n3) {
        TableCellRenderer tableCellRenderer = null;
        TableModel tableModel = jTable.getModel();
        Component component = null;
        Object object = null;
        object = jTable.getValueAt(n2, n3);
        tableCellRenderer = jTable.getCellRenderer(n2, n3);
        component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, n2, n3);
        return component;
    }

    public static int getTallestColIndexForRow(JTable jTable, int n2) {
        Component component = null;
        int n3 = jTable.getColumnCount();
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            component = PrintTableUtility.getRendererComponent(jTable, n2, i2);
            n6 = component.getPreferredSize().height;
            if (n6 <= n5) continue;
            n4 = i2;
            n5 = n6;
        }
        return n4;
    }

    public static boolean isSingleRowHeightTable(JTable jTable) {
        boolean bl = true;
        int n2 = jTable.getRowHeight();
        int n3 = jTable.getRowCount();
        if (n3 < 25) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (jTable.getRowHeight(i2) == n2) continue;
                bl = false;
                break;
            }
        } else {
            bl = jTable.getPreferredSize().height == n2 * n3;
        }
        return bl;
    }

    public static void printColumnWidths(JTable jTable, String string) {
        int[] nArray = PrintTableUtility.getColumnWidths(jTable);
        System.out.print(string);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            System.out.print("  [" + i2 + "]: " + nArray[i2]);
        }
        System.out.println();
    }

    public static void printRowHeights(JTable jTable, String string) {
        int n2 = jTable.getRowCount();
        System.out.print(string);
        for (int i2 = 0; i2 < n2; ++i2) {
            System.out.print("  [" + i2 + "]: " + jTable.getRowHeight(i2));
        }
        System.out.println();
    }

    public static void setColumnWidths(JTable jTable, int[] nArray) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = null;
        int n2 = 0;
        int n3 = Math.min(nArray.length, tableColumnModel.getColumnCount());
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = jTable.convertColumnIndexToView(i2);
            tableColumn = tableColumnModel.getColumn(n2);
            tableColumn.setPreferredWidth(nArray[i2]);
            tableColumn.setWidth(nArray[i2]);
        }
    }

    public static void setColumnWidthsToFitData(JTable jTable, int n2, int n3, int n4) {
        int[] nArray = new int[jTable.getColumnCount()];
        Arrays.fill(nArray, n3);
        PrintTableUtility.setColumnWidthsToFitData(jTable, n2, nArray, n4);
    }

    public static void setColumnWidthsToFitData(JTable jTable, int n2, int[] nArray, int n3) {
        TableCellRenderer tableCellRenderer = null;
        TableCellRenderer tableCellRenderer2 = null;
        JTableHeader jTableHeader = jTable.getTableHeader();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableModel tableModel = jTable.getModel();
        Component component = null;
        Object object = null;
        String string = null;
        int n4 = tableColumnModel.getColumnMargin();
        int n5 = tableModel.getRowCount();
        int n6 = tableColumnModel.getColumnCount();
        if (nArray.length != n6) {
            string = "The length of the Maximum Column Width array (" + nArray.length + ") is not the same as the number of columns in the table (" + n6 + ").";
            throw new IllegalArgumentException(string);
        }
        if (jTableHeader != null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        for (int i2 = n6 - 1; i2 >= 0; --i2) {
            TableColumn tableColumn = tableColumnModel.getColumn(i2);
            int n7 = tableColumn.getModelIndex();
            int n8 = -1;
            tableCellRenderer2 = tableColumn.getHeaderRenderer();
            if (tableCellRenderer2 == null) {
                tableCellRenderer2 = tableCellRenderer;
            }
            if (tableCellRenderer2 != null) {
                component = tableCellRenderer2.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, -1, i2);
                n8 = component.getPreferredSize().width;
            }
            for (int i3 = n5 - 1; i3 >= 0; --i3) {
                object = tableModel.getValueAt(i3, n7);
                tableCellRenderer2 = jTable.getCellRenderer(i3, i2);
                component = tableCellRenderer2.getTableCellRendererComponent(jTable, object, false, false, i3, i2);
                n8 = Math.max(n8, component.getPreferredSize().width);
            }
            if (n8 < 0) continue;
            if ((n8 += n3 + n4) > nArray[i2]) {
                n8 = nArray[i2];
            } else if (n8 < n2) {
                n8 = n2;
            }
            tableColumn.setPreferredWidth(n8);
            tableColumn.setWidth(n8);
        }
    }

    public static void setRowHeightsToFitData(JTable jTable) {
        int n2 = jTable.getRowHeight();
        int n3 = jTable.getColumnCount();
        int n4 = jTable.getRowCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            PrintTableUtility.a(jTable, i2, n3, n2);
        }
        PrintTableUtility.a(jTable, 0, n3, n2);
    }

    public static void setToPreferredColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = null;
        int n2 = tableColumnModel.getColumnCount();
        jTable.setAutoResizeMode(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            tableColumn = tableColumnModel.getColumn(i2);
            tableColumn.setWidth(tableColumn.getPreferredWidth());
        }
    }

    private static void a(JTable jTable, int n2, int n3, int n4) {
        TableCellRenderer tableCellRenderer = null;
        JComponent jComponent = null;
        Dimension dimension = null;
        Object object = null;
        int n5 = 0;
        n5 = n4;
        for (int i2 = 0; i2 < n3; ++i2) {
            tableCellRenderer = jTable.getCellRenderer(n2, i2);
            object = jTable.getValueAt(n2, i2);
            jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, n2, i2);
            dimension = jComponent.getPreferredSize();
            if (dimension.height <= n5) continue;
            n5 = dimension.height;
        }
        jTable.setRowHeight(n2, n5);
    }
}

