/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.print.Printable;
import java.net.URL;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.text.JTextComponent;
import jpdf.attribute.ContentFont;
import jpdf.manage.PrintManager;
import jpdf.printable.FullyNavigablePrintable;
import jpdf.printer.AbstractArrayPrinter;
import jpdf.utility.AttributeSetFactory;
import jpdf.utility.PrintUtility;
import jpdf_common.gui.constant.FontConstant;
import jpdf_common.system.utility.FileReadUtility;
import jpdf_common.system.utility.StringUtility;

public class TextPrinter
extends AbstractArrayPrinter
implements FullyNavigablePrintable {
    private final String[] a;

    public TextPrinter(String string, Font font, String string2) {
        this(StringUtility.getLineArray(string, "  "), font, string2);
    }

    public TextPrinter(String[] stringArray, Font font, String string) {
        super(string, font);
        this.a = stringArray;
    }

    public static TextPrinter createFileTextPrinter(String string) {
        return TextPrinter.createFileTextPrinter(string, string);
    }

    public static TextPrinter createFileTextPrinter(String string, String string2) {
        TextPrinter textPrinter = null;
        String[] stringArray = null;
        try {
            stringArray = FileReadUtility.readLineArray(string);
        }
        catch (Exception exception) {
            PrintManager.handleException(exception);
        }
        if (stringArray != null) {
            textPrinter = new TextPrinter(stringArray, FontConstant.DEFAULT_FIXED_FONT.deriveFont(10.0f), string2);
            textPrinter.setMinimumOffsets(2, 0, 2, 0);
        }
        return textPrinter;
    }

    public static TextPrinter createFileTextPrinter(URL uRL, String string) {
        TextPrinter textPrinter = null;
        String[] stringArray = null;
        try {
            stringArray = FileReadUtility.readLineArray(uRL);
        }
        catch (Exception exception) {
            PrintManager.handleException(exception);
        }
        if (stringArray != null) {
            textPrinter = new TextPrinter(stringArray, FontConstant.DEFAULT_FIXED_FONT.deriveFont(10.0f), string);
            textPrinter.setMinimumOffsets(2, 0, 2, 0);
        }
        return textPrinter;
    }

    public static void printComponentText(JTextComponent jTextComponent, String string) {
        TextPrinter.printComponentText(jTextComponent, string, 1.0f);
    }

    public static void printComponentText(JTextComponent jTextComponent, String string, float f2) {
        PrintRequestAttributeSet printRequestAttributeSet = null;
        TextPrinter textPrinter = null;
        Font font = jTextComponent.getFont();
        float f3 = 0.0f;
        printRequestAttributeSet = AttributeSetFactory.buildFromDefaultAttributeSet(true);
        if (f2 != 1.0f) {
            f3 = (float)font.getSize() * f2;
            font = font.deriveFont(f3);
        }
        textPrinter = new TextPrinter(jTextComponent.getText(), font, string);
        PrintManager.printPrintable((Printable)textPrinter, printRequestAttributeSet);
    }

    public static void printFileText(String string) {
        PrintRequestAttributeSet printRequestAttributeSet = null;
        TextPrinter textPrinter = TextPrinter.createFileTextPrinter(string);
        if (textPrinter != null) {
            printRequestAttributeSet = AttributeSetFactory.buildFromDefaultAttributeSet(true);
            PrintUtility.updateAttributeSet(true, 0.5f, 0.5f, 0.3f, 0.3f, (AttributeSet)printRequestAttributeSet, false);
            PrintManager.printPrintable((Printable)textPrinter, printRequestAttributeSet);
        }
    }

    protected boolean isMorePrintDataAvailable(int n2) {
        if (n2 <= this.PRINTED_PAGE_INFO.getPrintedPageIndex()) {
            return true;
        }
        return this.a.length > this.PRINTED_PAGE_INFO.getNextPrintArrayIndex(n2);
    }

    protected void printArrayPage(Graphics2D graphics2D, int n2, AttributeSet attributeSet) {
        FontMetrics fontMetrics = null;
        Font font = null;
        int n3 = 0;
        font = ContentFont.getFont(attributeSet, this.DEFAULT_CONTENT_FONT);
        fontMetrics = graphics2D.getFontMetrics(font);
        n3 = fontMetrics.getMaxAscent() + 2;
        this.printArrayPage(graphics2D, n2, 3, n3, font, this.a, this.PRINTED_PAGE_INFO.getNextPrintArrayIndex(n2));
    }
}

