/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import jpdf.ability.CloneableViewTextArea;
import jpdf.printer.AbstractTextComponentPrinter;
import jpdf.printer.swing.PrintTextComponentUtility;
import jpdf.printer.text.PrintTextAreaUI;

public class TextAreaPrinter
extends AbstractTextComponentPrinter {
    public static final String NO_FIT_WIDTH_SCALE_PROPERTY_KEY = "JPDF_NoFitWidthScale";
    private boolean A = true;
    static Class H;

    public TextAreaPrinter(JTextArea jTextArea, String string) {
        this(jTextArea, TextAreaPrinter.cloneTextAreaView(jTextArea), string);
    }

    public TextAreaPrinter(JTextArea jTextArea, JTextArea jTextArea2, String string) {
        super(jTextArea2, string);
        this.configureCloneForPrinting(jTextArea, jTextArea2);
        this.a(jTextArea2.getSize());
        Object object = jTextArea.getClientProperty(NO_FIT_WIDTH_SCALE_PROPERTY_KEY);
        if (object == Boolean.TRUE) {
            this.setFitWidthScalingAllowed(false);
        }
    }

    public TextAreaPrinter(JTextArea jTextArea, String string, boolean bl, boolean bl2) {
        super(bl ? TextAreaPrinter.cloneTextAreaView(jTextArea) : jTextArea, string);
        if (bl) {
            this.configureCloneForPrinting(jTextArea, (JTextArea)this.TARGET_COMPONENT);
            this.a(this.TARGET_COMPONENT.getSize());
        } else if (bl2) {
            TextAreaPrinter.configureForPrinting(jTextArea);
            this.a(jTextArea.getSize());
        }
        Object object = jTextArea.getClientProperty(NO_FIT_WIDTH_SCALE_PROPERTY_KEY);
        if (object == Boolean.TRUE) {
            this.setFitWidthScalingAllowed(false);
        }
    }

    public static JTextArea cloneTextAreaView(JTextArea jTextArea) {
        JTextArea jTextArea2 = null;
        if (jTextArea instanceof CloneableViewTextArea) {
            jTextArea2 = ((CloneableViewTextArea)((Object)jTextArea)).cloneView();
        } else {
            jTextArea2 = TextAreaPrinter.a(jTextArea);
            TextAreaPrinter.setTextAreaCloneProperties(jTextArea, jTextArea2);
        }
        jTextArea2.setSize(jTextArea.getSize());
        jTextArea2.setSelectionEnd(jTextArea.getSelectionEnd());
        jTextArea2.setSelectionStart(jTextArea.getSelectionStart());
        return jTextArea2;
    }

    public static void configureForPrinting(JTextArea jTextArea) {
        TextAreaPrinter.a(jTextArea, jTextArea.getSelectionStart(), jTextArea.getSelectionEnd());
    }

    public static TextAreaPrinter createInstanceForFile(File file, String string, Font font, Border border, Color color, Color color2) throws IOException {
        TextAreaPrinter textAreaPrinter = null;
        JTextArea jTextArea = new JTextArea();
        if (font != null) {
            jTextArea.setFont(font);
        }
        if (border != null) {
            jTextArea.setBorder(border);
        }
        if (color != null) {
            jTextArea.setForeground(color);
        }
        if (color2 != null) {
            jTextArea.setBackground(color2);
        }
        jTextArea.read(new FileReader(file), null);
        textAreaPrinter = new TextAreaPrinter(jTextArea, string, false, true);
        return textAreaPrinter;
    }

    public int getFitScalingSupportCode() {
        if (this.isFitWidthScalingAllowed()) {
            return 2;
        }
        return 0;
    }

    public boolean isFitWidthScalingAllowed() {
        return this.A && TextAreaPrinter.b(this.g());
    }

    public static boolean isFitWidthScalingAllowed(JTextArea jTextArea) {
        return TextAreaPrinter.b(jTextArea.getPreferredSize());
    }

    public void setFitWidthScalingAllowed(boolean bl) {
        this.A = bl;
    }

    public static void setTextAreaCloneProperties(JTextArea jTextArea, JTextArea jTextArea2) {
        jTextArea2.setLineWrap(jTextArea.getLineWrap());
        jTextArea2.setWrapStyleWord(jTextArea.getWrapStyleWord());
        TextAreaPrinter.setTextComponentCloneProperties(jTextArea, jTextArea2);
    }

    protected void configureCloneForPrinting(JTextArea jTextArea, JTextArea jTextArea2) {
        TextUI textUI = jTextArea2.getUI();
        EditorKit editorKit = textUI.getEditorKit(jTextArea2);
        if (jTextArea.getDocument() == jTextArea2.getDocument()) {
            jTextArea2.setDocument(editorKit.createDefaultDocument());
            jTextArea2.setText(jTextArea.getText());
        }
        TextAreaPrinter.a(jTextArea2, jTextArea.getSelectionStart(), jTextArea.getSelectionEnd());
    }

    private static void a(JTextArea jTextArea, int n2, int n3) {
        Dimension dimension = null;
        TextUI textUI = jTextArea.getUI();
        boolean bl = false;
        if (!(textUI instanceof PrintTextAreaUI)) {
            bl = jTextArea.isOpaque();
            jTextArea.setUI(new PrintTextAreaUI(TextAreaPrinter.isToUseGlyphDrawing()));
            jTextArea.setSelectionEnd(n3);
            jTextArea.setSelectionStart(n2);
            jTextArea.setOpaque(bl);
        }
        try {
            dimension = new Dimension(0, 100876);
            dimension.width = PrintTextComponentUtility.computeRequiredWidth(jTextArea);
            jTextArea.setSize(dimension);
            dimension = jTextArea.getPreferredSize();
            jTextArea.setPreferredSize(dimension);
            jTextArea.setSize(dimension);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        jTextArea.setDoubleBuffered(false);
    }

    private static JTextArea a(JTextArea jTextArea) {
        Constructor<?> constructor = null;
        JTextArea jTextArea2 = null;
        Object[] objectArray = null;
        Class[] classArray = null;
        try {
            classArray = new Class[]{H == null ? (H = TextAreaPrinter.class$("javax.swing.text.Document")) : H};
            constructor = jTextArea.getClass().getConstructor(classArray);
            objectArray = new Object[]{jTextArea.getDocument()};
            jTextArea2 = (JTextArea)constructor.newInstance(objectArray);
            return jTextArea2;
        }
        catch (Exception exception) {
            try {
                classArray = new Class[]{};
                constructor = jTextArea.getClass().getConstructor(classArray);
                objectArray = new Object[]{};
                jTextArea2 = (JTextArea)constructor.newInstance(objectArray);
                jTextArea2.setDocument(jTextArea.getDocument());
                return jTextArea2;
            }
            catch (Exception exception2) {
                jTextArea2 = new JTextArea();
                jTextArea2.setDocument(jTextArea.getDocument());
                return jTextArea2;
            }
        }
    }

    private static boolean b(Dimension dimension) {
        return dimension.width <= 1440;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

