/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer;

import java.awt.Component;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import jpdf.ability.CloneableViewComponent;
import jpdf.printer.AbstractComponentPrinter;
import jpdf.printer.AbstractTextComponentPrinter;
import jpdf.printer.CloneableGenericComponentPrinter;
import jpdf.printer.EditorPanePrinter;
import jpdf.printer.GenericComponentPrinter;
import jpdf.printer.TableComponentPrinter;
import jpdf.printer.TextAreaPrinter;
import jpdf.printer.TextPanePrinter;
import jpdf.printer.TreeComponentPrinter;
import jpdf.printer.UnscalableEditorPanePrinter;
import jpdf.printer.UnscalableGenericComponentPrinter;
import jpdf.printer.UnscalableTableComponentPrinter;
import jpdf.printer.UnscalableTextAreaPrinter;
import jpdf.printer.UnscalableTextPanePrinter;
import jpdf.printer.UnscalableTreeComponentPrinter;

public class PrinterFactory {
    private static boolean a = true;

    private PrinterFactory() {
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component) {
        return PrinterFactory.buildComponentPrinter(component, AbstractComponentPrinter.getTitleForComponent(component), GenericComponentPrinter.getDefaultPrintMode());
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, PrintRequestAttributeSet printRequestAttributeSet) {
        return PrinterFactory.buildComponentPrinter(component, AbstractComponentPrinter.getTitleForComponent(component), GenericComponentPrinter.getDefaultPrintMode(), printRequestAttributeSet);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, String string) {
        return PrinterFactory.buildComponentPrinter(component, string, GenericComponentPrinter.getDefaultPrintMode());
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, String string, PrintRequestAttributeSet printRequestAttributeSet) {
        return PrinterFactory.buildComponentPrinter(component, string, GenericComponentPrinter.getDefaultPrintMode(), printRequestAttributeSet);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, int n2) {
        return PrinterFactory.buildComponentPrinter(component, AbstractComponentPrinter.getTitleForComponent(component), n2);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, int n2, PrintRequestAttributeSet printRequestAttributeSet) {
        return PrinterFactory.buildComponentPrinter(component, AbstractComponentPrinter.getTitleForComponent(component), n2, printRequestAttributeSet);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, String string, int n2, PrintRequestAttributeSet printRequestAttributeSet) {
        AbstractComponentPrinter abstractComponentPrinter = null;
        abstractComponentPrinter = PrinterFactory.buildComponentPrinter(component, string, n2);
        abstractComponentPrinter.setAttributeSet(printRequestAttributeSet);
        return abstractComponentPrinter;
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, String string, int n2) {
        AbstractComponentPrinter abstractComponentPrinter = null;
        boolean bl = PrinterFactory.isToBuildScalingPrinters();
        abstractComponentPrinter = component instanceof JTable ? (bl ? new TableComponentPrinter((JTable)component, string) : new UnscalableTableComponentPrinter((JTable)component, string)) : (component instanceof JTree ? (bl ? new TreeComponentPrinter((JTree)component, string) : new UnscalableTreeComponentPrinter((JTree)component, string)) : (component instanceof JTextArea ? (bl ? new TextAreaPrinter((JTextArea)component, string) : new UnscalableTextAreaPrinter((JTextArea)component, string)) : (component instanceof JTextPane ? (bl ? new TextPanePrinter((JTextPane)component, string) : new UnscalableTextPanePrinter((JTextPane)component, string)) : (component instanceof JEditorPane ? (bl ? new EditorPanePrinter((JEditorPane)component, string) : new UnscalableEditorPanePrinter((JEditorPane)component, string)) : (bl ? (component instanceof CloneableViewComponent && component instanceof JComponent ? new CloneableGenericComponentPrinter((JComponent)component, string, n2, true, true) : new GenericComponentPrinter(component, string, n2)) : new UnscalableGenericComponentPrinter(component, string, n2))))));
        return abstractComponentPrinter;
    }

    public static AbstractTextComponentPrinter buildTextComponentPrinter(JTextComponent jTextComponent, String string, PrintRequestAttributeSet printRequestAttributeSet) {
        AbstractTextComponentPrinter abstractTextComponentPrinter = null;
        boolean bl = PrinterFactory.isToBuildScalingPrinters();
        if (jTextComponent instanceof JTextArea) {
            abstractTextComponentPrinter = bl ? new TextAreaPrinter((JTextArea)jTextComponent, string) : new UnscalableTextAreaPrinter((JTextArea)jTextComponent, string);
        } else if (jTextComponent instanceof JTextPane) {
            abstractTextComponentPrinter = bl ? new TextPanePrinter((JTextPane)jTextComponent, string) : new UnscalableTextPanePrinter((JTextPane)jTextComponent, string);
        } else if (jTextComponent instanceof JEditorPane) {
            abstractTextComponentPrinter = bl ? new EditorPanePrinter((JEditorPane)jTextComponent, string) : new UnscalableEditorPanePrinter((JEditorPane)jTextComponent, string);
        } else {
            String string2 = "The component for which a Printer is to be built must be a direct or indirect instance of either JTextArea or JEditorPane.\n Illegal text component class: " + jTextComponent.getClass().getName();
            throw new IllegalArgumentException(string2);
        }
        abstractTextComponentPrinter.setAttributeSet(printRequestAttributeSet);
        return abstractTextComponentPrinter;
    }

    public static AbstractTextComponentPrinter buildTextComponentPrinter(JTextComponent jTextComponent, JTextComponent jTextComponent2, String string, PrintRequestAttributeSet printRequestAttributeSet) {
        AbstractTextComponentPrinter abstractTextComponentPrinter = null;
        String string2 = null;
        boolean bl = PrinterFactory.isToBuildScalingPrinters();
        if (jTextComponent.getClass() != jTextComponent2.getClass()) {
            string2 = "The component and clone to be used by the Printer to be built must be of the same class.\n Component Class: " + jTextComponent.getClass().getName() + "\nClone Class: " + jTextComponent2.getClass().getName();
            throw new IllegalArgumentException(string2);
        }
        if (jTextComponent instanceof JTextArea) {
            abstractTextComponentPrinter = bl ? new TextAreaPrinter((JTextArea)jTextComponent, (JTextArea)jTextComponent2, string) : new UnscalableTextAreaPrinter((JTextArea)jTextComponent, (JTextArea)jTextComponent2, string);
        } else if (jTextComponent instanceof JTextPane) {
            abstractTextComponentPrinter = bl ? new TextPanePrinter((JTextPane)jTextComponent, (JTextPane)jTextComponent2, string) : new UnscalableTextPanePrinter((JTextPane)jTextComponent, (JTextPane)jTextComponent2, string);
        } else if (jTextComponent instanceof JEditorPane) {
            abstractTextComponentPrinter = bl ? new EditorPanePrinter((JEditorPane)jTextComponent, (JEditorPane)jTextComponent2, string) : new UnscalableEditorPanePrinter((JEditorPane)jTextComponent, (JEditorPane)jTextComponent2, string);
        } else {
            string2 = "The component for which a Printer is to be built must be a direct or indirect instance of either JTextArea or JEditorPane.\n Illegal text component class: " + jTextComponent.getClass().getName();
            throw new IllegalArgumentException(string2);
        }
        abstractTextComponentPrinter.setAttributeSet(printRequestAttributeSet);
        return abstractTextComponentPrinter;
    }

    public static boolean isToBuildScalingPrinters() {
        return a;
    }

    public static void setToBuildScalingPrinters(boolean bl) {
        a = bl;
    }
}

