/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import jpdf.manage.PrintManager;
import jpdf.printer.AbstractPrinter;
import jpdf.utility.PrintUtility;

public class PrintablePrinter
extends AbstractPrinter {
    private final Printable a;

    public PrintablePrinter(Printable printable, String string) {
        super(string);
        if (printable instanceof AbstractPrinter) {
            String string2 = "A PrintablePrinter cannot be used to print an AbstractPrinter.";
            throw new IllegalArgumentException(string2);
        }
        this.a = printable;
    }

    public PrintablePrinter(Printable printable, String string, AttributeSet attributeSet) {
        super(string, attributeSet);
        if (printable instanceof AbstractPrinter) {
            String string2 = "A PrintablePrinter cannot be used to print an AbstractPrinter.";
            throw new IllegalArgumentException(string2);
        }
        this.a = printable;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        PrintRequestAttributeSet printRequestAttributeSet = this.getAttributeSet();
        Rectangle rectangle = null;
        Paper paper = pageFormat.getPaper();
        int n3 = 0;
        if (PrintManager.isPrintJobCancelled()) {
            return 1;
        }
        this.prepareForPrinting(pageFormat, printRequestAttributeSet);
        this.printPageDecorations(graphics2D, pageFormat, n2, this.getDisplayPageCount(), 1.0f);
        rectangle = graphics2D.getClipBounds();
        ++rectangle.x;
        ++rectangle.y;
        rectangle.width -= 2;
        rectangle.height -= 2;
        PrintUtility.updatePageFormat(rectangle, pageFormat);
        try {
            n3 = this.a.print(graphics, pageFormat, n2);
        }
        catch (PrinterException printerException) {
            PrintManager.handleException(printerException);
            n3 = 1;
        }
        pageFormat.setPaper(paper);
        return n3;
    }
}

