/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer;

import java.util.Arrays;
import javax.swing.JTable;
import jpdf.printer.TableColumnResizer;
import jpdf.printer.swing.PrintTableUtility;

public class DefaultTableColumnResizer
implements TableColumnResizer {
    private final int c = -99;
    private final int a = -88;
    private final float[] d;
    private final int b;

    public DefaultTableColumnResizer() {
        this.d = null;
        this.b = -99;
    }

    public DefaultTableColumnResizer(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The Column Index cannot be less than zero.");
        }
        this.d = null;
        this.b = n2;
    }

    public DefaultTableColumnResizer(float[] fArray) {
        DefaultTableColumnResizer.validateResizeWeights(fArray);
        this.d = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.d[i2] = fArray[i2];
        }
        this.b = -88;
    }

    public boolean sizeColumnsToFitWidth(JTable jTable, int n2) {
        int n3;
        float f2 = 1.0f;
        boolean bl = false;
        float[] fArray = null;
        int[] nArray = null;
        int n4 = jTable.getWidth();
        int n5 = jTable.getColumnCount();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n6 = n2 - n4;
        if (n6 == 0) {
            return false;
        }
        fArray = this.a(n5);
        nArray = PrintTableUtility.getColumnPreferredWidthsInModel(jTable);
        for (n3 = 0; n3 < n5; ++n3) {
            n8 = (int)((float)n6 * fArray[n3]);
            int n10 = n3;
            nArray[n10] = nArray[n10] + n8;
            n9 += nArray[n3];
        }
        n6 = n2 - n9;
        if (n6 >= 0) {
            n7 = 1;
        } else {
            n7 = -1;
            n6 = -n6;
        }
        if (n6 > n5) {
            n6 = n5;
        }
        n3 = 0;
        while (n3 < n6) {
            int n11 = n3++;
            nArray[n11] = nArray[n11] + n7;
        }
        PrintTableUtility.setColumnWidths(jTable, nArray);
        return true;
    }

    public static void validateResizeWeights(float[] fArray) {
        String string = null;
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (fArray[i2] < 0.0f || fArray[i2] > 1.0f) {
                string = "The Column Resize Weights must be between 0.0 and 1.0.  Invalid weight: " + fArray[i2];
                throw new IllegalArgumentException(string);
            }
            f2 += fArray[i2];
        }
        if ((double)f2 <= 0.995 || (double)f2 >= 1.005) {
            string = "The sum of the Column Resize Weights must equal 1.0.  Invalid weight sum: " + f2;
            throw new IllegalArgumentException(string);
        }
    }

    private float[] a(int n2) {
        float[] fArray = null;
        int n3 = 0;
        if (this.b == -88) {
            if (this.d.length == n2) {
                fArray = this.d;
            } else {
                fArray = new float[n2];
                Arrays.fill(fArray, 1.0f / (float)n2);
            }
        } else if (this.b >= 0) {
            n3 = this.b;
            if (n3 >= n2) {
                n3 = n2 - 1;
            }
            fArray = new float[n2];
            Arrays.fill(fArray, 0.0f);
            fArray[n3] = 1.0f;
        } else {
            fArray = new float[n2];
            Arrays.fill(fArray, 1.0f / (float)n2);
        }
        return fArray;
    }
}

