/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer;

import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JComponent;
import jpdf.pageable.AbstractAttributeSetListPageable;
import jpdf.printer.AbstractComponentPrinter;
import jpdf.printer.ComponentPrinterBuilder;
import jpdf.printer.DefaultComponentPrinterBuilder;
import jpdf.utility.PrintUtility;

public class ComponentListPageable
extends AbstractAttributeSetListPageable {
    protected final AbstractComponentPrinter[] PRINTER_LIST;
    protected final PageFormat[] PAGE_FORMAT_LIST;
    private int c = 0;

    public ComponentListPageable(JComponent[] jComponentArray, String string, PrintRequestAttributeSet printRequestAttributeSet) {
        this(jComponentArray, ComponentListPageable.buildTitleList(string, jComponentArray.length), printRequestAttributeSet);
    }

    public ComponentListPageable(JComponent[] jComponentArray, String[] stringArray, PrintRequestAttributeSet printRequestAttributeSet) {
        this(jComponentArray, stringArray, ComponentListPageable.buildAttributeSetList(printRequestAttributeSet, jComponentArray.length), new DefaultComponentPrinterBuilder());
        this.setPrintAttributeSet(printRequestAttributeSet);
    }

    public ComponentListPageable(JComponent[] jComponentArray, String[] stringArray, PrintRequestAttributeSet[] printRequestAttributeSetArray) {
        this(jComponentArray, stringArray, printRequestAttributeSetArray, new DefaultComponentPrinterBuilder());
    }

    public ComponentListPageable(JComponent[] jComponentArray, String[] stringArray, PrintRequestAttributeSet[] printRequestAttributeSetArray, ComponentPrinterBuilder componentPrinterBuilder) {
        super(null);
        if (jComponentArray == null) {
            String string = "The Component List cannot be null.";
            throw new IllegalArgumentException(string);
        }
        if (jComponentArray.length <= 1) {
            String string = "The Component List must contain at least two elements.";
            throw new IllegalArgumentException(string);
        }
        if (stringArray == null) {
            String string = "The Title List cannot be null.";
            throw new IllegalArgumentException(string);
        }
        if (stringArray.length != jComponentArray.length) {
            String string = "The Title List must have the same length as the Component List.";
            throw new IllegalArgumentException(string);
        }
        if (printRequestAttributeSetArray == null) {
            String string = "The Attribute Set List cannot be null.";
            throw new IllegalArgumentException(string);
        }
        if (printRequestAttributeSetArray.length != jComponentArray.length) {
            String string = "The Attribute Set List must have the same length as the Component List.";
            throw new IllegalArgumentException(string);
        }
        if (componentPrinterBuilder == null) {
            String string = "The Component Printer Builder cannot be null.";
            throw new IllegalArgumentException(string);
        }
        this.PRINTER_LIST = this.a(jComponentArray, stringArray, componentPrinterBuilder);
        this.PAGE_FORMAT_LIST = ComponentListPageable.buildPageFormatList(this.PRINTER_LIST.length);
        this.a(this.PRINTER_LIST, printRequestAttributeSetArray, this.PAGE_FORMAT_LIST);
        this.a();
        this.setTitle(stringArray[0]);
    }

    public int getNumberOfPages() {
        return this.c;
    }

    public PrintRequestAttributeSet getPageAttributeSet(int n2) {
        int n3 = this.c(n2);
        return this.PRINTER_LIST[n3].getAttributeSet();
    }

    public PageFormat getPageFormat(int n2) throws IndexOutOfBoundsException {
        return this.PAGE_FORMAT_LIST[this.c(n2)];
    }

    public Printable getPrintable(int n2) {
        int n3 = this.c(n2);
        return this.PRINTER_LIST[n3];
    }

    public void updatedPageAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        for (int i2 = 0; i2 < this.PRINTER_LIST.length; ++i2) {
            if (this.PRINTER_LIST[i2].getAttributeSet() != printRequestAttributeSet) continue;
            PrintUtility.updatePageFormat(printRequestAttributeSet, this.PAGE_FORMAT_LIST[i2]);
            this.b(i2);
        }
    }

    private AbstractComponentPrinter[] a(JComponent[] jComponentArray, String[] stringArray, ComponentPrinterBuilder componentPrinterBuilder) {
        AbstractComponentPrinter[] abstractComponentPrinterArray = null;
        abstractComponentPrinterArray = new AbstractComponentPrinter[jComponentArray.length];
        for (int i2 = 0; i2 < jComponentArray.length; ++i2) {
            abstractComponentPrinterArray[i2] = jComponentArray[i2] instanceof ComponentPrinterBuilder ? ((ComponentPrinterBuilder)((Object)jComponentArray[i2])).buildComponentPrinter(jComponentArray[i2], stringArray[i2]) : componentPrinterBuilder.buildComponentPrinter(jComponentArray[i2], stringArray[i2]);
        }
        return abstractComponentPrinterArray;
    }

    private int a() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.PRINTER_LIST.length; ++i2) {
            n2 += this.PRINTER_LIST[i2].computePageCount(this.PAGE_FORMAT_LIST[i2]);
        }
        this.a(n2);
        return n2;
    }

    private int c(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.PRINTER_LIST.length; ++i2) {
            if ((n3 += this.PRINTER_LIST[i2].getPageCount()) <= n2) continue;
            return i2;
        }
        throw new IndexOutOfBoundsException("Invalid Page Index: " + n2);
    }

    private void a(AbstractComponentPrinter[] abstractComponentPrinterArray, PrintRequestAttributeSet[] printRequestAttributeSetArray, PageFormat[] pageFormatArray) {
        for (int i2 = 0; i2 < abstractComponentPrinterArray.length; ++i2) {
            abstractComponentPrinterArray[i2].setAttributeSet(printRequestAttributeSetArray[i2]);
            PrintUtility.updatePageFormat(printRequestAttributeSetArray[i2], pageFormatArray[i2]);
        }
    }

    private void a(int n2) {
        int n3;
        this.c = n2;
        for (n3 = 0; n3 < this.PRINTER_LIST.length; ++n3) {
            this.PRINTER_LIST[n3].setDisplayPageCount(n2);
        }
        n2 = 0;
        for (n3 = 1; n3 < this.PRINTER_LIST.length; ++n3) {
            this.PRINTER_LIST[n3].f(-(n2 += this.PRINTER_LIST[n3 - 1].getPageCount()));
        }
    }

    private int b(int n2) {
        int n3 = 0;
        this.PRINTER_LIST[n2].computePageCount(this.PAGE_FORMAT_LIST[n2]);
        for (int i2 = 0; i2 < this.PRINTER_LIST.length; ++i2) {
            n3 += this.PRINTER_LIST[i2].getPageCount();
        }
        this.a(n3);
        return n3;
    }
}

