/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.Date;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import jpdf.ability.PrintTimeUpdateable;
import jpdf.ability.Titled;
import jpdf.attribute.AlignmentFactorHorizontal;
import jpdf.attribute.AlignmentFactorVertical;
import jpdf.attribute.ContentFrame;
import jpdf.attribute.HeaderFooterDateFormat;
import jpdf.attribute.HeaderFooterTimeFormat;
import jpdf.attribute.PageContentFrame;
import jpdf.diagnostics.JpdfNotEnoughPageSpaceException;
import jpdf.manage.PrintJobAdministrator;
import jpdf.manage.PrintManager;
import jpdf.manage.PrintParameterHolder;
import jpdf.printable.AttributeSetPrintable;
import jpdf.printable.ValidatingPrintable;
import jpdf.printer.PrintCustomizer;
import jpdf.printer.swing.PrintSwingUtility;
import jpdf.utility.PageDecorationUtility;
import jpdf.wrap.NoDrawGraphics2DWrapper;
import jpdf_common.system.constant.SystemConstant;

public abstract class AbstractPrinter
implements AttributeSetPrintable,
ValidatingPrintable,
PrintTimeUpdateable,
Titled {
    public static final boolean RUNNING_VM_1_4 = SystemConstant.RUNNING_VM_1_4;
    public static final int UNKNOWN_PAGE_COUNT = -1;
    public static final String NAME_MARKER = "[-N-]";
    private static boolean d = false;
    protected final PrintParameterHolder PRINT_PARAM_HOLDER;
    protected final PageDecorationUtility.DecorationOptions DECORATION_OPTIONS = new PageDecorationUtility.DecorationOptions();
    private PrintRequestAttributeSet n = null;
    private PrintCustomizer k = null;
    private boolean o = false;
    private boolean u = false;
    private boolean q = false;
    private boolean h = true;
    private boolean y = false;
    private int i = 0;
    private int r = -1;
    static Class c;

    public AbstractPrinter(String string) {
        this(string, PrintManager.getDefaultPrintAttributes());
    }

    public AbstractPrinter(String string, AttributeSet attributeSet) {
        this.PRINT_PARAM_HOLDER = this.createPrintParameterHolder();
        if (attributeSet != null && !(attributeSet instanceof PrintRequestAttributeSet)) {
            String string2 = "The Attribute Set must be an instance of javax.print.attribute.PrintRequestAttributeSet.";
            throw new IllegalArgumentException(string2);
        }
        this.PRINT_PARAM_HOLDER.date = new Date();
        this.PRINT_PARAM_HOLDER.title = string == null ? "" : string;
        this.setAttributeSet((PrintRequestAttributeSet)attributeSet);
    }

    public static void drawPoint(Graphics2D graphics2D, Point point) {
        graphics2D.fillRect(point.x - 2, point.y - 2, 5, 5);
    }

    public static void drawShapes(Graphics2D graphics2D, Shape[] shapeArray) {
        if (shapeArray == null) {
            return;
        }
        for (int i2 = 0; i2 < shapeArray.length; ++i2) {
            if (shapeArray[i2] == null) continue;
            graphics2D.draw(shapeArray[i2]);
        }
    }

    public PrintRequestAttributeSet getAttributeSet() {
        return this.n;
    }

    public int getDisplayPageCount() {
        if (this.r == -1) {
            return this.getPageCount();
        }
        return this.r;
    }

    public int getDisplayPageNumberOffset() {
        return this.i;
    }

    public int getPageCount() {
        return -1;
    }

    public PrintCustomizer getPrintCustomizer() {
        return this.k;
    }

    public String getTitle() {
        return this.PRINT_PARAM_HOLDER.title;
    }

    public static boolean isToDebugPrinting() {
        return d;
    }

    public boolean isToPrintWithImage() {
        return this.o;
    }

    public static String replaceNameMarker(String string, String string2) {
        return PrintParameterHolder.replaceAll(string, NAME_MARKER, string2);
    }

    public void setAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        this.n = printRequestAttributeSet;
    }

    public void setDisplayPageCount(int n2) {
        this.r = n2;
    }

    public void setDisplayPageNumberOffset(int n2) {
        this.i = n2;
    }

    public void setMinimumOffsets(int n2) {
        this.DECORATION_OPTIONS.minimumOffsets.top = n2;
        this.DECORATION_OPTIONS.minimumOffsets.left = n2;
        this.DECORATION_OPTIONS.minimumOffsets.bottom = n2;
        this.DECORATION_OPTIONS.minimumOffsets.right = n2;
    }

    public void setMinimumOffsets(int n2, int n3, int n4, int n5) {
        this.DECORATION_OPTIONS.minimumOffsets.top = n2;
        this.DECORATION_OPTIONS.minimumOffsets.left = n3;
        this.DECORATION_OPTIONS.minimumOffsets.bottom = n4;
        this.DECORATION_OPTIONS.minimumOffsets.right = n5;
    }

    public void setPrintCustomizer(PrintCustomizer printCustomizer) {
        this.k = printCustomizer;
    }

    public static void setToDebugPrinting(boolean bl) {
        d = bl;
    }

    public void setToPrintWithImage(boolean bl) {
        this.o = bl;
    }

    public void updatePrintTime() {
        this.PRINT_PARAM_HOLDER.date = new Date();
    }

    public void updatePrintTime(Date date) {
        this.PRINT_PARAM_HOLDER.date = date;
    }

    public void validate(PageFormat pageFormat) throws Exception {
        Dimension dimension = null;
        int n2 = 100;
        if (pageFormat.getWidth() < 200.0 || pageFormat.getHeight() < 200.0) {
            n2 = 32;
        }
        if (pageFormat.getImageableWidth() < (double)n2 || pageFormat.getImageableHeight() < (double)n2) {
            throw new JpdfNotEnoughPageSpaceException();
        }
        this.PRINT_PARAM_HOLDER.pageNo = 1;
        dimension = PageDecorationUtility.computeAvailablePageSpace(pageFormat, this.getAttributeSet(), this.DECORATION_OPTIONS, this.PRINT_PARAM_HOLDER);
        if (dimension.width < n2 || dimension.height < n2) {
            throw new JpdfNotEnoughPageSpaceException();
        }
    }

    protected static Point computeAlignedContentStartPoint(Graphics2D graphics2D, int n2, int n3, AttributeSet attributeSet, float f2) {
        Rectangle rectangle = null;
        Point point = new Point();
        float f3 = 0.0f;
        float f4 = 0.0f;
        rectangle = graphics2D.getClipBounds();
        f3 = AlignmentFactorHorizontal.getAlignmentFactor(attributeSet);
        point.x = f3 > 0.0f ? rectangle.x + (int)((float)(rectangle.width - n2) * f3) : (f2 >= 1.0f ? rectangle.x + 3 : rectangle.x + (int)(3.0f / f2));
        f4 = AlignmentFactorVertical.getAlignmentFactor(attributeSet);
        point.y = f4 > 0.0f ? rectangle.y + (int)((float)(rectangle.height - n3) * f4) : (f2 >= 1.0f ? rectangle.y + 3 : rectangle.y + (int)(3.0f / f2));
        return point;
    }

    protected int computeTotalAvailableHeight(PageFormat pageFormat, AttributeSet attributeSet, int n2, int n3) {
        int n4 = 0;
        int n5 = this.getDisplayPageNumberOffset();
        n3 += n5;
        int n6 = n2 += n5;
        while (n6 <= n3) {
            this.PRINT_PARAM_HOLDER.pageNo = n6++;
            n4 += PageDecorationUtility.computeAvailablePageHeight(pageFormat, attributeSet, this.DECORATION_OPTIONS, this.PRINT_PARAM_HOLDER);
        }
        return n4;
    }

    protected PrintParameterHolder createPrintParameterHolder() {
        return new PrintParameterHolder();
    }

    protected void drawContentFrame(Graphics2D graphics2D, Color color, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = graphics2D.getClipBounds();
        --rectangle.x;
        --rectangle.y;
        rectangle.width += 2;
        rectangle.height += 2;
        graphics2D.setClip(rectangle);
        graphics2D.setColor(color);
        graphics2D.drawRect(n2, n3, n4, n5);
    }

    protected static int[] expandOffsetArray(int[] nArray, int n2) {
        int[] nArray2 = new int[nArray.length + n2];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[i2];
        }
        return nArray2;
    }

    protected static int[] expandOffsetArray(int[] nArray, float f2) {
        int[] nArray2 = null;
        int n2 = 0;
        if (f2 > 2.0f) {
            f2 = 2.0f;
        } else if (f2 < 1.2f) {
            f2 = 1.2f;
        }
        n2 = (int)((float)nArray.length * f2);
        if (n2 - nArray.length < 4) {
            n2 = nArray.length + 4;
        }
        nArray2 = new int[n2];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[i2];
        }
        return nArray2;
    }

    protected boolean isToPrintContentFrame() {
        return this.u;
    }

    protected boolean isToPrintPageContentFrame() {
        return this.q;
    }

    protected boolean isToPrintPageDecorations() {
        return this.h;
    }

    protected static boolean isTransparentImageGraphics(Graphics graphics) {
        return graphics.getClass() == (c == null ? (c = AbstractPrinter.class$("sun.print.ProxyGraphics2D")) : c);
    }

    protected void prepareForPrinting(PageFormat pageFormat, AttributeSet attributeSet) {
        this.setToPrintContentFrame(ContentFrame.isToPrintFrame(attributeSet));
        this.setToPrintPageContentFrame(PageContentFrame.isToPrintFrame(attributeSet));
        this.PRINT_PARAM_HOLDER.setDateStyle(HeaderFooterDateFormat.getDateStyle(attributeSet));
        this.PRINT_PARAM_HOLDER.setTimeStyle(HeaderFooterTimeFormat.getTimeStyle(attributeSet));
    }

    protected void printPageDecorations(Graphics2D graphics2D, PageFormat pageFormat, int n2, int n3, float f2) {
        PrintRequestAttributeSet printRequestAttributeSet = this.getAttributeSet();
        if (printRequestAttributeSet != null) {
            this.PRINT_PARAM_HOLDER.pageNo = n2 + 1 + this.getDisplayPageNumberOffset();
            this.PRINT_PARAM_HOLDER.pageCount = n3;
            this.PRINT_PARAM_HOLDER.scaleFactor = f2;
            if (!this.isToPrintPageDecorations()) {
                graphics2D = new NoDrawGraphics2DWrapper(graphics2D);
            }
            PageDecorationUtility.printStandardPageDecorations(graphics2D, printRequestAttributeSet, pageFormat, this.DECORATION_OPTIONS, this.PRINT_PARAM_HOLDER);
        }
    }

    protected void setToPrintContentFrame(boolean bl) {
        this.u = bl;
    }

    protected void setToPrintPageContentFrame(boolean bl) {
        this.q = bl;
    }

    protected void setToPrintPageDecorations(boolean bl) {
        this.h = bl;
    }

    protected void updatePrintJobStatus(String string) {
        PrintJobAdministrator.updatePrintJobStatus(string);
    }

    static Graphics2D d() {
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        bufferedImage = new BufferedImage(4, 4, 10);
        graphics2D = bufferedImage.createGraphics();
        PrintSwingUtility.configureGraphicsForPreview(graphics2D);
        return graphics2D;
    }

    boolean b() {
        return this.y;
    }

    void a(String string) {
        String string2 = this.getClass().getName() + "." + string + "(...) ";
        PrintJobAdministrator.updatePrintJobStatus(string2);
    }

    static int[] a(int[] nArray, int n2, int n3) {
        float f2 = (float)n2 / (float)n3;
        return AbstractPrinter.expandOffsetArray(nArray, f2);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

