/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.DebugGraphics;
import javax.swing.JComponent;
import javax.swing.border.Border;
import jpdf.ability.FitScalabilityCoded;
import jpdf.ability.PrintImageUsable;
import jpdf.attribute.BackgroundColorOnPage;
import jpdf.attribute.ContentBorder;
import jpdf.attribute.FitToPages;
import jpdf.attribute.FitToPagesSelected;
import jpdf.attribute.FloatSyntax;
import jpdf.attribute.ScaleFactor;
import jpdf.attribute.ScaleFactorMax;
import jpdf.attribute.ScaleFactorMin;
import jpdf.attribute.UseBackgroundColor;
import jpdf.manage.PrintManager;
import jpdf.printable.FullyNavigablePrintable;
import jpdf.printable.PageGridPrintable;
import jpdf.printable.ResetablePrintable;
import jpdf.printer.AbstractPrinter;
import jpdf.printer.PrintCustomizer;
import jpdf.printer.PrinterFactory;
import jpdf.printer.swing.SwingPropertyCopier;
import jpdf.utility.PageDecorationUtility;
import jpdf.utility.PrintUtility;
import jpdf.wrap.NoDrawGraphics2DWrapper;
import jpdf_common.gui.utility.UIUtility;
import jpdf_common.system.utility.SystemUtility;
import sun.print.PeekGraphics;

public abstract class AbstractComponentPrinter
extends AbstractPrinter
implements FullyNavigablePrintable,
PageGridPrintable,
ResetablePrintable,
FitScalabilityCoded {
    public static final String PRINT_CLONE_PROPERTY_KEY = "JpdfPrintClone";
    protected final Component TARGET_COMPONENT;
    protected final Dimension PAGE_GRID_SIZE = new Dimension(-1, -1);
    protected final Dimension EXTRA_SPACE = new Dimension();
    protected final ScaleFactorInfoHolder SCALE_FACTOR_INFO_HOLDER = new ScaleFactorInfoHolder();
    private Border C = null;
    private Color E = null;
    private Color F = null;
    private int m = -1;
    private int l = -1;
    private int G = 0;
    private int j = -1;
    private int B = 0;
    private int s = 20;
    static Class w;
    static Class e;
    static Class g;
    static Class D;

    public AbstractComponentPrinter(Component component, String string, boolean bl) {
        this(component, string, PrintManager.getDefaultPrintAttributes(), bl);
    }

    public AbstractComponentPrinter(Component component, String string, AttributeSet attributeSet, boolean bl) {
        super(string, attributeSet);
        this.TARGET_COMPONENT = component;
        this.setTargetComponentBackgroundColor(this.TARGET_COMPONENT.getBackground());
        if (this.TARGET_COMPONENT instanceof JComponent) {
            this.setTargetComponentBorder(((JComponent)this.TARGET_COMPONENT).getBorder());
            if (bl) {
                ((JComponent)this.TARGET_COMPONENT).putClientProperty(PRINT_CLONE_PROPERTY_KEY, Boolean.TRUE);
            }
        }
        this.a(component, string);
        this.setToPrintWithImage(this.TARGET_COMPONENT instanceof PrintImageUsable);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component) {
        return PrinterFactory.buildComponentPrinter(component);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, PrintRequestAttributeSet printRequestAttributeSet) {
        return PrinterFactory.buildComponentPrinter(component, printRequestAttributeSet);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, String string) {
        return PrinterFactory.buildComponentPrinter(component, string);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, String string, PrintRequestAttributeSet printRequestAttributeSet) {
        return PrinterFactory.buildComponentPrinter(component, string, printRequestAttributeSet);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, int n2) {
        return PrinterFactory.buildComponentPrinter(component, n2);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, int n2, PrintRequestAttributeSet printRequestAttributeSet) {
        return PrinterFactory.buildComponentPrinter(component, n2, printRequestAttributeSet);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, String string, int n2, PrintRequestAttributeSet printRequestAttributeSet) {
        return PrinterFactory.buildComponentPrinter(component, string, n2, printRequestAttributeSet);
    }

    public static AbstractComponentPrinter buildComponentPrinter(Component component, String string, int n2) {
        return PrinterFactory.buildComponentPrinter(component, string, n2);
    }

    public int computePageCount() {
        PageFormat pageFormat = PrintUtility.createPageFormat(this.getAttributeSet());
        return this.computePageCount(pageFormat);
    }

    public int computePageCount(PageFormat pageFormat) {
        this.resetState();
        this.computePageGridSize(pageFormat);
        return this.getPageCount();
    }

    public Dimension computePageGridSize(PageFormat pageFormat) {
        PrintRequestAttributeSet printRequestAttributeSet = this.getAttributeSet();
        this.DECORATION_OPTIONS.pageIndex = -99;
        this.prepareForPrinting(pageFormat, printRequestAttributeSet);
        this.computePageGridSize(pageFormat, printRequestAttributeSet, this.PAGE_GRID_SIZE);
        this.e(this.PAGE_GRID_SIZE.width * this.PAGE_GRID_SIZE.height);
        return this.PAGE_GRID_SIZE;
    }

    public abstract int getEmptySpaceAtLastPageBottom();

    public int getFitScalingSupportCode() {
        return 0;
    }

    public Color getPageBackgroundColor() {
        if (this.F != null) {
            return this.F;
        }
        return this.getTargetComponentBackgroundColor();
    }

    public int getPageCount() {
        return this.m;
    }

    public int getPrintedPageIndex() {
        return this.l;
    }

    public Component getTargetComponent() {
        return this.TARGET_COMPONENT;
    }

    public Color getTargetComponentBackgroundColor() {
        return this.E;
    }

    public Border getTargetComponentBorder() {
        return this.C;
    }

    public Dimension getTargetComponentPrintSize() {
        return this.TARGET_COMPONENT.getSize();
    }

    public boolean isBackgroundColorSupported() {
        return true;
    }

    public boolean isBorderControlAllowed() {
        return this.isBorderSupported() && this.getTargetComponentBorder() != null;
    }

    public boolean isDoubleBuffered() {
        return this.TARGET_COMPONENT.isDoubleBuffered();
    }

    public static boolean isToBuildScalingPrinters() {
        return PrinterFactory.isToBuildScalingPrinters();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) {
        PrintCustomizer printCustomizer = this.getPrintCustomizer();
        PrintRequestAttributeSet printRequestAttributeSet = this.getAttributeSet();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = null;
        float f2 = 0.0f;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (AbstractComponentPrinter.isToDebugPrinting()) {
            String string = this.getClass().getName() + " printing " + this.TARGET_COMPONENT.getClass().getName();
            this.updatePrintJobStatus(string);
        }
        if (PrintManager.isPrintJobCancelled()) {
            return 1;
        }
        if (this.a(graphics, n2)) {
            int n6 = this.c();
            if (n6 > 0) {
                SystemUtility.pauseThreadMilliSeconds(n6);
            }
            this.computePageGridSize(pageFormat);
        }
        n5 = this.PAGE_GRID_SIZE.width * this.PAGE_GRID_SIZE.height;
        if ((n2 += this.a()) >= n5) {
            return 1;
        }
        if (n2 > 0) {
            n3 = n2 / this.PAGE_GRID_SIZE.width;
            n4 = n2 % this.PAGE_GRID_SIZE.width;
        }
        if (printCustomizer != null) {
            graphics2D = printCustomizer.customizePrint(graphics2D, pageFormat, n2, this, printRequestAttributeSet, this.PRINT_PARAM_HOLDER);
        }
        f2 = this.computeScaleFactor(pageFormat, printRequestAttributeSet, this.SCALE_FACTOR_INFO_HOLDER);
        this.printPageDecorations(graphics2D, printRequestAttributeSet, pageFormat, n2, this.getDisplayPageCount(), f2);
        if (this.SCALE_FACTOR_INFO_HOLDER.fitsPagesWide != 0) {
            rectangle = graphics2D.getClipBounds();
            rectangle.x += this.SCALE_FACTOR_INFO_HOLDER.fitSpaceReduction / 2;
            graphics2D.setClip(rectangle);
        } else if (this.SCALE_FACTOR_INFO_HOLDER.fitsPagesHigh != 0) {
            rectangle = graphics2D.getClipBounds();
            rectangle.y += this.SCALE_FACTOR_INFO_HOLDER.fitSpaceReduction / 2;
            graphics2D.setClip(rectangle);
        }
        this.printTargetComponent(graphics2D, n3, n4, printRequestAttributeSet, f2);
        this.a(n2);
        return PrintManager.isPrintJobCancelled() ? 1 : 0;
    }

    public void reset() {
        this.resetState();
    }

    public static void setComponentCloneProperties(JComponent jComponent, JComponent jComponent2, boolean bl) {
        Container container = null;
        SwingPropertyCopier.copyComponentVisibleProperties(jComponent, jComponent2);
        if (jComponent.isOpaque() || bl) {
            jComponent2.setBackground(jComponent.getBackground());
        } else {
            container = UIUtility.getOpaqueParentContainer(jComponent);
            if (container != null) {
                jComponent2.setBackground(container.getBackground());
            } else {
                jComponent2.setBackground(Color.WHITE);
            }
        }
        jComponent2.setOpaque(true);
    }

    public boolean setDoubleBuffered(boolean bl) {
        boolean bl2 = false;
        if (this.TARGET_COMPONENT instanceof JComponent && this.TARGET_COMPONENT.isDoubleBuffered() != bl) {
            ((JComponent)this.TARGET_COMPONENT).setDoubleBuffered(bl);
            bl2 = true;
        }
        return bl2;
    }

    public void setPageBackgroundColor(Color color) {
        this.F = color;
    }

    public void setTargetComponentBackgroundColor(Color color) {
        this.E = color;
    }

    public void setTargetComponentBorder(Border border) {
        this.C = border;
    }

    public static void setToBuildScalingPrinters(boolean bl) {
        PrinterFactory.setToBuildScalingPrinters(bl);
    }

    protected abstract void computePageGridSize(PageFormat var1, AttributeSet var2, Dimension var3);

    protected float computeScaleFactor(PageFormat pageFormat, AttributeSet attributeSet, ScaleFactorInfoHolder scaleFactorInfoHolder) {
        FitToPages fitToPages = null;
        FloatSyntax floatSyntax = null;
        Dimension dimension = this.getTargetComponentPrintSize();
        boolean bl = false;
        boolean bl2 = false;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.01f;
        float f6 = 99.0f;
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getFitScalingSupportCode();
        bl2 = n6 != 0;
        scaleFactorInfoHolder.setToFixedScaleFactor(f2);
        if (attributeSet != null) {
            if (bl2) {
                bl = FitToPagesSelected.isFitSelected(attributeSet);
            }
            if (bl) {
                if (n6 == 2) {
                    n2 = 1;
                    n3 = 99999;
                } else {
                    fitToPages = (FitToPages)attributeSet.get(w == null ? (w = AbstractComponentPrinter.class$("jpdf.attribute.FitToPages")) : w);
                    if (fitToPages != null) {
                        n2 = fitToPages.getWidth();
                        n3 = fitToPages.getHeight();
                    }
                    if (n6 == 3) {
                        n3 = 99999;
                    } else if (n6 == 4) {
                        n2 = 99999;
                    }
                }
                n4 = PageDecorationUtility.computeAvailablePageWidth(pageFormat, attributeSet, this.DECORATION_OPTIONS, 1);
                n4 = n4 * n2 - 2;
                if (n3 / n2 > 10) {
                    n5 = 999999;
                } else {
                    n5 = this.computeTotalAvailableHeight(pageFormat, attributeSet, 1, n3);
                    n5 -= 2;
                }
                f3 = (float)n4 / (float)dimension.width;
                f4 = (float)n5 / (float)dimension.height;
                if (f3 < f4) {
                    f2 = f3;
                    scaleFactorInfoHolder.fitsPagesWide = n2;
                    scaleFactorInfoHolder.fitsPagesHigh = 0;
                } else {
                    f2 = f4;
                    scaleFactorInfoHolder.fitsPagesWide = 0;
                    scaleFactorInfoHolder.fitsPagesHigh = n3;
                }
            } else {
                floatSyntax = (ScaleFactor)attributeSet.get(e == null ? (e = AbstractComponentPrinter.class$("jpdf.attribute.ScaleFactor")) : e);
                if (floatSyntax != null) {
                    f2 = floatSyntax.getValue();
                }
            }
            floatSyntax = (ScaleFactorMin)attributeSet.get(g == null ? (g = AbstractComponentPrinter.class$("jpdf.attribute.ScaleFactorMin")) : g);
            if (floatSyntax != null) {
                f5 = floatSyntax.getValue();
            }
            if ((floatSyntax = (ScaleFactorMax)attributeSet.get(D == null ? (D = AbstractComponentPrinter.class$("jpdf.attribute.ScaleFactorMax")) : D)) != null) {
                f6 = floatSyntax.getValue();
            }
            if (f2 < f5) {
                f2 = f5;
                scaleFactorInfoHolder.fitsPagesWide = 0;
                scaleFactorInfoHolder.fitsPagesHigh = 0;
            } else if (f2 > f6) {
                f2 = f6;
                scaleFactorInfoHolder.fitsPagesWide = 0;
                scaleFactorInfoHolder.fitsPagesHigh = 0;
            }
        }
        scaleFactorInfoHolder.scaleFactor = f2;
        return f2;
    }

    protected void drawContentFrame(Graphics2D graphics2D, Color color) {
        Rectangle rectangle = graphics2D.getClipBounds();
        Dimension dimension = this.getTargetComponentPrintSize();
        if (dimension.width > 0 && dimension.height > 0) {
            graphics2D.setClip(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 4);
            graphics2D.setColor(color);
            graphics2D.drawRect(-1, -1, dimension.width + 1, dimension.height + 1);
            graphics2D.setClip(rectangle);
        }
    }

    protected void drawPageContentFrame(Graphics2D graphics2D, Color color) {
        Rectangle rectangle = graphics2D.getClipBounds();
        Rectangle rectangle2 = null;
        Dimension dimension = this.getTargetComponentPrintSize();
        int n2 = 0;
        int n3 = 0;
        rectangle2 = new Rectangle(rectangle);
        n2 = rectangle2.x + rectangle2.width;
        if (dimension.width < n2) {
            rectangle2.width -= n2 - dimension.width;
        }
        if (dimension.height < (n3 = rectangle2.y + rectangle2.height)) {
            rectangle2.height -= n3 - dimension.height;
        }
        graphics2D.setClip(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
        graphics2D.setColor(color);
        graphics2D.draw(rectangle2);
        graphics2D.setClip(rectangle);
    }

    protected abstract int getComponentHeightOnPage(int var1);

    protected int getEmptySpaceAtFirstPageTop() {
        return this.G;
    }

    protected int getLastPageHeightUsed() {
        int n2 = this.PAGE_GRID_SIZE.height - 1;
        int n3 = 0;
        if (n2 < 0) {
            return 0;
        }
        if (n2 == 0) {
            n3 = this.getEmptySpaceAtFirstPageTop();
        }
        return n3 += this.DECORATION_OPTIONS.minimumOffsets.top + this.getComponentHeightOnPage(n2);
    }

    protected static String getTitleForComponent(Component component) {
        String string = null;
        if (component instanceof Window) {
            if (component instanceof Dialog) {
                string = ((Dialog)component).getTitle();
                if (string.equals("")) {
                    string = component.getClass().getName();
                }
            } else if (component instanceof Frame) {
                string = ((Frame)component).getTitle();
                if (string.equals("")) {
                    string = component.getClass().getName();
                }
            } else {
                string = component.getClass().getName();
            }
        } else {
            string = component.getName();
        }
        return string;
    }

    protected boolean isBorderSupported() {
        return true;
    }

    protected void paintTargetComponent(Graphics2D graphics2D) {
        if (this.b()) {
            this.a("paintTargetComponent");
        }
        this.TARGET_COMPONENT.paint(graphics2D);
    }

    protected void prepareForPrinting(PageFormat pageFormat, AttributeSet attributeSet) {
        Container container = null;
        Border border = null;
        Color color = null;
        super.prepareForPrinting(pageFormat, attributeSet);
        if (this.isBackgroundColorSupported()) {
            color = UseBackgroundColor.isToUseBackgroundColor(attributeSet) ? this.getTargetComponentBackgroundColor() : Color.WHITE;
            this.TARGET_COMPONENT.setBackground(color);
        }
        if (this.isBorderSupported()) {
            if (ContentBorder.isToPrintBorder(attributeSet)) {
                border = this.getTargetComponentBorder();
            }
            ((JComponent)this.TARGET_COMPONENT).setBorder(border);
            container = this.TARGET_COMPONENT.getParent();
            if (container != null) {
                this.TARGET_COMPONENT.invalidate();
                container.validate();
            }
        }
    }

    protected void printPageDecorations(Graphics2D graphics2D, AttributeSet attributeSet, PageFormat pageFormat, int n2, int n3, float f2) {
        String[] stringArray = null;
        Color color = this.getPageBackgroundColor();
        boolean bl = this.isToPrintPageDecorations();
        if (bl && this.isBackgroundColorSupported() && !color.equals(Color.WHITE) && BackgroundColorOnPage.isBackgroundColorOnPage(attributeSet)) {
            PageDecorationUtility.fillBackground(graphics2D, pageFormat, color);
        }
        if (!bl) {
            graphics2D = new NoDrawGraphics2DWrapper(graphics2D);
        }
        if (attributeSet == null) {
            stringArray = new String[]{this.TARGET_COMPONENT.getClass().getName(), this.PRINT_PARAM_HOLDER.title, this.PRINT_PARAM_HOLDER.date.toString()};
            PageDecorationUtility.printStandardPageDecorations(graphics2D, pageFormat, this.DECORATION_OPTIONS, stringArray, null);
        } else {
            this.PRINT_PARAM_HOLDER.pageNo = n2 + 1 + this.getDisplayPageNumberOffset();
            this.PRINT_PARAM_HOLDER.pageCount = n3;
            this.PRINT_PARAM_HOLDER.scaleFactor = f2;
            this.PRINT_PARAM_HOLDER.pageGridWidth = this.PAGE_GRID_SIZE.width;
            PageDecorationUtility.printStandardPageDecorations(graphics2D, attributeSet, pageFormat, this.DECORATION_OPTIONS, this.PRINT_PARAM_HOLDER);
        }
    }

    protected abstract void printTargetComponent(Graphics2D var1, int var2, int var3, AttributeSet var4, float var5);

    protected void resetState() {
        this.PAGE_GRID_SIZE.width = -1;
        this.PAGE_GRID_SIZE.height = -1;
        this.e(-1);
        this.a(-1);
    }

    protected void setEmptySpaceAtFirstPageTop(int n2) {
        this.G = n2;
    }

    protected static int updateYOffsetArray_BottomInset(int[] nArray, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        n6 = n4 - n3;
        if (n6 > 0) {
            int n7 = n2++;
            nArray[n7] = nArray[n7] + (n4 - (n6 + 1));
            if (n2 >= nArray.length) {
                nArray = AbstractComponentPrinter.expandOffsetArray(nArray, 1);
            }
            nArray[n2] = nArray[n2 - 1] + n6 + 1;
        } else {
            if (n3 < n5) {
                n5 = n3;
            }
            int n8 = n2;
            nArray[n8] = nArray[n8] + (n4 + n5);
        }
        return n2;
    }

    protected void useDebugGraphicsForTargetComponent() {
        String string = null;
        String string2 = this.getClass().getName();
        int n2 = string2.lastIndexOf(46);
        if (this.isDoubleBuffered()) {
            String string3 = "Debug Graphics cannot be used with a Double Buffered component.";
            PrintManager.handleException(new IllegalStateException(string3));
            return;
        }
        if (n2 > 0) {
            string2 = string2.substring(n2 + 1);
        }
        string = string2 + ".DebugGraphics.log";
        try {
            DebugGraphics.setLogStream(new PrintStream(new FileOutputStream(string)));
            ((JComponent)this.TARGET_COMPONENT).setDebugGraphicsOptions(1);
        }
        catch (Exception exception) {
            PrintManager.handleException(exception);
        }
    }

    protected void useNormalGraphicsForTargetComponent() {
        PrintStream printStream = null;
        try {
            printStream = DebugGraphics.logStream();
            if (printStream != null) {
                printStream.close();
            }
        }
        catch (Exception exception) {
            PrintManager.handleException(exception);
        }
    }

    int e() {
        return this.j;
    }

    int c() {
        return this.s;
    }

    int a() {
        return this.B;
    }

    void d(int n2) {
        this.s = n2;
    }

    void f(int n2) {
        this.B = n2;
        this.setDisplayPageNumberOffset(-n2);
    }

    void c(int n2) {
        this.j = n2;
    }

    private boolean a(Graphics graphics, int n2) {
        if (this.PAGE_GRID_SIZE.width < 0) {
            return true;
        }
        return n2 == 0 && graphics instanceof PeekGraphics;
    }

    private void e(int n2) {
        this.m = n2;
    }

    private void a(int n2) {
        this.l = n2;
    }

    private void a(Component component, String string) {
        Dimension dimension = component.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            component.setSize(component.getPreferredSize());
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected static class ScaleFactorInfoHolder {
        public float scaleFactor = 1.0f;
        public int fitSpaceReduction = 2;
        public int fitsPagesWide = 0;
        public int fitsPagesHigh = 0;

        protected ScaleFactorInfoHolder() {
        }

        protected void resetDefaults() {
            this.scaleFactor = 1.0f;
            this.fitsPagesWide = 0;
            this.fitsPagesHigh = 0;
            this.fitSpaceReduction = 2;
        }

        protected void setToFixedScaleFactor(float f2) {
            this.scaleFactor = f2;
            this.fitsPagesWide = 0;
            this.fitsPagesHigh = 0;
            this.fitSpaceReduction = 2;
        }
    }
}

