/*
 * Decompiled with CFR 0.152.
 */
package jpdf.printer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import jpdf.ability.LookAheadAble;
import jpdf.attribute.ForegroundColor;
import jpdf.manage.PrintManager;
import jpdf.printable.PageCountPrintable;
import jpdf.printable.PageIndexPrintable;
import jpdf.printable.ResetablePrintable;
import jpdf.printer.AbstractPrinter;
import jpdf.printer.PrintCustomizer;
import jpdf.utility.PageDecorationUtility;
import jpdf.utility.PageDecorator;
import jpdf.wrap.NoDrawGraphics2DWrapper;

public abstract class AbstractArrayPrinter
extends AbstractPrinter
implements ResetablePrintable,
PageIndexPrintable,
LookAheadAble,
PageDecorator {
    public static final int NO_PAGE_INDEX = -1;
    public static final float NO_SCALE_FACTOR = 1.0f;
    protected static final String TAB_REPLACEMENT_STRING = "  ";
    public final Font DEFAULT_CONTENT_FONT;
    protected final PageDecorator PAGE_DECORATOR;
    protected final PrintedPageInfo PRINTED_PAGE_INFO = new PrintedPageInfo();
    private boolean j = false;
    private int g = -1;

    protected AbstractArrayPrinter(String string, Font font) {
        this(string, font, null);
    }

    protected AbstractArrayPrinter(String string, Font font, PageDecorator pageDecorator) {
        super(string);
        this.DEFAULT_CONTENT_FONT = font;
        this.PAGE_DECORATOR = pageDecorator == null ? this : pageDecorator;
    }

    protected AbstractArrayPrinter(String string, Font font, AttributeSet attributeSet, PageDecorator pageDecorator) {
        super(string, attributeSet);
        this.DEFAULT_CONTENT_FONT = font;
        this.PAGE_DECORATOR = pageDecorator == null ? this : pageDecorator;
    }

    public int computePageCount(PageFormat pageFormat) {
        Graphics2D graphics2D = AbstractArrayPrinter.d();
        int n2 = PrintedPageInfo.b(this.PRINTED_PAGE_INFO);
        int n3 = PrintedPageInfo.c(this.PRINTED_PAGE_INFO);
        int n4 = PrintedPageInfo.a(this.PRINTED_PAGE_INFO);
        this.PRINTED_PAGE_INFO.reset();
        this.g = this.b(graphics2D, pageFormat, 9999) + 1;
        this.PRINTED_PAGE_INFO.printedArrayPage(n2, n3, n4);
        return this.g;
    }

    public int getPageCount() {
        return this.g;
    }

    public int getPrintedPageIndex() {
        return PrintedPageInfo.b(this.PRINTED_PAGE_INFO);
    }

    public boolean isMoreDataAvailable() {
        return this.isMorePrintDataAvailable(PrintedPageInfo.b(this.PRINTED_PAGE_INFO) + 1);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) {
        PrintCustomizer printCustomizer = this.getPrintCustomizer();
        PrintRequestAttributeSet printRequestAttributeSet = this.getAttributeSet();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = null;
        int n3 = 0;
        if (PrintManager.isPrintJobCancelled()) {
            return 1;
        }
        n3 = this.getPageCount();
        if (this instanceof PageCountPrintable && n3 == -1) {
            n3 = this.computePageCount(pageFormat);
        }
        if (n2 > 0) {
            if (n2 != PrintedPageInfo.b(this.PRINTED_PAGE_INFO) && n2 != PrintedPageInfo.b(this.PRINTED_PAGE_INFO) + 1) {
                this.a(graphics, pageFormat, n2 - 1);
            }
            if (!this.isMorePrintDataAvailable(n2)) {
                return 1;
            }
        } else {
            this.PRINTED_PAGE_INFO.reset();
        }
        if (printCustomizer != null) {
            graphics2D = printCustomizer.customizePrint(graphics2D, pageFormat, n2, this, printRequestAttributeSet, this.PRINT_PARAM_HOLDER);
        }
        this.a(graphics2D, pageFormat, n2, printRequestAttributeSet);
        rectangle = graphics2D.getClipBounds();
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.setColor(ForegroundColor.getColor(printRequestAttributeSet, Color.BLACK));
        this.printArrayPage(graphics2D, n2, printRequestAttributeSet);
        return PrintManager.isPrintJobCancelled() ? 1 : 0;
    }

    public void printPageDecorations(Graphics2D graphics2D, PageFormat pageFormat, String string, int n2, AttributeSet attributeSet, Font font, PageDecorator pageDecorator) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n3 = n2 + 1 + this.getDisplayPageNumberOffset();
        if (attributeSet == null) {
            stringArray = new String[]{string, "", this.PRINT_PARAM_HOLDER.date.toString()};
            stringArray2 = new String[]{"", Integer.toString(n3), ""};
            PageDecorationUtility.printStandardPageDecorations(graphics2D, pageFormat, this.DECORATION_OPTIONS, stringArray, stringArray2);
        } else {
            this.PRINT_PARAM_HOLDER.pageNo = n3;
            this.PRINT_PARAM_HOLDER.pageCount = this.getDisplayPageCount();
            this.PRINT_PARAM_HOLDER.scaleFactor = 1.0f;
            PageDecorationUtility.printStandardPageDecorations(graphics2D, attributeSet, pageFormat, this.DECORATION_OPTIONS, this.PRINT_PARAM_HOLDER);
        }
    }

    public void reset() {
        this.e();
        this.PRINTED_PAGE_INFO.reset();
    }

    protected int computePageFitCount(Graphics2D graphics2D, int n2, FontMetrics fontMetrics) {
        Rectangle rectangle = graphics2D.getClipBounds();
        int n3 = 0;
        int n4 = 0;
        n4 = rectangle.height - n2 + fontMetrics.getMaxAscent();
        n3 = n4 > 0 ? n4 / fontMetrics.getHeight() : 0;
        return n3;
    }

    protected abstract boolean isMorePrintDataAvailable(int var1);

    protected abstract void printArrayPage(Graphics2D var1, int var2, AttributeSet var3);

    protected void printArrayPage(Graphics2D graphics2D, int n2, int n3, int n4, Font font, Object[] objectArray, int n5) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n6 = fontMetrics.getHeight();
        int n7 = this.computePageFitCount(graphics2D, n4, fontMetrics);
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (n7 <= 0) {
            return;
        }
        n9 = objectArray.length - n5;
        n8 = n9 > n7 ? n7 : n9;
        n11 = n5 + n8 - 1;
        if (!this.f()) {
            graphics2D.setFont(font);
            for (n10 = n5; n10 <= n11; ++n10) {
                graphics2D.drawString(objectArray[n10].toString(), n3, n4);
                n4 += n6;
            }
        }
        this.PRINTED_PAGE_INFO.printedArrayPage(n2, n5, n11);
    }

    private int b(Graphics graphics, PageFormat pageFormat, int n2) {
        PrintRequestAttributeSet printRequestAttributeSet = this.getAttributeSet();
        NoDrawGraphics2DWrapper noDrawGraphics2DWrapper = new NoDrawGraphics2DWrapper((Graphics2D)graphics.create());
        int n3 = this.PRINTED_PAGE_INFO.getPrintedPageIndex();
        int n4 = n3 + 1;
        this.a(true);
        while (this.isMorePrintDataAvailable(n4) && n3 < n2) {
            this.a(noDrawGraphics2DWrapper, pageFormat, n4, printRequestAttributeSet);
            this.printArrayPage(noDrawGraphics2DWrapper, n4, printRequestAttributeSet);
            ++n3;
            ++n4;
        }
        this.a(false);
        return n3;
    }

    private boolean f() {
        return this.j;
    }

    private int a(Graphics graphics, PageFormat pageFormat, int n2) {
        if (n2 > PrintedPageInfo.b(this.PRINTED_PAGE_INFO)) {
            n2 = this.b(graphics, pageFormat, n2);
        } else if (n2 < PrintedPageInfo.b(this.PRINTED_PAGE_INFO)) {
            this.PRINTED_PAGE_INFO.reset();
            n2 = this.b(graphics, pageFormat, n2);
        }
        return n2;
    }

    private void e() {
        this.g = 0;
    }

    private void a(Graphics2D graphics2D, PageFormat pageFormat, int n2, AttributeSet attributeSet) {
        if (!this.isToPrintPageDecorations()) {
            graphics2D = new NoDrawGraphics2DWrapper(graphics2D);
        }
        this.PAGE_DECORATOR.printPageDecorations(graphics2D, pageFormat, this.PRINT_PARAM_HOLDER.title, n2, attributeSet, PageDecorationUtility.DEFAULT_DECORATION_FONT, this);
    }

    private void a(boolean bl) {
        this.j = bl;
    }

    protected static class PrintedPageInfo {
        private int b = 0;
        private int c = 0;
        private int a = 0;

        protected PrintedPageInfo() {
            this.reset();
        }

        protected int getPrintedPageIndex() {
            return this.b;
        }

        protected int getPrintedStartArrayIndex() {
            return this.c;
        }

        protected int getNextPrintArrayIndex(int n2) {
            if (n2 == this.b) {
                return this.c;
            }
            return this.a + 1;
        }

        protected void printedArrayPage(int n2, int n3, int n4) {
            this.b = n2;
            this.c = n3;
            this.a = n4;
        }

        protected void reset() {
            this.b = -1;
            this.c = 0;
            this.a = -1;
        }

        static int b(PrintedPageInfo printedPageInfo) {
            return printedPageInfo.b;
        }

        static int c(PrintedPageInfo printedPageInfo) {
            return printedPageInfo.c;
        }

        static int a(PrintedPageInfo printedPageInfo) {
            return printedPageInfo.a;
        }
    }
}

