/*
 * Decompiled with CFR 0.152.
 */
package jpdf.gui.preview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Locale;
import javax.print.attribute.PrintRequestAttributeSet;
import jpdf.gui.preview.AbstractOverviewPanel;
import jpdf.gui.preview.AbstractPageImageDisplayPanel;
import jpdf.gui.preview.E;
import jpdf.gui.preview.g;
import jpdf.gui.preview.j;
import jpdf.gui.preview.q;
import jpdf.printable.PageCountPrintable;
import jpdf.printable.PageGridPrintable;
import jpdf.printable.ResetablePrintable;

public class PrintableOverviewPanel
extends AbstractOverviewPanel {
    private final Dimension g = new Dimension();
    private q k = null;
    private boolean l = false;
    private boolean a = true;

    public PrintableOverviewPanel(Locale locale) {
        super(locale);
        this.setOverviewPrintable(new AbstractPageImageDisplayPanel.NothingPrintable());
    }

    public PrintableOverviewPanel(Locale locale, Printable printable) {
        super(locale);
        this.setOverviewPrintable(printable);
    }

    public int getFixedColumnCount() {
        if (this.d()) {
            return 0;
        }
        return this.getOverviewPrintable().getColumnCount();
    }

    public boolean isColumnCountSettable() {
        return this.getOverviewPrintable().isColumnCountSettable();
    }

    public boolean isToUsePageGridColumnCount() {
        return this.a;
    }

    public boolean requestFixedColumnCount(int n2) {
        q q2 = this.getOverviewPrintable();
        boolean bl = n2 < 1;
        int n3 = q2.getColumnCount();
        this.b(bl);
        if (bl) {
            n2 = this.b();
        }
        q2.setRequestedColumnCount(n2);
        if (n2 != n3) {
            this.refreshDisplay();
        }
        return this.isColumnCountSettable();
    }

    public void setRequestedFixedColumnCount(int n2) {
        this.getOverviewPrintable().setRequestedColumnCount(n2);
    }

    public void setToUsePageGridColumnCount(boolean bl) {
        this.a = bl;
    }

    protected Dimension computeFullLayoutSize() {
        Dimension dimension = this.getOverviewPrintable().computePageGridSize(this.PAGE_FORMAT);
        this.g.width = dimension.width;
        this.g.height = dimension.height;
        return this.g;
    }

    protected Dimension getFullLayoutSize() {
        return this.g;
    }

    protected int getFullPageCount() {
        return this.getOverviewPrintable().getPageCount();
    }

    protected q getOverviewPrintable() {
        return this.k;
    }

    protected Printable getTargetPrintable() {
        return this.k.WRAPPED_PRINTABLE;
    }

    protected boolean handleContainerResize() {
        q q2 = null;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        if (this.d() && (n2 = (q2 = this.getOverviewPrintable()).getColumnCount()) != (n3 = this.b())) {
            q2.setRequestedColumnCount(n3);
            this.setZoomFactorResize(this.getZoomFactor(), true);
            this.refreshDisplay();
            bl = true;
        }
        return bl;
    }

    protected void paintOverviewPageImage(Graphics2D graphics2D, int n2, int n3, int n4) {
        q q2 = this.getOverviewPrintable();
        float f2 = this.getZoomFactor();
        graphics2D = this.prepareImageGraphics(graphics2D, q2.WRAPPED_PRINTABLE, n2, n3);
        this.a(graphics2D, q2, f2, 7, 7, n4);
    }

    protected void paintOverviewPageRangeImage(Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        q q2 = this.getOverviewPrintable();
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle rectangle = graphics2D.getClipBounds();
        Dimension dimension = null;
        Stroke stroke = graphics2D.getStroke();
        float f2 = this.getZoomFactor();
        int n6 = 0;
        int n7 = (int)((double)f2 * this.PAGE_FORMAT.getWidth());
        int n8 = (int)((double)f2 * this.PAGE_FORMAT.getHeight());
        int n9 = 0;
        int n10 = 7;
        int n11 = 0;
        int n12 = 0;
        if (n5 == 9999) {
            n4 = 0;
            n5 = this.getFullPageCount() - 1;
            this.setPageIndexRange(0, n5);
            n5 = this.getLastPageIndex();
        }
        graphics2D = this.prepareImageGraphics(graphics2D, q2.WRAPPED_PRINTABLE, n2, n3);
        dimension = this.g;
        n11 = n4 / dimension.width;
        n12 = n5 / dimension.width;
        n6 = n11 * dimension.width;
        for (int i2 = n11; i2 <= n12; ++i2) {
            n9 = 7;
            for (int i3 = 0; i3 < dimension.width; ++i3) {
                if (n6 >= n4 && n6 <= n5) {
                    graphics2D.setStroke(stroke);
                    graphics2D.setClip(rectangle);
                    graphics2D.setTransform(affineTransform);
                    this.a(graphics2D, q2, f2, n9, n10, n6);
                }
                ++n6;
                n9 += n7 + 9;
            }
            n10 += n8 + 9;
        }
    }

    protected void paintOverviewPageRowImage(Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        q q2 = this.getOverviewPrintable();
        AffineTransform affineTransform = graphics2D.getTransform();
        Rectangle rectangle = graphics2D.getClipBounds();
        Dimension dimension = null;
        Stroke stroke = graphics2D.getStroke();
        float f2 = this.getZoomFactor();
        int n6 = 0;
        int n7 = (int)((double)f2 * this.PAGE_FORMAT.getWidth());
        int n8 = 7;
        int n9 = 0;
        graphics2D = this.prepareImageGraphics(graphics2D, q2.WRAPPED_PRINTABLE, n2, n3);
        dimension = q2.PAGE_GRID_SIZE;
        n9 = n4 / dimension.width;
        n6 = n9 * dimension.width;
        for (int i2 = 0; i2 < dimension.width; ++i2) {
            if (n6 >= n4 && n6 <= n5) {
                graphics2D.setStroke(stroke);
                graphics2D.setClip(rectangle);
                graphics2D.setTransform(affineTransform);
                this.a(graphics2D, q2, f2, n8, 7, n6);
                n8 += n7 + 9;
            }
            ++n6;
        }
    }

    protected void setOverviewPrintable(Printable printable) {
        int n2 = 3;
        this.displayWaitCursor();
        if (this.k != null) {
            n2 = this.k.getRequestedColumnCount();
        }
        this.k = printable instanceof PageGridPrintable ? new g(this, (PageGridPrintable)printable, n2, null) : (printable instanceof PageCountPrintable ? new E((PageCountPrintable)printable, n2, null) : new j(printable, n2, null));
    }

    protected PageFormat updatePageFormat(PageFormat pageFormat) {
        PageFormat pageFormat2 = null;
        int n2 = this.getFullPageCount();
        pageFormat2 = super.updatePageFormat(pageFormat);
        if (this.d()) {
            this.getOverviewPrintable().setRequestedColumnCount(this.b());
        }
        this.computeFullLayoutSize();
        this.a(this.getGraphics(), n2);
        return pageFormat2;
    }

    protected PageFormat updatePageFormat(PrintRequestAttributeSet printRequestAttributeSet) {
        PageFormat pageFormat = null;
        int n2 = this.getFullPageCount();
        pageFormat = super.updatePageFormat(printRequestAttributeSet);
        if (this.d()) {
            this.getOverviewPrintable().setRequestedColumnCount(this.b());
        }
        this.computeFullLayoutSize();
        this.a(this.getGraphics(), n2);
        return pageFormat;
    }

    private int b() {
        double d2 = this.getVisibleRect().getWidth();
        float f2 = 0.0f;
        int n2 = 0;
        f2 = (int)((double)this.getZoomFactor() * this.PAGE_FORMAT.getWidth() + 9.0);
        n2 = (int)((d2 - 7.0) / (double)f2);
        if (n2 < 1) {
            n2 = 1;
        }
        return n2;
    }

    private boolean d() {
        return this.l;
    }

    private void a(Graphics2D graphics2D, Printable printable, float f2, int n2, int n3, int n4) {
        PageFormat pageFormat = this.PAGE_FORMAT;
        this.paintScaledPage(graphics2D, n2, n3);
        try {
            graphics2D.setColor(Color.BLACK);
            graphics2D.scale(f2, f2);
            printable.print(graphics2D, pageFormat, n4);
        }
        catch (Throwable throwable) {
            this.setOverviewPrintable(new AbstractPageImageDisplayPanel.NothingPrintable());
            this.handlePreviewException(throwable);
        }
    }

    private void b(boolean bl) {
        this.l = bl;
    }

    private void a(Graphics graphics, int n2) {
        q q2 = this.getOverviewPrintable();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (graphics == null) {
            return;
        }
        n3 = q2.computePageCount(this.PAGE_FORMAT);
        if (q2.WRAPPED_PRINTABLE instanceof ResetablePrintable || q2.WRAPPED_PRINTABLE instanceof PageCountPrintable) {
            n5 = this.getFirstPageIndex();
            n4 = this.getLastPageIndex();
            if (n4 == 9999 || n5 == 0 && n4 == n2 - 1) {
                if (n3 <= 0) {
                    this.setPageIndexRange(-1, -1);
                } else {
                    this.setPageIndexRange(0, n3 - 1);
                }
            } else {
                if (n4 >= n3) {
                    n4 = n3 - 1;
                }
                if (n5 >= n3) {
                    n5 = 0;
                }
                q2.reset();
                q2.computePageCount(this.PAGE_FORMAT);
                this.setPageIndexRange(n5, n4);
            }
        } else {
            this.setPageIndexRange(0, n3 - 1);
        }
    }
}

