/*
 * Decompiled with CFR 0.152.
 */
package jpdf.gui.preview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.util.Locale;
import javax.print.attribute.PrintRequestAttributeSet;
import jpdf.gui.preview.A;
import jpdf.gui.preview.AbstractOverviewPanel;
import jpdf.gui.preview.PreviewGraphicsCustomizer;
import jpdf.printable.AttributeSetPrintable;
import jpdf.utility.PrintUtility;

public class PageableOverviewPanel
extends AbstractOverviewPanel {
    private final Dimension u = new Dimension();
    private final Dimension k = new Dimension();
    private final Color g = Color.BLUE;
    private final Stroke w = new BasicStroke(3.0f);
    private PageSelectionObserver y = null;
    private Pageable l = null;
    private int m = 0;
    private int v = 0;
    private int a = 0;
    private int x = 0;

    public PageableOverviewPanel(Locale locale, Pageable pageable) {
        this(locale, pageable, 0);
    }

    public PageableOverviewPanel(Locale locale, Pageable pageable, int n2) {
        super(locale);
        this.a(pageable, n2);
    }

    public int getFixedColumnCount() {
        return this.x;
    }

    public PageSelectionObserver getPageSelectionObserver() {
        return this.y;
    }

    public void paint(Graphics graphics) {
        if (!this.c()) {
            return;
        }
        super.paint(graphics);
        if (!this.isPleaseWaitMessageDisplayed() && this.isToPaintImage()) {
            this.a((Graphics2D)graphics);
        }
    }

    public boolean requestFixedColumnCount(int n2) {
        this.setRequestedFixedColumnCount(n2);
        this.d();
        this.refreshDisplay();
        return true;
    }

    public void selectPage(int n2) {
        Dimension dimension = this.computeLayoutSize();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.getFirstPageIndex();
        int n8 = this.getLastPageIndex();
        if (dimension.height > 1) {
            n3 = n7 % dimension.width;
        }
        if (n2 < n7 || n2 > n8) {
            n5 = 0;
            n6 = n3;
            n2 = n7;
        } else {
            n4 = n3 + (n2 - n7);
            n5 = (int)((float)n4 / (float)dimension.width);
            n6 = n4 % dimension.width;
        }
        this.a(n2, n5, n6);
    }

    public void setPageSelectionObserver(PageSelectionObserver pageSelectionObserver) {
        Pageable pageable = null;
        int n2 = 0;
        this.y = pageSelectionObserver;
        if (pageSelectionObserver != null) {
            n2 = this.getSelectedPageIndex();
            pageable = this.getOverviewPageable();
            pageSelectionObserver.selectedPage(n2, pageable.getPageFormat(n2), pageable.getPrintable(n2));
        }
    }

    public void setRequestedFixedColumnCount(int n2) {
        this.x = n2;
    }

    protected Dimension computeFullLayoutSize() {
        return this.u;
    }

    protected Dimension computeOverviewPagesSize(Dimension dimension) {
        Dimension dimension2 = new Dimension();
        Pageable pageable = this.getOverviewPageable();
        int n2 = this.getLastPageIndex();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = (int)this.PAGE_FORMAT.getWidth();
        int n7 = (int)this.PAGE_FORMAT.getHeight();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        dimension2.width = n6 * dimension.width;
        dimension2.height = n7 * dimension.height;
        if (dimension.height == 1 && dimension.width == 1) {
            return dimension2;
        }
        if (dimension.height == 1) {
            n10 = (int)pageable.getPageFormat(n2).getWidth();
            dimension2.width -= n6 - n10;
        } else if (dimension.width == 1) {
            n11 = (int)pageable.getPageFormat(n2).getHeight();
            dimension2.height -= n7 - n11;
        } else {
            n4 = this.getFirstPageIndex() / this.u.width;
            n5 = n2 / this.u.width;
            for (n3 = dimension.width * (n4 + 1) - 1; n3 <= n2; n3 += dimension.width) {
                n10 = (int)pageable.getPageFormat(n3).getWidth();
                if (n10 <= n8) continue;
                n8 = n10;
            }
            dimension2.width -= n6 - n8;
            for (n3 = dimension.width * n5; n3 <= n2; ++n3) {
                n11 = (int)pageable.getPageFormat(n3).getHeight();
                if (n11 <= n9) continue;
                n9 = n11;
            }
            dimension2.height -= n7 - n9;
        }
        return dimension2;
    }

    protected Image createOverviewImage(Graphics2D graphics2D) {
        Image image = super.createOverviewImage(graphics2D);
        this.f();
        return image;
    }

    protected Dimension getFullLayoutSize() {
        return this.u;
    }

    protected int getFullPageCount() {
        return this.getOverviewPageable().getNumberOfPages();
    }

    protected int getSelectedPageIndex() {
        return this.m;
    }

    protected Pageable getOverviewPageable() {
        return this.l;
    }

    protected boolean handleContainerResize() {
        boolean bl = false;
        if (this.getFixedColumnCount() < 1) {
            bl = this.b();
        }
        if (bl) {
            this.refreshDisplay();
        }
        return bl;
    }

    protected void paintOverviewPageImage(Graphics2D graphics2D, int n2, int n3, int n4) {
        Pageable pageable = this.getOverviewPageable();
        Printable printable = pageable.getPrintable(n4);
        this.setPageFormat(pageable.getPageFormat(n4));
        graphics2D = this.prepareImageGraphics(graphics2D, printable, n2, n3);
        this.a(graphics2D, printable, this.getZoomFactor(), 7, 7, n4);
    }

    protected void paintOverviewPageRangeImage(Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Graphics2D graphics2D2 = null;
        Rectangle rectangle = graphics2D.getClipBounds();
        Pageable pageable = this.getOverviewPageable();
        Printable printable = null;
        Stroke stroke = graphics2D.getStroke();
        float f2 = this.getZoomFactor();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 7;
        int n11 = 0;
        int n12 = 0;
        n7 = (int)(f2 * (float)this.k.width);
        n8 = (int)(f2 * (float)this.k.height);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n2, n3);
        n11 = n4 / this.u.width;
        n12 = n5 == 9999 ? this.u.height - 1 : n5 / this.u.width;
        n6 = n11 * this.u.width;
        for (int i2 = n11; i2 <= n12; ++i2) {
            n9 = 7;
            for (int i3 = 0; i3 < this.u.width; ++i3) {
                if (n6 >= n4 && n6 <= n5) {
                    graphics2D.setStroke(stroke);
                    graphics2D.setClip(rectangle);
                    graphics2D.setTransform(affineTransform);
                    printable = pageable.getPrintable(n6);
                    graphics2D2 = printable instanceof PreviewGraphicsCustomizer ? ((PreviewGraphicsCustomizer)((Object)printable)).customizePreviewGraphics(graphics2D) : graphics2D;
                    this.setPageFormat(pageable.getPageFormat(n6));
                    this.a(graphics2D2, printable, f2, n9, n10, n6);
                }
                ++n6;
                n9 += n7 + 9;
            }
            n10 += n8 + 9;
        }
    }

    protected void paintOverviewPageRowImage(Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Graphics2D graphics2D2 = null;
        Rectangle rectangle = graphics2D.getClipBounds();
        Pageable pageable = this.getOverviewPageable();
        Printable printable = null;
        Stroke stroke = graphics2D.getStroke();
        float f2 = this.getZoomFactor();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 7;
        int n10 = 0;
        n7 = (int)(f2 * (float)this.k.width);
        n8 = (int)(f2 * (float)this.k.height);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n2, n3);
        n10 = n4 / this.u.width;
        n6 = n10 * this.u.width;
        for (int i2 = 0; i2 < this.u.width; ++i2) {
            if (n6 >= n4 && n6 <= n5) {
                graphics2D.setStroke(stroke);
                graphics2D.setClip(rectangle);
                graphics2D.setTransform(affineTransform);
                printable = pageable.getPrintable(n6);
                graphics2D2 = printable instanceof PreviewGraphicsCustomizer ? ((PreviewGraphicsCustomizer)((Object)printable)).customizePreviewGraphics(graphics2D) : graphics2D;
                this.setPageFormat(pageable.getPageFormat(n6));
                this.a(graphics2D2, printable, f2, n9, 7, n6);
                n9 += n7 + 9;
            }
            ++n6;
        }
    }

    protected boolean setPageIndexRange(int n2, int n3, float f2) {
        Pageable pageable = this.getOverviewPageable();
        boolean bl = false;
        this.setZoomFactor(f2);
        if (this.getFixedColumnCount() < 1) {
            this.b(pageable, n2, n3);
        } else {
            this.a(pageable, n2, n3);
        }
        bl = super.setPageIndexRange(n2, n3, f2);
        this.selectPage(this.getSelectedPageIndex());
        return bl;
    }

    protected boolean setPageIndexRange(int n2, int n3, float f2, float f3) {
        boolean bl = false;
        this.a(this.getOverviewPageable(), n2, n3);
        bl = super.setPageIndexRange(n2, n3, f2, f3);
        this.selectPage(this.getSelectedPageIndex());
        return bl;
    }

    protected PageFormat updatePageFormat(PrintRequestAttributeSet printRequestAttributeSet) {
        Pageable pageable = this.getOverviewPageable();
        Printable printable = null;
        PageFormat pageFormat = null;
        int n2 = 0;
        this.b(pageable);
        n2 = this.getSelectedPageIndex();
        pageFormat = pageable.getPageFormat(n2);
        PrintUtility.updatePageFormat(printRequestAttributeSet, pageFormat);
        if (this.getFixedColumnCount() < 1) {
            this.b(pageable, this.getFirstPageIndex(), this.getLastPageIndex());
        } else {
            this.a(pageable, this.getFirstPageIndex(), this.getLastPageIndex());
        }
        printable = pageable.getPrintable(n2);
        if (printable instanceof AttributeSetPrintable) {
            ((AttributeSetPrintable)printable).setAttributeSet(printRequestAttributeSet);
        }
        this.refreshDisplay();
        return pageFormat;
    }

    private boolean b() {
        boolean bl = false;
        double d2 = this.getVisibleRect().getWidth();
        float f2 = this.getZoomFactor();
        float f3 = (float)this.k.width * f2 + 9.0f;
        int n2 = 0;
        int n3 = 0;
        n2 = (int)(d2 / (double)f3);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 != this.u.width) {
            n3 = this.getOverviewPageable().getNumberOfPages();
            this.a(n2, (int)(((float)n3 - 1.0f) / (float)n2) + 1);
            this.setZoomFactorResize(f2, true);
            this.selectPage(this.getSelectedPageIndex());
            bl = true;
        }
        return bl;
    }

    private int h() {
        return this.a;
    }

    private int j() {
        return this.v;
    }

    private boolean b(Pageable pageable) {
        boolean bl = false;
        int n2 = pageable.getNumberOfPages();
        int n3 = this.getFirstPageIndex();
        int n4 = this.getLastPageIndex();
        int n5 = this.getSelectedPageIndex();
        int n6 = 0;
        int n7 = 0;
        if (n4 >= n2) {
            n6 = n4 - n2 + 1;
            if ((n3 -= n6) < 0) {
                n3 = 0;
            }
            this.setPageIndexRange(n3, n4 -= n6);
            this.d();
            if (n5 >= n2) {
                n5 = n2 - 1;
                this.selectPage(n5);
            }
            bl = true;
        } else {
            n7 = this.u.width * this.u.height;
            if (n2 > n7 || n2 <= n7 - this.u.width) {
                this.d();
                bl = true;
            }
        }
        return bl;
    }

    private void a(Pageable pageable, int n2) {
        int n3 = pageable.getNumberOfPages();
        int n4 = n3 - 1;
        this.a(pageable);
        this.requestFixedColumnCount(n2);
        if (n2 < 1) {
            this.a(1, n3);
        } else {
            this.a(n2, (int)(((float)n3 - 1.0f) / (float)n2) + 1);
        }
        this.setPageIndexRange(0, n4);
        this.a(pageable, 0, n4);
        this.addMouseListener(new A(this, null));
    }

    private void a(Graphics2D graphics2D) {
        PageFormat pageFormat = this.getOverviewPageable().getPageFormat(this.getSelectedPageIndex());
        float f2 = this.getZoomFactor();
        int n2 = this.j();
        int n3 = this.h();
        int n4 = 0;
        int n5 = 0;
        int n6 = 3;
        int n7 = 0;
        int n8 = 0;
        graphics2D.setColor(this.g);
        graphics2D.setStroke(this.w);
        n7 = (int)((float)(n3 * this.k.width) * f2) + n6 + n3 * 9;
        n8 = (int)((float)(n2 * this.k.height) * f2) + n6 + n2 * 9;
        n4 = (int)(pageFormat.getWidth() * (double)f2) + 8;
        n5 = (int)(pageFormat.getHeight() * (double)f2) + 8;
        graphics2D.drawRect(n7, n8, n4, n5);
    }

    private void a(Graphics2D graphics2D, Printable printable, float f2, int n2, int n3, int n4) {
        this.paintScaledPage(graphics2D, n2, n3);
        try {
            graphics2D.setColor(Color.BLACK);
            graphics2D.scale(f2, f2);
            printable.print(graphics2D, this.PAGE_FORMAT, n4);
        }
        catch (Throwable throwable) {
            this.handlePreviewException(throwable);
        }
    }

    private void a(int n2, int n3) {
        this.u.width = n2;
        this.u.height = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(int n2, int n3, int n4) {
        PageSelectionObserver pageSelectionObserver = this.getPageSelectionObserver();
        Pageable pageable = null;
        PageableOverviewPanel pageableOverviewPanel = this;
        synchronized (pageableOverviewPanel) {
            this.m = n2;
            this.v = n3;
            this.a = n4;
        }
        if (pageSelectionObserver != null) {
            pageable = this.getOverviewPageable();
            pageSelectionObserver.selectedPage(n2, pageable.getPageFormat(n2), pageable.getPrintable(n2));
        }
        this.repaint();
    }

    private void a(Pageable pageable) {
        this.displayWaitCursor();
        this.l = pageable;
    }

    private void f() {
        Paper paper = new Paper();
        paper.setSize(this.k.width, this.k.height);
        this.PAGE_FORMAT.setPaper(paper);
        this.PAGE_FORMAT.setOrientation(1);
    }

    private void d() {
        int n2 = this.getFixedColumnCount();
        if (n2 > 0) {
            this.a(n2, (int)(((float)this.getFullPageCount() - 1.0f) / (float)n2) + 1);
            this.selectPage(this.getSelectedPageIndex());
        } else {
            this.b();
        }
    }

    private void a(Pageable pageable, int n2, int n3) {
        PageFormat pageFormat = null;
        int n4 = this.k.width;
        int n5 = pageable.getNumberOfPages();
        int n6 = 0;
        int n7 = 0;
        this.k.width = 0;
        this.k.height = 0;
        if (n3 >= n5) {
            n3 = n5 - 1;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            pageFormat = pageable.getPageFormat(i2);
            n6 = (int)pageFormat.getWidth();
            n7 = (int)pageFormat.getHeight();
            if (n6 > this.k.width) {
                this.k.width = n6;
            }
            if (n7 <= this.k.height) continue;
            this.k.height = n7;
        }
        this.f();
        if (this.getFixedColumnCount() < 1 && this.k.width != n4) {
            this.b();
        }
    }

    private void b(Pageable pageable, int n2, int n3) {
        if (n2 == n3) {
            this.a(pageable, n2, n3);
        } else if (this.isSinglePageDisplay()) {
            this.a(pageable, 0, pageable.getNumberOfPages() - 1);
        }
    }

    static Dimension a(PageableOverviewPanel pageableOverviewPanel) {
        return pageableOverviewPanel.k;
    }

    static void a(PageableOverviewPanel pageableOverviewPanel, int n2, int n3, int n4) {
        pageableOverviewPanel.a(n2, n3, n4);
    }

    public static interface PageSelectionObserver {
        public void selectedPage(int var1, PageFormat var2, Printable var3);
    }
}

