/*
 * Decompiled with CFR 0.152.
 */
package jpdf.gui.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import jpdf.gui.AbstractPrintOptionsPanel;
import jpdf.gui.InitializableDisplay;
import jpdf.gui.PrintInfoHolder;
import jpdf.gui.UpdatableDisplay;
import jpdf.gui.controller.PageOrientationPanel;
import jpdf.gui.controller.PageSizePanel;
import jpdf.gui.preview.AbstractPageImageDisplayPanel;
import jpdf.gui.preview.D;
import jpdf.gui.preview.L;
import jpdf.gui.preview.k;
import jpdf.gui.preview.w;
import jpdf.manage.ResourceAdministrator;
import jpdf.printable.AttributeSetPrintable;
import jpdf.utility.PrintUtility;
import jpdf_common.gui.layout.RowLayout;
import jpdf_common.gui.mouse.ScrollPaneMouseDragger;
import jpdf_common.system.manage.BasicResourceManager;

public abstract class AbstractViewControlPanel
extends AbstractPrintOptionsPanel
implements InitializableDisplay,
UpdatableDisplay {
    private static final Dimension d = new Dimension(8, 16);
    private static boolean e = true;
    private PrintInfoHolder b = null;
    private JLabel a = null;

    public AbstractViewControlPanel(String string) {
        super(string);
    }

    public void addToolBarComponent(JComponent jComponent, boolean bl, boolean bl2) {
        ToolBarPanel toolBarPanel = this.getToolBarPanel();
        if (toolBarPanel != null) {
            if (bl) {
                AbstractViewControlPanel.addToolBarSeparator(this.getLastToolBarComponent(toolBarPanel));
            }
            toolBarPanel.add(jComponent);
            if (bl2) {
                toolBarPanel.add(new JSeparator(0));
            }
        }
    }

    public void addToolBarComponent(JComponent jComponent, boolean bl, boolean bl2, int n2) {
        ToolBarPanel toolBarPanel = this.getToolBarPanel();
        int n3 = 0;
        if (toolBarPanel == null) {
            return;
        }
        n3 = toolBarPanel.getComponentCount() - 1;
        if (n2 > n3) {
            this.addToolBarComponent(jComponent, bl, bl2);
            return;
        }
        if (n2 < 0 && (n2 = n3 + 1 + n2) < 0) {
            n2 = 0;
        }
        if (bl) {
            AbstractViewControlPanel.addToolBarSeparator(jComponent);
        }
        toolBarPanel.add((Component)jComponent, n2);
        if (bl2) {
            toolBarPanel.add((Component)new JSeparator(0), n2 + 1);
        }
    }

    public void initializeDisplay() {
    }

    public void initializePrintOptions(PrintInfoHolder printInfoHolder) {
        this.setPrintInfoHolder(printInfoHolder);
    }

    public static boolean isPageNavigationAudible() {
        return e;
    }

    public void setBackground(Color color) {
        AbstractPageImageDisplayPanel abstractPageImageDisplayPanel = this.getPageImageDisplayPanel();
        super.setBackground(color);
        if (abstractPageImageDisplayPanel != null) {
            abstractPageImageDisplayPanel.setBackground(color);
        }
    }

    public static void setPageNavigationAudible(boolean bl) {
        e = bl;
    }

    public boolean updatePrintOptions(PrintInfoHolder printInfoHolder) {
        return true;
    }

    protected static void addToolBarSeparator(JComponent jComponent) {
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setPreferredSize(d);
        jComponent.add(jSeparator);
    }

    protected static String computeMediaSizeString(PageFormat pageFormat) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = ResourceAdministrator.getMediaSizeUnits();
        if (n2 == 25400) {
            f2 = (float)(pageFormat.getWidth() / 72.0);
            f3 = (float)(pageFormat.getHeight() / 72.0);
        } else {
            f2 = (float)(pageFormat.getWidth() / 2.8346456);
            f3 = (float)(pageFormat.getHeight() / 2.8346456);
        }
        return ResourceAdministrator.formMediaSizeString(f2, f3);
    }

    protected static String computeMediaSizeString(PrintRequestAttributeSet printRequestAttributeSet) {
        MediaSize mediaSize = PrintUtility.getMediaSize(printRequestAttributeSet);
        boolean bl = PageOrientationPanel.isLandscape(printRequestAttributeSet);
        return ResourceAdministrator.getMediaSizeString(mediaSize, bl, true);
    }

    protected JScrollPane createDisplayScrollPane(AbstractPageImageDisplayPanel abstractPageImageDisplayPanel) {
        JScrollPane jScrollPane = new JScrollPane(abstractPageImageDisplayPanel);
        AbstractAction abstractAction = null;
        InputMap inputMap = jScrollPane.getInputMap(2);
        ActionMap actionMap = jScrollPane.getActionMap();
        String string = null;
        jScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        string = "arrowDown";
        inputMap.put(KeyStroke.getKeyStroke(40, 0), string);
        abstractAction = new w(this, string, jScrollPane);
        actionMap.put(string, abstractAction);
        string = "arrowUp";
        inputMap.put(KeyStroke.getKeyStroke(38, 0), string);
        abstractAction = new k(this, string, jScrollPane);
        actionMap.put(string, abstractAction);
        string = "arrowRight";
        inputMap.put(KeyStroke.getKeyStroke(39, 0), string);
        abstractAction = new L(this, string, jScrollPane);
        actionMap.put(string, abstractAction);
        string = "arrowLeft";
        inputMap.put(KeyStroke.getKeyStroke(37, 0), string);
        abstractAction = new D(this, string, jScrollPane);
        actionMap.put(string, abstractAction);
        ScrollPaneMouseDragger.makeDraggable(jScrollPane);
        return jScrollPane;
    }

    protected JLabel createMediaLabel(int n2) {
        this.a = new JLabel();
        this.a.setHorizontalAlignment(n2);
        return this.a;
    }

    protected JScrollPane getDisplayScrollPane() {
        return (JScrollPane)this.getPageImageDisplayPanel().getParent().getParent();
    }

    protected Throwable getLastPreviewException() {
        return this.getPageImageDisplayPanel().getLastPreviewException();
    }

    protected JComponent getLastToolBarComponent(ToolBarPanel toolBarPanel) {
        Component[] componentArray = toolBarPanel.getComponents();
        JComponent jComponent = null;
        for (int i2 = componentArray.length - 1; i2 >= 0; --i2) {
            if (componentArray[i2] instanceof JSeparator) continue;
            jComponent = (JComponent)componentArray[i2];
            break;
        }
        return jComponent;
    }

    protected abstract AbstractPageImageDisplayPanel getPageImageDisplayPanel();

    protected JLabel getMediaLabel() {
        return this.a;
    }

    protected PrintRequestAttributeSet getPageFormatAttributeSet(Printable printable, PageFormat pageFormat) {
        PrintRequestAttributeSet printRequestAttributeSet = null;
        if (printable instanceof AttributeSetPrintable) {
            printRequestAttributeSet = ((AttributeSetPrintable)printable).getAttributeSet();
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = this.getPrintInfoHolder().getAttributeSet();
            PrintUtility.updateAttributeSet(pageFormat, printRequestAttributeSet, false);
        }
        return printRequestAttributeSet;
    }

    protected PrintInfoHolder getPrintInfoHolder() {
        return this.b;
    }

    protected abstract Printable getTargetPrintable();

    protected ToolBarPanel getToolBarPanel() {
        Component[] componentArray = this.getComponents();
        ToolBarPanel toolBarPanel = null;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (!(componentArray[i2] instanceof ToolBarPanel)) continue;
            toolBarPanel = (ToolBarPanel)componentArray[i2];
            break;
        }
        return toolBarPanel;
    }

    protected void navigatedPage() {
        this.a(true);
    }

    protected void navigateToNext() {
    }

    protected void navigateToPrevious() {
    }

    protected void scrollDisplayToOrigin() {
        JScrollPane jScrollPane = this.getDisplayScrollPane();
        jScrollPane.getHorizontalScrollBar().setValue(0);
        jScrollPane.getVerticalScrollBar().setValue(0);
    }

    protected void setPrintInfoHolder(PrintInfoHolder printInfoHolder) {
        this.b = printInfoHolder;
    }

    protected void setToCloseWindowOnPreviewException(boolean bl) {
        this.getPageImageDisplayPanel().setToCloseWindowOnException(bl);
    }

    protected void updateMediaLabel(PageFormat pageFormat) {
        MediaSizeName mediaSizeName = PrintUtility.lookupMediaSizeName(pageFormat);
        String string = null;
        string = ResourceAdministrator.getMediaSizeName(mediaSizeName) + " - " + AbstractViewControlPanel.computeMediaSizeString(pageFormat);
        this.getMediaLabel().setText(string);
    }

    protected void updateMediaLabel(PrintRequestAttributeSet printRequestAttributeSet) {
        String string = null;
        string = PageSizePanel.getMediaSizeDisplayName(printRequestAttributeSet) + " - " + AbstractViewControlPanel.computeMediaSizeString(printRequestAttributeSet);
        this.getMediaLabel().setText(string);
    }

    protected static JPanel wrapToolBarComponent(JComponent jComponent, int n2) {
        JPanel jPanel = new JPanel(new RowLayout(2, n2));
        jPanel.add(jComponent);
        return jPanel;
    }

    void a(boolean bl) {
        if (bl && AbstractViewControlPanel.isPageNavigationAudible()) {
            BasicResourceManager.playPageTurn();
        }
        this.scrollDisplayToOrigin();
    }

    protected static class ToolBarPanel
    extends JPanel {
        public ToolBarPanel() {
        }

        public ToolBarPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }
    }
}

