/*
 * Decompiled with CFR 0.152.
 */
package jpdf.gui.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jpdf.gui.component.PageNavigationPanel;
import jpdf.gui.preview.AbstractPageImageDisplayPanel;
import jpdf.gui.preview.AbstractViewControlPanel;
import jpdf.gui.preview.I;
import jpdf.gui.preview.PrintablePreviewPanel;
import jpdf.gui.preview.f;
import jpdf.gui.preview.o;
import jpdf.gui.preview.u;
import jpdf.manage.PrintManager;
import jpdf.manage.ResourceAdministrator;
import jpdf_common.gui.component.combo.PercentageInputComboBox;
import jpdf_common.gui.layout.DividingFlowLayout;
import jpdf_common.gui.layout.RowLayout;
import jpdf_common.system.manage.BasicResourceManager;

public abstract class AbstractPreviewControlPanel
extends AbstractViewControlPanel
implements PageNavigationPanel.PageNavigable {
    protected static final float MINIMUM_ZOOM_FACTOR = 0.1f;
    protected static final float MAXIMUM_ZOOM_FACTOR = 4.0f;
    protected static final float[] DEFAULT_ZOOM_VALUE_LIST = new float[]{0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f};
    private static float f = 4.0f;
    protected final FitRadioBotton FIT_RADIO_BUTTON;
    protected final ZoomRadioBotton ZOOM_RADIO_BUTTON;
    protected final ShowMarginsCheckBox SHOW_MARGINS_CHECK_BOX;
    protected final ShowSizeCheckBox SHOW_SIZE_CHECK_BOX;
    protected final GrayScaleCheckBox GRAY_SCALE_CHECK_BOX;
    private PrintablePreviewPanel g = null;
    private ZoomPercentageComboBox h = null;
    private PageNavigationPanel c = null;

    public AbstractPreviewControlPanel(boolean bl) {
        this("Preview", bl);
    }

    public AbstractPreviewControlPanel(Locale locale, boolean bl) {
        super(ResourceAdministrator.getLocalizedString("preview"));
        this.FIT_RADIO_BUTTON = new FitRadioBotton(this, locale, null);
        this.ZOOM_RADIO_BUTTON = new ZoomRadioBotton(this, locale, null);
        this.SHOW_MARGINS_CHECK_BOX = new ShowMarginsCheckBox(this, locale, null);
        this.SHOW_SIZE_CHECK_BOX = new ShowSizeCheckBox(this, locale, null);
        this.GRAY_SCALE_CHECK_BOX = new GrayScaleCheckBox(this, locale, null);
        this.a(locale, bl);
    }

    public AbstractPreviewControlPanel(String string, boolean bl) {
        super(string);
        this.FIT_RADIO_BUTTON = new FitRadioBotton(this, null);
        this.ZOOM_RADIO_BUTTON = new ZoomRadioBotton(this, null);
        this.SHOW_MARGINS_CHECK_BOX = new ShowMarginsCheckBox(this, null);
        this.SHOW_SIZE_CHECK_BOX = new ShowSizeCheckBox(this, null);
        this.GRAY_SCALE_CHECK_BOX = new GrayScaleCheckBox(this, null);
        this.a(null, bl);
    }

    public void addDisplayOptionToolBarComponent(JComponent jComponent) {
        JPanel jPanel = (JPanel)this.SHOW_MARGINS_CHECK_BOX.getParent();
        int n2 = jPanel.getComponentCount();
        jPanel.add((Component)jComponent, n2 - 1);
    }

    public BufferedImage createPageImage(int n2) {
        return this.getDisplayPanel().a(n2);
    }

    public static float getMaximumFitZoomFactor() {
        return f;
    }

    public void initializeDisplay() {
        this.updateDisplay();
        if (this.FIT_RADIO_BUTTON.isSelected()) {
            this.FIT_RADIO_BUTTON.actionPerformed(null);
        }
        if (this.SHOW_SIZE_CHECK_BOX.isSelected()) {
            this.SHOW_SIZE_CHECK_BOX.actionPerformed(null);
        }
        this.getDisplayPanel().a();
    }

    public void setControlState() {
        this.setControlState(new ControlState());
    }

    public void setControlState(ControlState controlState) {
        ZoomPercentageComboBox zoomPercentageComboBox = null;
        this.SHOW_MARGINS_CHECK_BOX.setSelected(controlState.highlightingMargins);
        this.SHOW_MARGINS_CHECK_BOX.actionPerformed(null);
        this.SHOW_SIZE_CHECK_BOX.setSelected(controlState.displayingSize);
        this.SHOW_SIZE_CHECK_BOX.actionPerformed(null);
        this.GRAY_SCALE_CHECK_BOX.setSelected(controlState.grayScaleImages);
        this.GRAY_SCALE_CHECK_BOX.actionPerformed(null);
        if (this.isZooomingEnabled()) {
            this.FIT_RADIO_BUTTON.setSelected(controlState.zoomedToFit);
            this.ZOOM_RADIO_BUTTON.setSelected(!controlState.zoomedToFit);
            if (!controlState.zoomedToFit) {
                zoomPercentageComboBox = this.getZoomPercentageComboBox();
                zoomPercentageComboBox.setEnabled(true);
                zoomPercentageComboBox.setValue(controlState.zoomFactor);
            }
        }
    }

    public static void setMaximumFitZoomFactor(float f2) {
        if (f2 > 0.1f && f2 <= 4.0f) {
            f = f2;
        } else {
            String string = "Invalid Maximum Fit Zoom Factor: " + f2 + "\nMust be between " + 0.1f + " and " + 4.0f + ".";
            PrintManager.handleException(new Exception(string));
        }
    }

    public void storeControlState(ControlState controlState) {
        controlState.highlightingMargins = this.SHOW_MARGINS_CHECK_BOX.isSelected();
        controlState.grayScaleImages = this.GRAY_SCALE_CHECK_BOX.isSelected();
        controlState.displayingSize = this.SHOW_SIZE_CHECK_BOX.isSelected();
        if (this.isZooomingEnabled()) {
            controlState.zoomedToFit = this.FIT_RADIO_BUTTON.isSelected();
            controlState.zoomFactor = this.getZoomPercentageComboBox().getValue();
        }
    }

    protected PrintablePreviewPanel getDisplayPanel() {
        return this.g;
    }

    protected AbstractPageImageDisplayPanel getPageImageDisplayPanel() {
        return this.g;
    }

    protected PageNavigationPanel getPageNavigationPanel() {
        return this.c;
    }

    protected ZoomPercentageComboBox getZoomPercentageComboBox() {
        return this.h;
    }

    protected boolean isZooomingEnabled() {
        return this.FIT_RADIO_BUTTON.isEnabled();
    }

    protected void navigateToNext() {
        int n2 = this.getCurrentPageIndex();
        if (n2 < this.getPageCount() - 1) {
            this.navigateToPage(n2 + 1);
        } else {
            BasicResourceManager.beep();
        }
    }

    protected void navigateToPrevious() {
        int n2 = this.getCurrentPageIndex();
        if (n2 > 0) {
            this.navigateToPage(n2 - 1);
        } else {
            BasicResourceManager.beep();
        }
    }

    protected void setZooomingEnabled(boolean bl) {
        ZoomPercentageComboBox zoomPercentageComboBox = this.getZoomPercentageComboBox();
        zoomPercentageComboBox.setEnabled(bl);
        this.FIT_RADIO_BUTTON.setEnabled(bl);
        this.ZOOM_RADIO_BUTTON.setEnabled(bl);
        if (!bl) {
            this.ZOOM_RADIO_BUTTON.setSelected(true);
            zoomPercentageComboBox.setValue(1.0f);
        }
        this.getDisplayPanel().setToUseFractionalMetrics(bl);
    }

    protected void updateDisplayPanelSize() {
        PrintablePreviewPanel printablePreviewPanel = this.getDisplayPanel();
        printablePreviewPanel.setZoomFactorResize(printablePreviewPanel.getZoomFactor(), true);
    }

    protected void zoomDisplayToFit() {
        ZoomPercentageComboBox zoomPercentageComboBox = this.getZoomPercentageComboBox();
        PrintablePreviewPanel printablePreviewPanel = this.getDisplayPanel();
        float f2 = zoomPercentageComboBox.getMinimumValue();
        float f3 = zoomPercentageComboBox.getMaximumValue();
        float f4 = AbstractPreviewControlPanel.getMaximumFitZoomFactor();
        float f5 = 0.0f;
        if (f3 < f4) {
            f4 = f3;
        }
        f5 = printablePreviewPanel.setZoomFactorToFit(f2, f4);
        printablePreviewPanel.repaint();
        if (f5 > 0.0f) {
            zoomPercentageComboBox.setSelectedItem(new Float(f5));
        }
    }

    private JPanel d(Locale locale) {
        JPanel jPanel = new JPanel(new RowLayout(2, 2));
        jPanel.add(this.SHOW_MARGINS_CHECK_BOX);
        jPanel.add(this.SHOW_SIZE_CHECK_BOX);
        jPanel.add(this.GRAY_SCALE_CHECK_BOX);
        AbstractPreviewControlPanel.addToolBarSeparator(jPanel);
        return jPanel;
    }

    private PrintablePreviewPanel a() {
        this.g = new PrintablePreviewPanel();
        return this.g;
    }

    private PageNavigationPanel a(Locale locale) {
        this.c = new PageNavigationPanel(this, locale);
        return this.c;
    }

    private AbstractViewControlPanel.ToolBarPanel c(Locale locale) {
        PageNavigationPanel pageNavigationPanel = this.a(locale);
        PreviewToolBarPanel previewToolBarPanel = null;
        previewToolBarPanel = new PreviewToolBarPanel(new DividingFlowLayout(0, 0, 10));
        previewToolBarPanel.add(this.f(locale));
        previewToolBarPanel.add(new JSeparator(0));
        previewToolBarPanel.add(this.d(locale));
        previewToolBarPanel.add(new JSeparator(0));
        if (pageNavigationPanel != null) {
            previewToolBarPanel.add(pageNavigationPanel);
            previewToolBarPanel.add(new JSeparator(0));
        }
        return previewToolBarPanel;
    }

    private JPanel f(Locale locale) {
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel(new RowLayout(2, 2));
        buttonGroup.add(this.FIT_RADIO_BUTTON);
        jPanel.add(this.FIT_RADIO_BUTTON);
        buttonGroup.add(this.ZOOM_RADIO_BUTTON);
        jPanel.add(this.ZOOM_RADIO_BUTTON);
        jPanel.add(this.e(locale).createContainingSpinnerPanel(0.1f));
        AbstractPreviewControlPanel.addToolBarSeparator(jPanel);
        return jPanel;
    }

    private ZoomPercentageComboBox e(Locale locale) {
        this.h = new ZoomPercentageComboBox(this, locale);
        return this.h;
    }

    private JPanel b(Locale locale) {
        PageNavigationPanel pageNavigationPanel = this.a(locale);
        JPanel jPanel = new JPanel(new BorderLayout());
        pageNavigationPanel.addPageNavigationControls();
        pageNavigationPanel.setPageNavigationButtonsVisible(false);
        jPanel.add((Component)this.createMediaLabel(2), "West");
        jPanel.add((Component)pageNavigationPanel, "East");
        return jPanel;
    }

    private void a(Locale locale, boolean bl) {
        JScrollPane jScrollPane = this.createDisplayScrollPane(this.a());
        this.setLayout(new BorderLayout(7, 7));
        this.setBorder(EMPTY_BORDER);
        if (bl) {
            this.add((Component)this.c(locale), "North");
            this.add((Component)jScrollPane, "Center");
            this.add((Component)this.createMediaLabel(2), "South");
        } else {
            this.e(locale);
            this.add((Component)jScrollPane, "Center");
            this.add((Component)this.b(locale), "South");
        }
        this.addComponentListener(new I(this, null));
    }

    protected class ZoomPercentageComboBox
    extends PercentageInputComboBox {
        private final AbstractPreviewControlPanel b;

        protected ZoomPercentageComboBox(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale) {
            this.b = abstractPreviewControlPanel;
            super(DEFAULT_ZOOM_VALUE_LIST, "Zoom Percentage");
            this.a(locale);
        }

        protected void configureForPageFormat(PageFormat pageFormat) {
            float f2;
            float[] fArray = null;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.1f;
            float f7 = 4.0f;
            float f8 = (float)pageFormat.getWidth();
            float f9 = f8 > (f2 = (float)pageFormat.getHeight()) ? f8 : f2;
            float f10 = 0.1f;
            if (f9 <= 864.0f) {
                f6 = 0.1f;
                f7 = 4.0f;
                fArray = DEFAULT_ZOOM_VALUE_LIST;
            } else if (f9 <= 1800.0f) {
                f6 = 0.1f;
                f7 = 2.0f;
                fArray = DEFAULT_ZOOM_VALUE_LIST;
            } else if (f9 <= 3600.0f) {
                f6 = 0.1f;
                f7 = 1.0f;
                fArray = new float[]{0.1f, 0.25f, 0.5f, 0.75f, 1.0f};
            } else if (f9 <= 7200.0f) {
                f10 = 0.05f;
                f6 = 0.05f;
                f7 = 0.5f;
                fArray = new float[]{0.1f, 0.2f, 0.3f, 0.4f, 0.5f};
            } else {
                f10 = 0.05f;
                f6 = 0.05f;
                f7 = 0.25f;
                fArray = new float[]{0.05f, 0.1f, 0.15f, 0.2f, 0.25f};
            }
            if (f6 != f4 || f7 != f5) {
                f3 = this.getValue();
                this.setValueRange(f6, f7);
                this.setValueList(fArray, true);
                this.setSpinnerIncrement(f10);
                if (f3 < f6) {
                    this.b.getDisplayPanel().setZoomFactor(f6);
                } else if (f3 > f7) {
                    this.b.getDisplayPanel().setZoomFactor(f7);
                }
            }
        }

        private void a(Locale locale) {
            String string = null;
            this.addActionListener(new o(this.b, null));
            this.getEditor().getEditorComponent().addMouseListener(new u(this.b, null));
            this.disablePageNavigationKeyActions();
            if (locale != null) {
                string = ResourceAdministrator.getLocalizedString("zoomPercentage");
                this.setErrorMessageTitle(string);
                string = ResourceAdministrator.getLocalizedString("msg.invalidZoomPercentageRange");
                this.setRangeMessageTemplate(string);
            }
        }
    }

    protected class ZoomRadioBotton
    extends JRadioButton
    implements ActionListener {
        private final AbstractPreviewControlPanel a;

        private ZoomRadioBotton(AbstractPreviewControlPanel abstractPreviewControlPanel) {
            this.a = abstractPreviewControlPanel;
            super("Zoom");
            this.addActionListener(this);
        }

        private ZoomRadioBotton(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale) {
            this.a = abstractPreviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("zoom"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.getZoomPercentageComboBox().setEnabled(true);
            this.a.updateDisplayPanelSize();
        }

        ZoomRadioBotton(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale, f f2) {
            this(abstractPreviewControlPanel, locale);
        }

        ZoomRadioBotton(AbstractPreviewControlPanel abstractPreviewControlPanel, f f2) {
            this(abstractPreviewControlPanel);
        }
    }

    protected class FitRadioBotton
    extends JRadioButton
    implements ActionListener {
        private final AbstractPreviewControlPanel a;

        private FitRadioBotton(AbstractPreviewControlPanel abstractPreviewControlPanel) {
            this.a = abstractPreviewControlPanel;
            super("Fit");
            this.addActionListener(this);
        }

        private FitRadioBotton(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale) {
            this.a = abstractPreviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("fit"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.getZoomPercentageComboBox().setEnabled(false);
            this.a.zoomDisplayToFit();
        }

        FitRadioBotton(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale, f f2) {
            this(abstractPreviewControlPanel, locale);
        }

        FitRadioBotton(AbstractPreviewControlPanel abstractPreviewControlPanel, f f2) {
            this(abstractPreviewControlPanel);
        }
    }

    protected class GrayScaleCheckBox
    extends JCheckBox
    implements ActionListener {
        private final AbstractPreviewControlPanel a;

        private GrayScaleCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel) {
            this.a = abstractPreviewControlPanel;
            super("Grayscale");
            this.setSelected(false);
            this.addActionListener(this);
        }

        private GrayScaleCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale) {
            this.a = abstractPreviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("grayScale"));
            this.setSelected(false);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintablePreviewPanel printablePreviewPanel = this.a.getDisplayPanel();
            printablePreviewPanel.setToUseGrayScaleImages(this.isSelected());
            printablePreviewPanel.repaint();
        }

        GrayScaleCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale, f f2) {
            this(abstractPreviewControlPanel, locale);
        }

        GrayScaleCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel, f f2) {
            this(abstractPreviewControlPanel);
        }
    }

    protected class ShowMarginsCheckBox
    extends JCheckBox
    implements ActionListener {
        private final AbstractPreviewControlPanel a;

        private ShowMarginsCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel) {
            this.a = abstractPreviewControlPanel;
            super("Margins");
            this.setSelected(true);
            this.addActionListener(this);
        }

        private ShowMarginsCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale) {
            this.a = abstractPreviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("margins"));
            this.setSelected(true);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintablePreviewPanel printablePreviewPanel = this.a.getDisplayPanel();
            printablePreviewPanel.setHighlightingMargins(this.isSelected());
            printablePreviewPanel.repaint();
        }

        ShowMarginsCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale, f f2) {
            this(abstractPreviewControlPanel, locale);
        }

        ShowMarginsCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel, f f2) {
            this(abstractPreviewControlPanel);
        }
    }

    protected class ShowSizeCheckBox
    extends JCheckBox
    implements ActionListener {
        private final AbstractPreviewControlPanel a;

        private ShowSizeCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel) {
            this.a = abstractPreviewControlPanel;
            super("Size");
            this.setSelected(true);
            this.addActionListener(this);
        }

        private ShowSizeCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale) {
            this.a = abstractPreviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("size"));
            this.setSelected(true);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.getMediaLabel().setVisible(this.isSelected());
            this.a.validate();
            if (this.a.FIT_RADIO_BUTTON.isSelected()) {
                this.a.zoomDisplayToFit();
            }
        }

        ShowSizeCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel, Locale locale, f f2) {
            this(abstractPreviewControlPanel, locale);
        }

        ShowSizeCheckBox(AbstractPreviewControlPanel abstractPreviewControlPanel, f f2) {
            this(abstractPreviewControlPanel);
        }
    }

    protected static class PreviewToolBarPanel
    extends AbstractViewControlPanel.ToolBarPanel {
        public PreviewToolBarPanel() {
        }

        public PreviewToolBarPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 100;
            return dimension;
        }
    }

    public static class ControlState
    implements Serializable {
        private static final long serialVersionUID = 120L;
        public boolean zoomedToFit = true;
        public boolean highlightingMargins = false;
        public boolean displayingSize = false;
        public boolean grayScaleImages = false;
        public float zoomFactor = 1.0f;

        public ControlState() {
        }

        public ControlState(float f2) {
            this.zoomFactor = f2;
            this.zoomedToFit = false;
        }

        public String toString() {
            return "\n  zoomedToFit = " + this.zoomedToFit + "\n  highlightingMargins = " + this.highlightingMargins + "\n  displayingSize = " + this.displayingSize + "\n  grayScaleImages = " + this.grayScaleImages + "\n  zoomFactor = " + this.zoomFactor;
        }
    }
}

