/*
 * Decompiled with CFR 0.152.
 */
package jpdf.gui.preview;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import jpdf.ability.LookAheadAble;
import jpdf.gui.controller.PageOrientationPanel;
import jpdf.manage.PrintManager;
import jpdf.printable.FullyNavigablePrintable;
import jpdf.printable.PageGridPrintable;
import jpdf.utility.PrintUtility;
import jpdf_common.gui.ability.WaitCursorable;
import jpdf_common.gui.plaf.PlafPainter;

public abstract class AbstractPageImageDisplayPanel
extends JPanel {
    protected static final Color MARGIN_HIGHLIGHT_COLOR = new Color(255, 255, 133);
    protected static final float SCREEN_SCALE_FACTOR = 72.0f;
    protected static final int INSET_WIDTH = 7;
    protected static final int TWO_INSET_WIDTH = 14;
    protected static final int NO_PAGE_INDEX = -1;
    protected final PageFormat PAGE_FORMAT = new PageFormat();
    protected final Rectangle PRINTABLE_RECTANGLE = new Rectangle();
    private Throwable n = null;
    private Image f = null;
    private float p = 1.0f;
    private boolean h = true;
    private boolean i = true;
    private boolean j = false;
    private boolean b = false;
    private boolean q = true;
    private boolean c = false;
    static Class t;

    public AbstractPageImageDisplayPanel() {
        this.setOpaque(true);
    }

    public static void updatePrintableRectangle(PageFormat pageFormat, Rectangle rectangle) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = pageFormat.getOrientation();
        bl = n2 == 0 || n2 == 2;
        bl2 = n2 == 2;
        AbstractPageImageDisplayPanel.a(pageFormat.getPaper(), bl, bl2, rectangle);
    }

    protected void configureToTrackContainerSize() {
        Container container = null;
        this.setPreferredSize(null);
        this.setSize(0, 0);
        container = this.getParent();
        if (container instanceof JViewport) {
            container = container.getParent();
        }
        container.validate();
    }

    protected Image createDisplayImage(Graphics2D graphics2D, int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = null;
        Image image = null;
        if (this.isToUseGrayScaleImages()) {
            image = new BufferedImage(n2, n3, 10);
        } else {
            graphicsConfiguration = graphics2D.getDeviceConfiguration();
            image = graphicsConfiguration.createCompatibleVolatileImage(n2, n3);
            if (image == null) {
                image = graphicsConfiguration.createCompatibleImage(n2, n3);
            }
        }
        return image;
    }

    protected WaitCursorable displayWaitCursor() {
        WaitCursorable waitCursorable = null;
        Container container = null;
        container = this.getTopLevelAncestor();
        if (container instanceof WaitCursorable) {
            waitCursorable = (WaitCursorable)((Object)container);
            waitCursorable.setWaitCursor();
        }
        return waitCursorable;
    }

    protected Image getDisplayImage() {
        return this.f;
    }

    protected Throwable getLastPreviewException() {
        return this.n;
    }

    protected float getZoomFactor() {
        return this.p;
    }

    protected void handlePreviewException(Throwable throwable) {
        Window window = null;
        this.setLastPreviewException(throwable);
        if (this.isToCloseWindowOnException() && (window = SwingUtilities.windowForComponent(this)) != null) {
            this.setVisible(false);
            this.setToPaintImage(false);
            window.dispose();
        }
        PrintManager.handleException(throwable);
    }

    protected boolean isHighlightingMargins() {
        return this.h;
    }

    protected boolean isToCloseWindowOnException() {
        return this.j;
    }

    protected boolean isToUseFractionalMetrics() {
        return this.q;
    }

    protected boolean isToUseGrayScaleImages() {
        return this.b;
    }

    protected boolean isToPaintImage() {
        return this.i;
    }

    protected void paintScaledPage(Graphics2D graphics2D, int n2, int n3) {
        AbstractPageImageDisplayPanel.a(graphics2D, this.PAGE_FORMAT, this.getZoomFactor(), this.PRINTABLE_RECTANGLE, this.isHighlightingMargins(), n2, n3);
    }

    protected void refreshDisplay() {
        this.g();
    }

    protected void setDisplayImage(Image image) {
        this.f = image;
    }

    protected void setHighlightingMargins(boolean bl) {
        this.h = bl;
        this.refreshDisplay();
    }

    protected void setLastPreviewException(Throwable throwable) {
        this.n = throwable;
    }

    protected void setPageFormat(PageFormat pageFormat) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = pageFormat.getOrientation();
        bl = n2 == 0 || n2 == 2;
        bl2 = n2 == 2;
        this.a(pageFormat.getPaper(), bl, bl2);
    }

    protected void setToCloseWindowOnException(boolean bl) {
        this.j = bl;
    }

    protected void setToPaintImage(boolean bl) {
        this.i = bl;
    }

    protected void setToUseFractionalMetrics(boolean bl) {
        this.q = bl;
    }

    protected void setToUseGrayScaleImages(boolean bl) {
        this.b = bl;
        this.refreshDisplay();
    }

    protected void setZoomFactor(float f2) {
        this.p = f2;
    }

    protected void setZoomFactorResize(float f2, boolean bl) {
        Dimension dimension = null;
        boolean bl2 = f2 != this.getZoomFactor();
        int n2 = 0;
        int n3 = 0;
        if (bl2) {
            this.setZoomFactor(f2);
        }
        if (bl) {
            n2 = (int)(this.PAGE_FORMAT.getWidth() * (double)f2);
            n3 = (int)(this.PAGE_FORMAT.getHeight() * (double)f2);
            dimension = new Dimension(n2 + 14, n3 + 14);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
        }
        if (bl2) {
            this.refreshDisplay();
        }
    }

    protected float setZoomFactorToFit(float f2, float f3) {
        Dimension dimension = null;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n2 = (int)this.PAGE_FORMAT.getWidth();
        int n3 = (int)this.PAGE_FORMAT.getHeight();
        if (this.isPreferredSizeSet()) {
            this.configureToTrackContainerSize();
        }
        dimension = this.getSize();
        if (dimension.width > 0) {
            f4 = (float)(dimension.width - 14) / (float)n2;
            f5 = (float)(dimension.height - 14) / (float)n3;
            float f7 = f6 = f4 < f5 ? f4 : f5;
            if (f6 < f2) {
                f6 = f2;
            } else if (f6 > f3) {
                f6 = f3;
            }
            if (f6 != this.getZoomFactor()) {
                this.setZoomFactor(f6);
                this.refreshDisplay();
            }
        }
        return f6;
    }

    protected PageFormat updatePageFormat(PageFormat pageFormat) {
        this.setPageFormat(pageFormat);
        this.refreshDisplay();
        return this.PAGE_FORMAT;
    }

    protected PageFormat updatePageFormat(PrintRequestAttributeSet printRequestAttributeSet) {
        MediaPrintableArea mediaPrintableArea = null;
        MediaSize mediaSize = null;
        Paper paper = this.PAGE_FORMAT.getPaper();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 25400;
        if (printRequestAttributeSet == null) {
            return null;
        }
        bl = PageOrientationPanel.isLandscape(printRequestAttributeSet);
        bl2 = PageOrientationPanel.isReverse(printRequestAttributeSet);
        mediaSize = PrintUtility.getMediaSize(printRequestAttributeSet);
        paper.setSize(mediaSize.getX(n2) * 72.0f, mediaSize.getY(n2) * 72.0f);
        mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(t == null ? (t = AbstractPageImageDisplayPanel.class$("javax.print.attribute.standard.MediaPrintableArea")) : t);
        paper.setImageableArea(mediaPrintableArea.getX(n2) * 72.0f, mediaPrintableArea.getY(n2) * 72.0f, mediaPrintableArea.getWidth(n2) * 72.0f, mediaPrintableArea.getHeight(n2) * 72.0f);
        this.a(paper, bl, bl2);
        this.refreshDisplay();
        return this.PAGE_FORMAT;
    }

    static void a(Graphics2D graphics2D, PageFormat pageFormat, float f2, Rectangle rectangle, boolean bl, int n2, int n3) {
        float f3 = 0.0f;
        int n4 = (int)pageFormat.getWidth();
        int n5 = (int)pageFormat.getHeight();
        int n6 = Math.round((float)n4 * f2);
        int n7 = Math.round((float)n5 * f2);
        int n8 = Math.round((float)rectangle.x * f2);
        int n9 = Math.round((float)rectangle.y * f2);
        int n10 = Math.round((float)rectangle.width * f2);
        int n11 = Math.round((float)rectangle.height * f2);
        int n12 = 5;
        int n13 = 0;
        n13 = n4 - (rectangle.x + rectangle.width);
        f3 = (float)(n13 - rectangle.x) * f2;
        if (f3 < 1.0f && f3 > -1.0f) {
            n13 = n6 - (n8 + n10);
            if (n8 > n13) {
                --n10;
            } else if (n8 < n13) {
                ++n10;
            }
        }
        if ((f3 = (float)((n13 = n5 - (rectangle.y + rectangle.height)) - rectangle.y) * f2) < 1.0f && f3 > -1.0f) {
            n13 = n7 - (n9 + n11);
            if (n9 > n13) {
                --n11;
            } else if (n9 < n13) {
                ++n11;
            }
        }
        if (n2 != 0 || n3 != 0) {
            graphics2D.translate(n2, n3);
        }
        graphics2D.setColor(PlafPainter.CONTROL_SHADOW_COLOR);
        graphics2D.fillRect(n12, n12, n6, n7);
        if (bl) {
            graphics2D.setColor(MARGIN_HIGHLIGHT_COLOR);
            graphics2D.fillRect(0, 0, n6, n7);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(n8, n9, n10, n11);
        } else {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n6, n7);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(-1, -1, n6 + 1, n7 + 1);
        graphics2D.clipRect(n8, n9, n10, n11);
    }

    static void a(Graphics2D graphics2D, boolean bl) {
        Object object = null;
        object = bl ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, object);
    }

    private void g() {
        if (this.f != null) {
            this.f.flush();
            this.f = null;
        }
    }

    boolean c() {
        return this.c;
    }

    private void a(Paper paper, boolean bl, boolean bl2) {
        if (bl) {
            this.PAGE_FORMAT.setOrientation(bl2 ? 2 : 0);
        } else {
            if (bl2) {
                throw new IllegalArgumentException("Reverse Portrait is not supported.");
            }
            this.PAGE_FORMAT.setOrientation(1);
        }
        this.PAGE_FORMAT.setPaper(paper);
        AbstractPageImageDisplayPanel.a(paper, bl, bl2, this.PRINTABLE_RECTANGLE);
    }

    void a() {
        this.c = true;
    }

    private static void a(Paper paper, boolean bl, boolean bl2, Rectangle rectangle) {
        if (bl) {
            rectangle.width = (int)Math.round(paper.getImageableHeight());
            rectangle.height = (int)Math.round(paper.getImageableWidth());
            if (bl2) {
                rectangle.x = (int)Math.round(paper.getImageableY());
                rectangle.y = (int)Math.round(paper.getWidth()) - (rectangle.height + (int)Math.round(paper.getImageableX()));
            } else {
                rectangle.y = (int)Math.round(paper.getImageableX());
                rectangle.x = (int)Math.round(paper.getHeight()) - (rectangle.width + (int)Math.round(paper.getImageableY()));
            }
        } else {
            rectangle.width = (int)Math.round(paper.getImageableWidth());
            rectangle.height = (int)Math.round(paper.getImageableHeight());
            if (bl2) {
                throw new IllegalArgumentException("Reverse Portrait is not supported.");
            }
            rectangle.x = (int)Math.round(paper.getImageableX());
            rectangle.y = (int)Math.round(paper.getImageableY());
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected static class NothingPrintable
    implements PageGridPrintable,
    FullyNavigablePrintable,
    LookAheadAble {
        private final Dimension a = new Dimension(0, 0);

        protected NothingPrintable() {
        }

        public int computePageCount(PageFormat pageFormat) {
            return 0;
        }

        public Dimension computePageGridSize(PageFormat pageFormat) {
            return this.a;
        }

        public int getPageCount() {
            return 0;
        }

        public int getPrintedPageIndex() {
            return -1;
        }

        public boolean isMoreDataAvailable() {
            return false;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n2) {
            return 1;
        }
    }
}

