/*
 * Decompiled with CFR 0.152.
 */
package jpdf.gui.preview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.Printable;
import java.util.Locale;
import javax.swing.RepaintManager;
import jpdf.gui.preview.AbstractPageImageDisplayPanel;
import jpdf.gui.preview.PreviewGraphicsCustomizer;
import jpdf.manage.ResourceAdministrator;
import jpdf_common.gui.ability.WaitCursorable;
import jpdf_common.gui.constant.FontConstant;

public abstract class AbstractOverviewPanel
extends AbstractPageImageDisplayPanel {
    private static boolean r = true;
    protected final String PLEASE_WAIT_MSG;
    protected final int GAP_WIDTH = 9;
    protected final int LAST_PAGE_UNKNOWN = 9999;
    private int o = 0;
    private int s = 9999;
    private boolean e = false;
    private boolean d = false;

    public AbstractOverviewPanel(Locale locale) {
        this.PLEASE_WAIT_MSG = locale == null ? "Generating page image.  Please wait..." : ResourceAdministrator.getLocalizedString("msg.previewPleaseWaitForImage");
    }

    public abstract int getFixedColumnCount();

    public static boolean isToDisplayPleaseWaitMessage() {
        return r;
    }

    public void paint(Graphics graphics) {
        WaitCursorable waitCursorable = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Image image = this.getDisplayImage();
        boolean bl = false;
        boolean bl2 = this.isToPaintImage();
        if (!this.c()) {
            return;
        }
        if (image == null && bl2) {
            waitCursorable = this.displayWaitCursor();
            if (AbstractOverviewPanel.isToDisplayPleaseWaitMessage() && !this.isPleaseWaitMessageDisplayed() && this.e()) {
                super.paint(graphics2D);
                graphics2D.setColor(Color.RED);
                graphics2D.setFont(FontConstant.BOLD_DIALOG_FONT);
                graphics2D.drawString(this.PLEASE_WAIT_MSG, 25, 100);
                this.a(true);
                this.repaint();
                return;
            }
            image = this.createOverviewImage(graphics2D);
            if (image == null) {
                this.setToPaintImage(false);
                bl2 = false;
            } else {
                this.setDisplayImage(image);
            }
        }
        super.paint(graphics2D);
        if (bl2) {
            graphics2D.drawImage(image, -1, -1, this);
        }
        this.a(false);
        this.i();
        if (waitCursorable != null) {
            waitCursorable.setDefaultCursor();
        }
    }

    public abstract boolean requestFixedColumnCount(int var1);

    public abstract void setRequestedFixedColumnCount(int var1);

    public static void setToDisplayPleaseWaitMessage(boolean bl) {
        r = bl;
    }

    protected abstract Dimension computeFullLayoutSize();

    protected Dimension computeLayoutSize() {
        Dimension dimension = null;
        int n2 = this.getFirstPageIndex();
        int n3 = this.getLastPageIndex();
        dimension = this.getFullLayoutSize();
        if (n2 > 0 || n3 < dimension.width * dimension.height) {
            dimension = this.a(dimension, n2, n3);
        }
        return dimension;
    }

    protected Dimension computeOverviewPagesSize(Dimension dimension) {
        Dimension dimension2 = new Dimension();
        dimension2.width = (int)this.PAGE_FORMAT.getWidth() * dimension.width;
        dimension2.height = (int)this.PAGE_FORMAT.getHeight() * dimension.height;
        return dimension2;
    }

    protected Image createOverviewImage(Graphics2D graphics2D) {
        RepaintManager repaintManager = RepaintManager.currentManager(null);
        Graphics2D graphics2D2 = null;
        Dimension dimension = this.getFullLayoutSize();
        Image image = null;
        boolean bl = repaintManager.isDoubleBufferingEnabled();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = this.getFirstPageIndex();
        int n5 = this.getLastPageIndex();
        if (dimension.width == 0) {
            return null;
        }
        image = this.createDisplayImage(graphics2D, n2, n3);
        graphics2D2 = (Graphics2D)image.getGraphics();
        if (bl) {
            repaintManager.setDoubleBufferingEnabled(false);
        }
        AbstractOverviewPanel.a(graphics2D2, this.isToUseFractionalMetrics());
        if (n4 == n5) {
            this.paintOverviewPageImage(graphics2D2, n2, n3, n4);
        } else if (n4 / dimension.width == n5 / dimension.width) {
            this.paintOverviewPageRowImage(graphics2D2, n2, n3, n4, n5);
        } else {
            this.paintOverviewPageRangeImage(graphics2D2, n2, n3, n4, n5);
        }
        graphics2D2.dispose();
        if (bl) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
        return image;
    }

    protected int getFullColumnCount() {
        return this.getFullLayoutSize().width;
    }

    protected abstract int getFullPageCount();

    protected int getDisplayedPageCount() {
        return this.s - this.o + 1;
    }

    protected int getFirstPageIndex() {
        return this.o;
    }

    protected abstract Dimension getFullLayoutSize();

    protected int getLastPageIndex() {
        return this.s;
    }

    protected abstract boolean handleContainerResize();

    protected boolean isPleaseWaitMessageDisplayed() {
        return this.e;
    }

    protected boolean isSinglePageDisplay() {
        return this.getFirstPageIndex() == this.getLastPageIndex();
    }

    protected abstract void paintOverviewPageImage(Graphics2D var1, int var2, int var3, int var4);

    protected abstract void paintOverviewPageRangeImage(Graphics2D var1, int var2, int var3, int var4, int var5);

    protected abstract void paintOverviewPageRowImage(Graphics2D var1, int var2, int var3, int var4, int var5);

    protected Graphics2D prepareImageGraphics(Graphics2D graphics2D, Printable printable, int n2, int n3) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, n2, n3);
        if (printable instanceof PreviewGraphicsCustomizer) {
            graphics2D = ((PreviewGraphicsCustomizer)((Object)printable)).customizePreviewGraphics(graphics2D);
        }
        return graphics2D;
    }

    protected boolean setPageIndexRange(int n2, int n3) {
        boolean bl = false;
        if (n2 != this.o || n3 != this.s) {
            this.o = n2;
            this.s = n3;
            bl = true;
        }
        return bl;
    }

    protected boolean setPageIndexRange(int n2, int n3, float f2) {
        boolean bl = false;
        bl = this.setPageIndexRange(n2, n3);
        if (bl) {
            this.refreshDisplay();
        }
        this.setZoomFactorResize(f2, true);
        return bl;
    }

    protected boolean setPageIndexRange(int n2, int n3, float f2, float f3) {
        boolean bl = false;
        bl = this.setPageIndexRange(n2, n3);
        if (bl) {
            this.refreshDisplay();
        }
        this.setZoomFactorToFit(f2, f3);
        return bl;
    }

    protected void setZoomFactorResize(float f2, boolean bl) {
        Dimension dimension = null;
        Dimension dimension2 = null;
        boolean bl2 = f2 != this.getZoomFactor();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (bl2) {
            this.setZoomFactor(f2);
        }
        if (bl) {
            dimension2 = this.computeLayoutSize();
            n2 = (int)(this.PAGE_FORMAT.getWidth() * (double)dimension2.width * (double)f2);
            n3 = (int)(this.PAGE_FORMAT.getHeight() * (double)dimension2.height * (double)f2);
            n4 = 9 * (dimension2.width - 1);
            n5 = 9 * (dimension2.height - 1);
            dimension = new Dimension(n2 + 14 + n4, n3 + 14 + n5);
            this.setPreferredSize(dimension);
            this.setSize(dimension);
        }
        if (bl2) {
            this.refreshDisplay();
        }
    }

    protected float setZoomFactorToFit(float f2, float f3) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = null;
        Dimension dimension3 = null;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        if (this.isPreferredSizeSet()) {
            this.configureToTrackContainerSize();
        }
        dimension = this.getSize();
        if (dimension.width > 0) {
            dimension2 = this.computeLayoutSize();
            dimension3 = this.computeOverviewPagesSize(dimension2);
            n2 = dimension.width - 14 - 9 * (dimension2.width - 1);
            f4 = (float)n2 / (float)dimension3.width;
            n3 = dimension.height - 14 - 9 * (dimension2.height - 1);
            f5 = (float)n3 / (float)dimension3.height;
            float f7 = f6 = f4 < f5 ? f4 : f5;
            if (f6 < f2) {
                f6 = f2;
            } else if (f6 > f3) {
                f6 = f3;
            }
            if (f6 != this.getZoomFactor()) {
                this.setZoomFactor(f6);
                this.refreshDisplay();
            }
        }
        return f6;
    }

    private Dimension a(Dimension dimension, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (n2 < 0 || n3 < 0) {
            dimension = new Dimension(0, 0);
        } else if (n2 == n3) {
            dimension = new Dimension(1, 1);
        } else {
            n4 = n2 / dimension.width;
            n5 = n3 == 9999 ? dimension.height - 1 : n3 / dimension.width;
            dimension = n4 == n5 ? new Dimension(n3 - n2 + 1, 1) : new Dimension(dimension.width, n5 - n4 + 1);
        }
        return dimension;
    }

    private boolean e() {
        return this.d;
    }

    private void i() {
        this.d = true;
    }

    private void a(boolean bl) {
        this.e = bl;
    }
}

