/*
 * Decompiled with CFR 0.152.
 */
package jpdf.gui.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Locale;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jpdf.gui.preview.AbstractOverviewPanel;
import jpdf.gui.preview.AbstractPageImageDisplayPanel;
import jpdf.gui.preview.AbstractViewControlPanel;
import jpdf.gui.preview.C;
import jpdf.gui.preview.l;
import jpdf.manage.ResourceAdministrator;
import jpdf_common.gui.component.scroll.VerticallyScrollablePanel;
import jpdf_common.gui.component.select.NumberRangeSelectionGridPanel;
import jpdf_common.gui.layout.ColLayout;
import jpdf_common.gui.layout.RowLayout;
import jpdf_common.gui.utility.KeyboardActionUtility;

public abstract class AbstractOverviewControlPanel
extends AbstractViewControlPanel
implements NumberRangeSelectionGridPanel.SelectionObserver {
    public static final int INITIAL_SELECT_FIRST_PAGE = 0;
    public static final int INITIAL_SELECT_FIRST_ROW = 1;
    public static final int INITIAL_SELECT_ALL_OR_MAX = 2;
    public static final int INITIAL_SELECT_DEFAULT = 3;
    private static int m = 3;
    private final VerticallyScrollablePanel j;
    protected final ShowMarginsCheckBox SHOW_MARGINS_CHECK_BOX;
    protected final ShowSizeCheckBox SHOW_SIZE_CHECK_BOX;
    protected final GrayScaleCheckBox GRAY_SCALE_CHECK_BOX;
    protected final FitColumnsRadioButton FIT_COLS_RADIO_BUTTON;
    protected final FixedColumnsRadioButton FIXED_COLS_RADIO_BUTTON;
    protected final FixedColumnsComboBox FIXED_COLS_COMBO_BOX = new FixedColumnsComboBox(this, null);
    protected final FitZoomRadioButton FIT_ZOOM_RADIO_BUTTON;
    protected final FixedZoomRadioButton FIXED_ZOOM_RADIO_BUTTON;
    private AbstractOverviewPanel l = null;
    private NumberRangeSelectionGridPanel o = null;
    private JLabel k = new JLabel();
    private JPanel n = null;
    private boolean p = false;
    private float i = 0.0f;
    private float c = 0.0f;
    private float f = 0.0f;
    private float g;
    private int h = 10;

    protected AbstractOverviewControlPanel(String string, Locale locale, AbstractOverviewPanel abstractOverviewPanel, float f2, float f3) {
        super(ResourceAdministrator.getLocalizedString("overview"));
        if (f2 > 1.0f) {
            String string2 = "The Fixed Zoom Factor cannot be greater than 1.0.\nInvalid value: " + f2;
            throw new IllegalArgumentException(string2);
        }
        this.j = new VerticallyScrollablePanel((LayoutManager)new BorderLayout(0, 0), 0);
        if (locale == null) {
            this.SHOW_MARGINS_CHECK_BOX = new ShowMarginsCheckBox(this, null);
            this.SHOW_SIZE_CHECK_BOX = new ShowSizeCheckBox(this, null);
            this.GRAY_SCALE_CHECK_BOX = new GrayScaleCheckBox(this, null);
            this.FIT_COLS_RADIO_BUTTON = new FitColumnsRadioButton(this, null);
            this.FIXED_COLS_RADIO_BUTTON = new FixedColumnsRadioButton(this, null);
            this.FIT_ZOOM_RADIO_BUTTON = new FitZoomRadioButton(this, null);
            this.FIXED_ZOOM_RADIO_BUTTON = new FixedZoomRadioButton(this, null);
        } else {
            this.SHOW_MARGINS_CHECK_BOX = new ShowMarginsCheckBox(this, locale, null);
            this.SHOW_SIZE_CHECK_BOX = new ShowSizeCheckBox(this, locale, null);
            this.GRAY_SCALE_CHECK_BOX = new GrayScaleCheckBox(this, locale, null);
            this.FIT_COLS_RADIO_BUTTON = new FitColumnsRadioButton(this, locale, null);
            this.FIXED_COLS_RADIO_BUTTON = new FixedColumnsRadioButton(this, locale, null);
            this.FIT_ZOOM_RADIO_BUTTON = new FitZoomRadioButton(this, locale, null);
            this.FIXED_ZOOM_RADIO_BUTTON = new FixedZoomRadioButton(this, locale, null);
        }
        if (f2 <= 0.0f) {
            f2 = 0.33f;
        } else if (f2 < 0.05f) {
            f2 = 0.05f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.c(f2);
        if (f3 <= 0.0f) {
            f3 = 1.0f;
        } else if (f3 < 0.05f) {
            f3 = 0.05f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        this.a(f3);
        this.l = abstractOverviewPanel;
        this.a(locale, abstractOverviewPanel);
    }

    public static int getInitialSelectionMode() {
        return m;
    }

    public void initializeDisplay() {
        boolean bl = this.FIXED_COLS_RADIO_BUTTON.isSelected();
        int n2 = this.FIXED_COLS_COMBO_BOX.getColumnCount();
        if (this.SHOW_SIZE_CHECK_BOX.isSelected()) {
            this.SHOW_SIZE_CHECK_BOX.actionPerformed(null);
        }
        this.updateDisplay();
        this.FIXED_COLS_COMBO_BOX.selectColumnCount(n2);
        if (bl) {
            this.FIXED_COLS_RADIO_BUTTON.setSelected(true);
        } else {
            this.FIT_COLS_RADIO_BUTTON.setSelected(true);
        }
        this.setDisplayInitialized(true);
        this.FIT_COLS_RADIO_BUTTON.setEnabled(this.isUsingFixedZoomFactor());
        if (this.FIXED_ZOOM_RADIO_BUTTON.isSelected()) {
            this.FIXED_ZOOM_RADIO_BUTTON.actionPerformed(null);
        } else {
            this.FIT_ZOOM_RADIO_BUTTON.actionPerformed(null);
        }
        if (bl) {
            this.FIXED_COLS_RADIO_BUTTON.actionPerformed(null);
        } else {
            this.getDisplayPanel().configureToTrackContainerSize();
            this.FIT_COLS_RADIO_BUTTON.actionPerformed(null);
        }
        this.refreshControlledDisplay();
        this.getDisplayPanel().a();
        this.selectInitialPages();
    }

    public void selectedValue(int n2) {
        this.selectedValueRange(n2, n2);
    }

    public void selectedValueRange(int n2, int n3) {
        NumberRangeSelectionGridPanel numberRangeSelectionGridPanel = this.getPageSelectionGridPanel();
        AbstractOverviewPanel abstractOverviewPanel = this.getDisplayPanel();
        float f2 = 0.0f;
        boolean bl = n2 == n3;
        boolean bl2 = false;
        int n4 = numberRangeSelectionGridPanel.getValueCellY(n2);
        int n5 = numberRangeSelectionGridPanel.getValueCellY(n3);
        int n6 = numberRangeSelectionGridPanel.getRowHeight();
        int n7 = n5 - n4 + n6;
        this.j.scrollToVisible(n4, n7);
        if (this.isUsingFixedZoomFactor()) {
            f2 = bl ? this.d() : this.a();
            bl2 = abstractOverviewPanel.setPageIndexRange(n2 - 1, n3 - 1, f2);
            if (!bl) {
                this.updatePageSelectionGridArrangement();
            }
        } else {
            bl2 = abstractOverviewPanel.setPageIndexRange(n2 - 1, n3 - 1, 0.05f, 2.0f);
        }
        this.d(abstractOverviewPanel.getZoomFactor());
        abstractOverviewPanel.repaint();
        if (bl2) {
            this.navigatedPage();
        }
    }

    public void setControlState(ControlState controlState) {
        boolean bl = false;
        if (!this.isZooomingEnabled()) {
            controlState.fixedZoomFactor = true;
        }
        bl = !controlState.fitColumns || !controlState.fixedZoomFactor;
        this.SHOW_MARGINS_CHECK_BOX.setSelected(controlState.highlightingMargins);
        this.SHOW_MARGINS_CHECK_BOX.actionPerformed(null);
        this.SHOW_SIZE_CHECK_BOX.setSelected(controlState.displayingSize);
        this.SHOW_SIZE_CHECK_BOX.actionPerformed(null);
        this.GRAY_SCALE_CHECK_BOX.setSelected(controlState.grayScaleImages);
        this.GRAY_SCALE_CHECK_BOX.actionPerformed(null);
        this.FIT_COLS_RADIO_BUTTON.setSelected(!bl);
        this.FIXED_COLS_RADIO_BUTTON.setSelected(bl);
        this.FIXED_COLS_COMBO_BOX.selectColumnCount(controlState.fixedColumnCount);
        this.FIT_ZOOM_RADIO_BUTTON.setSelected(!controlState.fixedZoomFactor);
        this.FIXED_ZOOM_RADIO_BUTTON.setSelected(controlState.fixedZoomFactor);
    }

    public static void setInitialSelectionMode(int n2) {
        m = n2 == 0 || n2 == 1 || n2 == 2 ? n2 : 3;
    }

    public void storeControlState(ControlState controlState) {
        controlState.highlightingMargins = this.SHOW_MARGINS_CHECK_BOX.isSelected();
        controlState.grayScaleImages = this.GRAY_SCALE_CHECK_BOX.isSelected();
        controlState.displayingSize = this.SHOW_SIZE_CHECK_BOX.isSelected();
        controlState.fitColumns = this.FIT_COLS_RADIO_BUTTON.isSelected();
        controlState.fixedColumnCount = this.FIXED_COLS_COMBO_BOX.getColumnCount();
        controlState.fixedZoomFactor = this.FIXED_ZOOM_RADIO_BUTTON.isSelected();
    }

    public void unselectedAllValues(int n2, int n3) {
    }

    protected JPanel getColumnsPanel() {
        return this.n;
    }

    protected AbstractOverviewPanel getDisplayPanel() {
        return this.l;
    }

    protected AbstractPageImageDisplayPanel getPageImageDisplayPanel() {
        return this.l;
    }

    protected NumberRangeSelectionGridPanel getPageSelectionGridPanel() {
        return this.o;
    }

    protected float getSinglePageZoomFactor() {
        return this.c;
    }

    protected float getZoomFactor() {
        return this.i;
    }

    protected void handlePanelResize() {
        NumberRangeSelectionGridPanel numberRangeSelectionGridPanel = this.getPageSelectionGridPanel();
        AbstractOverviewPanel abstractOverviewPanel = null;
        Dimension dimension = null;
        boolean bl = false;
        boolean bl2 = false;
        if (!this.isDisplayInitialized()) {
            return;
        }
        if (this.isUsingFixedZoomFactor()) {
            abstractOverviewPanel = this.getDisplayPanel();
            bl = abstractOverviewPanel.handleContainerResize();
            if (bl) {
                dimension = abstractOverviewPanel.computeFullLayoutSize();
                numberRangeSelectionGridPanel.setArrangement(abstractOverviewPanel.getFullPageCount(), dimension.width);
                abstractOverviewPanel.invalidate();
            }
        } else {
            this.zoomDisplayToFit();
        }
        if (this.j.isScrollBarVisibilityChanged()) {
            numberRangeSelectionGridPanel.invalidate();
        }
        this.validate();
        this.repaint();
    }

    protected boolean isDisplayInitialized() {
        return this.p;
    }

    protected boolean isUsingFixedZoomFactor() {
        return this.i > 0.0f;
    }

    protected boolean isZooomingEnabled() {
        return this.FIT_ZOOM_RADIO_BUTTON.isEnabled();
    }

    protected void navigateToNext() {
        this.getPageSelectionGridPanel().selectCellGroupNext(true);
    }

    protected void navigateToPrevious() {
        this.getPageSelectionGridPanel().selectCellGroupPrevious(true);
    }

    protected void refreshControlledDisplay() {
        AbstractOverviewPanel abstractOverviewPanel = this.getDisplayPanel();
        PrintRequestAttributeSet printRequestAttributeSet = this.getPrintInfoHolder().getAttributeSet();
        if (!this.isDisplayInitialized()) {
            return;
        }
        this.updateMediaLabel(printRequestAttributeSet);
        this.updatePageSelectionGridArrangement();
        if (this.isUsingFixedZoomFactor()) {
            this.updateDisplayPanelSize();
        } else {
            this.zoomDisplayToFit();
        }
        abstractOverviewPanel.repaint();
    }

    protected void selectInitialPages() {
        Dimension dimension = null;
        boolean bl = AbstractOverviewControlPanel.isPageNavigationAudible();
        AbstractOverviewControlPanel.setPageNavigationAudible(false);
        switch (AbstractOverviewControlPanel.getInitialSelectionMode()) {
            case 0: {
                this.getPageSelectionGridPanel().selectCellValue(1, true);
                break;
            }
            case 1: {
                this.getPageSelectionGridPanel().selectFirstRowCells(true);
                break;
            }
            case 2: {
                this.getPageSelectionGridPanel().selectAllCells(true);
                break;
            }
            default: {
                dimension = this.getDisplayPanel().getFullLayoutSize();
                if (dimension.height <= 3 && dimension.height * dimension.width <= 4) {
                    this.getPageSelectionGridPanel().selectAllCells(true);
                    break;
                }
                this.getPageSelectionGridPanel().selectFirstRowCells(true);
            }
        }
        AbstractOverviewControlPanel.setPageNavigationAudible(bl);
    }

    protected void setColumnsSelectionEnabled(boolean bl, int n2) {
        boolean bl2 = n2 > 0;
        this.FIXED_COLS_RADIO_BUTTON.setEnabled(bl);
        this.FIXED_COLS_COMBO_BOX.setEnabled(bl && bl2);
        this.FIT_COLS_RADIO_BUTTON.setEnabled(bl && this.FIXED_ZOOM_RADIO_BUTTON.isSelected());
        if (bl2) {
            this.FIXED_COLS_RADIO_BUTTON.setSelected(true);
            this.FIXED_COLS_COMBO_BOX.selectColumnCount(n2);
        }
    }

    protected void setDisplayInitialized(boolean bl) {
        this.p = bl;
    }

    protected void setPageSelectionGridPanelVisible(boolean bl) {
        Container container = this.getPageSelectionGridPanel().getParent();
        while (container.getComponentCount() <= 1) {
            container = container.getParent();
        }
        container.setVisible(bl);
    }

    protected void setZooomingEnabled(boolean bl) {
        this.FIT_ZOOM_RADIO_BUTTON.setEnabled(bl);
        this.FIXED_ZOOM_RADIO_BUTTON.setEnabled(bl);
        if (!bl) {
            this.FIXED_ZOOM_RADIO_BUTTON.setSelected(true);
            this.e(1.0f);
            this.b(1.0f);
            this.a(1.0f);
            this.c(1.0f);
            this.a(4);
        } else {
            this.a(10);
        }
        this.getDisplayPanel().setToUseFractionalMetrics(bl);
    }

    protected void updateDisplayPanelSize() {
        AbstractOverviewPanel abstractOverviewPanel = this.getDisplayPanel();
        float f2 = 0.0f;
        f2 = abstractOverviewPanel.isSinglePageDisplay() ? this.d() : this.a();
        abstractOverviewPanel.setZoomFactorResize(f2, true);
        this.d(f2);
    }

    protected boolean updatePageSelectionGridArrangement() {
        NumberRangeSelectionGridPanel numberRangeSelectionGridPanel = this.getPageSelectionGridPanel();
        AbstractOverviewPanel abstractOverviewPanel = this.getDisplayPanel();
        Dimension dimension = null;
        boolean bl = false;
        int n2 = 0;
        if (!this.isDisplayInitialized()) {
            return false;
        }
        dimension = abstractOverviewPanel.computeFullLayoutSize();
        n2 = abstractOverviewPanel.getFullPageCount();
        if (!numberRangeSelectionGridPanel.isMatchingArrangement(n2, dimension.width)) {
            numberRangeSelectionGridPanel.setArrangement(n2, dimension.width);
            bl = true;
            abstractOverviewPanel.invalidate();
            this.validate();
            this.repaint();
        }
        return bl;
    }

    protected void zoomDisplayToFit() {
        AbstractOverviewPanel abstractOverviewPanel = this.getDisplayPanel();
        float f2 = 0.0f;
        if (!this.isDisplayInitialized()) {
            return;
        }
        f2 = abstractOverviewPanel.setZoomFactorToFit(0.05f, 2.0f);
        abstractOverviewPanel.repaint();
        if (f2 >= 0.05f) {
            this.d(f2);
        }
    }

    private String[] a(Locale locale, int n2) {
        String[] stringArray = new String[2];
        if (locale == null) {
            stringArray[0] = "All";
            stringArray[1] = "First " + n2;
        } else {
            stringArray[0] = ResourceAdministrator.getLocalizedString("page.all");
            stringArray[1] = ResourceAdministrator.getLocalizedString("page.firstPlural") + " " + n2;
        }
        return stringArray;
    }

    private JPanel c(Locale locale) {
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel(new RowLayout(2, 0));
        String string = null;
        this.n = new JPanel(new ColLayout(0, 0));
        string = locale == null ? "Columns" : ResourceAdministrator.getLocalizedString("columns");
        this.n.add(new JLabel(string));
        this.FIT_COLS_RADIO_BUTTON.setSelected(true);
        buttonGroup.add(this.FIT_COLS_RADIO_BUTTON);
        this.n.add(this.FIT_COLS_RADIO_BUTTON);
        buttonGroup.add(this.FIXED_COLS_RADIO_BUTTON);
        jPanel.add(this.FIXED_COLS_RADIO_BUTTON);
        jPanel.add(this.FIXED_COLS_COMBO_BOX);
        this.n.add(jPanel);
        return this.n;
    }

    private JScrollPane a(NumberRangeSelectionGridPanel numberRangeSelectionGridPanel) {
        JScrollPane jScrollPane = this.j.createContainingScrollPane(true);
        this.j.add(numberRangeSelectionGridPanel);
        jScrollPane.setFocusable(false);
        jScrollPane.setInputMap(1, null);
        this.j.addChildResizeListener(this);
        return jScrollPane;
    }

    private JPanel e(Locale locale) {
        JPanel jPanel = new JPanel(new ColLayout(1, 2));
        jPanel.add(this.SHOW_MARGINS_CHECK_BOX);
        jPanel.add(this.SHOW_SIZE_CHECK_BOX);
        jPanel.add(this.GRAY_SCALE_CHECK_BOX);
        return jPanel;
    }

    private JPanel a(Locale locale) {
        NumberRangeSelectionGridPanel numberRangeSelectionGridPanel = this.e();
        ColLayout colLayout = new ColLayout(1, 0, 3);
        JPanel jPanel = new JPanel(colLayout);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 8, 0));
        JScrollPane jScrollPane = this.a(numberRangeSelectionGridPanel);
        String[] stringArray = null;
        int n2 = this.c();
        stringArray = this.a(locale, n2);
        colLayout.setShrinkingComponent(jScrollPane);
        jPanel2.add(numberRangeSelectionGridPanel.createSelectAllButton(stringArray[0], stringArray[1], null));
        jPanel.add(jScrollPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private NumberRangeSelectionGridPanel e() {
        this.o = new NumberRangeSelectionGridPanel(this, 2);
        this.o.addPageKeyActions(2);
        this.o.setMaxSelectedCellCount(this.c());
        return this.o;
    }

    private AbstractViewControlPanel.ToolBarPanel b(Locale locale) {
        ColLayout colLayout = new ColLayout(1, 2);
        AbstractViewControlPanel.ToolBarPanel toolBarPanel = new AbstractViewControlPanel.ToolBarPanel(colLayout);
        JPanel jPanel = this.a(locale);
        colLayout.setShrinkingComponent(jPanel);
        toolBarPanel.add(this.f(locale));
        toolBarPanel.add(new JSeparator(0));
        toolBarPanel.add(this.e(locale));
        toolBarPanel.add(new JSeparator(0));
        toolBarPanel.add(this.c(locale));
        toolBarPanel.add(new JSeparator(0));
        toolBarPanel.add(jPanel);
        toolBarPanel.add(new JSeparator(0));
        toolBarPanel.add(Box.createGlue());
        return toolBarPanel;
    }

    private JPanel f(Locale locale) {
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel(new ColLayout(1, 0));
        JPanel jPanel2 = new JPanel(new RowLayout(2, 2));
        String string = null;
        string = locale == null ? "Zoom: " : ResourceAdministrator.getLocalizedString("zoom") + ": ";
        jPanel2.add(new JLabel(string));
        jPanel2.add(this.b());
        buttonGroup.add(this.FIT_ZOOM_RADIO_BUTTON);
        buttonGroup.add(this.FIXED_ZOOM_RADIO_BUTTON);
        jPanel.add(jPanel2);
        jPanel.add(this.FIT_ZOOM_RADIO_BUTTON);
        jPanel.add(this.FIXED_ZOOM_RADIO_BUTTON);
        return jPanel;
    }

    private float a() {
        return this.f;
    }

    private int c() {
        return this.h;
    }

    private float d() {
        return this.g;
    }

    private JLabel b() {
        return this.k;
    }

    private void a(Locale locale, AbstractOverviewPanel abstractOverviewPanel) {
        this.setLayout(new BorderLayout(7, 7));
        this.setBorder(EMPTY_BORDER);
        this.add((Component)this.b(locale), "West");
        this.add((Component)this.createDisplayScrollPane(abstractOverviewPanel), "Center");
        this.add((Component)this.createMediaLabel(2), "South");
        this.addComponentListener(new l(this, null));
    }

    private void c(float f2) {
        this.f = f2;
    }

    private void a(int n2) {
        NumberRangeSelectionGridPanel numberRangeSelectionGridPanel = this.getPageSelectionGridPanel();
        String[] stringArray = null;
        this.h = n2;
        stringArray = this.a(Locale.getDefault(), n2);
        numberRangeSelectionGridPanel.setMaxSelectedCellCount(n2);
        numberRangeSelectionGridPanel.updateSelectAllButtonText(stringArray[0], stringArray[1]);
    }

    private void a(float f2) {
        this.g = f2;
    }

    private void e(float f2) {
        this.c = f2;
    }

    private void b(float f2) {
        this.i = f2;
    }

    private void d(float f2) {
        this.b().setText(Integer.toString(Math.round(f2 * 100.0f)) + "%");
    }

    static void a(AbstractOverviewControlPanel abstractOverviewControlPanel, float f2) {
        abstractOverviewControlPanel.b(f2);
    }

    static void b(AbstractOverviewControlPanel abstractOverviewControlPanel, float f2) {
        abstractOverviewControlPanel.e(f2);
    }

    static float b(AbstractOverviewControlPanel abstractOverviewControlPanel) {
        return abstractOverviewControlPanel.a();
    }

    static float a(AbstractOverviewControlPanel abstractOverviewControlPanel) {
        return abstractOverviewControlPanel.d();
    }

    protected class FixedZoomRadioButton
    extends JRadioButton
    implements ActionListener {
        private final AbstractOverviewControlPanel a;

        private FixedZoomRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel) {
            this.a = abstractOverviewControlPanel;
            super("Fixed");
            this.addActionListener(this);
        }

        private FixedZoomRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale) {
            this.a = abstractOverviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("fixed"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractOverviewControlPanel.a(this.a, AbstractOverviewControlPanel.b(this.a));
            AbstractOverviewControlPanel.b(this.a, AbstractOverviewControlPanel.a(this.a));
            if (this.a.FIXED_COLS_RADIO_BUTTON.isEnabled()) {
                this.a.FIT_COLS_RADIO_BUTTON.setEnabled(true);
            }
            this.a.updateDisplayPanelSize();
        }

        FixedZoomRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, C c2) {
            this(abstractOverviewControlPanel);
        }

        FixedZoomRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale, C c2) {
            this(abstractOverviewControlPanel, locale);
        }
    }

    protected class FitZoomRadioButton
    extends JRadioButton
    implements ActionListener {
        private final AbstractOverviewControlPanel a;

        private FitZoomRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel) {
            this.a = abstractOverviewControlPanel;
            super("Fit");
            this.addActionListener(this);
        }

        private FitZoomRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale) {
            this.a = abstractOverviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("fit"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractOverviewControlPanel.a(this.a, 0.0f);
            AbstractOverviewControlPanel.b(this.a, 0.0f);
            this.a.FIT_COLS_RADIO_BUTTON.setEnabled(false);
            this.a.FIXED_COLS_RADIO_BUTTON.setSelected(true);
            this.a.FIXED_COLS_RADIO_BUTTON.actionPerformed(null);
            this.a.zoomDisplayToFit();
        }

        FitZoomRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, C c2) {
            this(abstractOverviewControlPanel);
        }

        FitZoomRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale, C c2) {
            this(abstractOverviewControlPanel, locale);
        }
    }

    protected class FixedColumnsComboBox
    extends JComboBox
    implements ActionListener {
        private final AbstractOverviewControlPanel a;

        private FixedColumnsComboBox(AbstractOverviewControlPanel abstractOverviewControlPanel) {
            this.a = abstractOverviewControlPanel;
            super(new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5)});
            KeyboardActionUtility.disablePageNavigationKeyActions(this);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.a.FIXED_COLS_RADIO_BUTTON.isSelected()) {
                if (this.a.isDisplayInitialized()) {
                    this.a.getDisplayPanel().requestFixedColumnCount(this.getColumnCount());
                    this.a.refreshControlledDisplay();
                } else {
                    this.a.getDisplayPanel().setRequestedFixedColumnCount(this.getColumnCount());
                }
            }
        }

        public int getColumnCount() {
            return (Integer)this.getSelectedItem();
        }

        public void selectColumnCount(int n2) {
            if (n2 > 0 && n2 <= this.getItemCount()) {
                this.setSelectedIndex(n2 - 1);
            }
        }

        FixedColumnsComboBox(AbstractOverviewControlPanel abstractOverviewControlPanel, C c2) {
            this(abstractOverviewControlPanel);
        }
    }

    protected class FixedColumnsRadioButton
    extends JRadioButton
    implements ActionListener {
        private final AbstractOverviewControlPanel a;

        private FixedColumnsRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel) {
            this.a = abstractOverviewControlPanel;
            super("Fixed");
            this.addActionListener(this);
        }

        private FixedColumnsRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale) {
            this.a = abstractOverviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("fixed"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled()) {
                this.a.FIXED_COLS_COMBO_BOX.setEnabled(true);
            }
            this.a.FIXED_COLS_COMBO_BOX.actionPerformed(null);
        }

        FixedColumnsRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, C c2) {
            this(abstractOverviewControlPanel);
        }

        FixedColumnsRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale, C c2) {
            this(abstractOverviewControlPanel, locale);
        }
    }

    protected class FitColumnsRadioButton
    extends JRadioButton
    implements ActionListener {
        private final AbstractOverviewControlPanel a;

        private FitColumnsRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel) {
            this.a = abstractOverviewControlPanel;
            super("Fit");
            this.addActionListener(this);
        }

        private FitColumnsRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale) {
            this.a = abstractOverviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("fit"));
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractOverviewPanel abstractOverviewPanel = this.a.getDisplayPanel();
            this.a.FIXED_COLS_COMBO_BOX.setEnabled(false);
            abstractOverviewPanel.requestFixedColumnCount(0);
            this.a.refreshControlledDisplay();
        }

        FitColumnsRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, C c2) {
            this(abstractOverviewControlPanel);
        }

        FitColumnsRadioButton(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale, C c2) {
            this(abstractOverviewControlPanel, locale);
        }
    }

    protected class GrayScaleCheckBox
    extends JCheckBox
    implements ActionListener {
        private final AbstractOverviewControlPanel a;

        private GrayScaleCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel) {
            this.a = abstractOverviewControlPanel;
            super("Grayscale");
            this.setSelected(false);
            this.addActionListener(this);
        }

        private GrayScaleCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale) {
            this.a = abstractOverviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("grayScale"));
            this.setSelected(false);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractOverviewPanel abstractOverviewPanel = this.a.getDisplayPanel();
            abstractOverviewPanel.setToUseGrayScaleImages(this.isSelected());
            abstractOverviewPanel.repaint();
        }

        GrayScaleCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel, C c2) {
            this(abstractOverviewControlPanel);
        }

        GrayScaleCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale, C c2) {
            this(abstractOverviewControlPanel, locale);
        }
    }

    protected class ShowMarginsCheckBox
    extends JCheckBox
    implements ActionListener {
        private final AbstractOverviewControlPanel a;

        private ShowMarginsCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel) {
            this.a = abstractOverviewControlPanel;
            super("Margins");
            this.setSelected(true);
            this.addActionListener(this);
        }

        private ShowMarginsCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale) {
            this.a = abstractOverviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("margins"));
            this.setSelected(true);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractOverviewPanel abstractOverviewPanel = this.a.getDisplayPanel();
            abstractOverviewPanel.setHighlightingMargins(this.isSelected());
            abstractOverviewPanel.repaint();
        }

        ShowMarginsCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel, C c2) {
            this(abstractOverviewControlPanel);
        }

        ShowMarginsCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale, C c2) {
            this(abstractOverviewControlPanel, locale);
        }
    }

    protected class ShowSizeCheckBox
    extends JCheckBox
    implements ActionListener {
        private final AbstractOverviewControlPanel a;

        private ShowSizeCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel) {
            this.a = abstractOverviewControlPanel;
            super("Size");
            this.setSelected(true);
            this.addActionListener(this);
        }

        private ShowSizeCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale) {
            this.a = abstractOverviewControlPanel;
            super(ResourceAdministrator.getLocalizedString("size"));
            this.setSelected(true);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.getMediaLabel().setVisible(this.isSelected());
            this.a.validate();
            if (!this.a.isUsingFixedZoomFactor()) {
                this.a.zoomDisplayToFit();
            }
        }

        ShowSizeCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel, C c2) {
            this(abstractOverviewControlPanel);
        }

        ShowSizeCheckBox(AbstractOverviewControlPanel abstractOverviewControlPanel, Locale locale, C c2) {
            this(abstractOverviewControlPanel, locale);
        }
    }

    public static class ControlState
    implements Serializable {
        public static final int DEFAULT_COLUMN_COUNT = 2;
        private static final long serialVersionUID = 120L;
        public boolean highlightingMargins = false;
        public boolean displayingSize = false;
        public boolean grayScaleImages = false;
        public boolean fixedZoomFactor = false;
        public boolean fitColumns = false;
        public int fixedColumnCount = 2;

        public String toString() {
            return "\n  highlightingMargins = " + this.highlightingMargins + "\n  displayingSize = " + this.displayingSize + "\n  grayScaleImages = " + this.grayScaleImages + "\n  fixedZoomFactor = " + this.fixedZoomFactor + "\n  fitColumns = " + this.fitColumns + "\n  fixedColumnCount = " + this.fixedColumnCount;
        }
    }
}

