/*
 * Decompiled with CFR 0.152.
 */
package jpdf.gui.controller;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JPanel;
import jpdf.attribute.RequestMediaSizeName;
import jpdf.diagnostics.JpdfInvalidMinimumMarginsException;
import jpdf.diagnostics.MinimumMarginFixer;
import jpdf.gui.PrintInfoHolder;
import jpdf.gui.PrintServiceSelectionObserver;
import jpdf.gui.PrintableAreaUpdateObserver;
import jpdf.gui.component.PrintComponentFactory;
import jpdf.gui.controller.AbstractPrintOptionsControllerPanel;
import jpdf.gui.controller.C;
import jpdf.gui.controller.L;
import jpdf.gui.controller.PageOrientationPanel;
import jpdf.gui.controller.d;
import jpdf.manage.PrintManager;
import jpdf.manage.ResourceAdministrator;
import jpdf.utility.PrintUtility;

public class PageMarginsPanel
extends AbstractPrintOptionsControllerPanel
implements PrintServiceSelectionObserver,
PrintableAreaUpdateObserver {
    private static boolean b = true;
    private static boolean h = true;
    private static float g = 0.1f;
    private static int i = 5;
    private final AbstractPrintOptionsControllerPanel.MarginValuesHolder k = new AbstractPrintOptionsControllerPanel.MarginValuesHolder();
    private PrintInfoHolder a = null;
    private C[] f = new C[4];
    private boolean m = false;
    private boolean j = false;
    static Class l;

    public PageMarginsPanel() {
        this(null, "Margins");
    }

    public PageMarginsPanel(Locale locale) {
        this(locale, ResourceAdministrator.getLocalizedString("margins"));
    }

    public PageMarginsPanel(String string) {
        this(null, string);
    }

    public PageMarginsPanel(Locale locale, String string) {
        super(string);
        this.initializeBorderLayoutContents(this.a(locale), string + " (" + ResourceAdministrator.getMediaSizeUnitsString() + ")");
    }

    public static float getSpinnerIncrementInch() {
        return g;
    }

    public static int getSpinnerIncrementMillimeter() {
        return i;
    }

    public void initializePrintOptions(PrintInfoHolder printInfoHolder) {
        PrintRequestAttributeSet printRequestAttributeSet = printInfoHolder.getAttributeSet();
        this.a(printInfoHolder);
        this.setMarginValues(PageMarginsPanel.computeMarginValues(printRequestAttributeSet, null));
        this.initializeUpdatableContainer(printInfoHolder);
        this.initializePrintableArea(printRequestAttributeSet, printInfoHolder.getSelectedPrintService());
        printInfoHolder.getPrintServiceSetter().addSelectionObserver(this);
    }

    public static boolean isToAllowMinimumMargins() {
        return b;
    }

    public static boolean isToAllowUniformMargins() {
        return h;
    }

    public void selectedPrintService(PrintInfoHolder printInfoHolder) {
        this.updatePrintOptions(printInfoHolder);
    }

    public static void setSpinnerIncrementInch(float f2) {
        if (f2 < 0.01f || f2 > 0.25f) {
            String string = "Invalid Margin Spinner increment: " + f2 + "\nMust be between 0.01 and 0.25 inches.";
            throw new IllegalArgumentException(string);
        }
        g = f2;
    }

    public static void setSpinnerIncrementMillimeter(int n2) {
        if (n2 < 1 || n2 > 10) {
            String string = "Invalid Margin Spinner increment: " + n2 + "\nMust be between 1 and 10 millimeters.";
            throw new IllegalArgumentException(string);
        }
        i = n2;
    }

    public static void setToAllowMinimumMargins(boolean bl) {
        b = bl;
    }

    public static void setToAllowUniformMargins(boolean bl) {
        h = bl;
    }

    public void updatedPrintableArea(PrintInfoHolder printInfoHolder) {
        this.updatePrintOptions(printInfoHolder);
    }

    public boolean updatePrintOptions(PrintInfoHolder printInfoHolder) {
        PrintRequestAttributeSet printRequestAttributeSet = printInfoHolder.getAttributeSet();
        PrintService printService = printInfoHolder.getSelectedPrintService();
        DocFlavor docFlavor = printInfoHolder.getDocFlavor();
        this.a(printService, docFlavor, printRequestAttributeSet);
        if (this.f()) {
            this.g();
        }
        if (this.k() && !this.i()) {
            this.d();
        }
        this.updatePrintableArea(printInfoHolder, this.j(), true, false);
        return true;
    }

    protected PrintInfoHolder getPrintInfoHolder() {
        return this.a;
    }

    protected void setMarginValues(float f2) {
        C[] cArray = this.h();
        cArray[0].setValue(f2);
        cArray[1].setValue(f2);
        cArray[2].setValue(f2);
        cArray[3].setValue(f2);
    }

    protected void setMarginValues(AbstractPrintOptionsControllerPanel.MarginValuesHolder marginValuesHolder) {
        C[] cArray = this.h();
        cArray[0].setValue(marginValuesHolder.topMargin);
        cArray[1].setValue(marginValuesHolder.leftMargin);
        cArray[2].setValue(marginValuesHolder.rightMargin);
        cArray[3].setValue(marginValuesHolder.bottomMargin);
    }

    private JPanel a(Locale locale) {
        boolean bl;
        JPanel jPanel = new JPanel(new BorderLayout(0, 7));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 0));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 7, 0));
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = ResourceAdministrator.getMediaSizeUnits() == 25400;
        boolean bl3 = false;
        boolean bl4 = bl = locale != null;
        if (bl) {
            string = ResourceAdministrator.getLocalizedString("marginTop");
            string2 = ResourceAdministrator.getLocalizedString("marginLeft");
            string3 = ResourceAdministrator.getLocalizedString("marginRight");
            string4 = ResourceAdministrator.getLocalizedString("marginBottom");
        } else {
            string = "Top";
            string2 = "Left";
            string3 = "Right";
            string4 = "Bottom";
        }
        jPanel2.add(this.a(0, string, bl2));
        jPanel2.add(this.a(string2, string3, bl2));
        jPanel2.add(this.a(3, string4, bl2));
        if (PageMarginsPanel.isToAllowMinimumMargins()) {
            string5 = bl ? ResourceAdministrator.getLocalizedString("minimum") : "Minimum";
            jPanel3.add(new L(this, string5, null));
            bl3 = true;
        }
        if (PageMarginsPanel.isToAllowUniformMargins()) {
            string5 = bl ? ResourceAdministrator.getLocalizedString("uniform") : "Uniform";
            jPanel3.add(new d(this, string5, null));
            bl3 = true;
        }
        jPanel.add((Component)jPanel2, "Center");
        if (bl3) {
            jPanel.add((Component)jPanel3, "South");
        }
        return jPanel;
    }

    private JPanel a(int n2, String string, boolean bl) {
        this.f[n2] = bl ? new C(this, 0.0f, 0.0f, 100.0f, PageMarginsPanel.getSpinnerIncrementInch(), null) : new C(this, 0, 0, 10000, PageMarginsPanel.getSpinnerIncrementMillimeter(), null);
        this.f[n2].setName(string);
        return PrintComponentFactory.buildTopLabeledComponentPanel(string, this.f[n2], true);
    }

    private JPanel a(String string, String string2, boolean bl) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        jPanel.add(this.a(1, string, bl));
        jPanel.add(this.a(2, string2, bl));
        return jPanel;
    }

    private void g() {
        C[] cArray = null;
        if (this.k()) {
            this.setMarginValues(this.l());
        } else {
            cArray = this.h();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                cArray[i2].setValueToMinimum();
            }
        }
    }

    private void d() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        f2 = this.e();
        if (f2 < (f3 = this.l())) {
            f2 = f3;
        }
        this.setMarginValues(f2);
    }

    private AbstractPrintOptionsControllerPanel.MarginValuesHolder j() {
        C[] cArray = this.h();
        this.k.topMargin = cArray[0].getFloatValue();
        this.k.leftMargin = cArray[1].getFloatValue();
        this.k.rightMargin = cArray[2].getFloatValue();
        this.k.bottomMargin = cArray[3].getFloatValue();
        return this.k;
    }

    private C[] h() {
        return this.f;
    }

    private float l() {
        C[] cArray = this.h();
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            f3 = cArray[i2].getMinimum();
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    private float e() {
        C[] cArray = this.h();
        float f2 = 9999.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            f3 = cArray[i2].getFloatValue();
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    private boolean i() {
        C[] cArray = this.h();
        return cArray[0].getFloatValue() == cArray[3].getFloatValue() && cArray[1].getFloatValue() == cArray[2].getFloatValue() && cArray[0].getFloatValue() == cArray[1].getFloatValue();
    }

    private boolean f() {
        return this.m;
    }

    private boolean k() {
        return this.j;
    }

    private void a(PrintService printService, MediaSize mediaSize, MediaPrintableArea mediaPrintableArea, boolean bl, boolean bl2) {
        AbstractPrintOptionsControllerPanel.MarginValuesHolder marginValuesHolder = null;
        C[] cArray = this.h();
        String string = "";
        float f2 = 0.0f;
        int n2 = 0;
        marginValuesHolder = PageMarginsPanel.computeMarginValues(mediaSize, mediaPrintableArea, bl, bl2, null);
        if (marginValuesHolder.topMargin < 0.0f) {
            string = string + " top: " + marginValuesHolder.topMargin;
        }
        if (marginValuesHolder.leftMargin < 0.0f) {
            string = string + " left: " + marginValuesHolder.leftMargin;
        }
        if (marginValuesHolder.rightMargin < 0.0f) {
            string = string + " right: " + marginValuesHolder.rightMargin;
        }
        if (marginValuesHolder.bottomMargin < 0.0f) {
            string = string + " bottom: " + marginValuesHolder.bottomMargin;
        }
        if (string.length() > 0) {
            n2 = ResourceAdministrator.getMediaSizeUnits();
            marginValuesHolder.topMargin = f2 = n2 == 25400 ? 0.25f : 7.0f;
            marginValuesHolder.leftMargin = f2;
            marginValuesHolder.bottomMargin = f2;
            marginValuesHolder.rightMargin = f2;
            string = "Invalid negative margin minimums converted to " + f2 + ":\n   " + string;
            JpdfInvalidMinimumMarginsException jpdfInvalidMinimumMarginsException = new JpdfInvalidMinimumMarginsException(printService, string, false, f2);
            PrintManager.handleException(jpdfInvalidMinimumMarginsException);
        }
        cArray[0].setMinimum(marginValuesHolder.topMargin);
        cArray[1].setMinimum(marginValuesHolder.leftMargin);
        cArray[2].setMinimum(marginValuesHolder.rightMargin);
        cArray[3].setMinimum(marginValuesHolder.bottomMargin);
    }

    private void a(PrintInfoHolder printInfoHolder) {
        this.a = printInfoHolder;
    }

    private void b(boolean bl) {
        this.m = bl;
    }

    private void a(boolean bl) {
        this.j = bl;
    }

    private void a(PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) {
        MediaPrintableArea mediaPrintableArea = null;
        MediaSizeName mediaSizeName = null;
        MediaSize mediaSize = null;
        Media media = null;
        media = (Media)printRequestAttributeSet.get(l == null ? (l = PageMarginsPanel.class$("javax.print.attribute.standard.Media")) : l);
        if (media instanceof MediaSizeName) {
            mediaSizeName = (MediaSizeName)media;
        } else {
            mediaSizeName = PrintUtility.getMediaSizeName(printRequestAttributeSet);
            printRequestAttributeSet = new HashPrintRequestAttributeSet(printRequestAttributeSet);
            printRequestAttributeSet.add(mediaSizeName);
        }
        mediaPrintableArea = MinimumMarginFixer.getFixedPrintableArea(printService, mediaSizeName);
        if (mediaPrintableArea == null) {
            mediaPrintableArea = PrintUtility.getSupportedPrintableArea(printService, printRequestAttributeSet, null);
        }
        if (mediaPrintableArea != null) {
            mediaSize = RequestMediaSizeName.getMediaSize(mediaSizeName);
            this.a(printService, mediaSize, mediaPrintableArea, PageOrientationPanel.isLandscape(printRequestAttributeSet), PageOrientationPanel.isReverse(printRequestAttributeSet));
        }
    }

    static boolean f(PageMarginsPanel pageMarginsPanel) {
        return pageMarginsPanel.k();
    }

    static AbstractPrintOptionsControllerPanel.MarginValuesHolder g(PageMarginsPanel pageMarginsPanel) {
        return pageMarginsPanel.j();
    }

    static float c(PageMarginsPanel pageMarginsPanel) {
        return pageMarginsPanel.l();
    }

    static boolean a(PageMarginsPanel pageMarginsPanel) {
        return pageMarginsPanel.i();
    }

    static void a(PageMarginsPanel pageMarginsPanel, boolean bl) {
        pageMarginsPanel.a(bl);
    }

    static C[] b(PageMarginsPanel pageMarginsPanel) {
        return pageMarginsPanel.h();
    }

    static void b(PageMarginsPanel pageMarginsPanel, boolean bl) {
        pageMarginsPanel.b(bl);
    }

    static void e(PageMarginsPanel pageMarginsPanel) {
        pageMarginsPanel.g();
    }

    static void h(PageMarginsPanel pageMarginsPanel) {
        pageMarginsPanel.d();
    }

    static boolean d(PageMarginsPanel pageMarginsPanel) {
        return pageMarginsPanel.f();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

