/*
 * Decompiled with CFR 0.152.
 */
package jpdf.diagnostics;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import jpdf.diagnostics.m;
import jpdf.manage.PrintManager;

public class ThreadTracer {
    public static void writeStackTraces(boolean bl) {
        ThreadTracer.writeStackTraces(System.out, bl);
    }

    public static void writeStackTraces(String string, boolean bl) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(string);
            ThreadTracer.writeStackTraces(printStream, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            PrintManager.handleException(fileNotFoundException, true);
        }
    }

    public static void writeStackTraces(PrintStream printStream, boolean bl) {
        StackTraceElement[] stackTraceElementArray = null;
        Thread[] threadArray = null;
        Thread thread = null;
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Set<Thread> set = map.keySet();
        threadArray = set.toArray(new Thread[0]);
        for (int i2 = 0; i2 < threadArray.length; ++i2) {
            thread = threadArray[i2];
            if (thread.isDaemon() && !bl) continue;
            printStream.println("\"" + thread.getName() + "\"" + " " + (thread.isDaemon() ? "daemon" : "") + " priority=" + thread.getPriority() + " Thread id=" + thread.getId() + " " + (Object)((Object)thread.getState()));
            stackTraceElementArray = map.get(thread);
            for (int i3 = 0; i3 < stackTraceElementArray.length; ++i3) {
                printStream.println("\t" + stackTraceElementArray[i3]);
            }
            printStream.println("");
        }
    }

    public static void writeStackTraces(PrintStream printStream, boolean bl, int n2) {
        Thread thread = null;
        m m2 = null;
        m2 = new m(printStream, bl, n2, null);
        thread = new Thread((Runnable)m2, "ThreadTracer");
        thread.setPriority(10);
        thread.start();
    }

    public static void writeStackTraces(String string, boolean bl, int n2) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(string);
            ThreadTracer.writeStackTraces(printStream, bl, n2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            PrintManager.handleException(fileNotFoundException, true);
        }
    }
}

