/*
 * Decompiled with CFR 0.152.
 */
package jpdf.diagnostics;

import java.awt.print.PageFormat;
import java.util.Arrays;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.standard.MediaPrintableArea;
import jpdf.diagnostics.s;
import jpdf.manage.PrintServiceRegistry;
import jpdf_common.system.log.BasicDebugger;

public class PrintDebugger
extends BasicDebugger {
    private PrintDebugger() {
    }

    public static String buildPrintAttributeSetMessage(AttributeSet attributeSet, boolean bl) {
        Attribute[] attributeArray = attributeSet.toArray();
        String string = null;
        string = bl ? "\n[*Print Attribute Set*] " + attributeSet.toString() : "";
        Arrays.sort(attributeArray, new s(null));
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            string = string + "\n\t" + attributeArray[i2].getName() + " : ";
            if (attributeArray[i2] instanceof TextSyntax) {
                string = string + ((TextSyntax)((Object)attributeArray[i2])).getValue();
                continue;
            }
            if (attributeArray[i2] instanceof IntegerSyntax) {
                string = string + ((IntegerSyntax)((Object)attributeArray[i2])).getValue();
                continue;
            }
            if (attributeArray[i2] instanceof Size2DSyntax) {
                string = string + ((Size2DSyntax)((Object)attributeArray[i2])).toString(25400, " inches");
                continue;
            }
            if (attributeArray[i2] instanceof MediaPrintableArea) {
                MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)attributeArray[i2];
                string = string + mediaPrintableArea.toString(25400, " inches");
                continue;
            }
            string = string + attributeArray[i2].toString();
        }
        return string;
    }

    public static void logPageFormat(PageFormat pageFormat) {
        PrintDebugger.logMessageAsIs("\nPage Format: " + pageFormat.getImageableX() + " " + pageFormat.getImageableX() + " " + pageFormat.getImageableWidth() + " " + pageFormat.getImageableHeight());
    }

    public static void logDefaultAttributeValue(PrintService printService, Class clazz) {
        Object object = printService.getDefaultAttributeValue(clazz);
        String string = "\nDefault Attribute Value for " + clazz.getName() + " = ";
        string = object != null ? string + "\n\t" + object.getClass().getName() + " : " + object : string + "<null>";
        PrintDebugger.logMessageAsIs(string);
    }

    public static void logPrintAttributeSet(AttributeSet attributeSet) {
        PrintDebugger.logMessageAsIs(PrintDebugger.buildPrintAttributeSetMessage(attributeSet, true));
    }

    public static void logPrintServiceSupportedAttributes(PrintService printService) {
        Class<?>[] classArray = printService.getSupportedAttributeCategories();
        StringBuffer stringBuffer = new StringBuffer(64 * (classArray.length + 1));
        Object object = null;
        stringBuffer.append("[* Supported Attributes for Print Service: " + printService.getName() + " *] ");
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append("\n  " + i2 + ".\t" + classArray[i2] + " = ");
            object = printService.getDefaultAttributeValue(classArray[i2]);
            if (object != null) {
                stringBuffer.append(((Attribute)object).getName() + " : " + object);
                continue;
            }
            stringBuffer.append("<null>");
        }
        PrintDebugger.logMessageAsIs(stringBuffer.toString());
    }

    public static void logPrintServiceSupportedFlavors() {
        PrintService[] printServiceArray = PrintServiceRegistry.lookupPrintServices(null, null);
        for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
            PrintDebugger.logPrintServiceSupportedFlavors(printServiceArray[i2]);
        }
    }

    public static void logPrintServiceSupportedFlavors(PrintService printService) {
        DocFlavor[] docFlavorArray = printService.getSupportedDocFlavors();
        StringBuffer stringBuffer = new StringBuffer(32 * (docFlavorArray.length + 1));
        stringBuffer.append("[* Supported Doc Flavors for Print Service: " + printService.getName() + " *] ");
        for (int i2 = 0; i2 < docFlavorArray.length; ++i2) {
            stringBuffer.append("\n  " + i2 + ".\t" + docFlavorArray[i2]);
        }
        PrintDebugger.logMessageAsIs(stringBuffer.toString());
    }
}

