/*
 * Decompiled with CFR 0.152.
 */
package jpdf.diagnostics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.print.Printable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import jpdf.attribute.PageFootNotes;
import jpdf.attribute.ScaleFactor;
import jpdf.attribute.UseBackgroundColor;
import jpdf.attribute.WrapToFitPage;
import jpdf.diagnostics.MinimumMarginFixer;
import jpdf.diagnostics.PrintDebugger;
import jpdf.diagnostics.a;
import jpdf.diagnostics.b;
import jpdf.diagnostics.d;
import jpdf.diagnostics.e;
import jpdf.diagnostics.f;
import jpdf.diagnostics.h;
import jpdf.diagnostics.i;
import jpdf.diagnostics.j;
import jpdf.diagnostics.k;
import jpdf.diagnostics.l;
import jpdf.diagnostics.n;
import jpdf.diagnostics.o;
import jpdf.diagnostics.q;
import jpdf.manage.PrintInfoStateObserver;
import jpdf.manage.PrintManager;
import jpdf.manage.PrintServiceRegistry;
import jpdf.manage.ResourceAdministrator;
import jpdf.printer.AbstractComponentPrinter;
import jpdf.printer.PrinterFactory;
import jpdf.utility.PrintUtility;
import jpdf_common.gui.component.popup.ColorPopupPanelFactory;
import jpdf_common.gui.component.popup.ColorSelectionPopupPanel;
import jpdf_common.gui.component.popupmenu.PopupMenuButton;
import jpdf_common.gui.component.spinner.UneditableSpinner;
import jpdf_common.gui.layout.DividingFlowLayout;
import jpdf_common.gui.layout.RowLayout;
import jpdf_common.gui.manage.BasicUserNotificationManager;
import jpdf_common.gui.plaf.PlafPainter;
import jpdf_common.system.manage.ErrorHandler;
import jpdf_common.system.manage.IconRetriever;
import jpdf_common.system.utility.StringUtility;
import jpdf_common.system.utility.SystemUtility;

public class LogPanel
extends JPanel
implements ErrorHandler,
PrintInfoStateObserver {
    public static final String LOG_ATTRIBUTES_LABEL = " Selected Print Attributes (JPDF attributes begin with '@'.):";
    private static final Color m = new Color(188, 44, 44);
    private static final Color h = Color.YELLOW;
    private static final Font i;
    private final d f = new d(null);
    private final i k = new i(this, null);
    private ColorSelectionPopupPanel o = null;
    private ColorSelectionPopupPanel e = null;
    private PopupMenuButton d = null;
    private JSpinner a = null;
    private JLabel b = null;
    private JCheckBox c = null;
    private boolean j = true;
    private boolean g = false;
    static Class l;
    static Class n;

    public LogPanel() {
        this.i();
    }

    public void addControl(JComponent jComponent) {
        ((JPanel)this.getComponent(0)).add(jComponent);
    }

    public void addLogOperationMenuItem(Action action) {
        PopupMenuButton popupMenuButton = this.h();
        if (popupMenuButton != null) {
            popupMenuButton.addPopupMenuItem(action);
        }
    }

    public void addLogOperationMenuItem(JMenuItem jMenuItem) {
        PopupMenuButton popupMenuButton = this.h();
        if (popupMenuButton != null) {
            popupMenuButton.addPopupMenuItem(jMenuItem);
        }
    }

    public void addLogOperationMenuSeparator() {
        PopupMenuButton popupMenuButton = this.h();
        if (popupMenuButton != null) {
            popupMenuButton.addPopupMenuSeparator();
        }
    }

    public static String buildPrinterListString() {
        return LogPanel.buildPrinterListString(PrintServiceRegistry.lookupPrintServices(null, null));
    }

    public static String buildPrinterListString(PrintService[] printServiceArray) {
        PrintService printService = PrintManager.getDefaultPrintService();
        StringBuffer stringBuffer = new StringBuffer(printServiceArray.length * 50);
        PrintServiceAttributeSet printServiceAttributeSet = null;
        Arrays.sort(printServiceArray, StringUtility.getCaseInsensitiveStringComparator());
        for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
            try {
                stringBuffer.append("\n  " + printServiceArray[i2].toString());
                if (printServiceArray[i2] instanceof MultiDocPrintService) {
                    stringBuffer.append(" [MultiDoc] ");
                }
                if (printServiceArray[i2].getName() == printService.getName()) {
                    stringBuffer.append(" [Default] ");
                }
                stringBuffer.append("\n  ------------------------------------------");
                printServiceAttributeSet = printServiceArray[i2].getAttributes();
                stringBuffer.append(PrintDebugger.buildPrintAttributeSetMessage(printServiceAttributeSet, false) + "\n");
                continue;
            }
            catch (Throwable throwable) {
                stringBuffer.append("\n\n**** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            }
        }
        return stringBuffer.toString();
    }

    public static String buildPrinterSupportedAttributesString(PrintService printService, boolean bl) {
        MediaPrintableArea mediaPrintableArea = null;
        StringBuffer stringBuffer = new StringBuffer(512);
        Comparator comparator = StringUtility.getCaseInsensitiveStringComparator();
        Class<?>[] classArray = null;
        String string = null;
        String string2 = null;
        Class<?> clazz = null;
        if (bl) {
            stringBuffer.append(printService.toString());
        }
        stringBuffer.append("\n\n    Supported Attributes [default value]\n    ----------------------------------------");
        try {
            classArray = printService.getSupportedAttributeCategories();
            Arrays.sort(classArray, comparator);
        }
        catch (Throwable throwable) {
            stringBuffer.append("\n\n**** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            return stringBuffer.toString();
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            try {
                clazz = classArray[i2];
                string2 = clazz.getName();
                stringBuffer.append("\n    " + string2 + " [");
                if (classArray[i2] == (l == null ? LogPanel.class$("javax.print.attribute.standard.MediaPrintableArea") : l)) {
                    mediaPrintableArea = (MediaPrintableArea)printService.getDefaultAttributeValue(clazz);
                    string = mediaPrintableArea.toString(ResourceAdministrator.getMediaSizeUnits(), ResourceAdministrator.getMediaSizeUnitsString());
                    stringBuffer.append(string + "]");
                    continue;
                }
                stringBuffer.append(printService.getDefaultAttributeValue(clazz) + "]");
                continue;
            }
            catch (Throwable throwable) {
                stringBuffer.append("\n\n**** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            }
        }
        return stringBuffer.toString();
    }

    public static String buildPrinterSupportedDocFlavorsString(PrintService printService, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(512);
        Comparator comparator = StringUtility.getCaseInsensitiveStringComparator();
        DocFlavor[] docFlavorArray = null;
        if (bl) {
            stringBuffer.append(printService.toString());
        }
        stringBuffer.append("\n\n    Supported Doc Flavors\n    ----------------------------------------");
        try {
            docFlavorArray = printService.getSupportedDocFlavors();
            Arrays.sort(docFlavorArray, comparator);
        }
        catch (Throwable throwable) {
            stringBuffer.append("\n\n**** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            return stringBuffer.toString();
        }
        for (int i2 = 0; i2 < docFlavorArray.length; ++i2) {
            try {
                stringBuffer.append("\n    " + docFlavorArray[i2]);
                continue;
            }
            catch (Throwable throwable) {
                stringBuffer.append("\n\n**** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            }
        }
        return stringBuffer.toString();
    }

    public static String buildPrinterSupportedMediaString(PrintService printService, boolean bl) {
        MediaPrintableArea mediaPrintableArea = null;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        StringBuffer stringBuffer = new StringBuffer(512);
        NumberFormat numberFormat = NumberFormat.getInstance();
        MediaSizeName mediaSizeName = null;
        Media[] mediaArray = null;
        String string = null;
        if (bl) {
            stringBuffer.append(printService.toString());
        }
        stringBuffer.append("\n\n    Supported Media\n    ----------------------------------------");
        try {
            mediaArray = (Media[])printService.getSupportedAttributeValues(n == null ? (n = LogPanel.class$("javax.print.attribute.standard.Media")) : n, null, null);
            Arrays.sort(mediaArray, StringUtility.getClassStringComparator());
            numberFormat.setMaximumFractionDigits(ResourceAdministrator.isUsingInches() ? 3 : 1);
        }
        catch (Throwable throwable) {
            stringBuffer.append("\n\n**** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            return stringBuffer.toString();
        }
        for (int i2 = 0; i2 < mediaArray.length; ++i2) {
            try {
                stringBuffer.append("\n    " + mediaArray[i2].getClass().getName() + " : ");
                if (mediaArray[i2] instanceof MediaSizeName) {
                    mediaSizeName = (MediaSizeName)mediaArray[i2];
                    stringBuffer.append(ResourceAdministrator.getMediaSizeName(mediaSizeName, true, false));
                    hashPrintRequestAttributeSet.add(mediaSizeName);
                    mediaPrintableArea = PrintUtility.getSupportedPrintableArea(printService, hashPrintRequestAttributeSet, null);
                    if (mediaPrintableArea == null) continue;
                    string = ResourceAdministrator.getMarginsString(mediaSizeName, mediaPrintableArea, numberFormat);
                    stringBuffer.append("\n      Mimimum Margins: " + string);
                    continue;
                }
                stringBuffer.append(((Object)mediaArray[i2]).toString());
                continue;
            }
            catch (Throwable throwable) {
                stringBuffer.append("\n\n**** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            }
        }
        return stringBuffer.toString();
    }

    public static JDialog createContainingLogDialog(JFrame jFrame, String string, int n2, int n3, int n4, int n5) {
        return new LogPanel().createLogDialog(jFrame, string, n2, n3, n4, n5);
    }

    public static JFrame createContainingLogFrame(String string, int n2, int n3, int n4, int n5) {
        return new LogPanel().createLogFrame(string, n2, n3, n4, n5);
    }

    public JDialog createLogDialog(JFrame jFrame, String string, int n2, int n3, int n4, int n5) {
        JDialog jDialog = new JDialog(jFrame, string, false);
        jDialog.getContentPane().add(this);
        jDialog.setLocation(n2, n3);
        jDialog.setSize(n4, n5);
        return jDialog;
    }

    public JFrame createLogFrame(String string, int n2, int n3, int n4, int n5) {
        JFrame jFrame = new JFrame(string);
        jFrame.getContentPane().add(this);
        jFrame.setLocation(n2, n3);
        jFrame.setSize(n4, n5);
        return jFrame;
    }

    public static JLabel createStatusLabel(String string) {
        return LogPanel.createStatusLabel(string, false);
    }

    public static JLabel createStatusLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel(string);
        if (bl) {
            jLabel.setBackground(m);
            jLabel.setForeground(h);
            jLabel.setOpaque(true);
        } else {
            jLabel.setForeground(m);
        }
        jLabel.setFont(i);
        jLabel.setBorder(BorderFactory.createLineBorder(m));
        jLabel.setHorizontalAlignment(0);
        return jLabel;
    }

    public void defaultedPrintService(PrintService printService) {
        String string = printService.getName();
        this.g().setText(" " + string + " ");
        this.k.setToolTipText("Print Log (" + string + ")");
    }

    public void displayAttributeSet(String string, AttributeSet attributeSet) {
        String string2 = null;
        string2 = PrintDebugger.buildPrintAttributeSetMessage(attributeSet, false);
        this.displayOperationMessage(string, string2, false);
    }

    public void displayErrorMessage(String string, String string2) {
        BasicUserNotificationManager.displayErrorMessage(string, string2);
        this.f.append("\n*** ERROR: " + string + "\n------------------------------------------------\n" + string2 + "\n");
    }

    public void displayException(Throwable throwable, String string) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        this.f.append("\n*** " + string + ": " + throwable + "\n------------------------------------------------\n");
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            this.f.append(stackTraceElementArray[i2].toString() + '\n');
        }
    }

    public void displayMessage(String string) {
        this.f.append(string + "\n");
    }

    public void displayOperationMessage(String string, String string2, boolean bl) {
        string = string == null ? "" : string + (bl ? "\n\t" : "\n");
        if (bl) {
            string2 = string2.replaceAll("\n", "\n\t");
        }
        this.f.append("\n==============================================\n" + string + string2 + "\n==============================================\n");
    }

    public void displayPrinterList(String string, PrintService[] printServiceArray) {
        this.displayOperationMessage(string, LogPanel.buildPrinterListString(printServiceArray), false);
    }

    public void displayPrinterSupportedAttributes(String string, PrintService printService) {
        String string2 = LogPanel.buildPrinterSupportedAttributesString(printService, true);
        this.displayOperationMessage(string, string2, false);
    }

    public void displayPrinterSupportedDocFlavors(String string, PrintService printService) {
        String string2 = LogPanel.buildPrinterSupportedDocFlavorsString(printService, true);
        this.displayOperationMessage(string, string2, false);
    }

    public void displayPrinterSupportedMedia(String string, PrintService printService) {
        String string2 = LogPanel.buildPrinterSupportedMediaString(printService, true);
        this.displayOperationMessage(string, string2, false);
    }

    public void eraseLog() {
        this.f.setText("");
    }

    public Color getLogBackgroundColor() {
        return this.f.getBackground();
    }

    public Font getLogFont() {
        return this.f.getFont();
    }

    public Color getLogForegroundColor() {
        return this.f.getForeground();
    }

    public void handleError(Throwable throwable, boolean bl) {
        if (bl || this.isToDisplayAllErrors()) {
            BasicUserNotificationManager.displayException_System(throwable);
            this.displayException(throwable, "ERROR");
        }
    }

    public void handleUncaughtError(Throwable throwable) {
        BasicUserNotificationManager.displayException_Uncaught(throwable);
        this.displayException(throwable, "UNCAUGHT ERROR");
    }

    public boolean isLogging() {
        return this.j;
    }

    public boolean isToDisplayAllErrors() {
        return this.g;
    }

    public void logAttributeSet(String string, AttributeSet attributeSet) {
        String string2 = null;
        if (this.isLogging()) {
            string2 = PrintDebugger.buildPrintAttributeSetMessage(attributeSet, false);
            this.displayOperationMessage(string, string2, false);
        }
    }

    public void logDialogDisplay(String string) {
        String string2 = null;
        string2 = "\n\n -------------------------------------------------------\n Display: " + string;
        this.logMessage(string2);
    }

    public void logMessage(String string) {
        if (this.isLogging()) {
            this.f.append(string + "\n");
        }
    }

    public void requestFocus() {
        this.f.requestFocus();
    }

    public void setLogBackgroundColor(Color color) {
        ColorSelectionPopupPanel colorSelectionPopupPanel = this.d();
        if (colorSelectionPopupPanel != null) {
            colorSelectionPopupPanel.selectColor(color, true);
        } else {
            this.f.setBackground(color);
        }
    }

    public void setLogFont(Font font) {
        JSpinner jSpinner = this.e();
        this.f.setFont(font);
        if (jSpinner != null) {
            jSpinner.setValue(new Integer(font.getSize()));
        }
    }

    public void setLogForegroundColor(Color color) {
        ColorSelectionPopupPanel colorSelectionPopupPanel = this.f();
        if (colorSelectionPopupPanel != null) {
            colorSelectionPopupPanel.selectColor(color, true);
        } else {
            this.f.setForeground(color);
        }
    }

    public void setLogging(boolean bl) {
        JCheckBox jCheckBox = this.b();
        this.j = bl;
        if (jCheckBox != null) {
            jCheckBox.setSelected(bl);
        }
    }

    public void setToDisplayAllErrors(boolean bl) {
        this.g = bl;
    }

    protected void addBackgroundColorPopup(JPanel jPanel) {
        this.o = ColorPopupPanelFactory.buildBackgroundColorInstance(this.f);
        jPanel.add(this.o);
        this.o.setToolTipText("Select Log Background Color");
    }

    protected void addControls(JPanel jPanel) {
        this.addLogOperationMenuButton(jPanel);
        this.addEraseLogButton(jPanel);
        this.addPrintLogButton(jPanel);
        this.addLoggingCheckBox(jPanel);
        this.addFontSizeSpinner(jPanel);
        this.addForegroundColorPopup(jPanel);
        if (!PlafPainter.isUsingGtkLookAndFeel()) {
            this.addBackgroundColorPopup(jPanel);
        }
        this.addDefaultPrintServiceLabel(jPanel);
    }

    protected void addDefaultPrintServiceLabel(JPanel jPanel) {
        JLabel jLabel = this.c();
        jPanel.add(jLabel);
        PrintManager.setPrintInfoStateObserver(this);
        this.defaultedPrintService(PrintManager.getDefaultPrintService());
    }

    protected void addEraseLogButton(JPanel jPanel) {
        JButton jButton = null;
        jButton = new JButton("Erase Log", IconRetriever.getRemoveButtonIcon());
        jButton.addActionListener(new n(this));
        jPanel.add(jButton);
    }

    protected void addFontSizeSpinner(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new RowLayout(0, 1));
        this.a = new UneditableSpinner(new SpinnerNumberModel(8, 8, 99, 1));
        this.a.setValue(new Integer(this.getLogFont().getSize()));
        this.a.addChangeListener(new j(this));
        jPanel2.add(new JLabel(" Font Size:"));
        jPanel2.add(this.a);
        jPanel.add(jPanel2);
    }

    protected void addForegroundColorPopup(JPanel jPanel) {
        this.e = ColorPopupPanelFactory.buildForegroundColorInstance(this.f);
        jPanel.add(this.e);
        this.e.setToolTipText("Select Log Foreground Color");
    }

    protected void addLoggingCheckBox(JPanel jPanel) {
        this.c = new JCheckBox("Logging", true);
        this.c.addActionListener(new f(this));
        jPanel.add(this.c);
    }

    protected void addLogDefaultPrintAttributesButton(JPanel jPanel) {
        JButton jButton = null;
        jButton = new JButton("Log Default Print Attributes");
        jButton.addActionListener(new a(this));
        jPanel.add(jButton);
    }

    protected void addLogDefaultPrintServiceButton(JPanel jPanel) {
        JButton jButton = null;
        jButton = new JButton("Log Default Print Service");
        jButton.addActionListener(new o(this));
        jPanel.add(jButton);
    }

    protected void addLogOperationMenuButton(JPanel jPanel) {
        this.d = new PopupMenuButton("Log", true);
        jPanel.add(this.d);
        this.d.addPopupMenuItem(new h(this), "Printer List");
        this.d.addPopupMenuItem(new e(this), "Selected Print Attributes");
        this.d.addPopupMenuItem(new k(this), "Selected Printer - Supported Attributes");
        this.d.addPopupMenuItem(new q(this), "Selected Printer - Supported Doc Flavors");
        this.d.addPopupMenuItem(new b(this), "Selected Printer - Supported Media");
        this.d.addPopupMenuSeparator();
        this.d.addPopupMenuItem(new l(this), "Copy Selection To Clipboard");
    }

    protected void addPrintLogButton(JPanel jPanel) {
        jPanel.add(this.k);
    }

    protected JPanel createControlPanel() {
        Object var1_1 = null;
        JPanel jPanel = new JPanel(new DividingFlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 2, 2, 2));
        this.addControls(jPanel);
        return jPanel;
    }

    protected void printContents() {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = this.a();
        AbstractComponentPrinter abstractComponentPrinter = this.a(hashPrintRequestAttributeSet);
        PrintManager.printPrintable((Printable)abstractComponentPrinter, hashPrintRequestAttributeSet);
    }

    private AbstractComponentPrinter a(PrintRequestAttributeSet printRequestAttributeSet) {
        AbstractComponentPrinter abstractComponentPrinter = null;
        abstractComponentPrinter = PrinterFactory.buildComponentPrinter((Component)this.f, "Log Panel", printRequestAttributeSet);
        ((JTextArea)abstractComponentPrinter.getTargetComponent()).setLineWrap(true);
        return abstractComponentPrinter;
    }

    private JLabel c() {
        this.b = LogPanel.createStatusLabel("PS: ???");
        return this.b;
    }

    private HashPrintRequestAttributeSet a() {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        float f2 = 0.0f;
        f2 = MinimumMarginFixer.getFixedMarginWidth(PrintManager.getDefaultPrintService(), 0.33f);
        PrintUtility.updateAttributeSet(true, f2, (AttributeSet)hashPrintRequestAttributeSet, false);
        hashPrintRequestAttributeSet.add(new ScaleFactor(0.75f));
        hashPrintRequestAttributeSet.add(WrapToFitPage.TRUE);
        hashPrintRequestAttributeSet.add(UseBackgroundColor.FALSE);
        hashPrintRequestAttributeSet.add(new PageFootNotes("JPDF Log", "[-s-]", "[-d-] [-t-]"));
        return hashPrintRequestAttributeSet;
    }

    private ColorSelectionPopupPanel d() {
        return this.o;
    }

    private JLabel g() {
        return this.b;
    }

    private JSpinner e() {
        return this.a;
    }

    private ColorSelectionPopupPanel f() {
        return this.e;
    }

    private JCheckBox b() {
        return this.c;
    }

    private PopupMenuButton h() {
        return this.d;
    }

    private void i() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.add((Component)this.createControlPanel(), "North");
        this.add((Component)new JScrollPane(this.f), "Center");
    }

    static d a(LogPanel logPanel) {
        return logPanel.f;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Font font = PlafPainter.getPlafPainter().getDefaultLabelFont();
        if (!font.isBold()) {
            font = font.deriveFont(1);
        }
        i = font;
    }
}

