/*
 * Decompiled with CFR 0.152.
 */
package jpdf.diagnostics;

import jpdf_common.system.manage.Diagnostic;

public abstract class JpdfException
extends Exception
implements Diagnostic {
    public JpdfException() {
    }

    public JpdfException(String string) {
        super(string);
    }

    public JpdfException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public String getDetailedExplanation() {
        return this.getMessage();
    }

    public String getDetailedExplanation(boolean bl, int n2) {
        String string = this.getDetailedExplanation();
        if (bl) {
            string = string + "<HR><CODE>" + JpdfException.getExceptionTraceHtml(this, n2) + "</CODE>";
        }
        return string;
    }

    public String getTitle() {
        return this.isWarning() ? "System Warning" : "System Critical Error";
    }

    public boolean isLocalized() {
        return false;
    }

    public boolean isWarning() {
        return false;
    }

    protected static String getExceptionTraceHtml(Throwable throwable) {
        return JpdfException.getExceptionTraceHtml(throwable, 999);
    }

    protected static String getExceptionTraceHtml(Throwable throwable, int n2) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StringBuffer stringBuffer = null;
        int n3 = Math.min(stackTraceElementArray.length, n2);
        stringBuffer = new StringBuffer(100 * n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuffer.append("<BR>&nbsp;&nbsp;&nbsp;&nbsp;" + stackTraceElementArray[i2].toString());
        }
        if (n3 < stackTraceElementArray.length) {
            stringBuffer.append("<BR>&nbsp;&nbsp;&nbsp;&nbsp;... " + (stackTraceElementArray.length - n3) + " more");
        }
        return stringBuffer.toString();
    }

    protected static StackTraceElement getExceptionTraceLastElement(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        return stackTraceElementArray.length > 0 ? stackTraceElementArray[0] : null;
    }
}

