/*
 * Decompiled with CFR 0.152.
 */
package jpdf.diagnostics;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.AttributeSet;
import jpdf.diagnostics.JpdfDiagnosticsException;
import jpdf.diagnostics.JpdfException;
import jpdf.diagnostics.JpdfNoPrintServiceException;
import jpdf.diagnostics.JpdfPrintServiceDiagnosticException;
import jpdf.diagnostics.JpdfUnexpectedException;
import jpdf.diagnostics.LogPanel;
import jpdf.diagnostics.PrintDebugger;
import jpdf.manage.PrintManager;
import jpdf.manage.PrintServiceRegistry;
import jpdf_common.gui.dialog.exception.AbstractExceptionDialog;
import jpdf_common.system.utility.SystemUtility;

public class DiagnosticsManager {
    static Class a;

    private DiagnosticsManager() {
    }

    public static String buildAttributeSetString(AttributeSet attributeSet) {
        return PrintDebugger.buildPrintAttributeSetMessage(attributeSet, false);
    }

    public static String buildEnvironmentInfoString(String string) {
        return string + "\n---------------------------------------\n" + "JPDF " + "1.7.1" + '\n' + "Operating System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + '\n' + "    Java Runtime: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + '\n' + "            Time: " + new Date() + '\n';
    }

    public static void copyToClipboard(String string) {
        Clipboard clipboard = null;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(string), null);
        }
        catch (Throwable throwable) {
            PrintManager.handleException(throwable);
        }
    }

    public static String[] getBadPrintServiceNames() {
        LineNumberReader lineNumberReader = null;
        Vector<String> vector = new Vector<String>(5);
        String[] stringArray = null;
        String string = null;
        int n2 = 0;
        try {
            lineNumberReader = new LineNumberReader(new FileReader("JPDF_BadPrintService.txt"));
            while ((string = lineNumberReader.readLine()) != null) {
                if (string.trim().length() <= 0) continue;
                vector.add(string);
                ++n2;
            }
            if (n2 > 0) {
                stringArray = vector.toArray(new String[n2]);
            }
            lineNumberReader.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringArray;
    }

    public static void initialize() {
        AbstractExceptionDialog.setErrorInformationPrefix("JPDF 1.7.1");
    }

    public static JpdfDiagnosticsException runDiagnostics() {
        JpdfPrintServiceDiagnosticException[] jpdfPrintServiceDiagnosticExceptionArray = null;
        JpdfDiagnosticsException jpdfDiagnosticsException = new JpdfDiagnosticsException();
        PrintService[] printServiceArray = null;
        String string = null;
        boolean bl = false;
        int n2 = 0;
        System.out.println("Running JPDF Diagnostics");
        try {
            printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            boolean bl2 = bl = printServiceArray == null || printServiceArray.length == 0;
            if (bl) {
                jpdfDiagnosticsException.addJpdfException(new JpdfNoPrintServiceException());
            } else {
                jpdfPrintServiceDiagnosticExceptionArray = DiagnosticsManager.a(printServiceArray);
                if (jpdfPrintServiceDiagnosticExceptionArray != null) {
                    n2 = jpdfPrintServiceDiagnosticExceptionArray.length;
                    for (int i2 = 0; i2 < jpdfPrintServiceDiagnosticExceptionArray.length; ++i2) {
                        string = jpdfPrintServiceDiagnosticExceptionArray[i2].PRINT_SERVICE.getName();
                        System.out.println("  >>>[DiagnosticsManager] Bad Printer: " + string);
                        jpdfDiagnosticsException.addJpdfException(jpdfPrintServiceDiagnosticExceptionArray[i2]);
                    }
                    DiagnosticsManager.a(jpdfPrintServiceDiagnosticExceptionArray);
                }
            }
        }
        catch (Throwable throwable) {
            jpdfDiagnosticsException.addJpdfException(new JpdfUnexpectedException(throwable));
        }
        if (n2 > 0) {
            DiagnosticsManager.writePrintServiceDiagnosticsFile();
        }
        if (jpdfDiagnosticsException.getJpdfExceptionCount() == 0) {
            jpdfDiagnosticsException = null;
            System.out.println("  No problems found.");
        } else {
            DiagnosticsManager.a(jpdfDiagnosticsException);
        }
        return jpdfDiagnosticsException;
    }

    public static JpdfDiagnosticsException runQuickDiagnostics() {
        JpdfPrintServiceDiagnosticException[] jpdfPrintServiceDiagnosticExceptionArray = null;
        JpdfDiagnosticsException jpdfDiagnosticsException = new JpdfDiagnosticsException();
        PrintService[] printServiceArray = null;
        PrintService printService = null;
        String string = null;
        boolean bl = false;
        int n2 = 0;
        System.out.println("Running JPDF Quick Diagnostics");
        try {
            printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            boolean bl2 = bl = printServiceArray == null || printServiceArray.length == 0;
            if (bl) {
                jpdfDiagnosticsException.addJpdfException(new JpdfNoPrintServiceException());
            } else {
                printService = PrintServiceRegistry.lookupDefaultPrintService();
                if (printService == null) {
                    printService = printServiceArray[0];
                }
                if ((jpdfPrintServiceDiagnosticExceptionArray = DiagnosticsManager.a(printServiceArray = new PrintService[]{printService})) != null) {
                    n2 = jpdfPrintServiceDiagnosticExceptionArray.length;
                    for (int i2 = 0; i2 < jpdfPrintServiceDiagnosticExceptionArray.length; ++i2) {
                        string = jpdfPrintServiceDiagnosticExceptionArray[i2].PRINT_SERVICE.getName();
                        System.out.println("  >>>[DiagnosticsManager] Bad Printer: " + string);
                        jpdfDiagnosticsException.addJpdfException(jpdfPrintServiceDiagnosticExceptionArray[i2]);
                    }
                    DiagnosticsManager.a(jpdfPrintServiceDiagnosticExceptionArray);
                }
            }
        }
        catch (Throwable throwable) {
            jpdfDiagnosticsException.addJpdfException(new JpdfUnexpectedException(throwable));
        }
        if (n2 > 0) {
            DiagnosticsManager.writePrintServiceDiagnosticsFile();
        }
        if (jpdfDiagnosticsException.getJpdfExceptionCount() == 0) {
            jpdfDiagnosticsException = null;
            System.out.println("  No problems found.");
        } else {
            DiagnosticsManager.a(jpdfDiagnosticsException);
        }
        return jpdfDiagnosticsException;
    }

    public static void unregisterBadPrintServices() {
        String[] stringArray = DiagnosticsManager.getBadPrintServiceNames();
        int n2 = 0;
        if (stringArray == null) {
            return;
        }
        n2 = PrintServiceLookup.lookupPrintServices(null, null).length;
        if (stringArray.length < n2) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                System.out.println("  >>>[DiagnosticsManager] Unregister Printer: " + stringArray[i2]);
                PrintServiceRegistry.unregisterPrintService(stringArray[i2]);
            }
        }
    }

    public static void writeAttributeSetToFile(AttributeSet attributeSet, String string) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
        }
        catch (Throwable throwable) {
            System.out.println("\n*** ERROR: Could not create file: " + string + "\n   " + throwable);
            return;
        }
        System.out.print("\n  Writing Attribute Set File: " + string);
        try {
            DiagnosticsManager.a(fileWriter, "JPDF Print Attribute Set File");
            fileWriter.write("\nAttribute Set\n======================");
            fileWriter.write(PrintDebugger.buildPrintAttributeSetMessage(attributeSet, false));
        }
        catch (IOException iOException) {
            System.out.println("\n*** ERROR: Could not write to file: " + string + "\n   " + iOException);
            return;
        }
        catch (Throwable throwable) {
            System.out.println("\n*** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            return;
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("\n*** ERROR: Could not close the file: " + string + "\n   " + iOException);
            return;
        }
        System.out.println("\n  Done. \n");
    }

    public static void writePrintServiceDiagnosticsFile() {
        PrintService[] printServiceArray = null;
        PrintService printService = null;
        FileWriter fileWriter = null;
        String string = null;
        DateFormat dateFormat = DateFormat.getTimeInstance(2);
        Date date = new Date();
        try {
            fileWriter = new FileWriter("JPDF_PrintService_diagnostics.txt");
        }
        catch (Throwable throwable) {
            System.out.println("\n*** ERROR: Could not create Diagnostic File: JPDF_PrintService_diagnostics.txt\n   " + throwable);
            return;
        }
        System.out.print("\n  Writing Diagnostic File: JPDF_PrintService_diagnostics.txt");
        try {
            int n2;
            DiagnosticsManager.a(fileWriter, "JPDF Print Service Diagnostics");
            printService = PrintServiceRegistry.lookupDefaultPrintService();
            string = printService == null ? "<None>" : printService.getName();
            fileWriter.write("\n[" + dateFormat.format(date) + "] Platform Default Printer: " + string + "\n");
            try {
                printServiceArray = PrintServiceRegistry.lookupPrintServices(null, null);
            }
            catch (Throwable throwable) {
                System.out.println("\n*** ERROR: Could not get printer list. \n   " + throwable);
                return;
            }
            if (printServiceArray == null || printServiceArray.length == 0) {
                System.out.println("\n*** ERROR: Empty printer list. ");
                return;
            }
            fileWriter.write("\n[" + dateFormat.format(new Date()) + "] Printer List" + "\n================================" + "\n");
            fileWriter.write(LogPanel.buildPrinterListString());
            System.out.print("\n    >Printer List.");
            fileWriter.write("\n\n[" + dateFormat.format(new Date()) + "] Supported Print Attributes" + "\n================================");
            System.out.print("\n    >Print Attributes ");
            for (n2 = 0; n2 < printServiceArray.length; ++n2) {
                System.out.print(".");
                fileWriter.write("\n\n  [" + dateFormat.format(new Date()) + "] " + printServiceArray[n2].getName() + "\n  ----------------------------------");
                fileWriter.write(LogPanel.buildPrinterSupportedAttributesString(printServiceArray[n2], false));
            }
            fileWriter.write("\n\n[" + dateFormat.format(new Date()) + "] Supported Media" + "\n================================");
            System.out.print("\n    >Supported Media ");
            for (n2 = 0; n2 < printServiceArray.length; ++n2) {
                System.out.print(".");
                fileWriter.write("\n\n  [" + dateFormat.format(new Date()) + "] " + printServiceArray[n2].getName() + "\n  ----------------------------------");
                fileWriter.write(LogPanel.buildPrinterSupportedMediaString(printServiceArray[n2], false));
            }
            fileWriter.write("\n\n[" + dateFormat.format(new Date()) + "] Supported Doc Flavors" + "\n================================");
            System.out.print("\n    >Doc Flavors ");
            for (n2 = 0; n2 < printServiceArray.length; ++n2) {
                System.out.print(".");
                fileWriter.write("\n\n  [" + dateFormat.format(new Date()) + "] " + printServiceArray[n2].getName() + "\n  ----------------------------------");
                fileWriter.write(LogPanel.buildPrinterSupportedDocFlavorsString(printServiceArray[n2], false));
            }
            fileWriter.write("\n\n[" + dateFormat.format(new Date()) + "] * * *  END  * * *\n\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("\n*** ERROR: Could not write to Diagnostic File: JPDF_PrintService_diagnostics.txt\n   " + iOException);
            return;
        }
        catch (Throwable throwable) {
            System.out.println("\n*** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            return;
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("\n*** ERROR: Could not close the Diagnostic File: JPDF_PrintService_diagnostics.txt\n   " + iOException);
            return;
        }
        System.out.println("\n  Done. \n");
    }

    public static void writePrintServiceDiagnosticsFile(PrintService printService) {
        FileWriter fileWriter = null;
        String string = null;
        DateFormat dateFormat = DateFormat.getTimeInstance(2);
        Date date = new Date();
        try {
            fileWriter = new FileWriter("JPDF_PrintService_diagnostics.txt");
        }
        catch (Throwable throwable) {
            System.out.println("\n*** ERROR: Could not create Diagnostic File: JPDF_PrintService_diagnostics.txt\n   " + throwable);
            return;
        }
        System.out.print("\n  Writing Diagnostic File: JPDF_PrintService_diagnostics.txt");
        try {
            DiagnosticsManager.a(fileWriter, "JPDF Print Service Diagnostics");
            string = printService.getName();
            fileWriter.write("\n[" + dateFormat.format(date) + "] Printer: " + string + "\n");
            fileWriter.write("\n\n[" + dateFormat.format(new Date()) + "] Supported Print Attributes" + "\n================================");
            System.out.print("\n    >Print Attributes ");
            fileWriter.write(LogPanel.buildPrinterSupportedAttributesString(printService, false));
            fileWriter.write("\n\n[" + dateFormat.format(new Date()) + "] Supported Media" + "\n================================");
            System.out.print("\n    >Supported Media ");
            fileWriter.write(LogPanel.buildPrinterSupportedMediaString(printService, false));
            fileWriter.write("\n\n[" + dateFormat.format(new Date()) + "] Supported Doc Flavors" + "\n================================");
            System.out.print("\n    >Doc Flavors ");
            System.out.print(".");
            fileWriter.write(LogPanel.buildPrinterSupportedDocFlavorsString(printService, false));
            fileWriter.write("\n\n[" + dateFormat.format(new Date()) + "] * * *  END  * * *\n\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("\n*** ERROR: Could not write to Diagnostic File: JPDF_PrintService_diagnostics.txt\n   " + iOException);
            return;
        }
        catch (Throwable throwable) {
            System.out.println("\n*** ERROR: " + SystemUtility.getThrowableStackTrace(throwable, 10, true));
            return;
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("\n*** ERROR: Could not close the Diagnostic File: JPDF_PrintService_diagnostics.txt\n   " + iOException);
            return;
        }
        System.out.println("\n  Done. \n");
    }

    private static JpdfPrintServiceDiagnosticException[] a(PrintService[] printServiceArray) {
        JpdfPrintServiceDiagnosticException[] jpdfPrintServiceDiagnosticExceptionArray = null;
        JpdfPrintServiceDiagnosticException jpdfPrintServiceDiagnosticException = null;
        PrintService printService = null;
        Vector<JpdfPrintServiceDiagnosticException> vector = new Vector<JpdfPrintServiceDiagnosticException>(5);
        int n2 = 0;
        System.out.print("  ");
        for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
            try {
                System.out.print(".");
                printService = printServiceArray[i2];
                printService.getSupportedAttributeValues(a == null ? DiagnosticsManager.class$("javax.print.attribute.standard.Media") : a, null, null);
                printService.getSupportedDocFlavors();
                printService.getSupportedAttributeCategories();
                continue;
            }
            catch (Throwable throwable) {
                jpdfPrintServiceDiagnosticException = new JpdfPrintServiceDiagnosticException(printService, throwable);
                vector.add(jpdfPrintServiceDiagnosticException);
                ++n2;
            }
        }
        System.out.println();
        if (n2 > 0) {
            jpdfPrintServiceDiagnosticExceptionArray = vector.toArray(new JpdfPrintServiceDiagnosticException[n2]);
        }
        return jpdfPrintServiceDiagnosticExceptionArray;
    }

    private static void a(JpdfPrintServiceDiagnosticException[] jpdfPrintServiceDiagnosticExceptionArray) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter("JPDF_BadPrintService.txt");
            for (int i2 = 0; i2 < jpdfPrintServiceDiagnosticExceptionArray.length; ++i2) {
                fileWriter.write(jpdfPrintServiceDiagnosticExceptionArray[i2].PRINT_SERVICE.getName() + "\n");
            }
            fileWriter.write("\n");
            fileWriter.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void a(JpdfDiagnosticsException jpdfDiagnosticsException) {
        JpdfException[] jpdfExceptionArray = jpdfDiagnosticsException.getJpdfExceptionList();
        Throwable throwable = null;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter("JPDF_error_diagnostics.txt"));
        }
        catch (Throwable throwable2) {
            System.out.println("\n*** ERROR: Could not create Diagnostic File: JPDF_error_diagnostics.txt\n   " + throwable2);
            return;
        }
        System.out.print("\n  Writing Diagnostic File: JPDF_error_diagnostics.txt");
        try {
            DiagnosticsManager.a(printWriter, "JPDF Error Diagnostics");
            for (int i2 = 0; i2 < jpdfExceptionArray.length; ++i2) {
                printWriter.write("\n");
                if (jpdfExceptionArray[i2] instanceof JpdfUnexpectedException) {
                    throwable = ((JpdfUnexpectedException)jpdfExceptionArray[i2]).getCause();
                    printWriter.write(jpdfExceptionArray[i2] + "\n----------------------------------------------\n");
                } else {
                    throwable = jpdfExceptionArray[i2];
                }
                throwable.printStackTrace(printWriter);
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("\n*** ERROR: Could not write to Diagnostic File: JPDF_error_diagnostics.txt\n   " + iOException);
            return;
        }
        catch (Throwable throwable3) {
            System.out.println("\n*** ERROR: " + SystemUtility.getThrowableStackTrace(throwable3, 10, true));
            return;
        }
        System.out.println("\n  Done. \n");
    }

    private static void a(Writer writer, String string) throws IOException {
        writer.write(DiagnosticsManager.buildEnvironmentInfoString(string));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

