/*
 * Decompiled with CFR 0.152.
 */
package jpdf.attribute;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.print.attribute.Attribute;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jpdf.attribute.CloneableValueAttribute;
import jpdf.manage.PrintParameterHolder;
import jpdf_common.system.utility.SerializationUtility;

public abstract class TextDocumentSyntax
implements Serializable,
CloneableValueAttribute {
    private static final long serialVersionUID = 120L;
    protected final AbstractDocument DOCUMENT;

    protected TextDocumentSyntax(AbstractDocument abstractDocument) {
        this.DOCUMENT = this.a(abstractDocument);
    }

    public Attribute cloneAttribute() {
        return this.createNewInstance(this.DOCUMENT);
    }

    public static DefaultStyledDocument createDocument(String string, String string2, int n2, Color color, boolean bl) {
        DefaultStyledDocument defaultStyledDocument = null;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (n2 > 0) {
            StyleConstants.setFontSize(simpleAttributeSet, n2);
        }
        if (string2 != null) {
            StyleConstants.setFontFamily(simpleAttributeSet, string2);
        }
        if (color != null) {
            StyleConstants.setForeground(simpleAttributeSet, color);
        }
        if (bl) {
            StyleConstants.setAlignment(simpleAttributeSet, 1);
        }
        defaultStyledDocument = new DefaultStyledDocument();
        try {
            defaultStyledDocument.insertString(0, string, simpleAttributeSet);
            if (bl) {
                defaultStyledDocument.setParagraphAttributes(0, string.length(), simpleAttributeSet, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultStyledDocument;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextDocumentSyntax)) {
            return false;
        }
        return this.DOCUMENT == ((TextDocumentSyntax)object).getValue();
    }

    public AbstractDocument getDocumentClone() {
        return this.a();
    }

    public AbstractDocument getValue() {
        return this.DOCUMENT;
    }

    public int hashCode() {
        return this.DOCUMENT.hashCode();
    }

    public boolean isContainingOnlyWhitespace() {
        return TextDocumentSyntax.isContainingOnlyWhitespace(this.DOCUMENT);
    }

    public static boolean isContainingOnlyWhitespace(AbstractDocument abstractDocument) {
        String string = null;
        int n2 = abstractDocument.getLength();
        if (n2 == 0) {
            return true;
        }
        try {
            string = abstractDocument.getText(0, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Character.isWhitespace(string.charAt(i2))) continue;
                return false;
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return true;
    }

    public String toString() {
        String string = null;
        int n2 = this.DOCUMENT.getLength();
        try {
            string = n2 > 40 ? this.DOCUMENT.getText(0, 40) + "... [length=" + n2 + "]" : this.DOCUMENT.getText(0, n2) + " [length=" + n2 + "]";
            string = string.replace('\n', '\u00b6');
        }
        catch (BadLocationException badLocationException) {
            string = "Document Length = " + n2;
        }
        return string;
    }

    protected abstract TextDocumentSyntax createNewInstance(AbstractDocument var1);

    protected AbstractDocument getFormattedDocument(PrintParameterHolder printParameterHolder) {
        AbstractDocument abstractDocument = null;
        if (printParameterHolder == null) {
            return this.DOCUMENT;
        }
        if (printParameterHolder.title == "[[No Replace]]") {
            return this.DOCUMENT;
        }
        abstractDocument = this.a();
        if (abstractDocument instanceof DefaultStyledDocument) {
            printParameterHolder.replaceMarkers((DefaultStyledDocument)abstractDocument);
        } else {
            printParameterHolder.replaceMarkers(abstractDocument);
        }
        return abstractDocument;
    }

    private AbstractDocument a() {
        IllegalStateException illegalStateException = null;
        AbstractDocument abstractDocument = null;
        try {
            abstractDocument = (AbstractDocument)SerializationUtility.cloneSerializable(this.DOCUMENT);
        }
        catch (Exception exception) {
            illegalStateException = new IllegalStateException("Could not clone Text Document.");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
        return abstractDocument;
    }

    private AbstractDocument a(AbstractDocument abstractDocument) {
        int n2;
        int n3;
        UndoableEditListener[] undoableEditListenerArray = abstractDocument.getUndoableEditListeners();
        DocumentListener[] documentListenerArray = abstractDocument.getDocumentListeners();
        IllegalStateException illegalStateException = null;
        AbstractDocument abstractDocument2 = null;
        for (n3 = 0; n3 < undoableEditListenerArray.length; ++n3) {
            abstractDocument.removeUndoableEditListener(undoableEditListenerArray[n3]);
        }
        for (n3 = 0; n3 < documentListenerArray.length; ++n3) {
            abstractDocument.removeDocumentListener(documentListenerArray[n3]);
        }
        try {
            abstractDocument2 = (AbstractDocument)SerializationUtility.cloneSerializable(abstractDocument);
        }
        catch (Exception exception) {
            illegalStateException = new IllegalStateException("Could not clone Text Document.");
            illegalStateException.initCause(exception);
        }
        for (n2 = 0; n2 < undoableEditListenerArray.length; ++n2) {
            abstractDocument.addUndoableEditListener(undoableEditListenerArray[n2]);
        }
        for (n2 = 0; n2 < documentListenerArray.length; ++n2) {
            abstractDocument.addDocumentListener(documentListenerArray[n2]);
        }
        if (illegalStateException != null) {
            throw illegalStateException;
        }
        return abstractDocument2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

