/*
 * Decompiled with CFR 0.152.
 */
package jpdf.attribute;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.print.PrinterGraphics;
import jpdf.attribute.PageHeaderFooterAttribute;
import jpdf.attribute.StringArraySyntax;
import jpdf.manage.PrintParameterHolder;
import jpdf_common.gui.plaf.PlafPainter;
import jpdf_common.system.constant.SystemConstant;

public abstract class PageNotesSyntax
extends StringArraySyntax
implements PageHeaderFooterAttribute {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final AffineTransform d;
    private static final long serialVersionUID = 120L;
    private static Font a;
    private static int c;
    private static int i;
    private Color e = null;
    private Font b = null;

    public PageNotesSyntax(String string, String string2, String string3) {
        this(string, string2, string3, Color.BLACK, PageNotesSyntax.getDefaultNoteFont());
    }

    public PageNotesSyntax(String string, String string2, String string3, Color color) {
        this(string, string2, string3, color, PageNotesSyntax.getDefaultNoteFont());
    }

    public PageNotesSyntax(String string, String string2, String string3, Color color, Font font) {
        super(new String[]{string == null ? "" : string, string2 == null ? "" : string2, string3 == null ? "" : string3});
        this.e = color;
        this.b = font;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PageNotesSyntax)) {
            return false;
        }
        if (!this.e.equals(((PageNotesSyntax)object).getNotesColor())) {
            return false;
        }
        if (!this.b.equals(((PageNotesSyntax)object).getNotesFont())) {
            return false;
        }
        return super.equals(object);
    }

    public String formatValue(int n2, PrintParameterHolder printParameterHolder) {
        return printParameterHolder.replaceMarkers(this.getArrayElementValue(n2));
    }

    public static Font getDefaultNoteFont() {
        return a;
    }

    public Color getNotesColor() {
        return this.e;
    }

    public Font getNotesFont() {
        return this.b;
    }

    public static int getNoteXOffsetLeft() {
        return c;
    }

    public static int getNoteXOffsetRight() {
        return i;
    }

    public int getRequiredHeight(int n2, PrintParameterHolder printParameterHolder) {
        Window window = null;
        Font font = this.getNotesFont();
        int n3 = 0;
        int n4 = 0;
        window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window != null) {
            n4 = window.getFontMetrics(font).getHeight();
        } else {
            n3 = font.getSize();
            n4 = n3 + (int)((float)n3 * 0.4f);
        }
        return n4;
    }

    public int hashCode() {
        return super.hashCode() | this.e.hashCode() | this.b.hashCode();
    }

    public String toString() {
        return "[" + this.getArrayElementValue(0) + " | " + this.getArrayElementValue(1) + " | " + this.getArrayElementValue(2) + "]";
    }

    public static void setDefaultNoteFont(Font font) {
        a = font;
    }

    public static void setNoteXOffsetLeft(int n2) {
        c = n2;
    }

    public static void setNoteXOffsetRight(int n2) {
        i = n2;
    }

    protected static int computeCenterNoteXPos(String string, int n2, FontMetrics fontMetrics) {
        return (n2 - fontMetrics.stringWidth(string)) / 2;
    }

    protected static int computeLeftNoteXPos(String string, int n2, FontMetrics fontMetrics) {
        return PageNotesSyntax.getNoteXOffsetLeft();
    }

    protected static int computeRightNoteXPos(String string, int n2, FontMetrics fontMetrics) {
        return n2 - (fontMetrics.stringWidth(string) + PageNotesSyntax.getNoteXOffsetRight());
    }

    protected String[] getFormattedNotes(PrintParameterHolder printParameterHolder) {
        boolean bl;
        String[] stringArray = new String[3];
        boolean bl2 = bl = printParameterHolder != null;
        if (bl) {
            boolean bl3 = bl = printParameterHolder.title != "[[No Replace]]";
        }
        if (bl) {
            stringArray[0] = printParameterHolder.replaceMarkers(this.getArrayElementValue(0));
            stringArray[1] = printParameterHolder.replaceMarkers(this.getArrayElementValue(1));
            stringArray[2] = printParameterHolder.replaceMarkers(this.getArrayElementValue(2));
        } else {
            stringArray[0] = this.getArrayElementValue(0);
            stringArray[1] = this.getArrayElementValue(1);
            stringArray[2] = this.getArrayElementValue(2);
        }
        return stringArray;
    }

    protected int print(Graphics2D graphics2D, int n2, int n3, int n4, PrintParameterHolder printParameterHolder, boolean bl) {
        AffineTransform affineTransform = null;
        FontMetrics fontMetrics = null;
        String[] stringArray = this.getFormattedNotes(printParameterHolder);
        Font font = this.getNotesFont();
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        graphics2D.setFont(font);
        graphics2D.setColor(this.getNotesColor());
        boolean bl3 = bl2 = SystemConstant.RUNNING_VM_1_6 && graphics2D instanceof PrinterGraphics;
        if (bl2) {
            affineTransform = graphics2D.getTransform();
            graphics2D.setTransform(d);
        }
        fontMetrics = graphics2D.getFontMetrics();
        n5 = fontMetrics.getHeight();
        n7 = fontMetrics.getMaxAscent();
        if (font.getSize() > 10) {
            --n7;
        }
        if (bl2) {
            graphics2D.setTransform(affineTransform);
        }
        if (bl) {
            n4 -= n5;
        }
        graphics2D.translate(n3, n4);
        if (stringArray[0].length() > 0) {
            n6 = PageNotesSyntax.computeLeftNoteXPos(stringArray[0], n2, fontMetrics);
            graphics2D.drawString(stringArray[0], n6, n7);
        }
        if (stringArray[1].length() > 0) {
            n6 = PageNotesSyntax.computeCenterNoteXPos(stringArray[1], n2, fontMetrics);
            graphics2D.drawString(stringArray[1], n6, n7);
        }
        if (stringArray[2].length() > 0) {
            n6 = PageNotesSyntax.computeRightNoteXPos(stringArray[2], n2, fontMetrics);
            graphics2D.drawString(stringArray[2], n6, n7);
        }
        graphics2D.translate(-n3, -n4);
        return n5;
    }

    static {
        c = 6;
        i = -2;
        a = PlafPainter.getPlafPainter().getDefaultLabelFont();
        if (!a.isPlain()) {
            a = a.deriveFont(0);
        }
        d = SystemConstant.RUNNING_VM_1_6 ? new AffineTransform() : null;
    }
}

